// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary of an AccountRecommendationLifecycle for an Organization Recommendation
type AccountRecommendationLifecycleSummary struct {

	// The AWS account ID
	AccountId *string

	// The Recommendation ARN
	AccountRecommendationArn *string

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage RecommendationLifecycleStage

	// Reason for the lifecycle stage change
	UpdateReason *string

	// Reason code for the lifecycle state change
	UpdateReasonCode UpdateRecommendationLifecycleStageReasonCode

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string

	noSmithyDocumentSerde
}

// A summary of an AWS Trusted Advisor Check
type CheckSummary struct {

	// The ARN of the AWS Trusted Advisor Check
	//
	// This member is required.
	Arn *string

	// The AWS Services that the Check applies to
	//
	// This member is required.
	AwsServices []string

	// A description of what the AWS Trusted Advisor Check is monitoring
	//
	// This member is required.
	Description *string

	// The unique identifier of the AWS Trusted Advisor Check
	//
	// This member is required.
	Id *string

	// The column headings for the metadata returned in the resource
	//
	// This member is required.
	Metadata map[string]string

	// The name of the AWS Trusted Advisor Check
	//
	// This member is required.
	Name *string

	// The Recommendation pillars that the AWS Trusted Advisor Check falls under
	//
	// This member is required.
	Pillars []RecommendationPillar

	// The source of the Recommendation
	//
	// This member is required.
	Source RecommendationSource

	noSmithyDocumentSerde
}

// A Recommendation for accounts within an Organization
type OrganizationRecommendation struct {

	// The ARN of the Recommendation
	//
	// This member is required.
	Arn *string

	// A description for AWS Trusted Advisor recommendations
	//
	// This member is required.
	Description *string

	// The ID which identifies where the Recommendation was produced
	//
	// This member is required.
	Id *string

	// The name of the AWS Trusted Advisor Recommendation
	//
	// This member is required.
	Name *string

	// The Pillars that the Recommendation is optimizing
	//
	// This member is required.
	Pillars []RecommendationPillar

	// An aggregation of all resources
	//
	// This member is required.
	ResourcesAggregates *RecommendationResourcesAggregates

	// The source of the Recommendation
	//
	// This member is required.
	Source RecommendationSource

	// The status of the Recommendation
	//
	// This member is required.
	Status RecommendationStatus

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// This member is required.
	Type RecommendationType

	// The AWS Services that the Recommendation applies to
	AwsServices []string

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time

	// The creator, if created by AWS Trusted Advisor Priority
	CreatedBy *string

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage RecommendationLifecycleStage

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates

	// When the Recommendation was resolved
	ResolvedAt *time.Time

	// Reason for the lifecycle stage change
	UpdateReason *string

	// Reason code for the lifecycle state change
	UpdateReasonCode UpdateRecommendationLifecycleStageReasonCode

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string

	noSmithyDocumentSerde
}

// Organization Recommendation Resource Summary
type OrganizationRecommendationResourceSummary struct {

	// The ARN of the Recommendation Resource
	//
	// This member is required.
	Arn *string

	// The AWS resource identifier
	//
	// This member is required.
	AwsResourceId *string

	// The ID of the Recommendation Resource
	//
	// This member is required.
	Id *string

	// When the Recommendation Resource was last updated
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// Metadata associated with the Recommendation Resource
	//
	// This member is required.
	Metadata map[string]string

	// The Recommendation ARN
	//
	// This member is required.
	RecommendationArn *string

	// The AWS Region code that the Recommendation Resource is in
	//
	// This member is required.
	RegionCode *string

	// The current status of the Recommendation Resource
	//
	// This member is required.
	Status ResourceStatus

	// The AWS account ID
	AccountId *string

	// The exclusion status of the Recommendation Resource
	ExclusionStatus ExclusionStatus

	noSmithyDocumentSerde
}

// Summary of recommendation for accounts within an Organization
type OrganizationRecommendationSummary struct {

	// The ARN of the Recommendation
	//
	// This member is required.
	Arn *string

	// The ID which identifies where the Recommendation was produced
	//
	// This member is required.
	Id *string

	// The name of the AWS Trusted Advisor Recommendation
	//
	// This member is required.
	Name *string

	// The Pillars that the Recommendation is optimizing
	//
	// This member is required.
	Pillars []RecommendationPillar

	// An aggregation of all resources
	//
	// This member is required.
	ResourcesAggregates *RecommendationResourcesAggregates

	// The source of the Recommendation
	//
	// This member is required.
	Source RecommendationSource

	// The status of the Recommendation
	//
	// This member is required.
	Status RecommendationStatus

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// This member is required.
	Type RecommendationType

	// The AWS Services that the Recommendation applies to
	AwsServices []string

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage RecommendationLifecycleStage

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates

	noSmithyDocumentSerde
}

// A Recommendation for an Account
type Recommendation struct {

	// The ARN of the Recommendation
	//
	// This member is required.
	Arn *string

	// A description for AWS Trusted Advisor recommendations
	//
	// This member is required.
	Description *string

	// The ID which identifies where the Recommendation was produced
	//
	// This member is required.
	Id *string

	// The name of the AWS Trusted Advisor Recommendation
	//
	// This member is required.
	Name *string

	// The Pillars that the Recommendation is optimizing
	//
	// This member is required.
	Pillars []RecommendationPillar

	// An aggregation of all resources
	//
	// This member is required.
	ResourcesAggregates *RecommendationResourcesAggregates

	// The source of the Recommendation
	//
	// This member is required.
	Source RecommendationSource

	// The status of the Recommendation
	//
	// This member is required.
	Status RecommendationStatus

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// This member is required.
	Type RecommendationType

	// The AWS Services that the Recommendation applies to
	AwsServices []string

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time

	// The creator, if created by AWS Trusted Advisor Priority
	CreatedBy *string

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage RecommendationLifecycleStage

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates

	// When the Recommendation was resolved
	ResolvedAt *time.Time

	// Reason for the lifecycle stage change
	UpdateReason *string

	// Reason code for the lifecycle state change
	UpdateReasonCode UpdateRecommendationLifecycleStageReasonCode

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string

	noSmithyDocumentSerde
}

// Cost optimizing aggregates for a Recommendation
type RecommendationCostOptimizingAggregates struct {

	// The estimated monthly savings
	//
	// This member is required.
	EstimatedMonthlySavings *float64

	// The estimated percently monthly savings
	//
	// This member is required.
	EstimatedPercentMonthlySavings *float64

	noSmithyDocumentSerde
}

// Recommendation pillar aggregates
type RecommendationPillarSpecificAggregates struct {

	// Cost optimizing aggregates
	CostOptimizing *RecommendationCostOptimizingAggregates

	noSmithyDocumentSerde
}

// The request entry for Recommendation Resource exclusion. Each entry is a
// combination of Recommendation Resource ARN and corresponding exclusion status
type RecommendationResourceExclusion struct {

	// The ARN of the Recommendation Resource
	//
	// This member is required.
	Arn *string

	// The exclusion status
	//
	// This member is required.
	IsExcluded *bool

	noSmithyDocumentSerde
}

// Aggregation of Recommendation Resources
type RecommendationResourcesAggregates struct {

	// The number of AWS resources that were flagged to have errors according to the
	// Trusted Advisor check
	//
	// This member is required.
	ErrorCount *int64

	// The number of AWS resources that were flagged to be OK according to the Trusted
	// Advisor check
	//
	// This member is required.
	OkCount *int64

	// The number of AWS resources that were flagged to have warning according to the
	// Trusted Advisor check
	//
	// This member is required.
	WarningCount *int64

	noSmithyDocumentSerde
}

// Summary of a Recommendation Resource
type RecommendationResourceSummary struct {

	// The ARN of the Recommendation Resource
	//
	// This member is required.
	Arn *string

	// The AWS resource identifier
	//
	// This member is required.
	AwsResourceId *string

	// The ID of the Recommendation Resource
	//
	// This member is required.
	Id *string

	// When the Recommendation Resource was last updated
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// Metadata associated with the Recommendation Resource
	//
	// This member is required.
	Metadata map[string]string

	// The Recommendation ARN
	//
	// This member is required.
	RecommendationArn *string

	// The AWS Region code that the Recommendation Resource is in
	//
	// This member is required.
	RegionCode *string

	// The current status of the Recommendation Resource
	//
	// This member is required.
	Status ResourceStatus

	// The exclusion status of the Recommendation Resource
	ExclusionStatus ExclusionStatus

	noSmithyDocumentSerde
}

// Summary of Recommendation for an Account
type RecommendationSummary struct {

	// The ARN of the Recommendation
	//
	// This member is required.
	Arn *string

	// The ID which identifies where the Recommendation was produced
	//
	// This member is required.
	Id *string

	// The name of the AWS Trusted Advisor Recommendation
	//
	// This member is required.
	Name *string

	// The Pillars that the Recommendation is optimizing
	//
	// This member is required.
	Pillars []RecommendationPillar

	// An aggregation of all resources
	//
	// This member is required.
	ResourcesAggregates *RecommendationResourcesAggregates

	// The source of the Recommendation
	//
	// This member is required.
	Source RecommendationSource

	// The status of the Recommendation
	//
	// This member is required.
	Status RecommendationStatus

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// This member is required.
	Type RecommendationType

	// The AWS Services that the Recommendation applies to
	AwsServices []string

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage RecommendationLifecycleStage

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates

	noSmithyDocumentSerde
}

// The error entry for Recommendation Resource exclusion. Each entry is a
// combination of Recommendation Resource ARN, error code and error message
type UpdateRecommendationResourceExclusionError struct {

	// The ARN of the Recommendation Resource
	Arn *string

	// The error code
	ErrorCode *string

	// The error message
	ErrorMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
