// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package repostspace

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSpace = "CreateSpace"

// CreateSpaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateSpace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSpace for more information on using the CreateSpace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSpaceRequest method.
//	req, resp := client.CreateSpaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateSpace
func (c *Repostspace) CreateSpaceRequest(input *CreateSpaceInput) (req *request.Request, output *CreateSpaceOutput) {
	op := &request.Operation{
		Name:       opCreateSpace,
		HTTPMethod: "POST",
		HTTPPath:   "/spaces",
	}

	if input == nil {
		input = &CreateSpaceInput{}
	}

	output = &CreateSpaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSpace API operation for AWS re:Post Private.
//
// Creates an AWS re:Post Private private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation CreateSpace for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/CreateSpace
func (c *Repostspace) CreateSpace(input *CreateSpaceInput) (*CreateSpaceOutput, error) {
	req, out := c.CreateSpaceRequest(input)
	return out, req.Send()
}

// CreateSpaceWithContext is the same as CreateSpace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSpace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) CreateSpaceWithContext(ctx aws.Context, input *CreateSpaceInput, opts ...request.Option) (*CreateSpaceOutput, error) {
	req, out := c.CreateSpaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSpace = "DeleteSpace"

// DeleteSpaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSpace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSpace for more information on using the DeleteSpace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSpaceRequest method.
//	req, resp := client.DeleteSpaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeleteSpace
func (c *Repostspace) DeleteSpaceRequest(input *DeleteSpaceInput) (req *request.Request, output *DeleteSpaceOutput) {
	op := &request.Operation{
		Name:       opDeleteSpace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/spaces/{spaceId}",
	}

	if input == nil {
		input = &DeleteSpaceInput{}
	}

	output = &DeleteSpaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSpace API operation for AWS re:Post Private.
//
// Deletes an AWS re:Post Private private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation DeleteSpace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeleteSpace
func (c *Repostspace) DeleteSpace(input *DeleteSpaceInput) (*DeleteSpaceOutput, error) {
	req, out := c.DeleteSpaceRequest(input)
	return out, req.Send()
}

// DeleteSpaceWithContext is the same as DeleteSpace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSpace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) DeleteSpaceWithContext(ctx aws.Context, input *DeleteSpaceInput, opts ...request.Option) (*DeleteSpaceOutput, error) {
	req, out := c.DeleteSpaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterAdmin = "DeregisterAdmin"

// DeregisterAdminRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterAdmin for more information on using the DeregisterAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterAdminRequest method.
//	req, resp := client.DeregisterAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeregisterAdmin
func (c *Repostspace) DeregisterAdminRequest(input *DeregisterAdminInput) (req *request.Request, output *DeregisterAdminOutput) {
	op := &request.Operation{
		Name:       opDeregisterAdmin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/spaces/{spaceId}/admins/{adminId}",
	}

	if input == nil {
		input = &DeregisterAdminInput{}
	}

	output = &DeregisterAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterAdmin API operation for AWS re:Post Private.
//
// Removes the user or group from the list of administrators of the private
// re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation DeregisterAdmin for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/DeregisterAdmin
func (c *Repostspace) DeregisterAdmin(input *DeregisterAdminInput) (*DeregisterAdminOutput, error) {
	req, out := c.DeregisterAdminRequest(input)
	return out, req.Send()
}

// DeregisterAdminWithContext is the same as DeregisterAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) DeregisterAdminWithContext(ctx aws.Context, input *DeregisterAdminInput, opts ...request.Option) (*DeregisterAdminOutput, error) {
	req, out := c.DeregisterAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSpace = "GetSpace"

// GetSpaceRequest generates a "aws/request.Request" representing the
// client's request for the GetSpace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSpace for more information on using the GetSpace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSpaceRequest method.
//	req, resp := client.GetSpaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetSpace
func (c *Repostspace) GetSpaceRequest(input *GetSpaceInput) (req *request.Request, output *GetSpaceOutput) {
	op := &request.Operation{
		Name:       opGetSpace,
		HTTPMethod: "GET",
		HTTPPath:   "/spaces/{spaceId}",
	}

	if input == nil {
		input = &GetSpaceInput{}
	}

	output = &GetSpaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSpace API operation for AWS re:Post Private.
//
// Displays information about the AWS re:Post Private private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation GetSpace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/GetSpace
func (c *Repostspace) GetSpace(input *GetSpaceInput) (*GetSpaceOutput, error) {
	req, out := c.GetSpaceRequest(input)
	return out, req.Send()
}

// GetSpaceWithContext is the same as GetSpace with the addition of
// the ability to pass a context and additional request options.
//
// See GetSpace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) GetSpaceWithContext(ctx aws.Context, input *GetSpaceInput, opts ...request.Option) (*GetSpaceOutput, error) {
	req, out := c.GetSpaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSpaces = "ListSpaces"

// ListSpacesRequest generates a "aws/request.Request" representing the
// client's request for the ListSpaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSpaces for more information on using the ListSpaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSpacesRequest method.
//	req, resp := client.ListSpacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces
func (c *Repostspace) ListSpacesRequest(input *ListSpacesInput) (req *request.Request, output *ListSpacesOutput) {
	op := &request.Operation{
		Name:       opListSpaces,
		HTTPMethod: "GET",
		HTTPPath:   "/spaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSpacesInput{}
	}

	output = &ListSpacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSpaces API operation for AWS re:Post Private.
//
// Returns a list of AWS re:Post Private private re:Posts in the account with
// some information about each private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation ListSpaces for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListSpaces
func (c *Repostspace) ListSpaces(input *ListSpacesInput) (*ListSpacesOutput, error) {
	req, out := c.ListSpacesRequest(input)
	return out, req.Send()
}

// ListSpacesWithContext is the same as ListSpaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListSpaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) ListSpacesWithContext(ctx aws.Context, input *ListSpacesInput, opts ...request.Option) (*ListSpacesOutput, error) {
	req, out := c.ListSpacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSpacesPages iterates over the pages of a ListSpaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSpaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSpaces operation.
//	pageNum := 0
//	err := client.ListSpacesPages(params,
//	    func(page *repostspace.ListSpacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Repostspace) ListSpacesPages(input *ListSpacesInput, fn func(*ListSpacesOutput, bool) bool) error {
	return c.ListSpacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSpacesPagesWithContext same as ListSpacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) ListSpacesPagesWithContext(ctx aws.Context, input *ListSpacesInput, fn func(*ListSpacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSpacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSpacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSpacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListTagsForResource
func (c *Repostspace) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS re:Post Private.
//
// Returns the tags that are associated with the AWS re:Post Private resource
// specified by the resourceArn. The only resource that can be tagged is a private
// re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/ListTagsForResource
func (c *Repostspace) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterAdmin = "RegisterAdmin"

// RegisterAdminRequest generates a "aws/request.Request" representing the
// client's request for the RegisterAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterAdmin for more information on using the RegisterAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterAdminRequest method.
//	req, resp := client.RegisterAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/RegisterAdmin
func (c *Repostspace) RegisterAdminRequest(input *RegisterAdminInput) (req *request.Request, output *RegisterAdminOutput) {
	op := &request.Operation{
		Name:       opRegisterAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/spaces/{spaceId}/admins/{adminId}",
	}

	if input == nil {
		input = &RegisterAdminInput{}
	}

	output = &RegisterAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterAdmin API operation for AWS re:Post Private.
//
// Adds a user or group to the list of administrators of the private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation RegisterAdmin for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/RegisterAdmin
func (c *Repostspace) RegisterAdmin(input *RegisterAdminInput) (*RegisterAdminOutput, error) {
	req, out := c.RegisterAdminRequest(input)
	return out, req.Send()
}

// RegisterAdminWithContext is the same as RegisterAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) RegisterAdminWithContext(ctx aws.Context, input *RegisterAdminInput, opts ...request.Option) (*RegisterAdminOutput, error) {
	req, out := c.RegisterAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendInvites = "SendInvites"

// SendInvitesRequest generates a "aws/request.Request" representing the
// client's request for the SendInvites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendInvites for more information on using the SendInvites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendInvitesRequest method.
//	req, resp := client.SendInvitesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/SendInvites
func (c *Repostspace) SendInvitesRequest(input *SendInvitesInput) (req *request.Request, output *SendInvitesOutput) {
	op := &request.Operation{
		Name:       opSendInvites,
		HTTPMethod: "POST",
		HTTPPath:   "/spaces/{spaceId}/invite",
	}

	if input == nil {
		input = &SendInvitesInput{}
	}

	output = &SendInvitesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendInvites API operation for AWS re:Post Private.
//
// Sends an invitation email to selected users and groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation SendInvites for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/SendInvites
func (c *Repostspace) SendInvites(input *SendInvitesInput) (*SendInvitesOutput, error) {
	req, out := c.SendInvitesRequest(input)
	return out, req.Send()
}

// SendInvitesWithContext is the same as SendInvites with the addition of
// the ability to pass a context and additional request options.
//
// See SendInvites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) SendInvitesWithContext(ctx aws.Context, input *SendInvitesInput, opts ...request.Option) (*SendInvitesOutput, error) {
	req, out := c.SendInvitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/TagResource
func (c *Repostspace) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS re:Post Private.
//
// Associates tags with an AWS re:Post Private resource. Currently, the only
// resource that can be tagged is the private re:Post. If you specify a new
// tag key for the resource, the tag is appended to the list of tags that are
// associated with the resource. If you specify a tag key that’s already associated
// with the resource, the new tag value that you specify replaces the previous
// value for that tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/TagResource
func (c *Repostspace) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UntagResource
func (c *Repostspace) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS re:Post Private.
//
// Removes the association of the tag with the AWS re:Post Private resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UntagResource
func (c *Repostspace) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSpace = "UpdateSpace"

// UpdateSpaceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSpace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSpace for more information on using the UpdateSpace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSpaceRequest method.
//	req, resp := client.UpdateSpaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateSpace
func (c *Repostspace) UpdateSpaceRequest(input *UpdateSpaceInput) (req *request.Request, output *UpdateSpaceOutput) {
	op := &request.Operation{
		Name:       opUpdateSpace,
		HTTPMethod: "PUT",
		HTTPPath:   "/spaces/{spaceId}",
	}

	if input == nil {
		input = &UpdateSpaceInput{}
	}

	output = &UpdateSpaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSpace API operation for AWS re:Post Private.
//
// Modifies an existing AWS re:Post Private private re:Post.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS re:Post Private's
// API operation UpdateSpace for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/repostspace-2022-05-13/UpdateSpace
func (c *Repostspace) UpdateSpace(input *UpdateSpaceInput) (*UpdateSpaceOutput, error) {
	req, out := c.UpdateSpaceRequest(input)
	return out, req.Send()
}

// UpdateSpaceWithContext is the same as UpdateSpace with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSpace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Repostspace) UpdateSpaceWithContext(ctx aws.Context, input *UpdateSpaceInput, opts ...request.Option) (*UpdateSpaceOutput, error) {
	req, out := c.UpdateSpaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateSpaceInput struct {
	_ struct{} `type:"structure"`

	// A description for the private re:Post. This is used only to help you identify
	// this private re:Post.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSpaceInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The name for the private re:Post. This must be unique in your account.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSpaceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The IAM role that grants permissions to the private re:Post to convert unanswered
	// questions into AWS support tickets.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The subdomain that you use to access your AWS re:Post Private private re:Post.
	// All custom subdomains must be approved by AWS before use. In addition to
	// your custom subdomain, all private re:Posts are issued an AWS generated subdomain
	// for immediate use.
	//
	// Subdomain is a required field
	Subdomain *string `locationName:"subdomain" min:"1" type:"string" required:"true"`

	// The list of tags associated with the private re:Post.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSpaceInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// The pricing tier for the private re:Post.
	//
	// Tier is a required field
	Tier *string `locationName:"tier" type:"string" required:"true" enum:"TierLevel"`

	// The AWS KMS key ARN that’s used for the AWS KMS encryption. If you don't
	// provide a key, your data is encrypted by default with a key that AWS owns
	// and manages for you.
	UserKMSKey *string `locationName:"userKMSKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSpaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSpaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSpaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSpaceInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Subdomain == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdomain"))
	}
	if s.Subdomain != nil && len(*s.Subdomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subdomain", 1))
	}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSpaceInput) SetDescription(v string) *CreateSpaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSpaceInput) SetName(v string) *CreateSpaceInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateSpaceInput) SetRoleArn(v string) *CreateSpaceInput {
	s.RoleArn = &v
	return s
}

// SetSubdomain sets the Subdomain field's value.
func (s *CreateSpaceInput) SetSubdomain(v string) *CreateSpaceInput {
	s.Subdomain = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSpaceInput) SetTags(v map[string]*string) *CreateSpaceInput {
	s.Tags = v
	return s
}

// SetTier sets the Tier field's value.
func (s *CreateSpaceInput) SetTier(v string) *CreateSpaceInput {
	s.Tier = &v
	return s
}

// SetUserKMSKey sets the UserKMSKey field's value.
func (s *CreateSpaceInput) SetUserKMSKey(v string) *CreateSpaceInput {
	s.UserKMSKey = &v
	return s
}

type CreateSpaceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `locationName:"spaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSpaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSpaceOutput) GoString() string {
	return s.String()
}

// SetSpaceId sets the SpaceId field's value.
func (s *CreateSpaceOutput) SetSpaceId(v string) *CreateSpaceOutput {
	s.SpaceId = &v
	return s
}

type DeleteSpaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSpaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSpaceInput"}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpaceId sets the SpaceId field's value.
func (s *DeleteSpaceInput) SetSpaceId(v string) *DeleteSpaceInput {
	s.SpaceId = &v
	return s
}

type DeleteSpaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpaceOutput) GoString() string {
	return s.String()
}

type DeregisterAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the admin to remove.
	//
	// AdminId is a required field
	AdminId *string `location:"uri" locationName:"adminId" type:"string" required:"true"`

	// The ID of the private re:Post to remove the admin from.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterAdminInput"}
	if s.AdminId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminId"))
	}
	if s.AdminId != nil && len(*s.AdminId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminId", 1))
	}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminId sets the AdminId field's value.
func (s *DeregisterAdminInput) SetAdminId(v string) *DeregisterAdminInput {
	s.AdminId = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *DeregisterAdminInput) SetSpaceId(v string) *DeregisterAdminInput {
	s.SpaceId = &v
	return s
}

type DeregisterAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterAdminOutput) GoString() string {
	return s.String()
}

type GetSpaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSpaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSpaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSpaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSpaceInput"}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpaceId sets the SpaceId field's value.
func (s *GetSpaceInput) SetSpaceId(v string) *GetSpaceInput {
	s.SpaceId = &v
	return s
}

type GetSpaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the private re:Post.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The Identity Center identifier for the Application Instance.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The configuration status of the private re:Post.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *string `locationName:"configurationStatus" type:"string" required:"true" enum:"ConfigurationStatus"`

	// The content size of the private re:Post.
	ContentSize *int64 `locationName:"contentSize" type:"long"`

	// The date when the private re:Post was created.
	//
	// CreateDateTime is a required field
	CreateDateTime *time.Time `locationName:"createDateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The IAM role that grants permissions to the private re:Post to convert unanswered
	// questions into AWS support tickets.
	CustomerRoleArn *string `locationName:"customerRoleArn" min:"20" type:"string"`

	// The date when the private re:Post was deleted.
	DeleteDateTime *time.Time `locationName:"deleteDateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the private re:Post.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSpaceOutput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The list of groups that are administrators of the private re:Post.
	GroupAdmins []*string `locationName:"groupAdmins" type:"list"`

	// The name of the private re:Post.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSpaceOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The AWS generated subdomain of the private re:Post
	//
	// RandomDomain is a required field
	RandomDomain *string `locationName:"randomDomain" type:"string" required:"true"`

	// The unique ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `locationName:"spaceId" type:"string" required:"true"`

	// The creation or deletion status of the private re:Post.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true"`

	// The storage limit of the private re:Post.
	//
	// StorageLimit is a required field
	StorageLimit *int64 `locationName:"storageLimit" type:"long" required:"true"`

	// The pricing tier of the private re:Post.
	//
	// Tier is a required field
	Tier *string `locationName:"tier" type:"string" required:"true" enum:"TierLevel"`

	// The list of users that are administrators of the private re:Post.
	UserAdmins []*string `locationName:"userAdmins" type:"list"`

	// The number of users that have onboarded to the private re:Post.
	UserCount *int64 `locationName:"userCount" type:"integer"`

	// The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
	UserKMSKey *string `locationName:"userKMSKey" type:"string"`

	// The custom subdomain that you use to access your private re:Post. All custom
	// subdomains must be approved by AWS before use.
	//
	// VanityDomain is a required field
	VanityDomain *string `locationName:"vanityDomain" type:"string" required:"true"`

	// The approval status of the custom subdomain.
	//
	// VanityDomainStatus is a required field
	VanityDomainStatus *string `locationName:"vanityDomainStatus" type:"string" required:"true" enum:"VanityDomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSpaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSpaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSpaceOutput) SetArn(v string) *GetSpaceOutput {
	s.Arn = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *GetSpaceOutput) SetClientId(v string) *GetSpaceOutput {
	s.ClientId = &v
	return s
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *GetSpaceOutput) SetConfigurationStatus(v string) *GetSpaceOutput {
	s.ConfigurationStatus = &v
	return s
}

// SetContentSize sets the ContentSize field's value.
func (s *GetSpaceOutput) SetContentSize(v int64) *GetSpaceOutput {
	s.ContentSize = &v
	return s
}

// SetCreateDateTime sets the CreateDateTime field's value.
func (s *GetSpaceOutput) SetCreateDateTime(v time.Time) *GetSpaceOutput {
	s.CreateDateTime = &v
	return s
}

// SetCustomerRoleArn sets the CustomerRoleArn field's value.
func (s *GetSpaceOutput) SetCustomerRoleArn(v string) *GetSpaceOutput {
	s.CustomerRoleArn = &v
	return s
}

// SetDeleteDateTime sets the DeleteDateTime field's value.
func (s *GetSpaceOutput) SetDeleteDateTime(v time.Time) *GetSpaceOutput {
	s.DeleteDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSpaceOutput) SetDescription(v string) *GetSpaceOutput {
	s.Description = &v
	return s
}

// SetGroupAdmins sets the GroupAdmins field's value.
func (s *GetSpaceOutput) SetGroupAdmins(v []*string) *GetSpaceOutput {
	s.GroupAdmins = v
	return s
}

// SetName sets the Name field's value.
func (s *GetSpaceOutput) SetName(v string) *GetSpaceOutput {
	s.Name = &v
	return s
}

// SetRandomDomain sets the RandomDomain field's value.
func (s *GetSpaceOutput) SetRandomDomain(v string) *GetSpaceOutput {
	s.RandomDomain = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *GetSpaceOutput) SetSpaceId(v string) *GetSpaceOutput {
	s.SpaceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSpaceOutput) SetStatus(v string) *GetSpaceOutput {
	s.Status = &v
	return s
}

// SetStorageLimit sets the StorageLimit field's value.
func (s *GetSpaceOutput) SetStorageLimit(v int64) *GetSpaceOutput {
	s.StorageLimit = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *GetSpaceOutput) SetTier(v string) *GetSpaceOutput {
	s.Tier = &v
	return s
}

// SetUserAdmins sets the UserAdmins field's value.
func (s *GetSpaceOutput) SetUserAdmins(v []*string) *GetSpaceOutput {
	s.UserAdmins = v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *GetSpaceOutput) SetUserCount(v int64) *GetSpaceOutput {
	s.UserCount = &v
	return s
}

// SetUserKMSKey sets the UserKMSKey field's value.
func (s *GetSpaceOutput) SetUserKMSKey(v string) *GetSpaceOutput {
	s.UserKMSKey = &v
	return s
}

// SetVanityDomain sets the VanityDomain field's value.
func (s *GetSpaceOutput) SetVanityDomain(v string) *GetSpaceOutput {
	s.VanityDomain = &v
	return s
}

// SetVanityDomainStatus sets the VanityDomainStatus field's value.
func (s *GetSpaceOutput) SetVanityDomainStatus(v string) *GetSpaceOutput {
	s.VanityDomainStatus = &v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListSpacesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of private re:Posts to include in the results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of private re:Posts to return. You receive this
	// token from a previous ListSpaces operation.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSpacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSpacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSpacesInput) SetMaxResults(v int64) *ListSpacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpacesInput) SetNextToken(v string) *ListSpacesInput {
	s.NextToken = &v
	return s
}

type ListSpacesOutput struct {
	_ struct{} `type:"structure"`

	// The token that you use when you request the next set of private re:Posts.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of structures that contain some information about the private re:Posts
	// in the account.
	//
	// Spaces is a required field
	Spaces []*SpaceData `locationName:"spaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpacesOutput) SetNextToken(v string) *ListSpacesOutput {
	s.NextToken = &v
	return s
}

// SetSpaces sets the Spaces field's value.
func (s *ListSpacesOutput) SetSpaces(v []*SpaceData) *ListSpacesOutput {
	s.Spaces = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource that the tags are associated with.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags that are associated with the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type RegisterAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the administrator.
	//
	// AdminId is a required field
	AdminId *string `location:"uri" locationName:"adminId" type:"string" required:"true"`

	// The ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterAdminInput"}
	if s.AdminId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminId"))
	}
	if s.AdminId != nil && len(*s.AdminId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminId", 1))
	}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminId sets the AdminId field's value.
func (s *RegisterAdminInput) SetAdminId(v string) *RegisterAdminInput {
	s.AdminId = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *RegisterAdminInput) SetSpaceId(v string) *RegisterAdminInput {
	s.SpaceId = &v
	return s
}

type RegisterAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAdminOutput) GoString() string {
	return s.String()
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendInvitesInput struct {
	_ struct{} `type:"structure"`

	// The array of identifiers for the users and groups.
	//
	// AccessorIds is a required field
	AccessorIds []*string `locationName:"accessorIds" type:"list" required:"true"`

	// The body of the invite.
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendInvitesInput's
	// String and GoString methods.
	//
	// Body is a required field
	Body *string `locationName:"body" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`

	// The title of the invite.
	//
	// Title is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendInvitesInput's
	// String and GoString methods.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendInvitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendInvitesInput"}
	if s.AccessorIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessorIds"))
	}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Body != nil && len(*s.Body) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Body", 1))
	}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessorIds sets the AccessorIds field's value.
func (s *SendInvitesInput) SetAccessorIds(v []*string) *SendInvitesInput {
	s.AccessorIds = v
	return s
}

// SetBody sets the Body field's value.
func (s *SendInvitesInput) SetBody(v string) *SendInvitesInput {
	s.Body = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *SendInvitesInput) SetSpaceId(v string) *SendInvitesInput {
	s.SpaceId = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *SendInvitesInput) SetTitle(v string) *SendInvitesInput {
	s.Title = &v
	return s
}

type SendInvitesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitesOutput) GoString() string {
	return s.String()
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code to identify the quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The id of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The code to identify the service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that contains some information about a private re:Post in the
// account.
type SpaceData struct {
	_ struct{} `type:"structure"`

	// The ARN of the private re:Post.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The configuration status of the private re:Post.
	//
	// ConfigurationStatus is a required field
	ConfigurationStatus *string `locationName:"configurationStatus" type:"string" required:"true" enum:"ConfigurationStatus"`

	// The content size of the private re:Post.
	ContentSize *int64 `locationName:"contentSize" type:"long"`

	// The date when the private re:Post was created.
	//
	// CreateDateTime is a required field
	CreateDateTime *time.Time `locationName:"createDateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date when the private re:Post was deleted.
	DeleteDateTime *time.Time `locationName:"deleteDateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description for the private re:Post. This is used only to help you identify
	// this private re:Post.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SpaceData's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The name for the private re:Post.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SpaceData's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The AWS generated subdomain of the private re:Post.
	//
	// RandomDomain is a required field
	RandomDomain *string `locationName:"randomDomain" type:"string" required:"true"`

	// The unique ID of the private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `locationName:"spaceId" type:"string" required:"true"`

	// The creation/deletion status of the private re:Post.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true"`

	// The storage limit of the private re:Post.
	//
	// StorageLimit is a required field
	StorageLimit *int64 `locationName:"storageLimit" type:"long" required:"true"`

	// The pricing tier of the private re:Post.
	//
	// Tier is a required field
	Tier *string `locationName:"tier" type:"string" required:"true" enum:"TierLevel"`

	// The number of onboarded users to the private re:Post.
	UserCount *int64 `locationName:"userCount" type:"integer"`

	// The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
	UserKMSKey *string `locationName:"userKMSKey" type:"string"`

	// This custom subdomain that you use to access your private re:Post. All custom
	// subdomains must be approved by AWS before use.
	//
	// VanityDomain is a required field
	VanityDomain *string `locationName:"vanityDomain" type:"string" required:"true"`

	// This approval status of the custom subdomain.
	//
	// VanityDomainStatus is a required field
	VanityDomainStatus *string `locationName:"vanityDomainStatus" type:"string" required:"true" enum:"VanityDomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpaceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpaceData) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SpaceData) SetArn(v string) *SpaceData {
	s.Arn = &v
	return s
}

// SetConfigurationStatus sets the ConfigurationStatus field's value.
func (s *SpaceData) SetConfigurationStatus(v string) *SpaceData {
	s.ConfigurationStatus = &v
	return s
}

// SetContentSize sets the ContentSize field's value.
func (s *SpaceData) SetContentSize(v int64) *SpaceData {
	s.ContentSize = &v
	return s
}

// SetCreateDateTime sets the CreateDateTime field's value.
func (s *SpaceData) SetCreateDateTime(v time.Time) *SpaceData {
	s.CreateDateTime = &v
	return s
}

// SetDeleteDateTime sets the DeleteDateTime field's value.
func (s *SpaceData) SetDeleteDateTime(v time.Time) *SpaceData {
	s.DeleteDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SpaceData) SetDescription(v string) *SpaceData {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *SpaceData) SetName(v string) *SpaceData {
	s.Name = &v
	return s
}

// SetRandomDomain sets the RandomDomain field's value.
func (s *SpaceData) SetRandomDomain(v string) *SpaceData {
	s.RandomDomain = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *SpaceData) SetSpaceId(v string) *SpaceData {
	s.SpaceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SpaceData) SetStatus(v string) *SpaceData {
	s.Status = &v
	return s
}

// SetStorageLimit sets the StorageLimit field's value.
func (s *SpaceData) SetStorageLimit(v int64) *SpaceData {
	s.StorageLimit = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *SpaceData) SetTier(v string) *SpaceData {
	s.Tier = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *SpaceData) SetUserCount(v int64) *SpaceData {
	s.UserCount = &v
	return s
}

// SetUserKMSKey sets the UserKMSKey field's value.
func (s *SpaceData) SetUserKMSKey(v string) *SpaceData {
	s.UserKMSKey = &v
	return s
}

// SetVanityDomain sets the VanityDomain field's value.
func (s *SpaceData) SetVanityDomain(v string) *SpaceData {
	s.VanityDomain = &v
	return s
}

// SetVanityDomainStatus sets the VanityDomainStatus field's value.
func (s *SpaceData) SetVanityDomainStatus(v string) *SpaceData {
	s.VanityDomainStatus = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that the tag is associated with.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The list of tag keys and values that must be associated with the resource.
	// You can associate tag keys only, tags (key and values) only, or a combination
	// of tag keys and tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code to identify the quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code to identify the service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The key values of the tag.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateSpaceInput struct {
	_ struct{} `type:"structure"`

	// A description for the private re:Post. This is used only to help you identify
	// this private re:Post.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSpaceInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The IAM role that grants permissions to the private re:Post to convert unanswered
	// questions into AWS support tickets.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The unique ID of this private re:Post.
	//
	// SpaceId is a required field
	SpaceId *string `location:"uri" locationName:"spaceId" type:"string" required:"true"`

	// The pricing tier of this private re:Post.
	Tier *string `locationName:"tier" type:"string" enum:"TierLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSpaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSpaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSpaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSpaceInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SpaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceId"))
	}
	if s.SpaceId != nil && len(*s.SpaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSpaceInput) SetDescription(v string) *UpdateSpaceInput {
	s.Description = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateSpaceInput) SetRoleArn(v string) *UpdateSpaceInput {
	s.RoleArn = &v
	return s
}

// SetSpaceId sets the SpaceId field's value.
func (s *UpdateSpaceInput) SetSpaceId(v string) *UpdateSpaceInput {
	s.SpaceId = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateSpaceInput) SetTier(v string) *UpdateSpaceInput {
	s.Tier = &v
	return s
}

type UpdateSpaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSpaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSpaceOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that caused the error, if applicable.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason why the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field that’s passed inside a request that resulted
// in an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The name of the field.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// Message describing why the field failed validation.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// ConfigurationStatusConfigured is a ConfigurationStatus enum value
	ConfigurationStatusConfigured = "CONFIGURED"

	// ConfigurationStatusUnconfigured is a ConfigurationStatus enum value
	ConfigurationStatusUnconfigured = "UNCONFIGURED"
)

// ConfigurationStatus_Values returns all elements of the ConfigurationStatus enum
func ConfigurationStatus_Values() []string {
	return []string{
		ConfigurationStatusConfigured,
		ConfigurationStatusUnconfigured,
	}
}

const (
	// TierLevelBasic is a TierLevel enum value
	TierLevelBasic = "BASIC"

	// TierLevelStandard is a TierLevel enum value
	TierLevelStandard = "STANDARD"
)

// TierLevel_Values returns all elements of the TierLevel enum
func TierLevel_Values() []string {
	return []string{
		TierLevelBasic,
		TierLevelStandard,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VanityDomainStatusPending is a VanityDomainStatus enum value
	VanityDomainStatusPending = "PENDING"

	// VanityDomainStatusApproved is a VanityDomainStatus enum value
	VanityDomainStatusApproved = "APPROVED"

	// VanityDomainStatusUnapproved is a VanityDomainStatus enum value
	VanityDomainStatusUnapproved = "UNAPPROVED"
)

// VanityDomainStatus_Values returns all elements of the VanityDomainStatus enum
func VanityDomainStatus_Values() []string {
	return []string{
		VanityDomainStatusPending,
		VanityDomainStatusApproved,
		VanityDomainStatusUnapproved,
	}
}
