package storagecache

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CacheIdentityType enumerates the values for cache identity type.
type CacheIdentityType string

const (
	// CacheIdentityTypeNone ...
	CacheIdentityTypeNone CacheIdentityType = "None"
	// CacheIdentityTypeSystemAssigned ...
	CacheIdentityTypeSystemAssigned CacheIdentityType = "SystemAssigned"
	// CacheIdentityTypeSystemAssignedUserAssigned ...
	CacheIdentityTypeSystemAssignedUserAssigned CacheIdentityType = "SystemAssigned, UserAssigned"
	// CacheIdentityTypeUserAssigned ...
	CacheIdentityTypeUserAssigned CacheIdentityType = "UserAssigned"
)

// PossibleCacheIdentityTypeValues returns an array of possible values for the CacheIdentityType const type.
func PossibleCacheIdentityTypeValues() []CacheIdentityType {
	return []CacheIdentityType{CacheIdentityTypeNone, CacheIdentityTypeSystemAssigned, CacheIdentityTypeSystemAssignedUserAssigned, CacheIdentityTypeUserAssigned}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DomainJoinedType enumerates the values for domain joined type.
type DomainJoinedType string

const (
	// DomainJoinedTypeError ...
	DomainJoinedTypeError DomainJoinedType = "Error"
	// DomainJoinedTypeNo ...
	DomainJoinedTypeNo DomainJoinedType = "No"
	// DomainJoinedTypeYes ...
	DomainJoinedTypeYes DomainJoinedType = "Yes"
)

// PossibleDomainJoinedTypeValues returns an array of possible values for the DomainJoinedType const type.
func PossibleDomainJoinedTypeValues() []DomainJoinedType {
	return []DomainJoinedType{DomainJoinedTypeError, DomainJoinedTypeNo, DomainJoinedTypeYes}
}

// FirmwareStatusType enumerates the values for firmware status type.
type FirmwareStatusType string

const (
	// FirmwareStatusTypeAvailable ...
	FirmwareStatusTypeAvailable FirmwareStatusType = "available"
	// FirmwareStatusTypeUnavailable ...
	FirmwareStatusTypeUnavailable FirmwareStatusType = "unavailable"
)

// PossibleFirmwareStatusTypeValues returns an array of possible values for the FirmwareStatusType const type.
func PossibleFirmwareStatusTypeValues() []FirmwareStatusType {
	return []FirmwareStatusType{FirmwareStatusTypeAvailable, FirmwareStatusTypeUnavailable}
}

// HealthStateType enumerates the values for health state type.
type HealthStateType string

const (
	// HealthStateTypeDegraded ...
	HealthStateTypeDegraded HealthStateType = "Degraded"
	// HealthStateTypeDown ...
	HealthStateTypeDown HealthStateType = "Down"
	// HealthStateTypeFlushing ...
	HealthStateTypeFlushing HealthStateType = "Flushing"
	// HealthStateTypeHealthy ...
	HealthStateTypeHealthy HealthStateType = "Healthy"
	// HealthStateTypeStopped ...
	HealthStateTypeStopped HealthStateType = "Stopped"
	// HealthStateTypeStopping ...
	HealthStateTypeStopping HealthStateType = "Stopping"
	// HealthStateTypeTransitioning ...
	HealthStateTypeTransitioning HealthStateType = "Transitioning"
	// HealthStateTypeUnknown ...
	HealthStateTypeUnknown HealthStateType = "Unknown"
	// HealthStateTypeUpgrading ...
	HealthStateTypeUpgrading HealthStateType = "Upgrading"
)

// PossibleHealthStateTypeValues returns an array of possible values for the HealthStateType const type.
func PossibleHealthStateTypeValues() []HealthStateType {
	return []HealthStateType{HealthStateTypeDegraded, HealthStateTypeDown, HealthStateTypeFlushing, HealthStateTypeHealthy, HealthStateTypeStopped, HealthStateTypeStopping, HealthStateTypeTransitioning, HealthStateTypeUnknown, HealthStateTypeUpgrading}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount ...
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeNotSpecified ...
	MetricAggregationTypeNotSpecified MetricAggregationType = "NotSpecified"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeCount, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeNotSpecified, MetricAggregationTypeTotal}
}

// NfsAccessRuleAccess enumerates the values for nfs access rule access.
type NfsAccessRuleAccess string

const (
	// NfsAccessRuleAccessNo ...
	NfsAccessRuleAccessNo NfsAccessRuleAccess = "no"
	// NfsAccessRuleAccessRo ...
	NfsAccessRuleAccessRo NfsAccessRuleAccess = "ro"
	// NfsAccessRuleAccessRw ...
	NfsAccessRuleAccessRw NfsAccessRuleAccess = "rw"
)

// PossibleNfsAccessRuleAccessValues returns an array of possible values for the NfsAccessRuleAccess const type.
func PossibleNfsAccessRuleAccessValues() []NfsAccessRuleAccess {
	return []NfsAccessRuleAccess{NfsAccessRuleAccessNo, NfsAccessRuleAccessRo, NfsAccessRuleAccessRw}
}

// NfsAccessRuleScope enumerates the values for nfs access rule scope.
type NfsAccessRuleScope string

const (
	// NfsAccessRuleScopeDefault ...
	NfsAccessRuleScopeDefault NfsAccessRuleScope = "default"
	// NfsAccessRuleScopeHost ...
	NfsAccessRuleScopeHost NfsAccessRuleScope = "host"
	// NfsAccessRuleScopeNetwork ...
	NfsAccessRuleScopeNetwork NfsAccessRuleScope = "network"
)

// PossibleNfsAccessRuleScopeValues returns an array of possible values for the NfsAccessRuleScope const type.
func PossibleNfsAccessRuleScopeValues() []NfsAccessRuleScope {
	return []NfsAccessRuleScope{NfsAccessRuleScopeDefault, NfsAccessRuleScopeHost, NfsAccessRuleScopeNetwork}
}

// OperationalStateType enumerates the values for operational state type.
type OperationalStateType string

const (
	// OperationalStateTypeBusy ...
	OperationalStateTypeBusy OperationalStateType = "Busy"
	// OperationalStateTypeFlushing ...
	OperationalStateTypeFlushing OperationalStateType = "Flushing"
	// OperationalStateTypeReady ...
	OperationalStateTypeReady OperationalStateType = "Ready"
	// OperationalStateTypeSuspended ...
	OperationalStateTypeSuspended OperationalStateType = "Suspended"
)

// PossibleOperationalStateTypeValues returns an array of possible values for the OperationalStateType const type.
func PossibleOperationalStateTypeValues() []OperationalStateType {
	return []OperationalStateType{OperationalStateTypeBusy, OperationalStateTypeFlushing, OperationalStateTypeReady, OperationalStateTypeSuspended}
}

// ProvisioningStateType enumerates the values for provisioning state type.
type ProvisioningStateType string

const (
	// ProvisioningStateTypeCancelled ...
	ProvisioningStateTypeCancelled ProvisioningStateType = "Cancelled"
	// ProvisioningStateTypeCreating ...
	ProvisioningStateTypeCreating ProvisioningStateType = "Creating"
	// ProvisioningStateTypeDeleting ...
	ProvisioningStateTypeDeleting ProvisioningStateType = "Deleting"
	// ProvisioningStateTypeFailed ...
	ProvisioningStateTypeFailed ProvisioningStateType = "Failed"
	// ProvisioningStateTypeSucceeded ...
	ProvisioningStateTypeSucceeded ProvisioningStateType = "Succeeded"
	// ProvisioningStateTypeUpdating ...
	ProvisioningStateTypeUpdating ProvisioningStateType = "Updating"
)

// PossibleProvisioningStateTypeValues returns an array of possible values for the ProvisioningStateType const type.
func PossibleProvisioningStateTypeValues() []ProvisioningStateType {
	return []ProvisioningStateType{ProvisioningStateTypeCancelled, ProvisioningStateTypeCreating, ProvisioningStateTypeDeleting, ProvisioningStateTypeFailed, ProvisioningStateTypeSucceeded, ProvisioningStateTypeUpdating}
}

// ReasonCode enumerates the values for reason code.
type ReasonCode string

const (
	// ReasonCodeNotAvailableForSubscription ...
	ReasonCodeNotAvailableForSubscription ReasonCode = "NotAvailableForSubscription"
	// ReasonCodeQuotaID ...
	ReasonCodeQuotaID ReasonCode = "QuotaId"
)

// PossibleReasonCodeValues returns an array of possible values for the ReasonCode const type.
func PossibleReasonCodeValues() []ReasonCode {
	return []ReasonCode{ReasonCodeNotAvailableForSubscription, ReasonCodeQuotaID}
}

// StorageTargetType enumerates the values for storage target type.
type StorageTargetType string

const (
	// StorageTargetTypeBlobNfs ...
	StorageTargetTypeBlobNfs StorageTargetType = "blobNfs"
	// StorageTargetTypeClfs ...
	StorageTargetTypeClfs StorageTargetType = "clfs"
	// StorageTargetTypeNfs3 ...
	StorageTargetTypeNfs3 StorageTargetType = "nfs3"
	// StorageTargetTypeUnknown ...
	StorageTargetTypeUnknown StorageTargetType = "unknown"
)

// PossibleStorageTargetTypeValues returns an array of possible values for the StorageTargetType const type.
func PossibleStorageTargetTypeValues() []StorageTargetType {
	return []StorageTargetType{StorageTargetTypeBlobNfs, StorageTargetTypeClfs, StorageTargetTypeNfs3, StorageTargetTypeUnknown}
}

// UsernameDownloadedType enumerates the values for username downloaded type.
type UsernameDownloadedType string

const (
	// UsernameDownloadedTypeError ...
	UsernameDownloadedTypeError UsernameDownloadedType = "Error"
	// UsernameDownloadedTypeNo ...
	UsernameDownloadedTypeNo UsernameDownloadedType = "No"
	// UsernameDownloadedTypeYes ...
	UsernameDownloadedTypeYes UsernameDownloadedType = "Yes"
)

// PossibleUsernameDownloadedTypeValues returns an array of possible values for the UsernameDownloadedType const type.
func PossibleUsernameDownloadedTypeValues() []UsernameDownloadedType {
	return []UsernameDownloadedType{UsernameDownloadedTypeError, UsernameDownloadedTypeNo, UsernameDownloadedTypeYes}
}

// UsernameSource enumerates the values for username source.
type UsernameSource string

const (
	// UsernameSourceAD ...
	UsernameSourceAD UsernameSource = "AD"
	// UsernameSourceFile ...
	UsernameSourceFile UsernameSource = "File"
	// UsernameSourceLDAP ...
	UsernameSourceLDAP UsernameSource = "LDAP"
	// UsernameSourceNone ...
	UsernameSourceNone UsernameSource = "None"
)

// PossibleUsernameSourceValues returns an array of possible values for the UsernameSource const type.
func PossibleUsernameSourceValues() []UsernameSource {
	return []UsernameSource{UsernameSourceAD, UsernameSourceFile, UsernameSourceLDAP, UsernameSourceNone}
}
