/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Environment;
import com.google.caliper.Json;
import com.google.caliper.MeasurementSet;
import com.google.caliper.Result;
import com.google.caliper.Run;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import com.google.caliper.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Xml {
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String ENVIRONMENT_ELEMENT_NAME = "environment";
    private static final String RESULT_ELEMENT_NAME = "result";
    private static final String RUN_ELEMENT_NAME = "run";
    private static final String BENCHMARK_ATTRIBUTE = "benchmark";
    private static final String EXECUTED_TIMESTAMP_ATTRIBUTE = "executedTimestamp";
    private static final String OLD_SCENARIO_ELEMENT_NAME = "scenario";
    private static final String SCENARIO_ELEMENT_NAME = "newScenario";
    private static final String MEASUREMENTS_ELEMENT_NAME = "measurements";
    private static final String TIME_EVENT_LOG_ELEMENT_NAME = "eventLog";

    private static Result readResultElement(Element element) throws Exception {
        Environment environment = null;
        Run run = null;
        for (Node topLevelNode : XmlUtils.childrenOf(element)) {
            if (topLevelNode.getNodeName().equals(ENVIRONMENT_ELEMENT_NAME)) {
                Element environmentElement = (Element)topLevelNode;
                environment = Xml.readEnvironmentElement(environmentElement);
                continue;
            }
            if (topLevelNode.getNodeName().equals(RUN_ELEMENT_NAME)) {
                run = Xml.readRunElement((Element)topLevelNode);
                continue;
            }
            throw new RuntimeException("illegal node name: " + topLevelNode.getNodeName());
        }
        if (environment == null || run == null) {
            throw new RuntimeException("missing environment or run elements");
        }
        return new Result(run, environment);
    }

    private static Environment readEnvironmentElement(Element element) {
        return new Environment((Map<String, String>)XmlUtils.attributesOf(element));
    }

    private static Run readRunElement(Element element) throws Exception {
        String benchmarkName = element.getAttribute(BENCHMARK_ATTRIBUTE);
        String executedDateString = element.getAttribute(EXECUTED_TIMESTAMP_ATTRIBUTE);
        Date executedDate = new SimpleDateFormat(DATE_FORMAT_STRING, Locale.US).parse(executedDateString);
        ImmutableMap.Builder measurementsBuilder = ImmutableMap.builder();
        for (Node scenarioNode : XmlUtils.childrenOf(element)) {
            ScenarioResult scenarioResult;
            Element scenarioElement = (Element)scenarioNode;
            Scenario scenario = new Scenario((Map<String, String>)XmlUtils.attributesOf(scenarioElement));
            if (scenarioNode.getNodeName().equals(OLD_SCENARIO_ELEMENT_NAME)) {
                MeasurementSet measurement = Json.measurementSetFromJson(scenarioElement.getTextContent());
                scenarioResult = new ScenarioResult(measurement, "", null, null, null, null);
            } else if (scenarioNode.getNodeName().equals(SCENARIO_ELEMENT_NAME)) {
                MeasurementSet timeMeasurementSet = null;
                String eventLog = null;
                for (Node node : XmlUtils.childrenOf(scenarioElement)) {
                    if (node.getNodeName().equals(MEASUREMENTS_ELEMENT_NAME)) {
                        timeMeasurementSet = Json.measurementSetFromJson(node.getTextContent());
                        continue;
                    }
                    if (node.getNodeName().equals(TIME_EVENT_LOG_ELEMENT_NAME)) {
                        eventLog = node.getTextContent();
                        continue;
                    }
                    throw new RuntimeException("illegal node name: " + node.getNodeName());
                }
                if (timeMeasurementSet == null || eventLog == null) {
                    throw new RuntimeException("missing node \"measurements\" or \"eventLog\"");
                }
                scenarioResult = new ScenarioResult(timeMeasurementSet, eventLog, null, null, null, null);
            } else {
                throw new RuntimeException("illegal node name: " + scenarioNode.getNodeName());
            }
            measurementsBuilder.put((Object)scenario, (Object)scenarioResult);
        }
        return new Run((Map<Scenario, ScenarioResult>)measurementsBuilder.build(), benchmarkName, executedDate);
    }

    public static Run runFromXml(InputStream in) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            return Xml.readRunElement(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalStateException("Malformed XML document", e);
        }
    }

    public static Environment environmentFromXml(InputStream in) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            Element environmentElement = document.getDocumentElement();
            return Xml.readEnvironmentElement(environmentElement);
        }
        catch (Exception e) {
            throw new IllegalStateException("Malformed XML document", e);
        }
    }

    public static Result resultFromXml(InputStream in) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            return Xml.readResultElement(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalStateException("Malformed XML document", e);
        }
    }

    private Xml() {
    }
}

