/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.languages.dataobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/**
 *
 * @author  hanz
 */
public class GLFFilesCustomEditor extends javax.swing.JPanel {
    
    /** Creates new form GLFFilesCustomEditor */
    public GLFFilesCustomEditor () {
        initComponents ();
        List<String> mimeTypes = getSupportedMimeTypes ();
        Collections.sort (mimeTypes);
        DefaultListModel<String> model = new DefaultListModel<>();
        Iterator<String> it = mimeTypes.iterator ();
        while (it.hasNext ()) {
            String name = (String) it.next ();
            model.addElement (name);
        }
        lFiles.setModel (model);    
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings ("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        spFiles = new javax.swing.JScrollPane();
        lFiles = new javax.swing.JList();
        bEdit = new javax.swing.JButton();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(GLFFilesCustomEditor.class, "GLFFilesCustomEditor.jLabel1.text")); // NOI18N

        spFiles.setViewportView(lFiles);

        bEdit.setText(org.openide.util.NbBundle.getMessage(GLFFilesCustomEditor.class, "GLFFilesCustomEditor.bEdit.text")); // NOI18N
        bEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bEditActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel1)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(spFiles, javax.swing.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bEdit))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(bEdit)
                        .addContainerGap())
                    .addComponent(spFiles, javax.swing.GroupLayout.DEFAULT_SIZE, 139, Short.MAX_VALUE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private static List<String> getSupportedMimeTypes () {
        List<String> result = new ArrayList<String> ();
        FileSystem fs = Repository.getDefault ().getDefaultFileSystem ();
        FileObject root = fs.findResource ("Editors");
        Enumeration e1 = root.getChildren (false);
        while (e1.hasMoreElements ()) {
            FileObject f1 = (FileObject) e1.nextElement ();
            if (f1.isData ()) continue;
            Enumeration e2 = f1.getChildren (false);
            while (e2.hasMoreElements ()) {
                FileObject f2 = (FileObject) e2.nextElement ();
                if (f2.isData ()) continue;
                FileObject fo = f2.getFileObject ("language.nbs");
                if (fo == null) continue;
                result.add (f1.getName () + '/' + f2.getName ());
            }
        }
        return result;
    }
    
    private void bEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bEditActionPerformed
        String mimeType = (String) lFiles.getSelectedValue ();
        if (mimeType == null) return;
        FileObject fileObject = Repository.getDefault ().getDefaultFileSystem ().findResource ("Editors/" + mimeType + "/language.nbs");
        try {
            DataObject dataObject = DataObject.find (fileObject);
            OpenCookie openCookie = dataObject.getCookie (OpenCookie.class);
            openCookie.open ();
        } catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace (ex);
        }
}//GEN-LAST:event_bEditActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bEdit;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList lFiles;
    private javax.swing.JScrollPane spFiles;
    // End of variables declaration//GEN-END:variables
    
}
