/*******************************************************************************
    Copyright (c) 2020, NVIDIA CORPORATION. All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

*******************************************************************************/

/* AUTO GENERATED FILE -- DO NOT EDIT */

#ifndef __CLC7C0QMD_H__
#define __CLC7C0QMD_H__

/*
** Queue Meta Data, Version 02_03
 */

// The below C preprocessor definitions describe "multi-word" structures, where
// fields may have bit numbers beyond 32.  For example, MW(127:96) means
// the field is in bits 0-31 of word number 3 of the structure.  The "MW(X:Y)"
// syntax is to distinguish from similar "X:Y" single-word definitions: the
// macros historically used for single-word definitions would fail with
// multi-word definitions.
//
// See nvmisc.h:DRF_VAL_MW() in the source code of the kernel
// interface layer of nvidia.ko for an example of how to manipulate
// these MW(X:Y) definitions.

#define NVC7C0_QMDV02_03_OUTER_PUT                                 MW(30:0)
#define NVC7C0_QMDV02_03_OUTER_OVERFLOW                            MW(31:31)
#define NVC7C0_QMDV02_03_OUTER_GET                                 MW(62:32)
#define NVC7C0_QMDV02_03_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC7C0_QMDV02_03_INNER_GET                                 MW(94:64)
#define NVC7C0_QMDV02_03_INNER_OVERFLOW                            MW(95:95)
#define NVC7C0_QMDV02_03_INNER_PUT                                 MW(126:96)
#define NVC7C0_QMDV02_03_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC7C0_QMDV02_03_QMD_GROUP_ID                              MW(133:128)
#define NVC7C0_QMDV02_03_SM_GLOBAL_CACHING_ENABLE                  MW(134:134)
#define NVC7C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION               MW(135:135)
#define NVC7C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC7C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC7C0_QMDV02_03_IS_QUEUE                                  MW(136:136)
#define NVC7C0_QMDV02_03_IS_QUEUE_FALSE                            0x00000000
#define NVC7C0_QMDV02_03_IS_QUEUE_TRUE                             0x00000001
#define NVC7C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(137:137)
#define NVC7C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC7C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0                 MW(138:138)
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0_FALSE           0x00000000
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0_TRUE            0x00000001
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1                 MW(139:139)
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1_FALSE           0x00000000
#define NVC7C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1_TRUE            0x00000001
#define NVC7C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS                   MW(140:140)
#define NVC7C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC7C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE             MW(141:141)
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE_FALSE       0x00000000
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE_TRUE        0x00000001
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_TYPE                        MW(142:142)
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_TYPE_QUEUE                  0x00000000
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_TYPE_GRID                   0x00000001
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY                  MW(143:143)
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY_FALSE            0x00000000
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY_TRUE             0x00000001
#define NVC7C0_QMDV02_03_QMD_RESERVED_B                            MW(159:144)
#define NVC7C0_QMDV02_03_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVC7C0_QMDV02_03_QMD_RESERVED_C                            MW(185:185)
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE           MW(186:186)
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(187:187)
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE             MW(188:188)
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE              MW(189:189)
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE              MW(190:190)
#define NVC7C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE          MW(191:191)
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV02_03_CTA_RASTER_WIDTH_RESUME                   MW(223:192)
#define NVC7C0_QMDV02_03_CTA_RASTER_HEIGHT_RESUME                  MW(239:224)
#define NVC7C0_QMDV02_03_CTA_RASTER_DEPTH_RESUME                   MW(255:240)
#define NVC7C0_QMDV02_03_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED       MW(287:256)
#define NVC7C0_QMDV02_03_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC7C0_QMDV02_03_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC7C0_QMDV02_03_QMD_RESERVED_D                            MW(335:328)
#define NVC7C0_QMDV02_03_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC7C0_QMDV02_03_RELEASE_MEMBAR_TYPE                       MW(366:366)
#define NVC7C0_QMDV02_03_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVC7C0_QMDV02_03_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV02_03_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC7C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC7C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC7C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC7C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC7C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC7C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV02_03_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC7C0_QMDV02_03_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC7C0_QMDV02_03_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC7C0_QMDV02_03_SAMPLER_INDEX                             MW(382:382)
#define NVC7C0_QMDV02_03_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC7C0_QMDV02_03_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC7C0_QMDV02_03_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC7C0_QMDV02_03_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC7C0_QMDV02_03_QMD_RESERVED13A                           MW(447:432)
#define NVC7C0_QMDV02_03_CTA_RASTER_DEPTH                          MW(463:448)
#define NVC7C0_QMDV02_03_QMD_RESERVED14A                           MW(479:464)
#define NVC7C0_QMDV02_03_DEPENDENT_QMD_POINTER                     MW(511:480)
#define NVC7C0_QMDV02_03_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC7C0_QMDV02_03_QUEUE_ENTRIES_PER_CTA_LOG2                MW(534:530)
#define NVC7C0_QMDV02_03_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC7C0_QMDV02_03_MIN_SM_CONFIG_SHARED_MEM_SIZE             MW(568:562)
#define NVC7C0_QMDV02_03_MAX_SM_CONFIG_SHARED_MEM_SIZE             MW(575:569)
#define NVC7C0_QMDV02_03_QMD_VERSION                               MW(579:576)
#define NVC7C0_QMDV02_03_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC7C0_QMDV02_03_QMD_RESERVED_H                            MW(591:584)
#define NVC7C0_QMDV02_03_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC7C0_QMDV02_03_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC7C0_QMDV02_03_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC7C0_QMDV02_03_REGISTER_COUNT_V                          MW(656:648)
#define NVC7C0_QMDV02_03_TARGET_SM_CONFIG_SHARED_MEM_SIZE          MW(663:657)
#define NVC7C0_QMDV02_03_FREE_CTA_SLOTS_EMPTY_SM                   MW(671:664)
#define NVC7C0_QMDV02_03_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC7C0_QMDV02_03_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC7C0_QMDV02_03_RELEASE0_ADDRESS_LOWER                    MW(767:736)
#define NVC7C0_QMDV02_03_RELEASE0_ADDRESS_UPPER                    MW(775:768)
#define NVC7C0_QMDV02_03_QMD_RESERVED_J                            MW(783:776)
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP                     MW(790:788)
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV02_03_QMD_RESERVED_K                            MW(791:791)
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT                 MW(793:792)
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE                 MW(794:794)
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE                   MW(799:799)
#define NVC7C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC7C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC7C0_QMDV02_03_RELEASE0_PAYLOAD                          MW(831:800)
#define NVC7C0_QMDV02_03_RELEASE1_ADDRESS_LOWER                    MW(863:832)
#define NVC7C0_QMDV02_03_RELEASE1_ADDRESS_UPPER                    MW(871:864)
#define NVC7C0_QMDV02_03_QMD_RESERVED_L                            MW(879:872)
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP                     MW(886:884)
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV02_03_QMD_RESERVED_M                            MW(887:887)
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT                 MW(889:888)
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE                 MW(890:890)
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE                   MW(895:895)
#define NVC7C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC7C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC7C0_QMDV02_03_RELEASE1_PAYLOAD                          MW(927:896)
#define NVC7C0_QMDV02_03_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(951:928)
#define NVC7C0_QMDV02_03_QMD_RESERVED_N                            MW(954:952)
#define NVC7C0_QMDV02_03_BARRIER_COUNT                             MW(959:955)
#define NVC7C0_QMDV02_03_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(983:960)
#define NVC7C0_QMDV02_03_REGISTER_COUNT                            MW(991:984)
#define NVC7C0_QMDV02_03_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED       MW(1000:992)
#define NVC7C0_QMDV02_03_PROGRAM_PREFETCH_SIZE                     MW(1009:1001)
#define NVC7C0_QMDV02_03_QMD_RESERVED_A                            MW(1015:1010)
#define NVC7C0_QMDV02_03_SASS_VERSION                              MW(1023:1016)
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((1055+(i)*64):(1024+(i)*64))
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((1072+(i)*64):(1056+(i)*64))
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST(i)          MW((1073+(i)*64):(1073+(i)*64))
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST_FALSE       0x00000000
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST_TRUE        0x00000001
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE(i)             MW((1074+(i)*64):(1074+(i)*64))
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC7C0_QMDV02_03_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1087+(i)*64):(1075+(i)*64))
#define NVC7C0_QMDV02_03_PROGRAM_ADDRESS_LOWER                     MW(1567:1536)
#define NVC7C0_QMDV02_03_PROGRAM_ADDRESS_UPPER                     MW(1584:1568)
#define NVC7C0_QMDV02_03_QMD_RESERVED_S                            MW(1599:1585)
#define NVC7C0_QMDV02_03_HW_ONLY_INNER_GET                         MW(1630:1600)
#define NVC7C0_QMDV02_03_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1631:1631)
#define NVC7C0_QMDV02_03_HW_ONLY_INNER_PUT                         MW(1662:1632)
#define NVC7C0_QMDV02_03_HW_ONLY_SCG_TYPE                          MW(1663:1663)
#define NVC7C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1693:1664)
#define NVC7C0_QMDV02_03_QMD_RESERVED_Q                            MW(1694:1694)
#define NVC7C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1695:1695)
#define NVC7C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC7C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC7C0_QMDV02_03_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1727:1696)
#define NVC7C0_QMDV02_03_QMD_SPARE_G                               MW(1759:1728)
#define NVC7C0_QMDV02_03_QMD_SPARE_H                               MW(1791:1760)
#define NVC7C0_QMDV02_03_QMD_SPARE_I                               MW(1823:1792)
#define NVC7C0_QMDV02_03_QMD_SPARE_J                               MW(1855:1824)
#define NVC7C0_QMDV02_03_QMD_SPARE_K                               MW(1887:1856)
#define NVC7C0_QMDV02_03_QMD_SPARE_L                               MW(1919:1888)
#define NVC7C0_QMDV02_03_QMD_SPARE_M                               MW(1951:1920)
#define NVC7C0_QMDV02_03_QMD_SPARE_N                               MW(1983:1952)
#define NVC7C0_QMDV02_03_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC7C0_QMDV02_03_DEBUG_ID_LOWER                            MW(2047:2016)


/*
** Queue Meta Data, Version 02_04
 */

#define NVC7C0_QMDV02_04_OUTER_PUT                                 MW(30:0)
#define NVC7C0_QMDV02_04_OUTER_OVERFLOW                            MW(31:31)
#define NVC7C0_QMDV02_04_OUTER_GET                                 MW(62:32)
#define NVC7C0_QMDV02_04_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC7C0_QMDV02_04_INNER_GET                                 MW(94:64)
#define NVC7C0_QMDV02_04_INNER_OVERFLOW                            MW(95:95)
#define NVC7C0_QMDV02_04_INNER_PUT                                 MW(126:96)
#define NVC7C0_QMDV02_04_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC7C0_QMDV02_04_QMD_GROUP_ID                              MW(133:128)
#define NVC7C0_QMDV02_04_SM_GLOBAL_CACHING_ENABLE                  MW(134:134)
#define NVC7C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION               MW(135:135)
#define NVC7C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC7C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC7C0_QMDV02_04_IS_QUEUE                                  MW(136:136)
#define NVC7C0_QMDV02_04_IS_QUEUE_FALSE                            0x00000000
#define NVC7C0_QMDV02_04_IS_QUEUE_TRUE                             0x00000001
#define NVC7C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(137:137)
#define NVC7C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC7C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0                 MW(138:138)
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0_FALSE           0x00000000
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0_TRUE            0x00000001
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1                 MW(139:139)
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1_FALSE           0x00000000
#define NVC7C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1_TRUE            0x00000001
#define NVC7C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS                   MW(140:140)
#define NVC7C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC7C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ENABLE                     MW(141:141)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ENABLE_FALSE               0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ENABLE_TRUE                0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ACTION                     MW(144:142)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE        0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH                   MW(145:145)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH_FALSE             0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH_TRUE              0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ENABLE                     MW(146:146)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ENABLE_FALSE               0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ENABLE_TRUE                0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ACTION                     MW(149:147)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE        0x00000001
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH                   MW(150:150)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH_FALSE             0x00000000
#define NVC7C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH_TRUE              0x00000001
#define NVC7C0_QMDV02_04_DEPENDENCE_COUNTER                        MW(157:151)
#define NVC7C0_QMDV02_04_SELF_COPY_ON_COMPLETION                   MW(158:158)
#define NVC7C0_QMDV02_04_SELF_COPY_ON_COMPLETION_FALSE             0x00000000
#define NVC7C0_QMDV02_04_SELF_COPY_ON_COMPLETION_TRUE              0x00000001
#define NVC7C0_QMDV02_04_QMD_RESERVED_B                            MW(159:159)
#define NVC7C0_QMDV02_04_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVC7C0_QMDV02_04_DEMOTE_L2_EVICT_LAST                      MW(185:185)
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE           MW(186:186)
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(187:187)
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE             MW(188:188)
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE              MW(189:189)
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE              MW(190:190)
#define NVC7C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE          MW(191:191)
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV02_04_CTA_RASTER_WIDTH_RESUME                   MW(223:192)
#define NVC7C0_QMDV02_04_CTA_RASTER_HEIGHT_RESUME                  MW(239:224)
#define NVC7C0_QMDV02_04_CTA_RASTER_DEPTH_RESUME                   MW(255:240)
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED       MW(287:256)
#define NVC7C0_QMDV02_04_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC7C0_QMDV02_04_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC7C0_QMDV02_04_QMD_RESERVED_D                            MW(335:328)
#define NVC7C0_QMDV02_04_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC7C0_QMDV02_04_RELEASE_MEMBAR_TYPE                       MW(366:366)
#define NVC7C0_QMDV02_04_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVC7C0_QMDV02_04_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV02_04_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC7C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC7C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC7C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC7C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC7C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC7C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV02_04_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC7C0_QMDV02_04_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC7C0_QMDV02_04_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC7C0_QMDV02_04_SAMPLER_INDEX                             MW(382:382)
#define NVC7C0_QMDV02_04_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC7C0_QMDV02_04_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC7C0_QMDV02_04_DISABLE_AUTO_INVALIDATE                   MW(383:383)
#define NVC7C0_QMDV02_04_DISABLE_AUTO_INVALIDATE_FALSE             0x00000000
#define NVC7C0_QMDV02_04_DISABLE_AUTO_INVALIDATE_TRUE              0x00000001
#define NVC7C0_QMDV02_04_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC7C0_QMDV02_04_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC7C0_QMDV02_04_QMD_RESERVED13A                           MW(447:432)
#define NVC7C0_QMDV02_04_CTA_RASTER_DEPTH                          MW(463:448)
#define NVC7C0_QMDV02_04_QMD_RESERVED14A                           MW(479:464)
#define NVC7C0_QMDV02_04_DEPENDENT_QMD0_POINTER                    MW(511:480)
#define NVC7C0_QMDV02_04_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC7C0_QMDV02_04_QUEUE_ENTRIES_PER_CTA_LOG2                MW(534:530)
#define NVC7C0_QMDV02_04_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC7C0_QMDV02_04_MIN_SM_CONFIG_SHARED_MEM_SIZE             MW(568:562)
#define NVC7C0_QMDV02_04_MAX_SM_CONFIG_SHARED_MEM_SIZE             MW(575:569)
#define NVC7C0_QMDV02_04_QMD_VERSION                               MW(579:576)
#define NVC7C0_QMDV02_04_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC7C0_QMDV02_04_QMD_RESERVED_H                            MW(591:584)
#define NVC7C0_QMDV02_04_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC7C0_QMDV02_04_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC7C0_QMDV02_04_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC7C0_QMDV02_04_REGISTER_COUNT_V                          MW(656:648)
#define NVC7C0_QMDV02_04_TARGET_SM_CONFIG_SHARED_MEM_SIZE          MW(663:657)
#define NVC7C0_QMDV02_04_FREE_CTA_SLOTS_EMPTY_SM                   MW(671:664)
#define NVC7C0_QMDV02_04_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC7C0_QMDV02_04_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC7C0_QMDV02_04_RELEASE0_ADDRESS_LOWER                    MW(767:736)
#define NVC7C0_QMDV02_04_RELEASE0_ADDRESS_UPPER                    MW(775:768)
#define NVC7C0_QMDV02_04_QMD_RESERVED_J                            MW(783:776)
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP                     MW(790:788)
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV02_04_QMD_RESERVED_K                            MW(791:791)
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT                 MW(793:792)
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE                 MW(794:794)
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE                   MW(799:799)
#define NVC7C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC7C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC7C0_QMDV02_04_RELEASE0_PAYLOAD                          MW(831:800)
#define NVC7C0_QMDV02_04_RELEASE1_ADDRESS_LOWER                    MW(863:832)
#define NVC7C0_QMDV02_04_RELEASE1_ADDRESS_UPPER                    MW(871:864)
#define NVC7C0_QMDV02_04_QMD_RESERVED_L                            MW(879:872)
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP                     MW(886:884)
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV02_04_QMD_RESERVED_M                            MW(887:887)
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT                 MW(889:888)
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE                 MW(890:890)
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE                   MW(895:895)
#define NVC7C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC7C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC7C0_QMDV02_04_RELEASE1_PAYLOAD                          MW(927:896)
#define NVC7C0_QMDV02_04_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(951:928)
#define NVC7C0_QMDV02_04_QMD_RESERVED_N                            MW(954:952)
#define NVC7C0_QMDV02_04_BARRIER_COUNT                             MW(959:955)
#define NVC7C0_QMDV02_04_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(983:960)
#define NVC7C0_QMDV02_04_QMD_RESERVED_G                            MW(991:984)
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED       MW(1000:992)
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_SIZE                     MW(1009:1001)
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_TYPE                     MW(1011:1010)
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH     0x00000000
#define NVC7C0_QMDV02_04_PROGRAM_PREFETCH_TYPE_PREFTECH_POST       0x00000001
#define NVC7C0_QMDV02_04_QMD_RESERVED_A                            MW(1015:1012)
#define NVC7C0_QMDV02_04_SASS_VERSION                              MW(1023:1016)
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((1055+(i)*64):(1024+(i)*64))
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((1072+(i)*64):(1056+(i)*64))
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST(i)          MW((1073+(i)*64):(1073+(i)*64))
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST_FALSE       0x00000000
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST_TRUE        0x00000001
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE(i)             MW((1074+(i)*64):(1074+(i)*64))
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC7C0_QMDV02_04_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1087+(i)*64):(1075+(i)*64))
#define NVC7C0_QMDV02_04_PROGRAM_ADDRESS_LOWER                     MW(1567:1536)
#define NVC7C0_QMDV02_04_PROGRAM_ADDRESS_UPPER                     MW(1584:1568)
#define NVC7C0_QMDV02_04_QMD_RESERVED_S                            MW(1599:1585)
#define NVC7C0_QMDV02_04_HW_ONLY_INNER_GET                         MW(1630:1600)
#define NVC7C0_QMDV02_04_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1631:1631)
#define NVC7C0_QMDV02_04_HW_ONLY_INNER_PUT                         MW(1662:1632)
#define NVC7C0_QMDV02_04_HW_ONLY_SCG_TYPE                          MW(1663:1663)
#define NVC7C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1693:1664)
#define NVC7C0_QMDV02_04_QMD_RESERVED_Q                            MW(1694:1694)
#define NVC7C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1695:1695)
#define NVC7C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC7C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC7C0_QMDV02_04_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1727:1696)
#define NVC7C0_QMDV02_04_HW_ONLY_DEPENDENCE_COUNTER                MW(1734:1728)
#define NVC7C0_QMDV02_04_QMD_RESERVED_I                            MW(1759:1735)
#define NVC7C0_QMDV02_04_QMD_SPARE_H                               MW(1791:1760)
#define NVC7C0_QMDV02_04_QMD_SPARE_I                               MW(1823:1792)
#define NVC7C0_QMDV02_04_QMD_SPARE_J                               MW(1855:1824)
#define NVC7C0_QMDV02_04_QMD_SPARE_K                               MW(1887:1856)
#define NVC7C0_QMDV02_04_QMD_SPARE_L                               MW(1919:1888)
#define NVC7C0_QMDV02_04_QMD_SPARE_M                               MW(1951:1920)
#define NVC7C0_QMDV02_04_QMD_SPARE_N                               MW(1983:1952)
#define NVC7C0_QMDV02_04_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC7C0_QMDV02_04_DEBUG_ID_LOWER                            MW(2047:2016)


/*
** Queue Meta Data, Version 03_00
 */

#define NVC7C0_QMDV03_00_OUTER_PUT                                 MW(30:0)
#define NVC7C0_QMDV03_00_OUTER_OVERFLOW                            MW(31:31)
#define NVC7C0_QMDV03_00_OUTER_GET                                 MW(62:32)
#define NVC7C0_QMDV03_00_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC7C0_QMDV03_00_INNER_GET                                 MW(94:64)
#define NVC7C0_QMDV03_00_INNER_OVERFLOW                            MW(95:95)
#define NVC7C0_QMDV03_00_INNER_PUT                                 MW(126:96)
#define NVC7C0_QMDV03_00_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC7C0_QMDV03_00_QMD_GROUP_ID                              MW(133:128)
#define NVC7C0_QMDV03_00_SM_GLOBAL_CACHING_ENABLE                  MW(134:134)
#define NVC7C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION               MW(135:135)
#define NVC7C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC7C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC7C0_QMDV03_00_IS_QUEUE                                  MW(136:136)
#define NVC7C0_QMDV03_00_IS_QUEUE_FALSE                            0x00000000
#define NVC7C0_QMDV03_00_IS_QUEUE_TRUE                             0x00000001
#define NVC7C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(137:137)
#define NVC7C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC7C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC7C0_QMDV03_00_QMD_RESERVED04A                           MW(139:138)
#define NVC7C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS                   MW(140:140)
#define NVC7C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC7C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC7C0_QMDV03_00_QMD_RESERVED04B                           MW(141:141)
#define NVC7C0_QMDV03_00_DEPENDENCE_COUNTER                        MW(157:142)
#define NVC7C0_QMDV03_00_SELF_COPY_ON_COMPLETION                   MW(158:158)
#define NVC7C0_QMDV03_00_SELF_COPY_ON_COMPLETION_FALSE             0x00000000
#define NVC7C0_QMDV03_00_SELF_COPY_ON_COMPLETION_TRUE              0x00000001
#define NVC7C0_QMDV03_00_QMD_RESERVED04C                           MW(159:159)
#define NVC7C0_QMDV03_00_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVC7C0_QMDV03_00_DEMOTE_L2_EVICT_LAST                      MW(185:185)
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE           MW(186:186)
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(187:187)
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE             MW(188:188)
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE              MW(189:189)
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE              MW(190:190)
#define NVC7C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE          MW(191:191)
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC7C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC7C0_QMDV03_00_CTA_RASTER_WIDTH_RESUME                   MW(223:192)
#define NVC7C0_QMDV03_00_CTA_RASTER_HEIGHT_RESUME                  MW(239:224)
#define NVC7C0_QMDV03_00_CTA_RASTER_DEPTH_RESUME                   MW(255:240)
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED       MW(287:256)
#define NVC7C0_QMDV03_00_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC7C0_QMDV03_00_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC7C0_QMDV03_00_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC7C0_QMDV03_00_QMD_RESERVED11A                           MW(366:366)
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV03_00_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC7C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC7C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC7C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC7C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC7C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC7C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC7C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC7C0_QMDV03_00_QMD_RESERVED11B                           MW(377:372)
#define NVC7C0_QMDV03_00_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC7C0_QMDV03_00_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC7C0_QMDV03_00_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC7C0_QMDV03_00_QMD_RESERVED11C                           MW(381:379)
#define NVC7C0_QMDV03_00_SAMPLER_INDEX                             MW(382:382)
#define NVC7C0_QMDV03_00_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC7C0_QMDV03_00_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC7C0_QMDV03_00_DISABLE_AUTO_INVALIDATE                   MW(383:383)
#define NVC7C0_QMDV03_00_DISABLE_AUTO_INVALIDATE_FALSE             0x00000000
#define NVC7C0_QMDV03_00_DISABLE_AUTO_INVALIDATE_TRUE              0x00000001
#define NVC7C0_QMDV03_00_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC7C0_QMDV03_00_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC7C0_QMDV03_00_CTA_RASTER_DEPTH                          MW(463:448)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_POINTER                    MW(511:480)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ENABLE                     MW(512:512)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ENABLE_FALSE               0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ENABLE_TRUE                0x00000001
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ACTION                     MW(515:513)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE        0x00000001
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH                   MW(516:516)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH_FALSE             0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH_TRUE              0x00000001
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ENABLE                     MW(517:517)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ENABLE_FALSE               0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ENABLE_TRUE                0x00000001
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ACTION                     MW(520:518)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE        0x00000001
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH                   MW(521:521)
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH_FALSE             0x00000000
#define NVC7C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH_TRUE              0x00000001
#define NVC7C0_QMDV03_00_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC7C0_QMDV03_00_QUEUE_ENTRIES_PER_CTA_LOG2                MW(534:530)
#define NVC7C0_QMDV03_00_OCCUPANCY_THRESHOLD_SHARED_MEM            MW(542:535)
#define NVC7C0_QMDV03_00_CTA_LAUNCH_QUEUE                          MW(543:543)
#define NVC7C0_QMDV03_00_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC7C0_QMDV03_00_MIN_SM_CONFIG_SHARED_MEM_SIZE             MW(567:562)
#define NVC7C0_QMDV03_00_QMD_RESERVED17A                           MW(568:568)
#define NVC7C0_QMDV03_00_MAX_SM_CONFIG_SHARED_MEM_SIZE             MW(574:569)
#define NVC7C0_QMDV03_00_QMD_RESERVED17B                           MW(575:575)
#define NVC7C0_QMDV03_00_QMD_VERSION                               MW(579:576)
#define NVC7C0_QMDV03_00_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC7C0_QMDV03_00_OCCUPANCY_MAX_SHARED_MEM                  MW(591:584)
#define NVC7C0_QMDV03_00_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC7C0_QMDV03_00_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC7C0_QMDV03_00_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC7C0_QMDV03_00_REGISTER_COUNT_V                          MW(656:648)
#define NVC7C0_QMDV03_00_TARGET_SM_CONFIG_SHARED_MEM_SIZE          MW(662:657)
#define NVC7C0_QMDV03_00_SHARED_ALLOCATION_ENABLE                  MW(663:663)
#define NVC7C0_QMDV03_00_SHARED_ALLOCATION_ENABLE_FALSE            0x00000000
#define NVC7C0_QMDV03_00_SHARED_ALLOCATION_ENABLE_TRUE             0x00000001
#define NVC7C0_QMDV03_00_FREE_CTA_SLOTS_EMPTY_SM                   MW(671:664)
#define NVC7C0_QMDV03_00_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC7C0_QMDV03_00_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC7C0_QMDV03_00_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(759:736)
#define NVC7C0_QMDV03_00_BARRIER_COUNT                             MW(767:763)
#define NVC7C0_QMDV03_00_RELEASE0_ADDRESS_LOWER                    MW(799:768)
#define NVC7C0_QMDV03_00_RELEASE0_ADDRESS_UPPER                    MW(807:800)
#define NVC7C0_QMDV03_00_SEMAPHORE_RESERVED25A                     MW(818:808)
#define NVC7C0_QMDV03_00_RELEASE0_MEMBAR_TYPE                      MW(819:819)
#define NVC7C0_QMDV03_00_RELEASE0_MEMBAR_TYPE_FE_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_MEMBAR_TYPE_FE_SYSMEMBAR         0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP                     MW(822:820)
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV03_00_RELEASE0_ENABLE                           MW(823:823)
#define NVC7C0_QMDV03_00_RELEASE0_ENABLE_FALSE                     0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_ENABLE_TRUE                      0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT                 MW(825:824)
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT_UNSIGNED        0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT_SIGNED          0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE                 MW(826:826)
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_TRAP_TYPE                        MW(828:827)
#define NVC7C0_QMDV03_00_RELEASE0_TRAP_TYPE_TRAP_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_TRAP_TYPE_TRAP_UNCONDITIONAL     0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_TRAP_TYPE_TRAP_CONDITIONAL       0x00000002
#define NVC7C0_QMDV03_00_RELEASE0_TRAP_TYPE_TRAP_CONDITIONAL_EXT   0x00000003
#define NVC7C0_QMDV03_00_RELEASE0_PAYLOAD64B                       MW(829:829)
#define NVC7C0_QMDV03_00_RELEASE0_PAYLOAD64B_FALSE                 0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_PAYLOAD64B_TRUE                  0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE                   MW(831:830)
#define NVC7C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVC7C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVC7C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVC7C0_QMDV03_00_RELEASE0_PAYLOAD_LOWER                    MW(863:832)
#define NVC7C0_QMDV03_00_RELEASE0_PAYLOAD_UPPER                    MW(895:864)
#define NVC7C0_QMDV03_00_RELEASE1_ADDRESS_LOWER                    MW(927:896)
#define NVC7C0_QMDV03_00_RELEASE1_ADDRESS_UPPER                    MW(935:928)
#define NVC7C0_QMDV03_00_SEMAPHORE_RESERVED29A                     MW(946:936)
#define NVC7C0_QMDV03_00_RELEASE1_MEMBAR_TYPE                      MW(947:947)
#define NVC7C0_QMDV03_00_RELEASE1_MEMBAR_TYPE_FE_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_MEMBAR_TYPE_FE_SYSMEMBAR         0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP                     MW(950:948)
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV03_00_RELEASE1_ENABLE                           MW(951:951)
#define NVC7C0_QMDV03_00_RELEASE1_ENABLE_FALSE                     0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_ENABLE_TRUE                      0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT                 MW(953:952)
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT_UNSIGNED        0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT_SIGNED          0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE                 MW(954:954)
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_TRAP_TYPE                        MW(956:955)
#define NVC7C0_QMDV03_00_RELEASE1_TRAP_TYPE_TRAP_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_TRAP_TYPE_TRAP_UNCONDITIONAL     0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_TRAP_TYPE_TRAP_CONDITIONAL       0x00000002
#define NVC7C0_QMDV03_00_RELEASE1_TRAP_TYPE_TRAP_CONDITIONAL_EXT   0x00000003
#define NVC7C0_QMDV03_00_RELEASE1_PAYLOAD64B                       MW(957:957)
#define NVC7C0_QMDV03_00_RELEASE1_PAYLOAD64B_FALSE                 0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_PAYLOAD64B_TRUE                  0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE                   MW(959:958)
#define NVC7C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVC7C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVC7C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVC7C0_QMDV03_00_RELEASE1_PAYLOAD_LOWER                    MW(991:960)
#define NVC7C0_QMDV03_00_RELEASE1_PAYLOAD_UPPER                    MW(1023:992)
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((1055+(i)*64):(1024+(i)*64))
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((1072+(i)*64):(1056+(i)*64))
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST(i)          MW((1073+(i)*64):(1073+(i)*64))
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST_FALSE       0x00000000
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST_TRUE        0x00000001
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE(i)             MW((1074+(i)*64):(1074+(i)*64))
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC7C0_QMDV03_00_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1087+(i)*64):(1075+(i)*64))
#define NVC7C0_QMDV03_00_PROGRAM_ADDRESS_LOWER                     MW(1567:1536)
#define NVC7C0_QMDV03_00_PROGRAM_ADDRESS_UPPER                     MW(1584:1568)
#define NVC7C0_QMDV03_00_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(1623:1600)
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED       MW(1640:1632)
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_SIZE                     MW(1649:1641)
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_TYPE                     MW(1651:1650)
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH     0x00000000
#define NVC7C0_QMDV03_00_PROGRAM_PREFETCH_TYPE_PREFTECH_POST       0x00000001
#define NVC7C0_QMDV03_00_SASS_VERSION                              MW(1663:1656)
#define NVC7C0_QMDV03_00_RELEASE2_ADDRESS_LOWER                    MW(1695:1664)
#define NVC7C0_QMDV03_00_RELEASE2_ADDRESS_UPPER                    MW(1703:1696)
#define NVC7C0_QMDV03_00_SEMAPHORE_RESERVED53A                     MW(1714:1704)
#define NVC7C0_QMDV03_00_RELEASE2_MEMBAR_TYPE                      MW(1715:1715)
#define NVC7C0_QMDV03_00_RELEASE2_MEMBAR_TYPE_FE_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_MEMBAR_TYPE_FE_SYSMEMBAR         0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP                     MW(1718:1716)
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_ADD             0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_MIN             0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_MAX             0x00000002
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_INC             0x00000003
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_DEC             0x00000004
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_AND             0x00000005
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_OR              0x00000006
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_XOR             0x00000007
#define NVC7C0_QMDV03_00_RELEASE2_ENABLE                           MW(1719:1719)
#define NVC7C0_QMDV03_00_RELEASE2_ENABLE_FALSE                     0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_ENABLE_TRUE                      0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT                 MW(1721:1720)
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT_UNSIGNED        0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT_SIGNED          0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE                 MW(1722:1722)
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_TRAP_TYPE                        MW(1724:1723)
#define NVC7C0_QMDV03_00_RELEASE2_TRAP_TYPE_TRAP_NONE              0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_TRAP_TYPE_TRAP_UNCONDITIONAL     0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_TRAP_TYPE_TRAP_CONDITIONAL       0x00000002
#define NVC7C0_QMDV03_00_RELEASE2_TRAP_TYPE_TRAP_CONDITIONAL_EXT   0x00000003
#define NVC7C0_QMDV03_00_RELEASE2_PAYLOAD64B                       MW(1725:1725)
#define NVC7C0_QMDV03_00_RELEASE2_PAYLOAD64B_FALSE                 0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_PAYLOAD64B_TRUE                  0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE                   MW(1727:1726)
#define NVC7C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVC7C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVC7C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVC7C0_QMDV03_00_RELEASE2_PAYLOAD_LOWER                    MW(1759:1728)
#define NVC7C0_QMDV03_00_RELEASE2_PAYLOAD_UPPER                    MW(1791:1760)
#define NVC7C0_QMDV03_00_OCCUPANCY_THRESHOLD_WARP                  MW(1799:1792)
#define NVC7C0_QMDV03_00_OCCUPANCY_MAX_WARP                        MW(1807:1800)
#define NVC7C0_QMDV03_00_OCCUPANCY_THRESHOLD_REGISTER              MW(1815:1808)
#define NVC7C0_QMDV03_00_OCCUPANCY_MAX_REGISTER                    MW(1823:1816)
#define NVC7C0_QMDV03_00_HW_ONLY_INNER_GET                         MW(1854:1824)
#define NVC7C0_QMDV03_00_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1855:1855)
#define NVC7C0_QMDV03_00_HW_ONLY_INNER_PUT                         MW(1886:1856)
#define NVC7C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1917:1888)
#define NVC7C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1919:1919)
#define NVC7C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC7C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC7C0_QMDV03_00_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1951:1920)
#define NVC7C0_QMDV03_00_HW_ONLY_DEPENDENCE_COUNTER                MW(1967:1952)
#define NVC7C0_QMDV03_00_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC7C0_QMDV03_00_DEBUG_ID_LOWER                            MW(2047:2016)



#endif // #ifndef __CLC7C0QMD_H__
