# Philosophy

Before settling for Material for MkDocs, it's a good idea to understand the
philosophy behind the project, in order to make sure it aligns with your goals.
This page explains the design principles anchored in Material for MkDocs, and
discusses the [conventions] used in this documentation.

  [conventions]: #conventions

## Design principles

- __It's just Markdown__: Focus on the content of your documentation and create
  a professional static site in minutes. No need to know HTML,CSS or JavaScript
  – let Material for MkDocs do the heavy lifting for you.

- __Works on all devices__: Serve your documentation with confidence – the
  underlying layout automatically adapts to perfectly fit the available screen
  estate, no matter the type or size of the viewing device.

- __Made to measure__: Change the colors, fonts, language, icons, logo and much
  more with a few lines of configuration. Material for MkDocs can be easily
  extended and provides tons of options to alter appearance and behavior.

- __Fast and lightweight__: Don't let your users wait – get incredible value
  with a small footprint, by using one of the fastest themes around with
  excellent performance, yielding great search engine rankings and happy
  users that return.

- __Accessible__: Make accessibility a priority – users can navigate your
  documentation with touch devices, keyboard, and screen readers. Semantic
  markup ensures that your documentation works for everyone.

- __Open Source__: Trust 20,000+ users – choose a mature and well-funded
  solution built with state-of-the-art Open Source technologies. Keep ownership
  of your content without fear of vendor lock-in. Licensed under MIT.
