use super::structs::*;
use crate::queries;

pub fn get_scenario() -> Scenario {
    Scenario::new(
        "preferences",
        vec![
            FileSource::new("toolkit", "toolkit/{locale}/", vec!["en-US", "pl"]),
            FileSource::new("browser", "browser/{locale}/", vec!["en-US", "pl"]),
        ],
        vec![
            "en-US",
        ],
        vec![
            "branding/brand.ftl",
            "browser/branding/brandings.ftl",
            "browser/branding/sync-brand.ftl",
            "browser/browser.ftl",
            "browser/preferences/preferences.ftl",
            "browser/preferences/fonts.ftl",
            "toolkit/featuregates/features.ftl",
            "browser/preferences/addEngine.ftl",
            "browser/preferences/blocklists.ftl",
            "browser/preferences/clearSiteData.ftl",
            "browser/preferences/colors.ftl",
            "browser/preferences/connection.ftl",
            "browser/preferences/languages.ftl",
            "browser/preferences/permissions.ftl",
            "browser/preferences/selectBookmark.ftl",
            "browser/preferences/siteDataSettings.ftl",
            "browser/aboutDialog.ftl",
            "browser/sanitize.ftl",
            "toolkit/updates/history.ftl",
            "security/certificates/deviceManager.ftl",
            "security/certificates/certManager.ftl",
        ],
        queries![
            ("pref-page-title", "Preferences"),
            ("category-list", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Categories")]))),
            ("category-general", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "General")]))),
            ("pane-general-title", "General"),
            ("category-home", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Home")]))),
            ("pane-home-title", "Home"),
            ("category-search", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Search")]))),
            ("pane-search-title", "Search"),
            ("category-privacy", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Privacy & Security")]))),
            ("pane-privacy-title", "Privacy & Security"),
            ("category-sync2", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Sync")]))),
            ("pane-sync-title2", "Sync"),
            ("category-experimental", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Nightly Experiments")]))),
            ("pane-experimental-title", "Nightly Experiments"),
            ("addons-button-label", "Extensions & Themes"),
            ("help-button-label", "Nightly Support"),
            ("focus-search", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "f")]))),
            ("managed-notice", "Your browser is being managed by your organization."),
            ("search-input-box", L10nMessage::new(None, Some(vec![L10nAttribute::new("style", "width: 15.4em"), L10nAttribute::new("placeholder", "Find in Preferences")]))),
            ("search-results-header", "Search Results"),
            ("search-results-empty-message", "Sorry! There are no results in Preferences for “<span data-l10n-name=\"query\"></span>”."),
            ("search-results-help-link", "Need help? Visit <a data-l10n-name=\"url\">Nightly Support</a>"),
            ("containers-back-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Back to Preferences")]))),
            ("containers-header", "Container Tabs"),
            ("containers-add-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add New Container"), L10nAttribute::new("accesskey", "A")]))),
            ("containers-new-tab-check", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Select a container for each new tab"), L10nAttribute::new("accesskey", "S")]))),
            ("close-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Close")]))),
            ("pane-general-title", "General"),
            ("startup-header", "Startup"),
            ("startup-restore-previous-session", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restore previous session"), L10nAttribute::new("accesskey", "s")]))),
            ("startup-restore-warn-on-quit", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Warn you when quitting the browser")]))),
            ("always-check-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always check if Nightly is your default browser"), L10nAttribute::new("accesskey", "y")]))),
            ("is-not-default", "Nightly is not your default browser"),
            ("set-as-my-default-browser", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Make Default…"), L10nAttribute::new("accesskey", "D")]))),
            ("is-default", "Nightly is currently your default browser"),
            ("tabs-group-header", "Tabs"),
            ("ctrl-tab-recently-used-order", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Ctrl+Tab cycles through tabs in recently used order"), L10nAttribute::new("accesskey", "T")]))),
            ("open-new-link-as-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open links in tabs instead of new windows"), L10nAttribute::new("accesskey", "w")]))),
            ("warn-on-close-multiple-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Warn you when closing multiple tabs"), L10nAttribute::new("accesskey", "m")]))),
            ("warn-on-open-many-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Warn you when opening multiple tabs might slow down Nightly"), L10nAttribute::new("accesskey", "d")]))),
            ("switch-links-to-new-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "When you open a link in a new tab, switch to it immediately"), L10nAttribute::new("accesskey", "h")]))),
            ("disable-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Disable Extension")]))),
            ("browser-containers-enabled", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Enable Container Tabs"), L10nAttribute::new("accesskey", "n")]))),
            ("browser-containers-learn-more", "Learn more"),
            ("browser-containers-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "i")]))),
            ("language-and-appearance-header", "Language and Appearance"),
            ("fonts-and-colors-header", "Fonts and Colors"),
            ("default-font", L10nMessage::new(Some("Default font"), Some(vec![L10nAttribute::new("accesskey", "D")]))),
            ("default-font-size", L10nMessage::new(Some("Size"), Some(vec![L10nAttribute::new("accesskey", "S")]))),
            ("advanced-fonts", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Advanced…"), L10nAttribute::new("accesskey", "A")]))),
            ("colors-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Colors…"), L10nAttribute::new("accesskey", "C")]))),
            ("preferences-zoom-header", "Zoom"),
            ("preferences-default-zoom", L10nMessage::new(Some("Default zoom"), Some(vec![L10nAttribute::new("accesskey", "z")]))),
            ("preferences-zoom-text-only", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Zoom text only"), L10nAttribute::new("accesskey", "t")]))),
            ("language-header", "Language"),
            ("choose-browser-language-description", "Choose the languages used to display menus, messages, and notifications from Nightly."),
            ("manage-browser-languages-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Set Alternatives…"), L10nAttribute::new("accesskey", "l")]))),
            ("choose-language-description", "Choose your preferred language for displaying pages"),
            ("choose-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Choose…"), L10nAttribute::new("accesskey", "o")]))),
            (L10nKey::new("use-system-locale", Some(vec![L10nArgument::new("localeName", "und")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use your operating system settings for “und” to format dates, times, numbers, and measurements.")]))),
            ("translate-web-pages", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Translate web content"), L10nAttribute::new("accesskey", "T")]))),
            ("translate-attribution", "Translations by <img data-l10n-name=\"logo\"/>"),
            ("translate-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exceptions…"), L10nAttribute::new("accesskey", "x")]))),
            ("check-user-spelling", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check your spelling as you type"), L10nAttribute::new("accesskey", "t")]))),
            ("files-and-applications-title", "Files and Applications"),
            ("download-header", "Downloads"),
            ("download-save-to", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save files to"), L10nAttribute::new("accesskey", "v")]))),
            ("download-choose-folder", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Browse…"), L10nAttribute::new("accesskey", "o")]))),
            ("download-always-ask-where", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask you where to save files"), L10nAttribute::new("accesskey", "A")]))),
            ("applications-header", "Applications"),
            ("applications-description", "Choose how Nightly handles the files you download from the web or the applications you use while browsing."),
            ("applications-filter", L10nMessage::new(None, Some(vec![L10nAttribute::new("placeholder", "Search file types or applications")]))),
            ("applications-type-column", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Content Type"), L10nAttribute::new("accesskey", "T")]))),
            ("applications-action-column", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Action"), L10nAttribute::new("accesskey", "A")]))),
            ("drm-content-header", "Digital Rights Management (DRM) Content"),
            ("play-drm-content", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Play DRM-controlled content"), L10nAttribute::new("accesskey", "P")]))),
            ("play-drm-content-learn-more", "Learn more"),
            ("update-application-title", "Nightly Updates"),
            ("update-application-title", "Nightly Updates"),
            ("update-application-description", "Keep Nightly up to date for the best performance, stability, and security."),
            ("update-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show Update History…"), L10nAttribute::new("accesskey", "p")]))),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-updateButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restart to Update Nightly"), L10nAttribute::new("accesskey", "R")]))),
            ("update-checkingForUpdates", "Checking for updates…"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-downloading", "<img data-l10n-name=\"icon\"/>Downloading update — <label data-l10n-name=\"download-status\"/>"),
            ("update-applying", "Applying update…"),
            ("update-failed-main", "Update failed. <a data-l10n-name=\"failed-link-main\">Download the latest version</a>"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-adminDisabled", "Updates disabled by your system administrator"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-noUpdatesFound", "Nightly is up to date"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-otherInstanceHandlingUpdates", "Nightly is being updated by another instance"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-manual", "Updates available at <label data-l10n-name=\"manual-link\"/>"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-unsupported", "You can not perform further updates on this system. <label data-l10n-name=\"unsupported-link\">Learn more</label>"),
            ("update-checkForUpdatesButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates"), L10nAttribute::new("accesskey", "C")]))),
            ("update-restarting", "Restarting…"),
            ("update-updateButton", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restart to Update Nightly"), L10nAttribute::new("accesskey", "R")]))),
            ("update-application-allow-description", "Allow Nightly to"),
            ("update-application-auto", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Automatically install updates (recommended)"), L10nAttribute::new("accesskey", "A")]))),
            ("update-application-check-choose", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Check for updates but let you choose to install them"), L10nAttribute::new("accesskey", "C")]))),
            ("update-application-warning-cross-user-setting", "This setting will apply to all Windows accounts and Nightly profiles using this installation of Nightly."),
            ("performance-title", "Performance"),
            ("performance-title", "Performance"),
            ("performance-use-recommended-settings-checkbox", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use recommended performance settings"), L10nAttribute::new("accesskey", "U")]))),
            ("performance-settings-learn-more", "Learn more"),
            ("performance-use-recommended-settings-desc", "These settings are tailored to your computer’s hardware and operating system."),
            ("performance-allow-hw-accel", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use hardware acceleration when available"), L10nAttribute::new("accesskey", "r")]))),
            ("performance-limit-content-process-option", L10nMessage::new(Some("Content process limit"), Some(vec![L10nAttribute::new("accesskey", "l")]))),
            ("performance-limit-content-process-enabled-desc", "Additional content processes can improve performance when using multiple tabs, but will also use more memory."),
            ("performance-limit-content-process-blocked-desc", "Modifying the number of content processes is only possible with multiprocess Nightly. <a data-l10n-name=\"learn-more\">Learn how to check if multiprocess is enabled</a>"),
            ("browsing-title", "Browsing"),
            ("browsing-title", "Browsing"),
            ("browsing-use-autoscroll", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use autoscrolling"), L10nAttribute::new("accesskey", "a")]))),
            ("browsing-use-smooth-scrolling", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use smooth scrolling"), L10nAttribute::new("accesskey", "m")]))),
            ("browsing-use-cursor-navigation", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always use the cursor keys to navigate within pages"), L10nAttribute::new("accesskey", "k")]))),
            ("browsing-search-on-start-typing", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Search for text when you start typing"), L10nAttribute::new("accesskey", "x")]))),
            ("browsing-picture-in-picture-toggle-enabled", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Enable picture-in-picture video controls"), L10nAttribute::new("accesskey", "E")]))),
            ("browsing-picture-in-picture-learn-more", "Learn more"),
            ("browsing-media-control", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Control media via keyboard, headset, or virtual interface"), L10nAttribute::new("accesskey", "v")]))),
            ("browsing-media-control-learn-more", "Learn more"),
            ("browsing-cfr-recommendations", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Recommend extensions as you browse"), L10nAttribute::new("accesskey", "R")]))),
            ("browsing-cfr-recommendations-learn-more", "Learn more"),
            ("browsing-cfr-features", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Recommend features as you browse"), L10nAttribute::new("accesskey", "f")]))),
            ("browsing-cfr-recommendations-learn-more", "Learn more"),
            ("network-settings-title", "Network Settings"),
            ("network-settings-title", "Network Settings"),
            ("network-proxy-connection-learn-more", "Learn more"),
            ("network-proxy-connection-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "e")]))),
            (L10nKey::new("performance-default-content-process-count", Some(vec![L10nArgument::new("num", "8")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "8 (default)")]))),
            (L10nKey::new("update-application-version", Some(vec![L10nArgument::new("version", "86.0a1 (2020-12-27) (64-bit)")])), L10nMessage::new(Some("Version 86.0a1 (2020-12-27) (64-bit) <a data-l10n-name=\"learn-more\">What’s new</a>"), None)),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "30")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "30%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "50")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "50%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "67")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "67%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "80")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "80%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "90")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "90%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "100")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "100%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "110")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "110%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "120")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "120%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "133")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "133%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "150")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "150%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "170")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "170%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "200")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "200%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "240")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "240%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "300")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "300%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "400")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "400%")]))),
            (L10nKey::new("preferences-default-zoom-value", Some(vec![L10nArgument::new("percentage", "500")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "500%")]))),
            ("network-proxy-connection-description", "Configure how Nightly connects to the internet."),
            (L10nKey::new("fonts-label-default", Some(vec![L10nArgument::new("name", "DejaVu Serif")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Default (DejaVu Serif)")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-always-ask-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Polari")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Polari (default)")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Mibbit")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Mibbit")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),
            ("applications-always-ask-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Mibbit")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Mibbit")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),
            (L10nKey::new("applications-use-app-default-label", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Use Evolution (default)")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Evolution (default)")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Evolution (default)")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Yahoo! Mail")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Yahoo! Mail")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Gmail")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Gmail")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),


            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-open-inapp-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-open-inapp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in Nightly")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-action-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save File")]))),
            ("applications-use-os-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use system default application")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-always-ask-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Polari")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Polari (default)")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Mibbit")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Mibbit")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),
            ("applications-always-ask-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Mibbit")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Mibbit")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),
            (L10nKey::new("applications-use-app-default-label", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Use Evolution (default)")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Evolution (default)")]))),
            ("applications-always-ask", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always ask")]))),
            (L10nKey::new("applications-use-app-default", Some(vec![L10nArgument::new("app-name", "Evolution")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Evolution (default)")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Yahoo! Mail")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Yahoo! Mail")]))),
            (L10nKey::new("applications-use-app", Some(vec![L10nArgument::new("app-name", "Gmail")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Gmail")]))),
            ("applications-use-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use other…")]))),
            ("applications-manage-app", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Application Details…")]))),
            ("pane-home-title", "Home"),
            ("home-restore-defaults", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restore Defaults"), L10nAttribute::new("accesskey", "R")]))),
            ("home-new-windows-tabs-header", "New Windows and Tabs"),
            ("home-new-windows-tabs-description2", "Choose what you see when you open your homepage, new windows, and new tabs."),
            ("home-homepage-mode-label", "Homepage and new windows"),
            ("home-mode-choice-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Firefox Home (Default)")]))),
            ("home-mode-choice-custom", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Custom URLs…")]))),
            ("home-mode-choice-blank", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Blank Page")]))),
            ("home-homepage-custom-url", L10nMessage::new(None, Some(vec![L10nAttribute::new("placeholder", "Paste a URL…")]))),
            (L10nKey::new("use-current-pages", Some(vec![L10nArgument::new("tabCount", "0")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Current Pages"), L10nAttribute::new("accesskey", "C")]))),
            ("choose-bookmark", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Bookmark…"), L10nAttribute::new("accesskey", "B")]))),
            ("home-newtabs-mode-label", "New tabs"),
            ("home-mode-choice-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Firefox Home (Default)")]))),
            ("home-mode-choice-blank", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Blank Page")]))),
            ("pane-search-title", "Search"),
            ("search-bar-header", "Search Bar"),
            ("search-bar-hidden", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use the address bar for search and navigation")]))),
            ("search-bar-shown", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add search bar in toolbar")]))),
            ("search-engine-default-header", "Default Search Engine"),
            ("search-engine-default-desc-2", "This is your default search engine in the address bar and search bar. You can switch it at any time."),
            ("search-separate-default-engine", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use this search engine in Private Windows"), L10nAttribute::new("accesskey", "U")]))),
            ("search-engine-default-private-desc-2", "Choose a different default search engine for Private Windows only"),
            ("search-suggestions-header", "Search Suggestions"),
            ("search-suggestions-desc", "Choose how suggestions from search engines appear."),
            ("search-suggestions-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Provide search suggestions"), L10nAttribute::new("accesskey", "s")]))),
            ("search-show-suggestions-url-bar-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show search suggestions in address bar results"), L10nAttribute::new("accesskey", "l")]))),
            ("search-show-suggestions-above-history-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show search suggestions ahead of browsing history in address bar results")]))),
            ("search-show-suggestions-private-windows", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show search suggestions in Private Windows")]))),
            ("search-suggestions-cant-show", "Search suggestions will not be shown in location bar results because you have configured Nightly to never remember history."),
            ("suggestions-addressbar-settings-generic", "Change preferences for other address bar suggestions"),
            ("search-one-click-header2", "Search Shortcuts"),
            ("search-one-click-desc", "Choose the alternative search engines that appear below the address bar and search bar when you start to enter a keyword."),
            ("search-choose-engine-column", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Search Engine")]))),
            ("search-choose-keyword-column", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Keyword")]))),
            ("search-restore-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restore Default Search Engines"), L10nAttribute::new("accesskey", "D")]))),
            ("search-remove-engine", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove"), L10nAttribute::new("accesskey", "R")]))),
            ("search-add-engine", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add"), L10nAttribute::new("accesskey", "A")]))),
            ("search-find-more-link", "Find more search engines"),
            ("privacy-header", "Browser Privacy"),
            ("content-blocking-enhanced-tracking-protection", "Enhanced Tracking Protection"),
            ("content-blocking-section-top-level-description", "Trackers follow you around online to collect information about your browsing habits and interests. Nightly blocks many of these trackers and other malicious scripts."),
            ("content-blocking-learn-more", "Learn more"),
            ("tracking-manage-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Manage Exceptions…"), L10nAttribute::new("accesskey", "x")]))),
            ("content-blocking-fpi-incompatibility-warning", "You are using First Party Isolation (FPI), which overrides some of Nightly’s cookie settings."),
            ("enhanced-tracking-protection-setting-standard", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Standard"), L10nAttribute::new("accesskey", "d")]))),
            ("content-blocking-expand-section", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "More information")]))),
            ("content-blocking-etp-standard-desc", "Balanced for protection and performance. Pages will load normally."),
            ("content-blocking-social-media-trackers", "Social media trackers"),
            ("content-blocking-cross-site-cookies", "Cross-site cookies"),
            ("content-blocking-cross-site-tracking-cookies", "Cross-site tracking cookies"),
            ("content-blocking-cross-site-tracking-cookies-plus-isolate", "Cross-site tracking cookies, and isolate remaining cookies"),
            ("content-blocking-private-windows", "Tracking content in Private Windows"),
            ("content-blocking-all-windows-tracking-content", "Tracking content in all windows"),
            ("content-blocking-all-third-party-cookies", "All third-party cookies"),
            ("content-blocking-all-cookies", "All cookies"),
            ("content-blocking-unvisited-cookies", "Cookies from unvisited sites"),
            ("content-blocking-cryptominers", "Cryptominers"),
            ("content-blocking-fingerprinters", "Fingerprinters"),
            ("content-blocking-reload-description", "You will need to reload your tabs to apply these changes."),
            ("content-blocking-reload-tabs-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload All Tabs"), L10nAttribute::new("accesskey", "R")]))),
            ("enhanced-tracking-protection-setting-strict", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Strict"), L10nAttribute::new("accesskey", "r")]))),
            ("content-blocking-expand-section", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "More information")]))),
            ("content-blocking-etp-strict-desc", "Stronger protection, but may cause some sites or content to break."),
            ("content-blocking-social-media-trackers", "Social media trackers"),
            ("content-blocking-cross-site-tracking-cookies", "Cross-site tracking cookies"),
            ("content-blocking-cross-site-cookies", "Cross-site cookies"),
            ("content-blocking-private-windows", "Tracking content in Private Windows"),
            ("content-blocking-all-windows-tracking-content", "Tracking content in all windows"),
            ("content-blocking-all-third-party-cookies", "All third-party cookies"),
            ("content-blocking-all-cookies", "All cookies"),
            ("content-blocking-unvisited-cookies", "Cookies from unvisited sites"),
            ("content-blocking-cross-site-tracking-cookies", "Cross-site tracking cookies"),
            ("content-blocking-cross-site-tracking-cookies-plus-isolate", "Cross-site tracking cookies, and isolate remaining cookies"),
            ("content-blocking-cryptominers", "Cryptominers"),
            ("content-blocking-fingerprinters", "Fingerprinters"),
            ("content-blocking-reload-description", "You will need to reload your tabs to apply these changes."),
            ("content-blocking-reload-tabs-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload All Tabs"), L10nAttribute::new("accesskey", "R")]))),
            ("content-blocking-warning-title", "Heads up!"),
            ("content-blocking-and-isolating-etp-warning-description", "Blocking trackers and isolating cookies could impact the functionality of some sites. Reload a page with trackers to load all content."),
            ("content-blocking-warning-learn-how", "Learn how"),
            ("enhanced-tracking-protection-setting-custom", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Custom"), L10nAttribute::new("accesskey", "C")]))),
            ("content-blocking-expand-section", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "More information")]))),
            ("content-blocking-etp-custom-desc", "Choose which trackers and scripts to block."),
            ("content-blocking-cookies-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies"), L10nAttribute::new("accesskey", "C")]))),
            ("sitedata-option-block-cross-site-trackers", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cross-site trackers")]))),
            ("sitedata-option-block-cross-site-and-social-media-trackers-plus-isolate", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cross-site and social media trackers, and isolate remaining cookies")]))),
            ("sitedata-option-block-unvisited", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies from unvisited websites")]))),
            ("sitedata-option-block-all-third-party", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "All third-party cookies (may cause websites to break)")]))),
            ("sitedata-option-block-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "All cookies (will cause websites to break)")]))),
            ("disable-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Disable Extension")]))),
            ("content-blocking-tracking-content-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Tracking content"), L10nAttribute::new("accesskey", "T")]))),
            ("content-blocking-option-private", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Only in Private Windows"), L10nAttribute::new("accesskey", "p")]))),
            ("content-blocking-tracking-protection-option-all-windows", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "In all windows"), L10nAttribute::new("accesskey", "A")]))),
            ("content-blocking-tracking-protection-change-block-list", "Change block list"),
            ("content-blocking-cryptominers-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cryptominers"), L10nAttribute::new("accesskey", "y")]))),
            ("content-blocking-fingerprinters-label", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Fingerprinters"), L10nAttribute::new("accesskey", "F")]))),
            ("content-blocking-reload-description", "You will need to reload your tabs to apply these changes."),
            ("content-blocking-reload-tabs-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload All Tabs"), L10nAttribute::new("accesskey", "R")]))),
            ("content-blocking-warning-title", "Heads up!"),
            ("content-blocking-and-isolating-etp-warning-description", "Blocking trackers and isolating cookies could impact the functionality of some sites. Reload a page with trackers to load all content."),
            ("content-blocking-warning-learn-how", "Learn how"),
            ("do-not-track-description", "Send websites a “Do Not Track” signal that you don’t want to be tracked"),
            ("do-not-track-learn-more", "Learn more"),
            ("do-not-track-option-always", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always")]))),
            ("do-not-track-option-default-content-blocking-known", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Only when Nightly is set to block known trackers")]))),
            ("sitedata-header", "Cookies and Site Data"),
            ("sitedata-learn-more", "Learn more"),
            ("sitedata-delete-on-close-private-browsing", "In permanent private browsing mode, cookies and site data will always be cleared when Nightly is closed."),
            ("sitedata-delete-on-close", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete cookies and site data when Nightly is closed"), L10nAttribute::new("accesskey", "c")]))),
            ("sitedata-clear", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear Data…"), L10nAttribute::new("accesskey", "l")]))),
            ("sitedata-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Manage Data…"), L10nAttribute::new("accesskey", "M")]))),
            ("sitedata-cookies-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Manage Exceptions…"), L10nAttribute::new("accesskey", "x")]))),
            ("pane-privacy-logins-and-passwords-header", L10nMessage::new(Some("Logins and Passwords"), Some(vec![L10nAttribute::new("searchkeywords", "Lockwise")]))),
            ("disable-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Disable Extension")]))),
            ("forms-ask-to-save-logins", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Ask to save logins and passwords for websites"), L10nAttribute::new("accesskey", "r")]))),
            ("forms-fill-logins-and-passwords", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Autofill logins and passwords"), L10nAttribute::new("accesskey", "i")]))),
            ("forms-generate-passwords", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Suggest and generate strong passwords"), L10nAttribute::new("accesskey", "u")]))),
            ("forms-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exceptions…"), L10nAttribute::new("accesskey", "x")]))),
            ("forms-saved-logins", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Saved Logins…"), L10nAttribute::new("accesskey", "L")]))),
            ("forms-breach-alerts", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show alerts about passwords for breached websites"), L10nAttribute::new("accesskey", "b")]))),
            ("forms-breach-alerts-learn-more-link", "Learn more"),
            ("forms-primary-pw-use", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use a Primary Password"), L10nAttribute::new("accesskey", "U")]))),
            ("forms-primary-pw-learn-more-link", "Learn more"),
            ("forms-primary-pw-change", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Change Primary Password…"), L10nAttribute::new("accesskey", "P")]))),
            ("forms-primary-pw-former-name", "Formerly known as Master Password"),
            ("forms-primary-pw-fips-title", "You are currently in FIPS mode. FIPS requires a non-empty Primary Password."),
            ("forms-master-pw-fips-desc", "Password Change Failed"),
            ("history-header", "History"),
            ("history-remember-label", L10nMessage::new(Some("Nightly will"), Some(vec![L10nAttribute::new("accesskey", "w")]))),
            ("history-remember-option-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remember history")]))),
            ("history-remember-option-never", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Never remember history")]))),
            ("history-remember-option-custom", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use custom settings for history")]))),
            ("history-remember-description", "Nightly will remember your browsing, download, form, and search history."),
            ("history-dontremember-description", "Nightly will use the same settings as private browsing, and will not remember any history as you browse the Web."),
            ("history-private-browsing-permanent", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always use private browsing mode"), L10nAttribute::new("accesskey", "p")]))),
            ("history-remember-browser-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remember browsing and download history"), L10nAttribute::new("accesskey", "b")]))),
            ("history-remember-search-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remember search and form history"), L10nAttribute::new("accesskey", "f")]))),
            ("history-clear-on-close-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear history when Nightly closes"), L10nAttribute::new("accesskey", "r")]))),
            ("history-clear-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear History…"), L10nAttribute::new("accesskey", "s")]))),
            ("history-clear-on-close-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("addressbar-header", "Address Bar"),
            ("addressbar-suggest", "When using the address bar, suggest"),
            ("addressbar-locbar-history-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Browsing history"), L10nAttribute::new("accesskey", "h")]))),
            ("addressbar-locbar-bookmarks-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks"), L10nAttribute::new("accesskey", "k")]))),
            ("addressbar-locbar-openpage-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open tabs"), L10nAttribute::new("accesskey", "O")]))),
            ("addressbar-locbar-topsites-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Top sites"), L10nAttribute::new("accesskey", "T")]))),
            ("addressbar-locbar-engines-option", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Search engines"), L10nAttribute::new("accesskey", "a")]))),
            ("addressbar-suggestions-settings", "Change preferences for search engine suggestions"),
            ("permissions-header", "Permissions"),
            ("permissions-header", "Permissions"),
            ("permissions-location", "Location"),
            ("permissions-location-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-camera", "Camera"),
            ("permissions-camera-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-microphone", "Microphone"),
            ("permissions-microphone-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-notification", "Notifications"),
            ("permissions-notification-link", "Learn more"),
            ("permissions-notification-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-autoplay", "Autoplay"),
            ("permissions-autoplay-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-xr", "Virtual Reality"),
            ("permissions-xr-settings", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Settings…"), L10nAttribute::new("accesskey", "t")]))),
            ("permissions-block-popups", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Block pop-up windows"), L10nAttribute::new("accesskey", "B")]))),
            ("permissions-block-popups-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exceptions…"), L10nAttribute::new("accesskey", "E")]))),
            ("permissions-addon-install-warning", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Warn you when websites try to install add-ons"), L10nAttribute::new("accesskey", "W")]))),
            ("permissions-addon-exceptions", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exceptions…"), L10nAttribute::new("accesskey", "E")]))),
            ("collection-header", "Nightly Data Collection and Use"),
            ("collection-header", "Nightly Data Collection and Use"),
            ("collection-description", "We strive to provide you with choices and collect only what we need to provide and improve Nightly for everyone. We always ask permission before receiving personal information."),
            ("collection-privacy-notice", "Privacy Notice"),
            ("collection-health-report-telemetry-disabled", "You’re no longer allowing Mozilla to capture technical and interaction data. All past data will be deleted within 30 days."),
            ("collection-health-report-telemetry-disabled-link", "Learn more"),
            ("collection-health-report", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Allow Nightly to send technical and interaction data to Mozilla"), L10nAttribute::new("accesskey", "r")]))),
            ("collection-health-report-link", "Learn more"),
            ("addon-recommendations", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Allow Nightly to make personalized extension recommendations")]))),
            ("addon-recommendations-link", "Learn more"),
            ("collection-health-report-disabled", "Data reporting is disabled for this build configuration"),
            ("collection-studies", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Allow Nightly to install and run studies")]))),
            ("collection-studies-link", "View Nightly studies"),
            ("collection-backlogged-crash-reports", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Allow Nightly to send backlogged crash reports on your behalf"), L10nAttribute::new("accesskey", "c")]))),
            ("collection-backlogged-crash-reports-link", "Learn more"),
            ("security-header", "Security"),
            ("security-browsing-protection", "Deceptive Content and Dangerous Software Protection"),
            ("security-enable-safe-browsing", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Block dangerous and deceptive content"), L10nAttribute::new("accesskey", "B")]))),
            ("security-enable-safe-browsing-link", "Learn more"),
            ("security-block-downloads", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Block dangerous downloads"), L10nAttribute::new("accesskey", "d")]))),
            ("security-block-uncommon-software", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Warn you about unwanted and uncommon software"), L10nAttribute::new("accesskey", "c")]))),
            ("certs-header", "Certificates"),
            ("certs-enable-ocsp", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Query OCSP responder servers to confirm the current validity of certificates"), L10nAttribute::new("accesskey", "Q")]))),
            ("certs-view", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Certificates…"), L10nAttribute::new("accesskey", "C")]))),
            ("certs-devices", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Security Devices…"), L10nAttribute::new("accesskey", "D")]))),
            ("httpsonly-header", "HTTPS-Only Mode"),
            ("httpsonly-description", "HTTPS provides a secure, encrypted connection between Nightly and the websites you visit. Most websites support HTTPS, and if HTTPS-Only Mode is enabled, then Nightly will upgrade all connections to HTTPS."),
            ("httpsonly-learn-more", "Learn more"),
            ("httpsonly-radio-enabled", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Enable HTTPS-Only Mode in all windows")]))),
            ("httpsonly-radio-enabled-pbm", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Enable HTTPS-Only Mode in private windows only")]))),
            ("httpsonly-radio-disabled", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Don’t enable HTTPS-Only Mode")]))),
            ("pane-experimental-title", "Nightly Experiments"),
            ("pane-experimental-subtitle", "Proceed with Caution"),
            ("pane-experimental-reset", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restore Defaults"), L10nAttribute::new("accesskey", "R")]))),
            ("pane-experimental-search-results-header", "Nightly Experiments: Proceed with Caution"),
            ("pane-experimental-description", "Changing advanced configuration preferences can impact Nightly performance or security."),
            ("pane-sync-title2", "Sync"),
            ("sync-signedout-caption", "Take Your Web With You"),
            ("sync-signedout-description", "Synchronize your bookmarks, history, tabs, passwords, add-ons, and preferences across all your devices."),
            ("sync-signedout-account-signin2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sign in to Sync…"), L10nAttribute::new("accesskey", "i")]))),
            ("sync-mobile-promo", "Download Firefox for <img data-l10n-name=\"android-icon\"/> <a data-l10n-name=\"android-link\">Android</a> or <img data-l10n-name=\"ios-icon\"/> <a data-l10n-name=\"ios-link\">iOS</a> to sync with your mobile device."),
            ("pane-sync-title2", "Sync"),
            ("sync-profile-picture", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Change profile picture")]))),
            ("sync-sign-out", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sign Out…"), L10nAttribute::new("accesskey", "g")]))),
            ("sync-manage-account", L10nMessage::new(Some("Manage account"), Some(vec![L10nAttribute::new("accesskey", "o")]))),
            (L10nKey::new("sync-signedin-unverified", Some(vec![L10nArgument::new("email", "")])), L10nMessage::new(Some(" is not verified."), None)),
            ("sync-resend-verification", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Resend Verification"), L10nAttribute::new("accesskey", "d")]))),
            ("sync-remove-account", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove Account"), L10nAttribute::new("accesskey", "R")]))),
            (L10nKey::new("sync-signedin-login-failure", Some(vec![L10nArgument::new("email", "")])), L10nMessage::new(Some("Please sign in to reconnect "), None)),
            ("sync-sign-in", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sign in"), L10nAttribute::new("accesskey", "g")]))),
            ("sync-remove-account", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove Account"), L10nAttribute::new("accesskey", "R")]))),
            ("sync-device-name-header", "Device Name"),
            ("sync-device-name-change", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Change Device Name…"), L10nAttribute::new("accesskey", "h")]))),
            ("sync-device-name-cancel", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cancel"), L10nAttribute::new("accesskey", "n")]))),
            ("sync-device-name-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save"), L10nAttribute::new("accesskey", "v")]))),
            ("prefs-syncing-off", "Syncing: OFF"),
            ("prefs-sync-offer-setup-label", "Synchronize your bookmarks, history, tabs, passwords, add-ons, and preferences across all your devices."),
            ("prefs-sync-setup", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Set Up Sync…"), L10nAttribute::new("accesskey", "S")]))),
            ("prefs-syncing-on", "Syncing: ON"),
            ("prefs-sync-now", L10nMessage::new(None, Some(vec![L10nAttribute::new("labelnotsyncing", "Sync Now"), L10nAttribute::new("accesskeynotsyncing", "N"), L10nAttribute::new("labelsyncing", "Syncing…")]))),
            ("sync-currently-syncing-heading", "You are currently syncing these items:"),
            ("sync-currently-syncing-bookmarks", "Bookmarks"),
            ("sync-currently-syncing-history", "History"),
            ("sync-currently-syncing-tabs", "Open tabs"),
            ("sync-currently-syncing-logins-passwords", "Logins and passwords"),
            ("sync-currently-syncing-addresses", "Addresses"),
            ("sync-currently-syncing-creditcards", "Credit cards"),
            ("sync-currently-syncing-addons", "Add-ons"),
            ("sync-currently-syncing-prefs", "Preferences"),
            ("sync-change-options", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Change…"), L10nAttribute::new("accesskey", "C")]))),
            ("sync-connect-another-device", "Connect another device"),
            ("experimental-features-abouthome-startup-cache", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "about:home startup cache")]))),
            ("experimental-features-cookie-samesite-lax-by-default2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: SameSite=Lax by default")]))),
            ("experimental-features-cookie-samesite-none-requires-secure2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: SameSite=None requires secure attribute")]))),
            ("experimental-features-cookie-samesite-schemeful", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: Schemeful SameSite")]))),
            ("experimental-features-css-constructable-stylesheets", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Constructable Stylesheets")]))),
            ("experimental-features-css-focus-visible", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Pseudo-class: :focus-visible")]))),
            ("experimental-features-css-masonry2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Masonry Layout")]))),
            ("experimental-features-devtools-color-scheme-simulation", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Color Scheme Simulation")]))),
            ("experimental-features-devtools-compatibility-panel", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Compatibility Panel")]))),
            ("experimental-features-devtools-execution-context-selector", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Execution Context Selector")]))),
            ("experimental-features-devtools-serviceworker-debugger-support", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Service Worker debugging")]))),
            ("experimental-features-fission", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Fission (Site Isolation)")]))),
            ("experimental-features-http3", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "HTTP/3 protocol")]))),
            ("experimental-features-media-avif", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Media: AVIF")]))),
            ("experimental-features-multi-pip", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Multiple Picture-in-Picture Support")]))),
            ("experimental-features-print-preview-tab-modal", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print Preview Redesign")]))),
            ("experimental-features-web-api-beforeinput", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: beforeinput Event")]))),
            ("experimental-features-web-api-inputmode", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: inputmode")]))),
            ("experimental-features-web-api-link-preload", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: <link rel=\"preload\">")]))),
            ("experimental-features-web-gpu2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: WebGPU")]))),
            ("experimental-features-webrtc-global-mute-toggles", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "WebRTC Global Mute Toggles")]))),
            (L10nKey::new("use-current-pages", Some(vec![L10nArgument::new("tabCount", "1")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Current Page"), L10nAttribute::new("accesskey", "C")]))),
            ("home-prefs-content-header", "Firefox Home Content"),
            ("home-prefs-content-description", "Choose what content you want on your Firefox Home screen."),
            ("home-prefs-search-header", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web Search")]))),
            ("home-prefs-topsites-header", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Top Sites")]))),
            ("home-prefs-topsites-description", "The sites you visit most"),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "1")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "1 row")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "2")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "2 rows")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "3")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "3 rows")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "4")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "4 rows")]))),
            (L10nKey::new("home-prefs-recommended-by-header", Some(vec![L10nArgument::new("provider", "Pocket")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Recommended by Pocket")]))),
            ("home-prefs-recommended-by-learn-more", "How it works"),
            (L10nKey::new("home-prefs-recommended-by-description-update", Some(vec![L10nArgument::new("provider", "Pocket")])), L10nMessage::new(Some("Exceptional content from across the web, curated by Pocket"), None)),
            ("home-prefs-recommended-by-option-sponsored-stories", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sponsored Stories")]))),
            ("home-prefs-highlights-header", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Highlights")]))),
            ("home-prefs-highlights-description", "A selection of sites that you’ve saved or visited"),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "1")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "1 row")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "2")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "2 rows")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "3")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "3 rows")]))),
            (L10nKey::new("home-prefs-sections-rows-option", Some(vec![L10nArgument::new("num", "4")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "4 rows")]))),
            ("home-prefs-highlights-option-visited-pages", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Visited Pages")]))),
            ("home-prefs-highlights-options-bookmarks", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks")]))),
            ("home-prefs-highlights-option-most-recent-download", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Most Recent Download")]))),
            ("home-prefs-highlights-option-saved-to-pocket", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Pages Saved to Pocket")]))),
            ("home-prefs-snippets-header", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Snippets")]))),
            ("home-prefs-snippets-description", "Updates from Mozilla and Firefox"),
            ("sitedata-option-block-cross-site-and-social-media-trackers", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cross-site and social media trackers")]))),
            ("sitedata-total-size-calculating", "Calculating site data and cache size…"),
            ("containers-preferences-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Preferences")]))),
            ("containers-remove-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove")]))),
            ("containers-preferences-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Preferences")]))),
            ("containers-remove-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove")]))),
            ("containers-preferences-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Preferences")]))),
            ("containers-remove-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove")]))),
            ("containers-preferences-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Preferences")]))),
            ("containers-remove-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove")]))),
            ("experimental-features-abouthome-startup-cache", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "about:home startup cache")]))),
            ("experimental-features-abouthome-startup-cache-description", "A cache for the initial about:home document that is loaded by default at startup. The purpose of the cache is to improve startup performance."),
            ("experimental-features-cookie-samesite-lax-by-default2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: SameSite=Lax by default")]))),
            ("experimental-features-cookie-samesite-lax-by-default2-description", "Treat cookies as “SameSite=Lax” by default if no “SameSite” attribute is specified. Developers must opt-in to the current status quo of unrestricted use by explicitly asserting “SameSite=None”."),
            ("experimental-features-cookie-samesite-none-requires-secure2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: SameSite=None requires secure attribute")]))),
            ("experimental-features-cookie-samesite-none-requires-secure2-description", "Cookies with “SameSite=None” attribute require the secure attribute. This feature requires “Cookies: SameSite=Lax by default”."),
            ("experimental-features-cookie-samesite-schemeful", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cookies: Schemeful SameSite")]))),
            ("experimental-features-cookie-samesite-schemeful-description", "Treat cookies from the same domain, but with different schemes (e.g. http://example.com and https://example.com) as cross-site instead of same-site. Improves security, but potentially introduces breakage."),
            ("experimental-features-css-constructable-stylesheets", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Constructable Stylesheets")]))),
            ("experimental-features-css-constructable-stylesheets-description", "The addition of a constructor to the <a data-l10n-name=\"mdn-cssstylesheet\">CSSStyleSheet</a> interface as well as a variety of related changes makes it possible to directly create new stylesheets without having to add the sheet to the HTML. This makes it much easier to create reusable stylesheets for use with <a data-l10n-name=\"mdn-shadowdom\">Shadow DOM</a>. See <a data-l10n-name=\"bugzilla\">bug 1520690</a> for more details."),
            ("experimental-features-css-masonry2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Masonry Layout")]))),
            ("experimental-features-css-masonry-description", "Enables support for the experimental CSS Masonry Layout feature. See the <a data-l10n-name=\"explainer\">explainer</a> for a high level description of the feature. To provide feedback, please comment in <a data-l10n-name=\"w3c-issue\">this GitHub issue</a> or <a data-l10n-name=\"bug\">this bug</a>."),
            ("experimental-features-css-focus-visible", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "CSS: Pseudo-class: :focus-visible")]))),
            ("experimental-features-css-focus-visible-description", "Allows focus styles to be applied to elements like buttons and form controls, only when they are focused using the keyboard (e.g. when tabbing between elements), and not when they are focused using a mouse or other pointing device. See <a data-l10n-name=\"bugzilla\">bug 1617600</a> for more details."),
            ("experimental-features-devtools-color-scheme-simulation", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Color Scheme Simulation")]))),
            ("experimental-features-devtools-color-scheme-simulation-description", "Adds an option to simulate different color schemes allowing you to test <a data-l10n-name=\"mdn-preferscolorscheme\">@prefers-color-scheme</a> media queries. Using this media query lets your stylesheet respond to whether the user prefers a light or dark user interface. This feature lets you test your code without having to change settings in your browser (or operating system, if the browser follows a system-wide color scheme setting). See <a data-l10n-name=\"bugzilla1\">bug 1550804</a> and <a data-l10n-name=\"bugzilla2\">bug 1137699</a> for more details."),
            ("experimental-features-devtools-compatibility-panel", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Compatibility Panel")]))),
            ("experimental-features-devtools-compatibility-panel-description", "A side panel for the Page Inspector that shows you information detailing your app’s cross-browser compatibility status. See <a data-l10n-name=\"bugzilla\">bug 1584464</a> for more details."),
            ("experimental-features-devtools-execution-context-selector", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Execution Context Selector")]))),
            ("experimental-features-devtools-execution-context-selector-description", "This feature displays a button on the console’s command line that lets you change the context in which the expression you enter will be executed. See <a data-l10n-name=\"bugzilla1\">bug 1605154</a> and <a data-l10n-name=\"bugzilla2\">bug 1605153</a> for more details."),
            ("experimental-features-devtools-serviceworker-debugger-support", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Developer Tools: Service Worker debugging")]))),
            ("experimental-features-devtools-serviceworker-debugger-support-description", "Enables experimental support for Service Workers in the Debugger panel. This feature may slow the Developer Tools down and increase memory consumption."),
            ("experimental-features-fission", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Fission (Site Isolation)")]))),
            ("experimental-features-fission-description", "Fission (site isolation) is an experimental feature in Nightly to provide an additional layer of defense against security bugs. By isolating each site into a separate process, Fission makes it harder for malicious websites to get access to information from other pages you are visiting. This is a major architectural change in Nightly and we appreciate you testing and reporting any issues you might encounter. For more details, see <a data-l10n-name=\"wiki\">the wiki</a>."),
            ("experimental-features-http3", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "HTTP/3 protocol")]))),
            ("experimental-features-http3-description", "Experimental support for the HTTP/3 protocol."),
            ("experimental-features-media-avif", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Media: AVIF")]))),
            ("experimental-features-media-avif-description", "With this feature enabled, Nightly supports the AV1 Image File (AVIF) format. This is a still image file format that leverages the capabilities of the AV1 video compression algorithms to reduce image size. See <a data-l10n-name=\"bugzilla\">bug 1443863</a> for more details."),
            ("experimental-features-multi-pip", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Multiple Picture-in-Picture Support")]))),
            ("experimental-features-multi-pip-description", "Experimental support for allowing multiple Picture-in-Picture windows to be open at the same time."),
            ("experimental-features-print-preview-tab-modal", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print Preview Redesign")]))),
            ("experimental-features-print-preview-tab-modal-description", "Introduces the redesigned print preview and makes print preview available on macOS. This potentially introduces breakage and does not include all print-related settings. To access all print-related settings, select “Print using the system dialog…” from within the Print panel."),
            ("experimental-features-web-api-link-preload", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: <link rel=\"preload\">")]))),
            ("experimental-features-web-api-link-preload-description", "The <a data-l10n-name=\"rel\">rel</a> attribute with value <code>\"preload\"</code> on a <a data-l10n-name=\"link\">&lt;link&gt;</a> element is intended to help provide performance gains by letting you download resources earlier in the page lifecycle, ensuring that they’re available earlier and are less likely to block page rendering. Read <a data-l10n-name=\"readmore\">“Preloading content with <code>rel=\"preload\"</code>”</a> or see <a data-l10n-name=\"bugzilla\">bug 1583604</a> for more details."),
            ("experimental-features-web-api-beforeinput", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: beforeinput Event")]))),
            ("experimental-features-web-api-beforeinput-description", "The global <a data-l10n-name=\"mdn-beforeinput\">beforeinput</a> event is fired on an <a data-l10n-name=\"mdn-input\">&lt;input&gt;</a> and <a data-l10n-name=\"mdn-textarea\">&lt;textarea&gt;</a> elements, or any element whose <a data-l10n-name=\"mdn-contenteditable\">contenteditable</a> attribute is enabled, immediately before the element’s value changes. The event allows web apps to override the browser’s default behavior for user interaction, e.g., web apps can cancel user input only for specific characters or can modify pasting styled text only with approved styles."),
            ("experimental-features-web-api-inputmode", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: inputmode")]))),
            ("experimental-features-web-api-inputmode-description", "Our implementation of the <a data-l10n-name=\"mdn-inputmode\">inputmode</a> global attribute has been updated as per <a data-l10n-name=\"whatwg\">the WHATWG specification</a>, but we still need to make other changes too, like making it available on contenteditable content. See <a data-l10n-name=\"bugzilla\">bug 1205133</a> for more details."),
            ("experimental-features-web-gpu2", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web API: WebGPU")]))),
            ("experimental-features-web-gpu-description2", "This new API provides low-level support for performing computation and graphics rendering using the <a data-l10n-name=\"wikipedia\">Graphics Processing Unit (GPU)</a> of the user’s device or computer. The <a data-l10n-name=\"spec\">specification</a> is still a work-in-progress. See <a data-l10n-name=\"bugzilla\">bug 1602129</a> for more details."),
            ("experimental-features-webrtc-global-mute-toggles", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "WebRTC Global Mute Toggles")]))),
            ("experimental-features-webrtc-global-mute-toggles-description", "Add controls to the WebRTC global sharing indicator that allow users to globally mute their microphone and camera feeds."),
            (L10nKey::new("sitedata-total-size", Some(vec![L10nArgument::new("value", "2.0"), L10nArgument::new("unit", "MB")])), L10nMessage::new(Some("Your stored cookies, site data, and cache are currently using 2.0 MB of disk space."), None))
        ],
    )
}
