## Usage

```js
const clone = require('{%= name %}');
```

**Supports**

- array buffers
- arrays
- buffers
- dates
- errors
- float32 arrays
- float64 arrays
- int16 arrays
- int32 arrays
- int8 arrays
- maps
- objects
- primitives
- regular expressions
- sets
- symbols
- uint16 arrays
- uint32 arrays
- uint8 arrays
- uint8clamped arrays


## Arrays

By default, only the array itself is cloned (shallow), use [clone-deep][] if you also need the elements in the array to be cloned.

```js
const arr = [{ a: 0 }, { b: 1 }];
const foo = clone(arr);
// foo =>  [{ 'a': 0 }, { 'b': 1 }]

// array is cloned
assert(actual === expected); // false

// array elements are not
assert.deepEqual(actual[0], expected[0]); // true
```

## Objects

Only the object is shallow cloned, use [clone-deep][] if you also need the values in the object to be cloned.

```js
console.log(clone({ a: 1, b: 2, c: 3 }));
//=> {a: 1, b: 2, c: 3 }
```


## RegExp

Clones regular expressions and flags, and preserves the `.lastIndex`. 

```js
const regex = clone(/foo/g); //=> /foo/g
// you can manually reset lastIndex if necessary
regex.lastIndex = 0;
```

## Primitives

Simply returns primitives unchanged.

```js
clone(0); //=> 0
clone('foo'); //=> 'foo'
```