if (typeof T === 'undefined') require('../setup');

T('asinh', function () {

   function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).asinh().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('Infinity', 40, 4, 'Infinity');
  t('-Infinity', 40, 4, '-Infinity');
  t('0', 40, 4, '0');
  t('-0', 40, 4, '-0');

  t('3.1444197343', 4, 3, '1.863');
  t('-7546164.80347805747707434691023987685', 5, 2, '-16.529');
  t('-0.15139', 9, 1, '-0.150817601');
  t('7649', 8, 2, '9.6354774');
  t('9522664768544403839474412593333.0574738', 8, 6, '72.024375');
  t('7979240.25859873', 3, 3, '16.5');
  t('268', 5, 2, '6.2842');
  t('-0.036', 2, 5, '-0.036');
  t('0.4807', 9, 3, '0.4638831');
  t('0.229', 10, 4, '0.2270443104');
  t('2.00400000074005', 7, 0, '1.445423');
  t('200000000000000.00004161', 6, 5, '33.6225');
  t('-58888888888888791888.6', 3, 0, '-46.3');
  t('-6031221', 3, 4, '-16.3');
  t('-640.3942', 7, 5, '-7.155232');
  t('14', 10, 4, '3.333477587');
  t('4', 2, 0, '2.1');
  t('0.03', 7, 0, '0.02999551');
  t('90', 1, 4, '5');
  t('5312357191358436060512320673773898993193725886736164185043184432297', 9, 5, '154.333799');
  t('7199699999999999999999999999999999999999999939998.999999990999999', 5, 3, '113.19');
  t('-882.444444444144444444494444440464444444494940444444244444', 5, 4, '-7.4758');
  t('-8', 13, 5, '-2.776472280724');
  t('-86000000000000000000.000000000000000000000005', 70, 0, '-46.59402615070627535463115294058075590852999710911467932978308270954662');
  t('-376.89', 48, 4, '-6.62510230823208343124289061224985909335679702244');
  t('96266757965567956426092817863148449', 5, 0, '81.246');
  t('7519.1832', 46, 1, '9.618359979005094092372581180036903865361423221');
  t('3111111111111111111111111113111111111111.111111111111161138', 73, 2, '91.62894574016671152726822536730571926386870493068213127138241128153116515');
  t('-8428702594578936542477442030434333806', 37, 5, '-85.71785338514359573130458501589518584');
  t('-729028279311299860.939180266635717461', 48, 6, '-41.8236360986491235923183022666827171650501445231');
  t('636378004660459076120.99604591124', 11, 4, '48.595471588');
  t('461967326081151345517140931535', 45, 1, '68.9984388572118740675493758006785202194685299');
  t('0.92', 17, 6, '0.82365909043241051');
  t('-230982323268609169145946104396150217.76896733458979187647947774685888534', 35, 0, '-82.120796434310525765547736423296875');
  t('-672211211111111111101111111111.1111111111111111111111111111131117111', 35, 5, '-69.373517284788400913185878628465723');
  t('0.00000060482048460767108485365525600300117458763457062849', 77, 2, '0.00000060482048460763421017663533424068534983602813406207303024723328078399099182286');
  t('-0.03384059130054301010037', 28, 4, '-0.03383413566704186353496859594');
  t('71984879069309', 42, 1, '32.6006243805224822843383423875877387660665');
  t('0.0900770980497960620934208869160426353386017063437926198857463084798514071501', 39, 0, '0.089955728166487127683719480764589414987');
  t('2844969', 19, 5, '15.55420990973386475');
  t('-356', 50, 1, '-6.5680798840106081722529702658569854797470604302438');
  t('-49.3', 14, 4, '-4.5911741056591');
  t('0.03933187411044072735132236169900601818974716', 8, 3, '0.03932174');
  t('-34170.3', 62, 0, '-11.132259305476110273648480940373325075775200555781318183293398');
  t('77.47574325137050802631', 52, 1, '5.043153724397571705290385521814303549847001281430545');

  /*
  t('0.682', 3, 2, '0.638');
  t('-85.2', 9, 5, '-5.13818305');
  t('-102548514', 3, 3, '-19.2');
  t('47777743499999999999999999999', 9, 4, '66.7295046');
  t('-0.69381', 3, 1, '-0.647');
  t('-0.2924236641496707700577', 9, 4, '-0.288408716');
  t('6353918', 10, 0, '16.35772937');
  t('35', 1, 0, '5');
  t('-0.7', 10, 6, '-0.6526665661');
  t('-4530581087059730651716886688928640783.6125206', 5, 5, '-85.097');
  t('-0.32517254', 7, 4, '-0.3196987');
  t('911', 9, 3, '7.50769037');
  t('5.6444', 8, 6, '2.4315673');
  t('-6.03718732513736', 6, 4, '-2.49788');
  t('-26', 7, 5, '-3.951613');
  t('0.77', 4, 3, '0.709');
  t('-8950', 5, 4, '-9.7926');
  t('75.921', 9, 0, '5.02288388');
  t('73723056', 2, 5, '19');
  t('-0.00247221933082699097335671317641', 9, 0, '-0.00247221682');
  t('-5555555555557249821854397896148166804182276566028427673263.7779', 3, 0, '-134');
  t('776000000', 8, 3, '21.16281');
  t('0.508951', 4, 0, '0.4893');
  t('1205', 9, 5, '7.7873822');
  t('-8.1876', 2, 4, '-2.8');
  t('-99', 7, 1, '-5.288292');
  t('0.529286', 10, 6, '0.5072514491');
  t('3499.99999999999999999999999999999999999999992999999999999899999299999939999999999999999999999999999', 5, 2, '8.8537');
  t('79999999999999999999979999999999999999699999.9999991', 7, 4, '101.7837');
  t('-7.079193', 2, 3, '-2.7');
  t('-0.96481', 3, 6, '-0.856');
  t('-144444444736322222222.99999999955', 8, 6, '-47.112574');
  t('7000000000063467184972946309802980143841464616044482005026996333333333.222222222222222222333333333', 7, 5, '161.5174');
  t('-566666666666666666637', 6, 6, '-48.4795');
  t('0.3873319', 6, 3, '0.378247');
  t('0.8', 6, 3, '0.732668');
  t('267777777777777777.66666666664772310324006', 8, 4, '40.822081');
  t('-41247431997421.70230848268919951562', 7, 0, '-32.04376');
  t('2456055769', 2, 2, '23');
  t('-558434477920361153014472214014281', 6, 4, '-76.0958');
  t('-98', 7, 0, '-5.278141');
  t('-0.209533121064196837027725', 7, 3, '-0.2080295');
  t('0.4', 10, 2, '0.3900353198');
  t('55555555551.53648888888888', 2, 0, '26');
  t('-0.9', 3, 4, '-0.809');
  t('0.576', 6, 0, '0.548137');
  t('722308888888888888888888888888888948888888880888.884888', 10, 6, '110.8919292');
  t('-722222222.888888888888888888889999982866666666666', 7, 6, '-21.09099');
  t('4500976290305344320022179681918610711917504922.23990746944329806056334690358051152798', 9, 5, '105.813771');
  t('6968939465618170893247651694777992551301206924869', 6, 3, '113.158');
  t('598822222.8888222222222', 3, 5, '20.9');
  t('-66993365125655557377109', 3, 1, '-53.2');
  t('-4', 8, 5, '-2.0947125');
  t('-1782', 4, 2, '-8.178');
  t('89000003000000000000000000800000.5', 10, 5, '74.25933637');
  t('-0.792', 9, 2, '-0.726409109');
  t('-9745759675977667440753', 7, 3, '-51.32427');
  t('1733.6333', 9, 3, '8.15112192');
  t('673', 5, 6, '7.2049');
  t('0.9', 2, 2, '0.81');
  t('-444444444499.44444444445998', 10, 0, '-27.51323809');
  t('-4', 10, 1, '-2.094712547');
  t('777777777554198536384501850189761294152473151886095.222222222222222222615063071111', 5, 5, '117.87');
  t('-0.59945', 9, 3, '-0.568353221');
  t('-910000.06000000000000005004', 1, 4, '-10');
  t('0.69205786', 1, 1, '0.6');
  t('3', 7, 3, '1.818446');
  t('-3.2', 4, 6, '-1.88');
  t('-50638', 4, 4, '-11.53');
  t('-3415708151311138350224754.36249031067865886817990333853976', 7, 2, '-57.18357');
  t('-0.0271', 2, 4, '-0.027');
  t('23777777777777777777777777277777777777777777.7777777777772777777777777777777477', 2, 5, '100');
  t('0.591069', 9, 5, '0.561151558');
  t('-0.322740426732849', 2, 5, '-0.32');
  t('4.48', 9, 1, '2.20499988');
  t('0.6328', 10, 6, '0.5967464714');
  t('-6359390.9756999', 3, 1, '-16.3');
  t('481087238.871037256182489838753932', 7, 2, '20.68471');
  t('4600', 4, 1, '9.126');
  t('-79.242598903374875658856365015015317943', 6, 4, '-5.0657');
  t('2.5', 9, 3, '1.64723114');
  t('-0.0000855455725996969215870071401242140796102065705794', 3, 0, '-0.0000856');
  t('341395309.99', 7, 6, '20.3417');
  t('-0.63607908', 5, 1, '-0.59951');
  t('-265000', 5, 5, '-13.181');
  t('-8555626219999999999.6125543165495012423764', 5, 0, '-44.287');
  t('-0.28497555947', 2, 5, '-0.28');
  t('-0.14', 5, 1, '-0.13954');
  t('-878.76', 6, 5, '-7.47166');
  t('-5', 1, 2, '-2');
  t('0.46225929610324484042670805669384676820364835844637613373', 6, 3, '0.447203');
  t('-9011', 1, 4, '-10');
  t('400000000000010000005000000000000030100000960000000000000.00050300005', 1, 3, '100');
  t('-14405.968', 7, 2, '-10.26854');
  t('0.434118390629225046961130013498918008428738556663808535997420089954145070931', 1, 3, '0.4');
  t('-2566666.66666666666664666666666766', 9, 6, '-15.4512658');
  t('0.5', 6, 2, '0.481212');
  t('3891.886', 5, 3, '8.9597');
  t('-0.282', 3, 2, '-0.278');
  t('-116518478153.090434571835', 1, 2, '-20');
  t('79484193485555555555555555555.0266492471', 3, 2, '67.3');
  t('-92491603481063366395630532188686969561243707859719766352720742', 2, 6, '-140');
  t('-0.0009479', 1, 5, '-0.0009');
  t('261479814', 8, 0, '20.075015');
  t('917722948548640439786091892946571165614546092608149355118069326442239641939330985432223709900', 5, 1, '214.74');
  t('-0.228', 8, 3, '-0.22606944');
  t('-20644.40042', 6, 2, '-10.6283');
  t('58', 4, 3, '4.753');
  t('-0.407', 8, 4, '-0.39652679');
  t('0.2999999991', 4, 5, '0.2957');
  t('-9222222222222222522222222272.22222222222222222222222222', 10, 5, '-65.08456072');
  t('-84445', 5, 1, '-12.037');
  t('2', 5, 2, '1.4437');
  t('8250434.98', 3, 0, '16.7');
  t('-95599675589026342067598454302295149328803061855877230448951232861', 9, 6, '-150.316177');
  t('0.888024', 7, 4, '0.7999387');
  t('0.000000095301215893820793981926728121875760283024', 7, 6, '0.00000009530122');
  t('-0.513986', 4, 5, '-0.4937');
  t('-9771', 3, 6, '-9.88');
  t('697.8', 4, 1, '7.241');
  t('-8321741254584463.2785317904712569353', 2, 3, '-38');
  t('-0.56404591661', 1, 6, '-0.5');
  t('-69.06', 3, 6, '-4.93');
  t('73', 3, 6, '4.98');
  t('-411502474659740777165572174637275075657286510911111111111.111', 4, 0, '-131.1');
  t('-888.1927098670677398402905', 9, 4, '-7.48233623');
  t('0.563', 6, 6, '0.53684');
  t('97402.414', 2, 1, '12');
  t('-6.9', 10, 6, '-2.629878706');
  t('91702.7888', 5, 2, '12.12');
  t('-788888888888888888888888888888888888888888888888888888888.8888888888888888888888888', 10, 0, '-131.7033677');
  t('64376.3622838574185447076', 3, 0, '11.8');
  t('22', 1, 5, '4');
  t('-180555855755585555055535555515.58', 5, 3, '-68.059');
  t('-1225909085702528014', 6, 2, '-42.3433');
  t('0.4', 1, 5, '0.4');
  t('8.3', 1, 2, '3');
  t('-457.01416288333391', 3, 2, '-6.81');
  t('5634293568.5836', 2, 6, '23');
  t('-5.96', 8, 3, '-2.4851825');
  t('-0.000000004', 4, 5, '-0.000000004');
  t('-30000', 2, 2, '-11');
  t('-477.767777777777777777777777777', 9, 5, '-6.86227307');
  t('8.2643482584756', 8, 1, '2.8087384');
  t('0.2', 4, 3, '0.1986');
  t('0.56584', 19, 3, '0.5393131599866100326');
  t('0.00515462523', 16, 1, '0.005154602403735655');
  t('-0.477', 13, 5, '-0.4605459698382');
  t('5682894009770307702714034949.64537242497058580001717701', 15, 3, '64.600405303139');
  t('-9.46019209', 5, 6, '-2.943');
  t('-883.26', 16, 1, '-7.476767109009691');
  t('-0.58006', 4, 5, '-0.5517');
  t('-64226635213007319651', 10, 3, '-46.30209686');
  t('-781.38915386280770694037859792685', 13, 5, '-7.354220892148');
  t('0.125', 17, 3, '0.12467674692144274');
  t('881746', 8, 5, '14.382806');
  t('0.05', 14, 3, '0.049979190069348');
  t('277777.7774907775771', 12, 2, '13.2277238921');
  t('-0.08', 11, 0, '-0.079914911495');
  t('-0.344', 13, 0, '-0.3375531280335');
  t('6863259373192', 17, 5, '30.250350752676521');
  t('0.5690856', 5, 6, '0.54214');
  t('73.9', 10, 6, '4.995905783');
  t('766791946767415313', 12, 0, '41.8741390842');
  t('769633533593018233355231111111.22222222222222227194514', 2, 6, '70');
  t('63778178.314284551120618390578295', 13, 0, '18.66406883768');
  t('0.001109727832666317304484077457927140198942879449585430594117055209894776', 3, 0, '0.00111');
  t('-71960000000.002000000000000000008000000900000000000000000404', 4, 1, '-25.69');
  t('0.8999999999999999999999994929799699999999199299999298', 2, 5, '0.81');
  t('0.773099601738', 16, 1, '0.7115245068279588');
  t('8555555539142222795342569680045666237333333333333333', 1, 5, '100');
  t('0.0793959637', 16, 2, '0.07931278446215733');
  t('616472926730707618636871319129812767163849443128613945799281', 7, 3, '138.3645');
  t('-7387475256656337143', 11, 2, '-44.139464887');
  t('92562921999999977777777777777777.22222229', 11, 2, '74.298588622');
  t('-0.608972053', 13, 3, '-0.5765031290833');
  t('-1.14126297', 4, 5, '-0.9778');
  t('-184127254597', 5, 6, '-26.632');
  t('-0.92', 1, 6, '-0.8');
  t('0.204', 10, 2, '0.2026109156');
  t('-0.0243649988127429304288988875138169', 15, 0, '-0.0243625887300743');
  t('-70000000000000000000000.58777777', 4, 1, '-53.29');
  t('0.7318349396', 9, 4, '0.678551741');
  t('-9666666666666662455217575872397177639319722125330970975', 4, 1, '-127.3');
  t('-8413.034904579542057756256706563', 20, 5, '-9.7306847405204586198');
  t('0.6', 20, 2, '0.5688248987322475301');
  t('54825982.94', 12, 5, '18.5128219613');
  t('6.2', 20, 1, '2.5241375702003277987');
  t('701.5', 11, 2, '7.2463685882');
  t('5555555517720126390000000000000000000.42638227102186909431005621854697452421682', 15, 4, '85.3010089496271');
  t('5673.638018837116707247995844106713458231', 10, 6, '9.336733005');
  t('-424', 4, 6, '-6.743');
  t('0.4684344468597919', 17, 2, '0.45280206947568404');
  t('-9', 16, 0, '-2.893443985885872');
  t('-350307.45864375042498300077185537907453397141287922166676392529430582', 18, 0, '-13.4597136816811783');
  t('-763896396', 1, 5, '-20');
  t('68638804', 20, 5, '18.73751576930969819');
  t('-200000400', 19, 6, '-19.8069771050702561');
  t('-93226023657087446251715', 6, 3, '-53.5825');
  t('3', 12, 5, '1.81844645923');
  t('9', 9, 5, '2.89344399');
  t('-0.1', 3, 1, '-0.0998');
  t('19621292972421729902772201501921', 11, 1, '72.747315323');
  t('3904.7', 20, 1, '8.9630834316957150023');
  t('-8', 7, 5, '-2.776472');
  t('3.86', 6, 1, '2.06018');
  t('-0.15691661014', 10, 6, '-0.1562796875');
  t('0.1419739', 7, 4, '0.1415012');
  t('90000', 13, 4, '12.1007121299');
  t('-4555555555555555555141', 6, 5, '-50.5638');
  t('-9409999849.39599', 17, 4, '-23.658185955098968');
  t('0.067965453857410949385132572637515', 5, 1, '0.067913');
  t('256955555555555500.3333333355', 20, 3, '40.780826709829272384');
  t('775912391103992457090631011117099043095.5292621805013436', 12, 0, '90.2402501441');
  t('50070000000000000500000.0000004000009', 20, 6, '52.960856159776758083');
  t('-662.57071', 1, 1, '-7');
  t('2750000000000000000000000070000', 12, 1, '70.782300882');
  t('-54.44444444247444444444444444444436', 7, 4, '-4.690412');
  t('37.7777777777777777777777777777777777777777777777', 7, 5, '4.325043');
  t('130007494174.6172086', 12, 2, '26.2840051138');
  t('-0.3266839965194001647176030530162519481749', 14, 0, '-0.32113577318321');
  t('-0.62', 3, 2, '-0.585');
  t('5', 8, 3, '2.3124383');
  t('29.999999999999', 9, 4, '4.09462222');
  t('-0.5924697214424183', 1, 0, '-0.6');
  t('-12980954187055054163231261142447433', 8, 4, '-79.241938');
  t('-0.7118348', 14, 2, '-0.66233505761899');
  t('296364928844343.4456003578991566666666666666666666', 15, 4, '34.0157598591726');
  t('-28680234.108015595051498664774', 1, 3, '-20');
  t('-6.4', 11, 5, '-2.5554935532');
  t('-133333333333333336161388888.38', 3, 6, '-60.8');
  t('-66723', 19, 3, '-11.80145218066665408');
  t('-0.00068037789', 7, 4, '-0.0006803778');
  t('-0.3', 3, 6, '-0.296');
  t('-131999959.9489', 11, 6, '-19.391459358');
  t('581205309807516447512260416240.792611916', 1, 4, '70');
  t('5475888888888188888888887888888888888888888888888888888888888888888888.8888888888888888688878888888828', 19, 5, '161.2718732138084848');
  t('998838527549614908232633470', 17, 4, '62.861782543916929');
  t('59.8121646881574138642652317197311911797971683006', 2, 4, '4.8');
  t('-409107911', 17, 3, '-20.522636700842881');
  t('573669083914387.1687228817738194715102706', 4, 4, '34.68');
  t('0.17261350292155351199009660032116664876', 17, 6, '0.17176761416782087');
  t('0.18894076', 11, 3, '0.1878342904');
  t('-1444.4', 3, 5, '-7.97');
  t('-9', 15, 0, '-2.89344398588588');
  t('-974812887442795013582265174002767.068593354151160578593', 6, 3, '-76.653');
  t('-65421655737910901270999999999999', 6, 2, '-73.9515');
  t('3348244367827299', 7, 4, '36.44036');
  t('1679.55', 3, 6, '8.12');
  t('4333333346827994037', 1, 1, '40');
  t('-0.8705', 17, 4, '-0.78677835214406983');
  t('-3402182507813893743866.865555923', 4, 3, '-50.28');
  t('-0.1', 8, 2, '-0.099834078');
  t('977.902', 10, 2, '7.578556903');
  t('-36187888888888888888888888888.88888888888888088886888888888388888', 7, 0, '-66.45167');
  t('-31510526.571476389', 9, 1, '-17.9589794');
  t('77274133713892', 15, 4, '32.6715275740122');
  t('1779', 8, 1, '8.1769539');
  t('-464246651045', 7, 3, '-27.55683');
  t('-481667', 2, 0, '-14');
  t('7', 10, 6, '2.644120761');
  t('-83.04', 3, 5, '-5.11');
  t('-0.464', 8, 4, '-0.44878296');
  t('317242258000000000000000.4444444444444488', 13, 1, '54.80709983626');
  t('-4240541655638211289904.8128901682', 6, 6, '-50.4921');
  t('-50405.34', 20, 3, '-11.520999581486198744');
  t('0.07707971971149761219737301568', 1, 3, '0.07');
  t('-7156867863723989509766063800760366725843936150997685', 20, 0, '-120.09305935931945494');
  t('-4129999992.7999', 12, 6, '-22.8346904227');
  t('47777777774653938813621622522216343673420620534179899013833357093773764972399399246544736614454715271', 9, 5, '232.515632');
  t('994251164.3', 16, 5, '21.41064759364478');
  t('4555.555555555555516', 8, 6, '9.11725');
  t('-1', 15, 3, '-0.881373587019544');
  t('-0.87387875032052404788123654586476870803561340978', 7, 0, '-0.7893247');
  t('-120286283971717611037799447665108865440913352296201315051527123257678234709408520596', 3, 1, '-191');
  t('6653091922378633629', 12, 5, '44.0347605518');
  t('-0.7990065770676212', 20, 1, '-0.73189233509091295962');
  t('366535752', 8, 2, '20.412754');
  t('61111111111117442861975394685102222222222222', 12, 2, '101.514414788');
  t('-3.7169005622200392321495437799109964', 11, 4, '-2.0236608058');
  t('-660.3666536', 11, 6, '-7.1859429704');
  t('90300', 15, 3, '12.1040399199956');
  t('982.843', 19, 2, '7.583596831597939763');
  t('-0.000672167854378534532371423', 12, 6, '-0.000672167803763');
  t('43333333333333333338016663998984546333333333333333', 13, 4, '114.9861538061');
  t('-61116666666666666.66661110982', 7, 2, '-39.3447');
  t('-41502151.688616153575043416113354497', 10, 0, '-18.23440302');
  t('-7076222222222222222222222.805', 7, 2, '-57.91192');
  t('56.73', 9, 1, '4.73152802');
  t('-40', 1, 5, '-4');
  t('-0.00078030420133739643985196294508766058872368', 8, 3, '-0.00078030413');
  t('-536627775207276220991267535273607971704155.28547657450943534281060199393820758403021784', 2, 1, '-96');
  t('-33091020', 19, 3, '-18.00791968500532465');
  t('9.524', 17, 0, '2.9497069237656979');
  t('-0.34291384705548944471328', 2, 6, '-0.34');
  t('-0.82', 19, 6, '-0.7482095630948231649');
  t('2', 14, 5, '1.4436354751788');
  t('-0.9626090705456093511316772571321644716559037011674560666488638', 15, 1, '-0.854685541484882');
  t('0.00008', 8, 6, '0.00008');
  t('938.2411', 17, 4, '7.5371544167804937');
  t('6', 13, 3, '2.491779852644');
  t('904666350855718.903223229177091281178', 4, 2, '35.14');
  t('34801147.9056824', 20, 6, '18.05830811055610015');
  t('95', 10, 2, '5.247051772');
  t('-4139388.226', 16, 4, '-15.92920574394459');
  t('-6211073333333333', 4, 3, '-37.06');
  t('-170035951804524683048.919775320333781477286900962349776698991', 2, 0, '-48');
  t('0.6784', 11, 5, '0.63488139524');
  t('33', 2, 1, '4.1');
  t('-6.3', 36, 4, '-2.53993693665065932064698849007307306');
  t('-0.92', 16, 5, '-0.8236590904324105');
  t('-31111111111111735238023043166511111111111111111888888888888.9999999999999911', 40, 6, '-135.3780625070535995848322322501024128908');
  t('96674720.987', 34, 0, '19.08000968992083721721689818471708');
  t('0.000000824566', 16, 0, '0.0000008245659999999066');
  t('-38888888888533012.444172138599777777', 32, 0, '-38.892632152608719442042244406119');
  t('8', 23, 5, '2.7764722807237176735308');
  t('0.6972522639359', 20, 4, '0.65041408010764600152');
  t('-9873170.27922951', 34, 3, '-16.79847874396414201049627611378566');
  t('-977', 16, 5, '-7.577634094511902');
  t('-3255555555555554555155855.755', 19, 4, '-57.13555235110384366');
  t('-12222267.282635710622', 26, 6, '-17.011917213734725441687658');
  t('5911634108185362315252599288351.6666796085389813851489', 30, 0, '71.5476222624274923008122682397');
  t('-146708401223638818013745', 13, 2, '-54.03588108499');
  t('6826', 6, 5, '9.52164');
  t('-619144980.19673376', 4, 3, '-20.94');
  t('828', 7, 0, '7.412161');
  t('-512326692738114253381912166666666666666666.9346113538333333333333333333', 29, 3, '-96.732928300640134945464829216');
  t('-699999999999799999999999999999.9999999999999999909999999999999999799999999999999909091999999999', 40, 5, '-69.41402502644229773675862272421730607324');
  t('9700000000000020000', 33, 6, '44.411804739962106821695478575887');
  t('90000', 36, 1, '12.1007121299032116258091237135378107');
  t('-263151122', 32, 4, '-20.081386214042829558917819516672');
  t('2310058999599.053566329206124517', 8, 0, '29.161442');
  t('-0.1284467333753266718', 23, 4, '-0.12809613241336007457298');
  t('-624', 23, 1, '-7.1292981909816803342498');
  t('-173784.4884958808167', 26, 4, '-12.758718419238068841519714');
  t('0.7483478325773490119468110012278389098999332923378899391294555', 9, 4, '0.691824922');
  t('5957009460430336859417326955217060599579597841', 14, 1, '106.09404495205');
  t('-0.00070815408', 7, 6, '-0.000708154');
  t('-20100418224824495574483983.543362773183355', 23, 3, '-58.955930034470803686314');
  t('83333333333336223199780618111111111111', 34, 5, '88.00905915753976135428655679104154');
  t('5222222.2412222222222222222222222222222222222', 26, 4, '16.161580766536365650321305');
  t('891050050', 20, 4, '21.301058337256900027');
  t('-3888888888888888884624441111111111', 3, 2, '-78');
  t('-801539816825119533509187656547954623888888888888888', 22, 2, '-117.903766292975204863');
  t('-89999999999999999999999.713', 3, 6, '-53.5');
  t('-147838', 25, 4, '-12.59701953921686062841479');
  t('144444444444444444447254701350587453', 4, 1, '81.65');
  t('-438912497298571960698888888888.0000000088888', 34, 1, '-68.94724476182462807540442662323253');
  t('3442783033688', 18, 2, '29.5604484622132997');
  t('-1698.16879', 7, 3, '-8.130454');
  t('46666666666666666.615', 30, 2, '39.0749537094118251757252921673');
  t('77959129313637330806918625680967639398636456449', 38, 0, '108.66566107149594837059374042664802812');
  t('3888888888888888910212431593598222222222222.610117551061511', 10, 5, '98.75984457');
  t('-86199949399.999999999599979979939', 28, 0, '-25.87308260816887103322361398');
  t('-3099999999999929.9059399', 3, 3, '-36.4');
  t('-180383.4606517262672762714394058366611969053480436546', 28, 6, '-12.79598738144382957748168314');
  t('-2641069247762176416', 24, 6, '-43.1108627077050382101599');
  t('-51952026064234463953957345262339028653257560408372399280', 11, 3, '-128.98306292');
  t('-70.1', 21, 1, '-4.94312084566588261119');
  t('94919308353.333333255791120084531404680616331358831054', 28, 2, '25.96944016242003638281831116');
  t('-9685.053236', 16, 6, '-9.87148625579872');
  t('0.662914763768427968939641988881293790829276096835960290888', 14, 0, '0.62202064283505');
  t('-300', 26, 5, '-6.3969324329823501439965447');
  t('-392073212722035132142505', 9, 0, '-55.0188828');
  t('2990680930594042830', 14, 1, '43.235179951912');
  t('5703', 39, 3, '9.34189481940306609011936208904657958568');
  t('35425314.4499614', 18, 5, '18.0760844005601254');
  t('0.4211988661', 12, 1, '0.409645304244');
  t('-1952456959333433.9', 29, 6, '-35.901012134084042811710106863');
  t('-0.0000008718', 4, 4, '-0.0000008718');
  t('-209792.7008953869265113713312982323', 7, 4, '-12.94702');
  t('45.5124108666', 39, 2, '4.51125290628945979463912982327953221773');
  t('-6999999999999.9999999999999999999999529843701379', 31, 1, '-30.27007844554380682273848232621');
  t('-262741136804715195.7642409207391346809003431410196765', 18, 6, '-40.8030928522313953');
  t('22.95631823', 1, 0, '4');
  t('949899', 37, 1, '14.45725812269554812133501611545553318');
  t('-0.4630993', 34, 2, '-0.447965785249116818803707202079365');
  t('-0.95191', 9, 1, '-0.846956785');
  t('-76222222202222222222622222222222222.2222222222222222222222222222222222222222222', 12, 3, '-81.0121082995');
  t('4', 13, 3, '2.094712547261');
  t('-917', 11, 2, '-7.5142549501');
  t('0.32', 22, 6, '0.3147759800187902094602');
  t('527.7431', 33, 5, '6.96175769045423966034938504433024');
  t('74111111111111111111', 15, 4, '46.4452443230322');
  t('0.3411928', 1, 4, '0.3');
  t('0.41671930162755854402453188', 6, 0, '0.405514');
  t('831272876013312016785.455619797221126343', 6, 4, '48.8626');
  t('13893.508378567289030252169353729156184365534', 38, 6, '10.232324168759945678823614807656597521');
  t('81117111111111111111111111111111111111114111111111118.111111111111111111111', 8, 5, '122.52088');
  t('30000000000000000000000000000000000000000000', 15, 5, '100.802918467972');
  t('332348972', 2, 0, '21');
  t('6.044614140018', 28, 5, '2.49908796599321823375398302');
  t('-4688.43888888887888988888188', 8, 2, '-9.1460021');
  t('-47', 33, 6, '-4.54340793644413347266493791809402');
  t('-290626.9', 9, 6, '-13.2729428');
  t('66596009.13870063880279763387188', 11, 4, '18.707302391');
  t('7950488', 17, 4, '16.581891048954364');
  t('86666666666666666666666666666666.366666697', 18, 4, '74.2327693127287339');
  t('-7000000860520768360873573920102236415239999', 8, 1, '-99.347631');
  t('77891870.0942609359', 24, 2, '18.8639793225947510197843');
  t('3.5', 6, 1, '1.96572');
  t('49444842.271583606902245173', 9, 1, '18.4095154');
  t('7581', 5, 0, '9.6266');
  t('0.790306', 19, 4, '0.7250806039103874689');
  t('76124558', 2, 6, '19');
  t('2000000', 24, 3, '15.2018049190842272229424');
  t('0.4696', 38, 1, '0.4538573215638993421112764743397416088');
  t('499999999999999999822751150099120917010636955100061328170073380968656797221', 2, 2, '180');
  t('651816908459', 11, 6, '27.896176725');
  t('47', 37, 6, '4.543407936444133472664937918094017108');
  t('8.0578407', 35, 1, '2.7836211199689798860472966671154528');
  t('-863219999999499999.9', 4, 6, '-41.99');
  t('116054891', 10, 2, '19.26272102');
  t('941758899742454280526810934546625115179.7960911315775942', 3, 6, '90.4');
  t('-0.848783', 19, 3, '-0.7703098747360644338');
  t('83519080', 34, 5, '18.93373284727220839496397433463758');
  t('-4100035', 11, 5, '-15.919653249');
  t('-799999999.9599999999999999999999999999999991999599499999999999999999599799999999999999999999', 33, 0, '-21.1932694661421467102022351233467');
  t('99.28891280803177', 40, 6, '5.291206450290834813729559863506789880059');
  t('-340', 16, 4, '-6.522094960792895');
  t('4142257459908187254600792087323112467291509222', 7, 3, '105.7307');
  t('-7800729.091839089', 21, 2, '-16.5628749411641154132');
  t('-0.933', 24, 1, '-0.83319526353136357605583');
  t('953042360183747', 10, 4, '35.18382765');
  t('-4222222222.22222222222222222', 36, 1, '-22.8567745998965228522289478382984885');
  t('0.3', 34, 4, '0.2956730475634224391027105297335171');
  t('32.485838', 1, 2, '5');
  t('-80.05', 3, 4, '-5.08');
  t('-33333333333333333333.33333333333333333333333333333333333333333333332', 37, 1, '-45.64623675177274929838181597822293501');
  t('-7668267822851217.2678552326', 14, 3, '-37.269014327386');
  t('-0.18927857199172722521327239738557418683692', 39, 6, '-0.188166219231885167037372862050173466821');
  t('-7918836388312840875795305', 32, 4, '-58.024433686781907092602174416027');
  t('-2978500', 27, 1, '-15.6000775566108526725814623');
  t('-78003999.96999999999999999999999999999999999959999999999999999999999999991999', 15, 4, '-18.8654178455656');
  t('-894870999.299999899999', 21, 1, '-21.3053373115503122604');
  t('-0.00000005', 25, 6, '-0.00000004999999999999997916666667');
  t('77000000090000', 7, 1, '32.66797');
  t('-268.2732870126', 4, 1, '-6.285');
  t('-79826535464394573', 38, 3, '-39.611779549268809700739336376378927055');
  t('298654599', 24, 5, '20.2079454568808022118358');
  t('905389069939156207517354056108141008340439497509642259099917803821049056617393136191', 10, 4, '194.0109045');
  t('435685813.435886238', 40, 4, '20.58557911072248653238880434125103675578');
  t('8412', 30, 1, '9.73056172091551814589861336712');
  t('-0.46', 27, 6, '-0.445151759147682279086489602');
  t('47028', 12, 5, '11.4516456287');
  t('-7919845.1789524', 34, 5, '-16.5780293960474203464753860469207');
  t('0.02278735', 33, 1, '0.0227853783548406995196866973049705');
  t('-0.28201', 19, 2, '-0.2783997430330089565');
  t('24', 37, 1, '3.871634756387731429687905076632625809');
  t('-9839999999999999999999999999999995999999999999999999999999999999999999999.999919', 33, 0, '-168.765729587195396614190338923699');
  t('84873915984134638401943976', 32, 4, '60.396356226304291944229977724087');
  t('459849841516', 8, 6, '27.547313');
  t('89990999.999999999', 3, 4, '19');
  t('-40', 27, 3, '-4.38218284806549830676116626');
  t('-0.550270858834130413273292980093817645995', 27, 1, '-0.52571776522505089400633673');
  t('-0.33359', 37, 4, '-0.3276936362408353342310367772260751887');
  t('-4937634748564478566873.1460599928931', 40, 4, '-50.64432055413825848772939680772429260045');
  t('-0.2173', 5, 2, '-0.21562');
  t('0.96', 23, 2, '0.8528046172289323883664');
  t('-531369500000000000000000', 37, 3, '-55.32289176955452866916111400088363897');
  t('247147228380584165764', 22, 1, '47.64966307982193311088');
  t('-0.19918', 29, 2, '-0.19788597087353839365435580487');
  t('6999999999999999999970154061522222222222222222.20800582718602093577777', 5, 3, '106.25');
  t('-711113079566666666666666666666666666666.6', 16, 1, '-90.15304198849392');
  t('62845101040', 34, 4, '25.55708600264700126552610218739537');
  t('81', 28, 3, '5.087634437002271205971176056');
  t('0.09485959085119', 36, 0, '0.0947179006711641818576225129221047834');
  t('-0.026520854469242617722958455691', 31, 4, '-0.02651774652038305619068613882491');
  t('0.097', 10, 0, '0.0968485283');
  t('-852070471472246', 9, 4, '-35.0718375');
  t('-0.3192246442786153', 12, 3, '-0.314037429454');
  t('0.3108765122', 3, 1, '0.306');
  t('-90000000.00000076', 36, 3, '-19.0084674088544929556423047533662424');
  t('-0.8', 31, 3, '-0.7326682560454108641549178160406');
  t('18541.6677156134565286112411814210519803606750593933397349169', 32, 0, '10.520922968659967321576916100335');
  t('999999999999999999999.99999999999999999', 37, 2, '49.04743413343490467379505266982982493');
  t('-0.000000032062026319386918317546539492', 68, 3, '-0.000000032062026319386912824394134631879349120685711006434599418643626889817');
  t('-0.495518257213512158706511639892645419702564774754871663413', 47, 0, '-0.47719964367522885229707070475504604098640681455');
  t('4.684639455750291940723155031769705994', 31, 4, '2.24863794273407643879754135637');
  t('-1809747622152.84286', 63, 4, '-28.9173556967695537947577896584887822645147544636133555232822118');
  t('22', 18, 2, '3.78470576309943263');
  t('0.0000007682018950027912762045590379395667605629287724596658066433422487394803', 1, 5, '0.0000008');
  t('1201669608619', 47, 0, '28.507880226780929003733493721133866199403479553');
  t('7', 80, 6, '2.6441207610586290756978279749393769270844809847849062322598868259601315526660783');
  t('-0.61264078148186551736921502385270866697500772889231748040477', 45, 1, '-0.579634012595090637727347035360249964733504534');
  t('31533', 43, 3, '11.05193707630283495126899119551930173866052');
  t('784753815', 14, 5, '21.174027795655');
  t('-1377215929546862623186', 6, 4, '-49.3675');
  t('7008.2793444130217879971231', 32, 2, '9.5479946782612750222572855052414');
  t('4533333333', 13, 5, '22.92787052151');
  t('54064589111521625869667219055297425839423752526900290761756323349584', 54, 2, '156.653942744637710900516543352956753955882430440996799');
  t('-0.01394270302075462233850116658194576388', 77, 4, '-0.013942251319089534938729177545535517349151440630074234544384533259048989883009');
  t('-299.9999399999999999979999999', 55, 2, '-6.396932232983441246172477794215715408005456019918545718');
  t('2871905932711046183372741366254436002512709390677791256612958523688550222222222222222222', 5, 0, '202.08');
  t('-3666666666666666945441259999999999999', 68, 1, '-84.885493512475850862761057376592434200924638643059656961531292753918');
  t('-0.4630001787821', 44, 5, '-0.44787583900004720705927877472616576353024259');
  t('0.0000381787734537946720671347502978841', 29, 4, '0.000038178773444519656114972517243');
  t('-479231619855807.279041355946419933478', 28, 2, '-34.49635232578689552286855113');
  t('31818639298', 29, 6, '24.876465277025226594891811886');
  t('8034931', 47, 2, '16.592456150246833229569977271856473077556750279');
  t('478495901493789264115055131614453231810655015', 22, 0, '103.5723687318449558603');
  t('10000000000000008924422625.038957956198862889764108904989871335727440037940395420141338007458', 2, 4, '58');
  t('7576819.134251765382766480261', 14, 2, '16.533751210825');
  t('-0.236', 16, 0, '-0.2338624428652866');
  t('666.4', 52, 2, '7.195037834362373019267915450088625094684860998039221');
  t('-597905188.855404', 70, 6, '-20.90208993284039487415407222670688838682708410198469285988197976625632');
  t('1143066393464740844554120951', 14, 4, '62.996659161546');
  t('-34576148', 63, 5, '-18.0518218187053176159154554874378086468535542537875963893907634');
  t('59143.549', 40, 2, '11.68086998238276467090428398240128035386');
  t('-4112027621', 62, 6, '-22.830329262805921069537874052115526618645567986303483833119863');
  t('-42300188487607.08507698250468', 17, 4, '-32.068959838502597');
  t('-49999999999996068207865666579414907934404', 65, 4, '-94.405988812755794408894962970555432792811847984958316523490241385');
  t('-393732', 21, 6, '-13.5765729343528937335');
  t('81565591738066.51221064', 69, 0, '32.7255757996541768867778312281602039075228692923616704820593301551593');
  t('-388888888888888888488888888888888888888888888888888888888888888888.88888888888888888888888888888', 43, 0, '-151.7193017093261090664737268501947374500573');
  t('-0.90227003', 38, 6, '-0.81055328367329905420961888198701813291');
  t('0.16048116729237818228488217018608992138057904533801696990375807225188308', 68, 6, '0.15980018615140439352109653317862793100180564950166901226745650742227');
  t('-91660344659083823715088713501862430002256093414', 3, 6, '-109');
  t('8751796156131372972947765981314595873532361651531', 47, 3, '113.38649059856407663544320437177002739340521618');
  t('-0.11565298940611', 35, 5, '-0.11539670737415873909331672061570151');
  t('18307313110514111.1131', 16, 4, '38.13922417901515');
  t('0.528661178298193193622792932112359556707308989326464132617', 71, 0, '0.5066991391754629989635915889270803300958927153096592692296376826878153');
  t('0.000000001120614602756449959115151100862613567428360270326663', 35, 0, '0.0000000011206146027564499588806107437759415');
  t('-8879122624052633559117', 78, 0, '-51.2311368819599099761698171866629447555735843157166793808555294965993467284221');
  t('-8094602024845467754977645584391855099787227824190845865855561719', 77, 2, '-147.8472054620231685369025851283017328023017549360393616940844376500188343281');
  t('-3698777777772222222.777777777777777', 48, 4, '-43.4476812892000324997093529613984351387568669844');
  t('-25555513029304410946135043638060771033643431362432520282', 2, 6, '-130');
  t('933122853153687095', 41, 6, '42.070460443055410208080217059719667276197');
  t('812383297326397', 58, 4, '35.02414056631620755554295016431934666362158052915198442028');
  t('12035307500151677576271283793185595769952874986342960000000000', 74, 3, '141.33609738160168960515531747765765638625969365209929147335277011181104642');
  t('-0.31955076689813588903813022792', 34, 0, '-0.3143480916774549591442736440624916');
  t('-9', 73, 0, '-2.893443985885871378072718306626369246055584762462533199231699336214345507');
  t('841121.0445', 40, 1, '14.33563803840945469915412524338642014789');
  t('-401192976852130477326172.02446147182800940320617027529', 74, 3, '-55.041876684015851681016506887779039230184296830809738525014803009319143725');
  t('2094264131119768979', 68, 1, '42.878881096061953658744102538534046920249496493047786044674644514957');
  t('-8.8152309666', 40, 3, '-2.872829942180628153748176987403419299171');
  t('5444444444444262495179677326632169.888888888888531828189994278666666666', 62, 0, '78.373050970137826690178452810763642059292342553612068102467462');
  t('8', 44, 4, '2.7764722807237176735308040270285434588028289');
  t('-37038010496114664183', 64, 2, '-45.75162355048026915588402715555390175730193409148111687570929603');
  t('-0.470057324338763', 79, 6, '-0.4542712382257772198681590569442154627233709746748991527156345272118435655094853');
  t('-46897669', 46, 5, '-18.35662571124875578792921843720553868421500085');
  t('-0.71', 49, 6, '-0.6608396407895863851885702105963280171844694680092');
  t('0.0237', 55, 3, '0.02369778188510610505248476315561774114767945912932627002');
  t('-0.59281287474', 44, 3, '-0.56265222720677036901896313065363370716612909');
  t('-4000000000000000000000000000000000000.000000001', 46, 6, '-84.97250488946548055289938873301164117786615399');
  t('-9999.999919959929899999994999199', 39, 6, '-9.90348754703212103410216844354175040348');
  t('-9321187577860222005515999315906072417531939005', 76, 1, '-106.5417664083891327308761567682228995515981166231673707742169473956666770305');
  t('-2912371969108035055.81543', 22, 0, '-43.20864671327381950253');
  t('-63757430941904384548453716680263421453558918785210470605446852', 51, 2, '-143.00333850124276923165154985620253767690360126989');
  t('-1793153438369827416498095155913.4228295', 39, 5, '-70.3546757376785198166924910975139977914');
  t('-755552878426498453999514964440064264429504279783361', 42, 2, '-117.844681414836793305623824906216106837976');
  t('3003628666573648171686', 39, 5, '50.1472552467046154946732945775939798698');
  t('9.33175999994999999999969999995995999999639999999999999', 49, 3, '2.929429397668981570767153144993747617496929262024');
  t('8333363', 52, 0, '16.62892483471797728634512092769578983328036838973708');
  t('-2645254233', 69, 4, '-22.3891801965340317801000748326656111196179595987500277428340460589467');
  t('8868579.991978514317', 68, 0, '16.691172430933767243771956183420459471608727224889169747323502745869');
  t('0.986495481090000216110712092639182', 61, 3, '0.8717921388083236179737287533092110161169033763820276103415718');
  t('87777777777777777777.777777759438529737774374204', 15, 5, '46.6144872225776');
  t('-6250556.44460529582373', 30, 3, '-16.3413282294463468310669547304');
  t('-4650554944476109456246.44227800986974871366', 43, 4, '-50.58442068881146054950591137326467041517047');
  t('-3132688644543805506815914041387888888.188', 68, 6, '-84.728102156042306390541063914584668473548332667805356796216535808734');
  t('5834638600227511111111111', 41, 2, '57.719001739686858603111938549132200739588');
  t('0.5628357269593211', 79, 4, '0.5366967665532565321157811358211010679946198046372758527219434816162851464781868');
  t('-711435524344012518587.535487226699139', 22, 1, '-48.70696364854271055317');
  t('-788888888888888888873333333333333.333703455680722179262019', 37, 6, '-76.44132545607450323651220442016665897');
  t('-9999999999999979999999999999999999999999999999999992999999.9', 20, 3, '-134.24308257421459299');
  t('-1767179228607568992300424253', 70, 4, '-63.43232931061026024978599269053595960297576362149001977060895755569638');
  t('-677777777777777115650766372141404403', 49, 3, '-83.19727472218863513909912631241275419697299702182');
  t('-1152497931515310182980267174191.90649', 26, 0, '-69.912631671487729817094428');
  t('-157.2662838843918581185659314317696663', 37, 1, '-5.751097732821724931066689490811938718');
  t('-8111511.14', 60, 2, '-16.6019419197504082912922343515714399631351664818426719226786');
  t('-3236535688684995', 38, 4, '-36.406427101351310979358162345258133336');
  t('-499999994499999.9999999999', 68, 2, '-34.538776383910685199769871176599790587121799252927346519384431685947');
  t('48539642920050737968554632.134943906451226801984434433289', 9, 0, '59.8375703');
  t('-4795608.20712122484190204827038708518351228283713872638801056', 5, 3, '-16.077');
  t('7', 17, 6, '2.6441207610586291');
  t('-0.62144937177976800092', 21, 4, '-0.587130357397079938832');
  t('9352999999.5796820631', 51, 0, '23.65211016491383102476483668587527795209875038715');
  t('0.0297512170573438389881182', 19, 5, '0.02974682983109472765');
  t('-9333333333972853173155919707', 69, 1, '-65.09653691297479299328335990767048403300363968885706293353776120698');
  t('34480807894389496956371086221591905587773907713447646110391369612', 40, 2, '149.2964109155175789209886653160484904986');
  t('700000000000000000008036912821597113706224347305506473353963550711540059386136214923443390119', 80, 1, '214.47688588506746154418927999989371641659417640376882933011144705894017063290101');
  t('-4111111111111111111111111111111111111111111111111111111111111111111111111111111111111111.111111111', 36, 5, '-202.431743606349924880560093876184258');
  t('965785', 42, 1, '14.473843701695309251250000057797595511394');
  t('86666666666666818777.4444444274333', 12, 5, '46.6017481968');
  t('45650707093393489', 39, 0, '39.0529426718416694163880211771172802776');
  t('-0.3233332926565753835310602448083516922671777745190719', 75, 4, '-0.317949148714865766428279631229951750179244481051196588800494070595629761416');
  t('-0.09', 49, 3, '-0.08987894074394680193837910433312734138968336097052');
  t('-55.670312', 78, 2, '-4.71267484383981078702376411703894296495712713033875003095936636961741734952498');
  t('-0.628440860129435399449474103322187339983081180352641', 16, 2, '-0.5930592725369947');
  t('-1999.999999999999999999999999999999999999999999999', 27, 2, '-8.2940497026020218115142524');
  t('-1327369603871370644605409232', 38, 0, '-63.146143933869671577726957734111441303');
  t('635065.115', 5, 1, '14.054');
  t('64029421.3389801753', 79, 6, '18.66800042467191265432367497626810268584465882800362413612037944536493814934557');
  t('6789865997693134', 62, 5, '37.147354781602477227304480228391826137127928928425330505649693');
  t('-2828.2', 64, 3, '-8.640542957688639359693485395291583498243863984629251096065701074');
  t('-5.04309', 72, 6, '-2.32085416067596536409988609455522401669880976274752182017699113420157702');
  t('0.128565765117403834693900448107529800362302668885076983970258921492563317686', 12, 6, '0.128214193327');
  t('0.5359', 100, 3, '0.5130891222032116670765029849561768275804143700885982467189154447290560950278609459007898558863014846');
  t('58902772988929392605291983045', 119, 2, '66.938832860556818695911433765043296138833376508235642931983037421599478508859641167613792101699477244812429802235132661');
  t('8555555555555555555550555555555555555555555555555555555555555555555555555555555555555555.555555555555', 10, 6, '203.1646311');
  t('-162272380371710581774229836148565768088357315717291195808646179041695699', 130, 3, '-164.6607948807968124264483700169627420807197121691430869322438739157544028584025139473610308769715490749188042060287981673374439404');
  t('808205395266195448068220712145889643232', 24, 0, '90.2810267566249385562788');
  t('-7301000000000000000000000000000000000000000000000000000000000000000000000000', 114, 5, '-175.375040480187320309915750620722879462485061545988599053228609275540753078531009884438846586324453515000242284001');
  t('-42108116533014808279162170', 134, 6, '-59.695429926281506183412489111557361000769026742050265567540802249524530491115905310884100760371785374722224768000029614453453989429547');
  t('16970077375222138468335503049633424504886138758', 50, 3, '107.14092800405762582456512017242587665370392685839');
  t('618925.61330539816651552976227743326053', 93, 4, '14.028887552639976490277741354127290349385996721371055254363619885191433658097593370159226981');
  t('722222783', 140, 4, '21.090991393532965525338356625800182030413926641437905025664390293068412988973824605103297914490805088456259152641343233465191113645430497169');
  t('4129958202.01099415083410812263986817820001332212208095', 86, 6, '22.834680303849632674181090153966231233015032541428559576647496184016670256091286760658');
  t('-6111112079513222', 148, 0, '-37.04203234183266951349212739088047397380298806829222557948284197955916807176170256928951779924027027120935254005683724958589436986376561272966054142');
  t('7404973365930640927996054861805035', 23, 5, '78.680607100308433423897');
  t('0.0000896210957473477', 82, 5, '0.0000896210956273758111438427851611397069223964047562496488828292453565235810205564608');
  t('-44892757424625744549229705809058178540513', 30, 0, '-94.298242284490916750272809115');
  t('2302934845632364585747.69598808461743351111805480015', 41, 3, '49.881618462788738681516570773576821527448');
  t('-585362271403222777777777777777777.7777777777777777722', 116, 0, '-76.142930893302204254077487034216433719763823350664523420704054020191228828500825439126057645009680736679272756525619');
  t('-1444444444444444444451518856518749347836544444444', 28, 4, '-111.5849564243994554955487166');
  t('0.5', 22, 4, '0.4812118250596034474978');
  t('-0.94511', 64, 5, '-0.8420231183061385495778944171576946480451563381824273232948346203');
  t('-3111111111111115889311957162157307669448053461700613444459407761870397688888888888888', 10, 5, '-195.2452749');
  t('38', 21, 5, '4.33090642553643102748');
  t('0.000001049', 53, 5, '0.0000010489999999998076132251667619328364026229422687835678');
  t('0.32137', 18, 3, '0.316080541384470312');
  t('-986392926.3120756937540198089440040998090594153422726313', 139, 6, '-21.40271251913217238559057413067042813036968267624302820131032493406019036258235216388783627261236084609215587448385527618515194435007038434');
  t('6829779279', 120, 1, '23.3377053741686260676966790802582416089547636451296405213383214369247159635874698424346213419241653514187999275951473608');
  t('-42448681963374690493210418833613333333', 122, 0, '-87.334506391466015874191538040830222677505301243576444153919343724175814537797914298661265080346980689640572703517662340354');
  t('-0.3446247952991', 107, 3, '-0.33814388635584418510738064332833855604241738811397681561201860299598678748499954376338003124720053114208482');
  t('-6367.284814916388344132426485910851840164482049790982042923492234036', 3, 1, '-9.45');
  t('0.90004', 25, 3, '0.8088966671229588301686246');
  t('974', 149, 2, '7.5745587477275418405700835725871558779208588059247773691613417080136170943235799087877712566293635041906950620608048175629670395073548906792091010396');
  t('-13333333333333333538555555555555', 8, 2, '-72.360967');
  t('0.000000063294', 147, 6, '0.0000000632939999999999577393300306360761857902945089569104707943180764077538992767704951359314932053627214676434299394238343835374103477162273838980589712');
  t('48538583376630276658143', 29, 2, '52.929793148648029117176619078');
  t('-2071623636088891113987', 51, 3, '-49.7757667985188455896400695345543154296958534961758');
  t('65300000.00080004000000030009', 55, 6, '18.6876497748188566106518298904924118435460198974417463');
  t('-5803115387662940661420', 7, 2, '-50.80582');
  t('-7', 7, 4, '-2.644121');
  t('-27.511571373307', 71, 3, '-4.0080840109022036104174580281231536284048450384408347962811591117353134');
  t('7155577777777777777777777777777777777777777777777777777717777777777777.777777777777777777777777777777777777777777', 95, 1, '161.539410758508425831565156334361887313007224599419703500790267537783509427327311674870924687');
  t('9513471911399694153589834819830', 147, 4, '72.0234088603761631385453483325559929924133792109057613254926608248143651074635699979649965367482628512805582013935547556729831666136910258364175377');
  t('812077777777777777777777.37277777727777777770777777777777777', 15, 6, '55.7470302544501');
  t('1898353.95255603660402784054711370040609', 148, 2, '15.14964490844666274317372634917853324777415694165260306777428550602025398385810375307490143090484418409176570479674139795722980844811861684437272818');
  t('6.83436469804799352917890439652', 157, 5, '2.620420570967358213744413105680274593726860268647153133825869560127237664360083433122036643305966596456640903519044824670687731726539966292290714521720197271');
  t('534804795277610.457783762921157984', 43, 4, '34.6060701081637614125448147945942153199803');
  t('1157074847152560611849421577737998376931677819781911365839857.31009924724323', 145, 5, '138.9941478970328146888738307079162687301430794464382149495511347571200315643834056122011712969831356083155401093498881723358547996764418228896867');
  t('122222222222222222222222222.222', 120, 0, '60.761030293867284255156463047369905674412682758818452737653738195514130973866795336502371181016947712917568966000516318');
  t('-4841447593507726', 104, 3, '-36.809137341048514444467138442157395209553263945536396461931376370606733421909918763959432206854829771295');
  t('-0.000488786383321740881197047960929896858852932286672536', 127, 2, '-0.0004887863638589104350955769712409180515389031436771188109790475153692458993965606927307719969931012413117254117244058300901680328');
  t('9000002867818369516111633522704320619395900848240773201041807085791421750290735138639128287453160500', 31, 3, '230.8462962829531221439984814399');
  t('48', 19, 3, '4.564456680755902429');
  t('397805941069071029036388762440467985022232185334730000000000000000', 146, 4, '151.74197234030732742794116441630649000222590124343963462732980826849376874843757360232125378842363330584400156454651966528381709329039415496544811');
  t('-620357018446067', 86, 2, '-34.7544634450009172817479223888189740260772945280654951282592143291209329126535887062');
  t('17926476925841136982808863085832873966599320819970.8203376167720261137984260309697905166', 52, 1, '114.1035104221126262954412378813022219652009952351782');
  t('9.33239439409416827669', 118, 4, '2.929496990652619624653169155035364834853336669273704721439452496931193601123523956565130545741289586955131019395246962');
  t('-1', 139, 0, '-0.8813735870195430252326093249797923090281603282616354107532956086533771842220260878337068919102560428567398161921064921887620725119765919376');
  t('-22.33137774413221708316', 35, 6, '-3.7996408802076074909430068561464513');
  t('47777777775056153661967757850407712004523932883420521661807222222222222222.0000000000244635423931584221643333333333', 70, 6, '170.3458345074256590577315932882828499204820787900117939972323929576559');
  t('-51.944444444444444444444444444444444444444444444444444444444444444444444444444743444444444444444444944444444444444444444444444444444444444444444444444444', 103, 3, '-4.643414592571207512996535168184869352247925826602428934746217002849649126525333110816248781143608115637');
  t('0.960141', 130, 2, '0.8529063292587847965362987179446059511653435421629805958850520281739871325224899633472891391375779075970949209070648584721166232991');
  t('-4275266310945811396384522744700331361206036', 131, 0, '-98.854567481716421792032202341927491387767427145221667704315379539630318464724660916569419755395446268665155560216698635804504297725');
  t('0.3309622945879699311054425', 87, 0, '0.32519998671112784622097589075567646404757702736036579565268277667155257087001854829812');
  t('604599253342480902589425033511239577889814', 113, 4, '96.898531654711159185378636292770031008936631910034902130526917924697882101858286136968610022574475104434115590121');
  t('399999997544988699419146016859437429339948698391561906156412585087029613906800777295615311683939810489916752040', 106, 2, '255.3638017648873328999439948260512669386156127433639093067155815661628347074825134636957481584005458509547');
  t('-555448081270529915', 119, 1, '-41.551698717123019272228366528095089408163331528103503331434935067634914756987010807796371613034009734463310348715748305');
  t('625870580', 39, 1, '20.9478013470363496743541251195317681671');
  t('39000000000000002000000000000020000000.000000000000000000010003000000001', 41, 5, '87.249772174475236412795708450634925908038');
  t('-40000090000000000000000000000000000000000000000000000000000000000000000000800.008000000000000000000000000006000700000000000000000000000000000000000000008', 56, 0, '-177.07591085922477666741591551317117996809836559452794328');
  t('8772759.9213487855', 125, 1, '16.680309195668391979369216295587447800528691630920034530502755633050290515039183587494057391408486452500916194287954666486478');
  t('-1447756085242457430852651314207819161006266696361107493.308538098300458915006881764973462905516346943908659587067', 41, 3, '-125.4027570325945477790851211432195526717');
  t('-872841872555555555555555', 123, 4, '-55.8191885417749966473649372824396670636986544300267026246106828156705326339353097413931685486947932265391261380154329114331');
  t('0.75651493151796185682592364255823', 5, 3, '0.69835');
  t('86185112150.438547987032981396367', 137, 2, '25.872910467387475663687786862939697373290450966569278409016251860309157457197613211756133839893480733765205936131216846674377330084070506');
  t('-18050052984322196238168013507738979.60166562388898979216014317', 81, 0, '-79.5716038695575467301307079636101221255793101803366288532841210597058077279311023');
  t('-747608578.570088230784244792', 52, 5, '-21.12553728885264412334479721377652209785314684468459');
  t('986821415.5230159420456031051563754671135429574380017006970363050903779599922320151135760336567425215803', 115, 3, '21.4031468249332106485054197915844527739605730471543566546970342860235357358608830048535863602836103998052348439084');
  t('-388888888888.999999999991', 2, 3, '-28');
  t('721052387533', 134, 5, '27.997124811698191800360191242669338596386344958273604590946376162919457902962605224832482390765880036442821952527878959164572350955898');
  t('7799999599999.0999999999999999949999989999999999999999', 42, 6, '30.3782919789018715888840822914999093175426');
  t('8054518389311434412171874365573023099827801235084207682332037408098458682798563494644638443250', 48, 6, '216.919794053569711640723039976145456992701634349');
  t('-28889943224558711224013707890976508655294563222551196384657288888888888888', 153, 5, '-169.84276742537929615374873556050318396463945501085851514056920379210838118421281437026137505547346970246057424350366633858486428595723920046244609294434');
  t('-0.045543', 25, 6, '-0.045527270728591327518225');
  t('-6860000.00000600000000000002004', 103, 0, '-16.43436518026289321820334621891354960606433397927898825339615422430926976176402911166220726586930393022');
  t('-0.438399927337802153562493231072106161505', 49, 4, '-0.4254484519042477742616483607954830816941371030167');
  t('-353.557', 99, 4, '-6.56119389754710733813175982479462987724572910150035792571981641206221669916970784404500124907067563');
  t('13861.1226479913161', 114, 4, '10.2299904504583568608076189053952505543990422124777223267022486904013844563261558631518695022817598434488544910096');
  t('-0.7480533263833', 115, 5, '-0.6915891140254265360181379378794301545278715839718300802568134576574598954559138977810686408458825495986957995719285');
  t('-0.516947265870619', 29, 3, '-0.49631831649332482140919443441');
  t('-6.049893342681998', 150, 1, '-2.49994926101472445635510302189335264112312035705500516230666152696977292860687747054598925120762853110141088103113882726777250312506336714742627835624');
  t('-47777777777777777777777777777777777777777777777777777777777776777777777777777777777777777747777.77', 35, 5, '-218.70012146035758264779078090128921');
  t('9', 63, 3, '2.89344398588587137807271830662636924605558476246253319923169933');
  t('-955555555555555555552630006666666666', 40, 4, '-83.54074815426883260014345557543966346962');
  t('73333333332.33333333333333333333333313343333333333333333333', 96, 5, '25.7114282751769719480446670068356570784645673028488717071687898933916446122871067642280267247344');
  t('-9657.45729529', 28, 1, '-9.868632855849273912143353088');
  t('477777777734585.8888888888359688444576957953444444444444', 111, 0, '34.493314020743526298440401444427874066544728958549146667103263213549435340668736526789292333692699558154087154');
  t('-13333338888888888888888888.55333333321980085567888888888', 24, 1, '-58.5454569945294481984414');
  t('133333288712699477262543999999999999999', 67, 5, '88.47906245213065231209455251042764722707357197560803650154264958404');
  t('-0.8063936201522819101552281847700498674967170278851754676093919459', 154, 4, '-0.7376530526688679050346218294792385087960069684100117478685346857717326397812134838153948797801703219609498376508411123106980282352142950574673280586189702');
  t('-48825076005395966', 31, 2, '-39.12016760892229911230827086482');
  t('-83.39197', 40, 1, '-5.116735149768480646735589120254279105381');
  t('-85143531143007416847.83868339850700461608', 14, 6, '-46.584017288541');
  t('-999999999.999999999999999999999699999999999999999999999999999999929999', 28, 1, '-21.41641301750635646582915521');
  t('-460253261924156072117', 23, 6, '-48.271455761828523092199');
  t('79', 70, 4, '5.062635088303317691620783377739400031721208392962908623262029508520472');
  t('633496', 86, 3, '14.052156145156103774234952320182221252300051876603789108318427725351685441442147739736');
  t('900.00006000000000000008000000000000033', 115, 6, '7.495542319192711771403777824832776940119510067936153133865267345523777532699563148131794382341896564639925255266021');
  t('950000000000000.0000000000000008000000000000000000000100000000000000000000000000000000000000000002000000000000000000000000002', 74, 6, '35.18063028108308003626090779747007155722620730431801697552532553701265226');
  t('-6135472286122111111111', 90, 3, '-50.8615211908877907053594733457846629088209321192288404672608079829889761962357309403082145');
  t('0.0841144040672275', 50, 4, '0.084015530376839848797598632870381781088803425904844');
  t('0.0000007887948010212581500014135203818886033795613652310702578', 21, 6, '0.000000788794801021176352344');
  t('-53000000000000000000000000000000000000006000000.00000000000000000000000000000000000000000000000000000300005', 73, 5, '-108.2797682788441229243713167212836236804851580831134265899893197400332978');
  t('9010014.9', 101, 4, '16.706994463861192659179625849638617888988014979358369229263368536288418479902757251293439590258526252');
  t('-0.037747798094', 117, 2, '-0.0377388393877703589761632906479178254231216601969717343107372339793340328521055061717843942105908357473171037600654377');
  t('-3222222222222263', 78, 1, '-36.4019948281208978692522992932638955382202112985236784204840174603694884667097');
  t('7944444444444444444094644144444.44444444444444444444444444444', 37, 3, '71.84317284274505841782065337922331573');
  t('-0.60989486259307695874372541518406415936', 67, 2, '-0.5772911333676867322621379201286430714150273452118877828106110851885');
  t('-211706633833.22222222222222228095861490359669484484', 5, 2, '-26.771');
  t('-181.01', 115, 5, '-5.891707089012635555467769173537153815719714653723860156907472921044037208311153284380545830858943792619587934301361');
  t('4162739857.9539577357538635', 2, 0, '23');
  t('0.718892940728', 62, 3, '0.66807557432267574073319109569668815420957206707932159790941154');
  t('2555555555555555555555555555555555555555555555555555555555555555555.555555516', 73, 1, '153.6020329567598907626209304885913589788955975830542085108495681835611905');
  t('-4333333333333383984956756317441547567.598', 61, 3, '-85.05254759713902866755934122946396978114568273561832977811679');
  t('2954477.7217', 76, 3, '15.59197962983571140578003477923299326914660517657323426967842944863678042778');
  t('-0.5779450467435', 44, 2, '-0.54982117046956055970213381082307328030919013');
  t('4144914675699611096353697', 65, 3, '57.377071615918993408329823151358977831144231218629203831154742432');
  t('982', 73, 2, '7.582738748163276497710220209841948408424521156982306871175850347127223846');
  t('355555555555555525555555555555555555555555555515555555.5555555555555558553559955', 44, 4, '123.99866843470787364229144935317530744244609');
  t('0.06493857652533101217446790978192981776362376506539', 51, 2, '0.0648930217211306861109176854789547736848902107850314');
  t('5999993999999999.8999993', 63, 0, '37.0236820446981855534994477166374819602154352449289354393326488');
  t('0.000002096467072973881441179568566968510453538357839422235247864', 64, 5, '0.000002096467072972345718185361569963366974699577222254206609069654988');
  t('-0.77499302160608207347709583171192013627193565305713', 51, 6, '-0.713021785530239295451792408385132854956440010810005');
  t('-8716381359353319614542829784520140474429384', 37, 6, '-99.56692525637647056491738352707639941');
  t('0.275430030393778815198156222554119317214407503659666616073', 74, 1, '0.27206137533572451351006139931260007613001988948498199370312452285324713657');
  t('0.00853', 76, 4, '0.00852989656164061819928592492057730962400705616616514408550722083973164877762');
  t('-93645725245593857353129316', 77, 5, '-60.4947081941958527539939442916018197177060768825151572953123428851387229189');
  t('-83933414570350698313637630006.494271521259', 49, 4, '-67.29296849221635223277839025237292731057350006084');
  t('-3452502080', 51, 0, '-22.6555122262694691864519844981175479921239242238467');
  t('-78.924', 18, 2, '-5.06167267711859986');
  t('403161203392092360600.160708548473028144970693', 6, 2, '48.1391');
  t('6163003697', 142, 0, '23.23497728935647572428121756886118061714707375440876969202716039702430344541330079938902301526820119920625047978606905301088462460182104642253');
  t('-0.5750527162', 24, 5, '-0.547315415642867174613002');
  t('-0.23909284771365012530455335105523642498333566809054403473879221433562', 148, 5, '-0.2368715550894555506342450941137269943200714265574874131003814720845914199898303308552383036959742316895101942221634792623240404916782920635537889188');
  t('-57970297265912.000691039852122832177273212734628270470604522', 24, 2, '-32.3840990597537079780915');
  t('0.250739470464885949099839708916132310128688296801746837428', 33, 2, '0.248183790811610508675822475141844');
  t('8508.426546364223533467', 15, 1, '9.74195949381629');
  t('2690046524.4011960547862', 45, 4, '22.4059715062869717032204077897820267004098985');
  t('-0.257722416904323411438838262968052277365', 131, 4, '-0.25495144244533546111788890912371185241829166906845462120895601135338150340370765549031688463586682019538456008218537301654693723398');
  t('9.7709600009000000000000000000000000000000008700000000000000000000000008000001005', 149, 4, '2.9751702540136792454438909471330796179375535910954731559524678770358896553483951379095630646005414195112357151840586416657779414377322046886545006913');
  t('920717.53626516475', 108, 4, '14.4260557563205514914512821286567248263378747066952064355467018298860792694813770240472287387070946405230778');
  t('-11850.569639', 57, 5, '-10.0732783985497166680961905973878043670847837992666736247');
  t('775631398193', 139, 6, '28.07009042251162366142013049745808064743303285006111537276864999703546689140317671366173405208214009874311778834752980737850362057360660173');
  t('-0.1303539342799214750697937286556887303575779652264316686362917987295366700417486352712', 75, 5, '-0.129987563305959448180126791101978353154580723260829913346298965636405468546');
  t('-8821894.09138533658336', 14, 4, '-16.685894335078');
  t('-97918156687333.185201735530123400403346591724609', 68, 3, '-32.908300290395310550671376162667942421518529285952600700164285927627');
  t('-9.30000000000000000010000000000000000000000000000000000000600000008', 110, 4, '-2.9260396356364362908053075220457471610650922903093985076203987920224304651315319363577531880393874475166146512');
  t('7', 103, 4, '2.64412076105862907569782797493937692708448098478490623225988682596013155266607826350112067573076812857');
  t('3536499.8996635330322257167504934', 44, 2, '15.771795247646460731502600750469417750236214');
  t('-54444051651770978804777136253226707995', 59, 0, '-87.583384127528709234756542723485201112989343881351662110825');
  t('-0.87449548622261424070359268739587497772254284727591940116618350263', 106, 4, '-0.7897889926333143626120096411864712404684283500713425018107866790117101104154659182573430070718069341359409');
  t('2261431726529983138882744515747570791576717', 85, 4, '98.21771920632716040837415328647411305954103754416114655695166443780382052029087890261');
  t('699999999999999999999999999999999999999999993999999999999999999999999999999799999999999739999999999979999999999999139999999599999999.9999', 110, 1, '304.27770451183524322087946542855306749345687986573994773151745375761155678102608175145201242701554484832467961');
  t('0.00000000952972071460333385012561918821899558071606859697939', 129, 3, '0.00000000952972071460333370588443845875875148433304197634037695687657184857436998979531323199479500737484674490764071306019942888746245539');
  t('-23704603.3645687204948722342591063494630650470391138104487634179819643965669510016499611994385869445152892353298896158611692151308', 72, 0, '-17.6743270025960995831309371340090332700087881660783692812787864506109493');
  t('-79179352839997528941193673649163272319242893902504', 107, 5, '-115.58894721264261027188746046235986149603642893661113830612746192530639395670170195151341184714432493293187');
  t('25555555555555555555555555555555555555555555565555555555555555555555555555555555555555555355.5555555555401', 39, 6, '211.166660281611032863070716855700464169');
  t('-95973', 97, 4, '-12.16496936147886201519068291861373283594281531576431842028451828076819058007345774281602091332579');
  t('-45555555555555555.6666666666666666666212803857104900766', 131, 5, '-39.050856157832764677220392685844262624292248864007312484176774218279819548362059808546657096281040187662014836484169544779700539464');
  t('-4000000000000000000000010000000050000000000000000000000000000000000000000000000000000900000.00000000000000000000004', 74, 3, '-209.31209991114394748987092978596732088832563437966720860533030111548359075');
  t('-6408698220232408848358.600321128395', 144, 3, '-50.90509029797560158755784055812271077070040222766927034560822488404714832820274254368809573117193491124869887664433989072786117754062806435563');
  t('-26681321336447777777777777.2270789632185598503350514118099216515234110942158', 155, 5, '-59.239153157592239443687587373091873632188852675907830346284926464780245372474521149171489030771220624173980390000339135850128482807211432400558352696609872');
  t('0.38882828886966052998619709737692351392084657115965880750077748507858070366', 22, 0, '0.3796427772699202477177');
  t('9.22665', 97, 2, '2.918167012351787250429727798513497875857085818867207739423336804437266725422969915794574779271232');
  t('-142191879.6865', 31, 2, '-19.46583514938588047248272184203');
  t('-46471131255901458266932597775769510175838618463035313325276720', 28, 2, '-142.6870840467928410889494771');
  t('-35677423545046726394920268', 100, 3, '-59.52970750746122883478639204578138515165073667616157615038261609010435625241030492404597882211264676');
  t('-9666666.665366666661666266666666666666666666660666966', 80, 1, '-16.777341279708103665552637853213260563508127867995796419694820025308117351289639');
  t('-5380000.00000000000000000000000000000000000000000200200000000000000000000000000934', 37, 0, '-16.19134611269792109837573026598650896');
  t('-941220.22947784394440880357898448118117565836105055325484656453234235461371587236986273642', 110, 6, '-14.448079609447471803723747230271727672570752268384390028590350011352079876652921946411317791108591566535110091');
  t('5337986736972.4', 33, 0, '29.9990168628241273409781709321368');
  t('-456026757301589830203301143736.035165299596723188346653823627631072421645', 102, 4, '-68.9854961774850213220906762413407209698747594483647268532381946702262103531979921978330512919648103442');
  t('54247062991240220', 5, 5, '39.225');
  t('-993227.7211292013163', 73, 1, '-14.50186242371032573584011107957695805605424986307442647965555600785199681');
  t('7396250000000000003000001000200000000000.0005', 63, 6, '92.4949389223364937611049413922610806174356235424175541107528843');
  t('-96271610695953686873244189876005565890050925015698868063', 135, 6, '-129.599915676915163294806902141315247216190689805540938212415133434272782390752057703720627730673742482309298718220770427194501621352847');
  t('3495.4840601890742171379542748921651827', 145, 4, '8.852374346867844711885358758328290017188288668022069566740543673619395249035857186075330833349948075915394522364299283330988254282291545574091175');
  t('-993431872.2128768928534159543116', 37, 4, '-21.409823224649849569568771377306649');
  t('0.494300243158702100697615141330271997682573864529263070126285338460208097929596445', 276, 2, '0.476108004975381118117135258993122020321204596425201212613774983148847807444023024295868661870292275117832489016173535953107707233870480919867231308101380179312957162440638656022942850853940187687737314947358412443309831476204793321426904539219106010830095981210334326368507679');
  t('-4420300000000.01', 269, 4, '-29.810375863577981537599509400265294417623081400490504708471423921168300452768083283389120032514065568643228555817102220413774876650207835048525445128618642213669800631032831818700196625480537754989599893071050882065368481416508236809858089849651208402177209500620207236');
  t('-9726722966605705', 191, 3, '-37.50680061808524489051761193453470440337755358782773306563563590519962211418617736002469056447516207574012041321352101570731135338575464567516658179101275524018716235396366737505162072934042');
  t('33163', 12, 5, '11.1023372564');
  t('79333333333333333333333333333373333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333.3333333333333', 232, 0, '329.7313036777237517593309014778059911701647796186299196781726115161006813355614283995003920110351169979031380416957469623617127186370290398068550007305101896330881284102626789152484927524156776072723529410819013218953472517256452486');
  t('747130.3166', 169, 0, '14.2171420827399294645577389585238620158290734992830484945172142277607460358343283250897059334210588056272130619721604968256181326450873550630931211853628108363229853551');
  t('-73683178893.2442286309017017702827044', 298, 2, '-25.71618755311071217800439173597170328061190593421536999628114230198430707049277755974800002588158030534015642501786426843738844696380484183688042249354978007894959688812036509615194001013364698344573275233281942806686169553550225196761788720157040513739143910499653977081964705787059621706708517586');
  t('805178980', 112, 2, '21.1997223266336565775654230832808069197539241658854391814009547619599935196541688552308539301916869737751755816');
  t('9999999999999999999999999999999999999999999999999.999999999999999999999999999999999999999999999999999', 123, 3, '113.51981673726818382629881340099202274052947307717013107975374715690445149615996624716972637638673530869842289909259686877');
  t('-959999999999999999999999999999999999999999999999999999999.99999999999999099999999199599999999999999999999999999999999999999999999999999999999999999999993999999999999999999999999999999999999993999999999999999999999999999999999999999999999999999999999999999999499999999995999', 102, 4, '-131.899675486700294168888167973311616531161073238566794658291808943814349547916163665151141996720150623');
  t('599702.884885871105818871223917480327260314200332769390006552216157139982253820665839705546241787631098900332261213132456978144702711479167306822375727935137594946916639632671654878312315052073142987472247989525727193108382213850196272643713179964581985530744179741643791250788837857163', 132, 2, '13.9973368002540636203618049163885820488770820062358999600249363922398187608330410102296445037108041383346378500394098625859115152916');
  t('-733933333333333333333333333333333333333333333333333333.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333303333383333333333333333333333333333333333333333', 118, 3, '-124.7234051212244682796003064593342286195098156130372457611791996501108386023859113293866575323624297337408761702227632');
  t('-0.789867018704217480379308288686419778725578211581445657569591998452482161', 19, 6, '-0.7247361577421402434');
  t('79827818', 11, 4, '18.888529779');
  t('-26099.66615621327774560736157298424552335607602637183582101', 280, 3, '-10.86282498320624576168053909865992841279643620476529086624727029218826109786617246863833350430703387515797415010802881136235684877574914919145939013660592997957483024096253279070572930937798871236547758509502250963878796833034287629974111620401576658594527250121510501930749246338');
  t('-852800000', 13, 5, '-21.25718279194');
  t('-9535000000000000000000000000000000000000000000000000000000000000000000000.0000000000000000000000000000000000000000000000000000000070000000000080000000000000000000000006000000000000000000000000000000000000000000000000009', 291, 0, '-168.734243115183616947485545014777456436169414392139861576074204072456099376282312776368544872417238918134663581405860305364583613586556305099234804745623824084503545848191216836505022749622354168542696334897744174969432740259286624855824914206880393893706432482083726430358741137136307930898');
  t('-0.09893002996922365417954565757917337184677449420418822836946620724833145424405614', 155, 3, '-0.098769362727604522350463430704541318751237912034941759365729979273051803944600098891763789351824963312286029765927098463759911355676098829649942486507674074');
  t('-0.95', 156, 6, '-0.845572697039727389920891100584013109644368739828865076716968920063651667653483746782142011044338225303742549467940785162182898478318070732990904226617378043');
  t('-38888888888882045645337515559289934040777646760693757983797', 288, 2, '-135.601206058367613310256465623446220723419453454570108222010656136432019014957827209092622009846412108131303196592231943784507739031533629115067393174285638082569124792031388057386907358574751288940603862708903117246051847525884386555423169377655137026374693600193716073180141817979646132');
  t('-74595.3368832', 216, 3, '-11.9129804565749057617415561734361343963304906478930013214271108391391849091848546862507080137154602203731124529582579908985993985794990014043389319074108431269027409571922269795496152488961757251351603168953933605401');
  t('0.8080547595342512426551190130036591455180872422888346439308521116000388717922913944341200718914949857883165189096372162545044295582684119673586366881433175461052730132904916381279306815095615749454444147', 58, 0, '0.7389456171298627623028450926798328677275095725088107690832');
  t('0.01500301577777171096491530134', 148, 0, '0.01500245299543125866944955113570177649412900258326740092733003753798341946374585497048998477023059760320992140187083360999899430085205456925836752463');
  t('20962391955770732377934616037.003376067', 131, 5, '65.905674664368054849545716402278555787873381993664341573244685766629580470622806937732515176319221878134324163302082466039452723965');
  t('0.596342162', 318, 1, '0.565685798769829802279647005296822505250369238582387186254870472551295824958292919778522273892240115386202888061038208880692943970258996486899250997136433512403730891460479453683988140079383748165467747685427339079945946590936655972069133230625177260740789972151258440360823395838789013093672053281935037000545125917734');
  t('993.99999999005', 109, 1, '7.594884640233630887613596271352479183172134518932586862570667198985002715969055093156847119576798962984556852');
  t('0.1716229202912250846293464581120113451', 131, 2, '0.17079138625530068267053552286785638138149965714931279470117084800618193263792593762445739202706349676371961709780494706426199813682');
  t('-0.99236', 205, 4, '-0.8759609597255583815941960443271338010344977021571421169160330627378178355439654316504371022043527033349634923604880737006850073482976753351824808411668611553314104805563281591416268153507249694700731194448');
  t('94508101194855775453423051409908337681.1932903245', 80, 1, '88.134896086100634504319886945258136524796414910386473433928761612309028223047693');
  t('155555555555555555230925118113806445278332123531341876385498911', 254, 6, '143.89525569846981694817788674796238947380164896309653283806799260826468025241368330754134118439827937669457699143665167555619548061812278848484883661864752112733520535179629867222640598589993349998082392771553529396617437179494440612808462414811622011892');
  t('-0.000000017511901816222879499804622990527795575275363174606868763258097748348432103852848664525244552541090626896', 203, 2, '-0.000000017511901816222878604751750967987100416583347377325716760196795038961297396801964615421773219248323367582621229723546940494480894211776319630188972330996924309749186517084785503169908102513862668946835879');
  t('-4193991999999939999999999.99999999999999999999949999999999999999999', 2, 3, '-58');
  t('-170032843872953132305964179561784790.595754717394456784184874345283548817', 222, 1, '-81.8144468670058079488885009124556669410102092685364083899208138098434678411531529362859748905323652312378604680219191855742375827594938519600483076313800636949067965897992563601743841086943287619730164651155739126680890266');
  t('-40000000000000000000000000000000000000000000000000000.00000000000007', 315, 0, '-121.813866377370211497187252007961468499483777811776960516095090878795706569131413119089444645648367576408329369510596986138351884891578811767744955448041875738903357545413957162573515646835801343889834112870626469259129601503894937018436964346274681460580002834959340337130455138400350647265807001014019910277315984');
  t('-0.6745308840041542', 164, 2, '-0.63167666306048615232842155329700226109466199050153027366527327348983911088063992382669261937529059732049183155071775210226841215890219081991017527683255263619046936');
  t('9.59', 43, 2, '2.956575385785493533388453543855369308805093');
  t('-90', 23, 3, '-5.1929877136589412026279');
  t('175375564618668220989306328015252446707722239200870748336678143215053283928457207277177932363870396066118848425291154754278680706405005', 154, 6, '309.8013092136848932975185970393960276529795083177373043690486184203069111954955157899118953236338846531789724444393301347051187255120750308613592762710768');
  t('79449488622113646460853412595661484927992956876087342380988384743730650346427233346348668446569755', 250, 2, '226.1164375644760012617283347070315433081439805662542520048875960475632386321985249749722922393057333895433292923125880278518236248172606443374991357615676772526941157694974582717605674230824357560210148996058641322231702292246260012487603185589498164');
  t('3283806362614826202151655300889625736471829652112564604268369489772213', 260, 6, '160.76052182311985052402736246235649817973854203312073448182795741216803796784463177710069851189253938742901370103700292442992710839130372585260538757477631814806183786247111258389461416802932732978589979781659786540279500908662328294129165209877758419207627981');
  t('-792999999999999991999999999.9999999499999999', 54, 4, '-62.6310126340518897005656311955195002202192416231669242');
  t('0.688836478257524850750853891003791104760892169337387', 187, 3, '0.6434970728074505883827075461071177778235747367201143047181123073483459320897439883077445255166984569634468796254061334936805847201799682901790158246795824649816779486768128686578519940495');
  t('-19089404076755992763168214325496926710.22644625814180160335246355693560819', 288, 0, '-86.5353439490824329887339710326033018653708179835849623602305478302749116384158900712176704251898224502529349334061156363578270754318117279279538544886311274268601769228007420644818421367339370568338300179946002077944339305985544090302497196004275073539121558548738376786793218971782329355');
  t('-62620887748141281043689327801111701307725008623040.820463818531248391268', 82, 1, '-115.3543305368228073682500850944763349723743496991620124422919382407698827492769713');
  t('476950316880465937', 138, 4, '41.399335903450904510490278036964164567779213415303005203431598983423321482372826336814672166153151948258836436281659958615754094367712992');
  t('-619999999999.99999999999499', 137, 6, '-27.846132495545493704943535684021395086503733481928078822027929241890114283163708563442454644187845042256480730171279251278564680093910889');
  t('-0.94968871997761659854803093664089264560906765310800714905245404491279389505216177097909103474559123503981429290526630314476911293238014653034403236495272462425753910420445998255262914471338984692125010984842417145554588060887723451661063314271829668683599', 177, 5, '-0.845347001659826838738170213945036768317236735482243081775665930124398689037825627651575637902672293337317011613972922281450858571273809891847165117915041271640065154643054620168');
  t('-3000000100.00000000000000000000000000000000000000000000000000000000000000000000006', 143, 5, '-22.51502533950779893477996834992238764113997301980898251719961991667653812522021287320277640684850837798118863443838355951759208339607537904019');
  t('3087382630465292263380485590465565961926572883.3685766468581276060660634802503038961863357948347750293143967234107485050954036263310221553463126485', 222, 2, '105.436800052099333300714403572433935077243172414270307978237132211611940293097781085716670508994702827193816366870989549882871707325551078875730188994145405983239569586081640597989572055819117261249090999093468920502235356');
  t('560000000000.0000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000209', 190, 5, '27.7443498012355513829541965733134056289705083165749648106067615424431903199802736988445080543214684403810566264262313767530772894632452334190729269631776564338848619686114444474618106572191');
  t('-2592433305051573581781967765981987274593238.349342', 262, 2, '-98.35431802098730445142828518517973071914786913499324557666751232248775040864602350128680423832903790994168056304511087334512233732656835095316839947992708368674651397992063952121957891002603516085078026208794064298071970327766250288544416637901469300636470976703');
  t('0.0033922427896', 195, 5, '0.00339223628370148028341451086114043325007853818733980028197480686288190735333471283123249268054714112892789140873631632260169879232515735788130552154097960956572588506240910814523343672095594729135');
  t('-78599999999999999999999999999999999999999999999999999999999999.9999999999999965', 199, 5, '-143.2126244596378472114406293173858929823713886602814465178993959648186018482583596466944042558619332922408904950286066376156300717281330613197113582825746096761859301920689979501358175335200584892198');
  t('664150605576901222125518795206215688232732908038179054513414', 2, 1, '130');
  t('68777.77777777777777707777777707777777777', 17, 0, '11.831783154943309');
  t('5238668228698068165815775511701951.310412403539912', 240, 4, '78.3345225605649788848562459267663365609483210240955944414749045754761742178128315267510999375938604672071169495107986736170480582265832910361526517951496255380940393739369777517079536175325335946253066748934226146086325477314801563426619379');
  t('98964443782853723415586104690.0087769875947678487183420443393597151', 77, 2, '67.457705323314080535296865855308716140836207641154910134812834659818205513366');
  t('-68800000000000000000.666666888149207222222222222222222', 176, 1, '-46.37088259939206559887454777597076453338534219195985162188634346255183087287547997415095365910603829128979745019714280590221236549971114781882679155143870439038472094514036585');
  t('0.2456921393300443638682080944626819254519025687732974235978284182331144304', 89, 3, '0.24328511480248863064929706158391645743586042443669210186656825587558133098927294749320818');
  t('766616666.66666666666666666657', 41, 4, '21.150644632255299901556679738174627536241');
  t('0.50339', 50, 4, '0.48424187561877310298962418173863882368772603499064');
  t('-11191328616994302532803326116595255458078579490017095913093957063610386063078840413058696328408685342676441783333', 309, 0, '-258.695231750703235956891009769353169910874004387070190820768477785803143138081989680870054170921517712049743767653997841757492505313707906633010131747285980138211865746092522237727927341539154923804243134809964180265275277321942897734142638694584884409532799456917934709235319630990983923498621680153171786988');
  t('-41922883588267201235001560277880627613571827917339133099770687520725301868009575881579328416996907488', 144, 1, '-232.38490321250552993418456075239131178996999890644517529430568740075767567010569953203413716184707718962505628297486167466356265927987371370215');
  t('-837469.049029217303747151013894229235381188465714363236074', 65, 3, '-14.331286766175732250892911283511997319324809006714644337395351693');
  t('-600000000000000000000000600000000000000000007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000.07', 94, 2, '-449.1864146906328630097200526886055351154121796321913839771083338070000228148977128972021334614');
  t('9063987092133333333333', 21, 4, '51.2517432330789839164');
  t('-8438510177.1345971093411210033864115681507462383072777969781106039725731225620349341493545536', 143, 3, '-23.549218791236008813748502929212560075302832645249188359507650173299340615119623103115274781227556838895806970568636226066859197840371789681602');
  t('-80432125335468709076367684317656118998696385103346746266797766478415950071676490864712535746212772938', 219, 1, '-233.036485052198127472294146371315324818063233222137440302722696634917144403318307862809598998356292206480795884811635754417548398059489512093402159188828391382743671253753927094116126918412101432403138052909359828039805');
  t('477233635253466633402.1111958263703065', 300, 6, '48.3076850267975231277289509875746486160373523976108862540895709315416947296742621237259794432826542974388949050085436447560067322990355252611760750161132677836883876230587223410560385259692491499922343395529819012311584230527762341600399429872951370919859937698005543148910450770825109092061532137673');
  t('-2706.002146697706563237401763131683', 267, 5, '-8.59637481674226448943890480655137822743989199203922761375624642408643208071609543783497986593488927836306497577581166776927797288000506743435392826442302098724165480057188579407172224077670973518650147865574138840548042680063770885100685059400199844354090841044082702');
  t('919007050453505360036757969919962747.89139568822272995639', 50, 0, '83.501749043565125130613094960482910650298966519136');
  t('5', 99, 5, '2.31243834127275262025356234136441438365824507264655923716722899009913255483823893241500577417895479');
  t('0.93288541480413872693334836254081969', 206, 5, '0.83311147909676642295092876470309021761756004092768334471877466390990041080671933753929939661642895436603688058901154927132042437511706378145045329743512353423143072517581132450092583292693641506494151627398');
  t('814961905557552563470129541149079289091825980552038805016483365648657349441034653895080110874628370232405397936936', 268, 2, '262.9832338734002793437364237838495436568180845963926100770087835727369060330327236238043722259726419108594905035689520544333182519069248318760321487906846590467529597959917518797226874631894301129093725674814331521669996782807255266246655805743483942945631935676169582');
  t('-0.32639104', 78, 4, '-0.320857287685475179389840903028942786031992014119504570263533950699614179777352');
  t('-4733614216514959999999999.882750044944404', 216, 5, '-57.5098784281127539694144540530005510217973742302219118079320143628311987376107049477018692899508659036299650873407732889889644478420440762765715355186424424025102078842264772810975578098902724434118791629617387011316');
  t('-521810678387646320094997949485609177867398897', 91, 6, '-103.6590259233252244845215259677285393662715637623940869720647543453777943914266090707365996');
  t('-176068106153573537648960087293673074447066281488807554302899817721458479099211401994367798658479515403450978805482', 169, 0, '-261.4509633898665004098402439412561080509849756812155000979728032095016243740943833651723400861788198518331627194205630222037087285685338136098540100972800868290755913227');
  t('-883397530298246463163.6148901206065', 79, 1, '-48.9234541579335027558995626198702265531027901212034120092370730079093956704086');
  t('-0.996011876938', 195, 0, '-0.878550744636600132615542217797337468469618649502152234610243642935718070272127672802623512549745765617025758412988010240197150471947957355199174879307722469783812772165367013813653722389231974271');
  t('7836693.79483469920618978424902568561107524487716552822449129', 250, 1, '16.56747477409942471651053049225740237031982424838687186583863534355023035083831623273619071751406144732890267624910140974434166094003775923680864757014368401953016609774228483654918517425450695381604690065989622715230809213607399478828689077311951006');
  t('0.00008767118271519603717759915815462262774588227790971264967', 143, 2, '0.000087671182602885800035985902674565686631919543992705073309862366360670389383312610171006800550581543266983729912620340895695477897260807781972252');
  t('9000000001961705', 110, 1, '37.429148153024817174676061782812732450729036696026757547695546850880181891356682642891964323326853001568683687');
  t('-0.0000000045557386189', 73, 3, '-0.000000004555738618899999984241127336556766918803706585749350616009203816498283354');
  t('8673333373333333333332333333333333333333333333333533333333333333333333333333333333333333333333333.33333833333331333333333333333333333333333333833333', 167, 0, '223.90156929701641753765515150083888330773981243505657291331851139325455835677040908671624844659320848472879832088237332568810385601221605612097030864371699127692158697');
  t('-0.0074475419672', 301, 1, '-0.007447473121505162749337777080969043059444908913514917120173516261672038345367713092836531642144449525429270689476695688056280465533042976875399973385381145307942414005391325702324330606541315557153888371187220266715805283117737184115504794162563975896942279819882913127372992505630384135865948439859828');
  t('-587096673913278577214761886671704933032238079622528286469383793086081256893665373617983041336761273037819370005199185525466572588183703961911263704599366030', 273, 1, '-359.363855906421607876450526810223622257573365509892792620708003233739011396486007420275966704734363056267687756814480935737501044480223137740249341962993540344524462768081527426191524503147759045164027942565051604810615737534531938134320893412996191856949712473017199719255');
  t('-0.000036976991', 217, 6, '-0.0000369769909915735732068876955049555094360071331998805582552715494093096313664735964933771499597649369432568517171744061156622248542416530359914576845621298412798404047478007293476695852311147742663157366924340640127748');
  t('-0.7', 290, 3, '-0.65266656608235578680868634410967589744239743329899284157982384870313400709464654984982670006573625009918171130305380501583654479394602214393534615675444148684203026219767694376354648888744493980333482866201769902859418639785242215409964359850430814010566407249387623327684827176136644699516');
  t('342771968804819414347810888019919663699724439162', 177, 1, '110.146541777391015435564195064490026932809168220092035310716490016835423462037739717757709554986916698760829593281741925396903711349563063277303620562289478003741163931129659069');
  t('245241016376598569391360379521600514696987392474410680.000834841585153567575774245555555555555555555', 124, 0, '123.6272283905582506795520330930885868907166353431975765846099511459584380303375777737689977740205792600512189144519131458425');
  t('62981776861555452059302857351047884976943320445698393339891238384198574.22222222222222220796111', 2, 0, '170');
  t('1536', 248, 4, '8.0300842002313588771048329404725762929075844812473171731134972032869035312181281307057743856239737060000818262658532339922097216723177666270054831821861781604469528019656126348544370146277023273759551233330411200458237149208727802261406463140158061');
  t('-149684244349335133517957295632225931528799', 239, 3, '-95.502493845046898658643729396579070041640835068566382151895561588512257226954184679411737397459883444457552404400085109491755144398970831357561684856796410277340912056776451315662481546394091101551021677976754634783937264570680873805917871');
  t('-854371128103737819719753180910959073', 244, 1, '-83.42882092498500485358735274076121758694725031573778439077360308176038200817366560299722401652042493615066878779391357531333500856483883161171337033400731326340804577156176250443355540222832007621495001819851232459132656294958203285681708432357');
  t('-5999999999999999999999999999999999.999999999999999999999999997', 36, 3, '-78.4702147185915078828234274844228977');
  t('-0.004185831812812535702598112516', 106, 5, '-0.004185819589451247170903561228358516264324899154391698177314287883010774095478749780377236480685500444928476');
  t('64.44438693333', 287, 4, '4.8590100052177285758907261031589393416879794016650960357937913637529070723601559564363465143060347840943657934283808903291586916590345942711464980180783178905711600351054358749613569286637249388718383282811066109051669980200647647827438227222373361770256862938868548043933035191700716654');
  t('14341911111111.1111141111111111111111111111111111911111111111113111117111111111311111', 307, 4, '30.98735439412679130836064651697964051517910152108971512567200735766376908980673544414761976456394928019900900532255325725990463319585341974954997771240486711438522642606653372648103422492732448699008422788040604400662145312361057037495866181765332245520993028563373180897213935266943410039132761237601828326');
  t('190123.47209722813689922774279726', 193, 0, '12.84857617378967184328321751458296077140207738560999750003527601733047642613320084542791948364417526716510836170741155096698892367867953490622550160866142885137461258314457464700762971077110908');
  t('88888888888888840525198859784.000000000263479642182222222222222', 123, 2, '67.3503318417308861473086773704040688656547613172386817915607205778376024700555591306381501954817897649681691194922061014674');
  t('-28981777778551.876', 1, 0, '-40');
  t('-0.043739012588093378030833', 133, 6, '-0.04372507838758140809637021536370772275725699797374126351952434623012655585811176418691565523064162192790331638916882619394783154677828');
  t('-409', 175, 3, '-6.706863831090701859453137947230734815080761616710014058111165753646596512479924214413313619284612105919133107627519681902766269583968579720097414870533202032021814465971101681');
  t('-0.9891226046841011261868968593535309532667684798283099702069687089727', 22, 3, '-0.8736611534515226823802');
  t('-0.000000911765986620687020562878995', 223, 2, '-0.0000009117659866205606927695216684219643617472652600473008723366482441520633144919266190564568963497915408495015902331721970850088013331886751573607041140838050036413600684301021172954089502111632422701086973460482026996466494731');
  t('-97.8', 194, 0, '-5.2760978939709067580684493089587821851249372843198164068033198528522319552392145203880391972906676834047046376969421351890450875988671906251559870916172811028673216722368688931623476925084761244');
  t('-6190000000000008003000000.00480000000000009000000002', 172, 3, '-57.77812449911354775293284042012349711293421192369560396391498863858880771283502510328673002448266074887751442458500527357889206886947168289925994187971492345506214344433697');
  t('-5861600000000000100500000000.0000005', 220, 1, '-64.63136729526279585522542265397297944181017680454658067565683909703973508354945456896736237260702807031947666848638627828277241900386875507266950483986106383441159313144288086646740265018188405254864405765813255248698568');
  t('-39.2989', 303, 6, '-4.36450554472122332043981995753559818994998798007832337307239873388932524249132575561932495667023015521699470558847060329148570539908652959568775517837187180590552180460926712765078012590067851369802479108575113203978765078436548117885243661914457087576805316641934411627216318421989086941697990511784905');
  t('-410368534040019638369306476636463357069109786083079748629637607090899447201434203373788633.80615381647725233948970177113156861154586159868284095531877', 38, 1, '-207.03510589051662703242045128321144552');
  t('9888888888897519310565672809251477015.6748077709684079', 79, 2, '85.87762232074238312886293519050185724024659202193159162316598253637269198398048');
  t('3666666666666661401067479739784440356747844444444444.7355278447571826883255555555', 11, 3, '119.4242699');
  t('826016809496875624302542168956469295568405449340577352439773937778282182239446407683452788264466983897590179394', 275, 5, '256.08895234771126799397031978913159678751681193946418998512561682521062823220935286102680135972272781081133783537336798709992567678982746336534349952324378636549949739098547306400753170625231809452900545124327564869493854591064129390319200404932109032879657791130832870258128');
  t('-54177308493204840914008016264792763626952605979573224144335159167112.48090265652231', 75, 4, '-156.656025476461957919901279827881548769394846160431187360652561173070300476');
  t('-13740555338485.120393203', 151, 6, '-30.94452000011404214406530495529952695727807507918149627225480265909339331864560891419501564901277606816637742226388656890702707617225320704888487278509');
  t('0.559280001220135516585754729473973473342', 266, 0, '0.53359577428744099049509519460828967129542468151692400696904114219236314058689892598963206019765533790639989848541839909374199497909826033893129241646634736180068562810298449418624373224477197758844398005847460350002384752905141808660902174265955940698918991123973728');
  t('-45555555.555555555555573580964893774431030945436444', 191, 6, '-18.327590320886353639083850401302202774666781689203955477377548053854437470400139619726528106926587713684754942516608411574077518745827816214027784453089692608603214423178191326328196114917366');
  t('9175555525555515555555556555555555.555555555557555556585555555555555555', 262, 1, '78.89499818921561651740897163786349531769221814956696221652952675715675785766477028430289918510815080712595255422071786099327662266410991515407549653751695574156889763013062452418440523119866684161726894578509642988537487448657034917388650469450316939701544398666');
  t('-11941002968615', 34, 4, '-30.80414640164661078627119219878251');
  t('-36.50832282517', 210, 6, '-4.29087495193142843636822303373913099059600653765168895989865914449814687999895661588824769217731570020323471654000565326076121001652891589115116712381269451717588321048178509601201580255605776235706434824580498');
  t('341349647.50897231543', 310, 0, '20.34156504974983966983948093579526683333797763663904619520979114889073795744438491060173575081508536590183625119182661903089998742981979253956164486966972059465044550427351360426871288378755063442437183817918880582742417822360530180907821148535809913168764505229188721584703493432727746433464175744493770862309');
  t('4640639373213165458148700455715824137541893788869742', 159, 2, '119.659839075952562318552186501065521891555878167476927270734035996940749451656796786277770145039847332989633120236392472628301213531291660730470995919151451885');
  t('80442222222222222222222.4444444444444444444955', 187, 3, '53.43497332379345112991312845842059297720565595464985217189227449623327264189079043945997138210879477388127591863996723206429627133143187817101533547763383975987031671030411788959217175894');
  t('-15912928284981', 248, 1, '-31.091300175012549937987107793885363185510633149218026499310447781561162704383804511948970997677739432635337705540715076885035761853067783824372707499396180119981254416018978376360248272761507656096440365635616189178107012649735831751050711881797027');
  t('0.38641121275460307139', 113, 6, '0.37738908650391965113802640316717026896337388717082546918074499416991758871938818148562932386947928510313021335149');
  t('-9136', 299, 3, '-9.813125115450950542489605984951209828831404154858016397338182767089320461164917158653793532507597709388286698287148972251752194107691449557727143917334844563314099624616151122993105321185992063275291593649989410169012274888785338672166358076946669164846726822665394603348214835931699698123160785434');
  t('9732809738372989740894196437931285757440604501311448215582965903472074655943002394448231721358464072507989394307677295741475308967392823842', 16, 1, '320.7253926388946');
  t('-89.72637742915648', 278, 4, '-5.1899430204324376813141779102835591171153755276704720303295417901460358698252362816231164086477917324758308249007609101711601936565502357261982865388694789969850528746083971854450527070691192754363146972787166339659456306787196090899499610659699120852396732521450899909510080564');
  t('-0.004572387207550535454', 221, 6, '-0.0045723712754269387478232298904768324514943586141789109298423914700805981277461227348268469885464057951631279610792747730890370758866597976623661193656262583173652608166333187926413755696907686314377421802209508379615503941');
  t('0.95871480273797645053727498516444828785861879515452806977587873350228501393865768019767379368017279828416929613421286048438', 133, 6, '0.8518771945242413440547570358523415587421270280123939346094601954835811844069307550382981893386328983423022743136616787417480510459693');
  t('911111111111111111125925101.222222222289932532705', 128, 5, '62.769854268333166824394774221341203103179154778552883697644268439225115960746247447275002302514257339154806338495383472058914654');
  t('-5565075129689654565758874690523329428601844', 87, 6, '-99.118231571339711624309908103472538672972838194042518372882683678470819559348437944347');
  t('-0.410466589489881857290427810830880497969588075581955094955558342918', 63, 6, '-0.399735678511605605990292853900847750076706914338187113061369968');
  t('5069', 233, 3, '9.224046028761904388038801916832154920678187054878336539709834830544063950463710812854932875225421738011217254576421890078626182218805161488992368480082786221248314104154917944744401471321274029306921657179801031225977117119441535232');
  t('-29700000000000000000.00000000000000000000080000000000000000000003', 13, 0, '-45.53082590027');
  t('-994570089346387', 98, 1, '-35.226478869268855919642614005677752024489146958376003624345211425217028314196357831288606394420323');
  t('617431237392792974291854906206139373623628105500387724781028716165061154110509', 183, 0, '179.812596860965995932543530596999663057196964045986470846270577891588611860172298363604973109411265830193898800929690794918211214801963586928409318213098227566460223150903604405488249');
  t('53288474000000000000000.000020008', 241, 1, '53.02315419356702384308042233799402773468968457777384669579081215571840965180156633970604219753453090166998217177199739752593461001712223545113254614832865494681595464081605192314689888530342461818371387662783620780841658894625489388344965485');
  t('836392260145629184104422243202322.9285362681614589346702', 115, 6, '76.49979768412161158298891425010240322626181183586869565201474733160581114752572614841084058222487562971382956598362');
  t('-1', 223, 4, '-0.8813735870195430252326093249797923090281603282616354107532956086533771842220260878337068919102560428567398161921064921887620725119765919375272554627657904092215786803628971962403073574096255489778715632623678065067630328954');
  t('-97977477777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777.7777777774777973777777777775777777777777777777777777777707', 222, 3, '-260.864830136563143973223926615266616316884219499669651280404061999466962581962008648497296777105072541316262658671050715852199329018658590524447176038537656320981637593685557444837995597025935597587676115436825965032449484');
  t('-0.38774378851311354524477913536085292075860074495544498404199438125818261354667133107093766916109030928761456491164139264546050587074742942185664026794469982901137304', 170, 0, '-0.37863181215935222749417899603832717734185396075877258079165735806580805299355922530455701828293391212757735936976142074213023047998393707969043533223142562719821486701841');
  t('-0.123871294340837', 85, 5, '-0.1235566796967979062227037990370818622273585373924803478878689609330298341867992459834');
  t('-917631636265844444444444444444', 165, 5, '-69.6847407338059834229662664802773422741342990104684086476956348265326681103447327466096741841837158439002488731089459565123519362045837835014264693367559401810290184');
  t('-600000000000641060816880907750024458679211652370008341936164985711499571210185136948593732570', 141, 3, '-214.32273520524127167457972425294074484383737914960306368685179700068878717406762219179031126276037814293315562236857881378319381745436719593');
  t('-473777777777777777.77777777776777777777775777777777776777777777777777777777777777777777777777777777', 79, 0, '-41.39266196398009165506856064683473722948028628023091723608497818076419065442295');
  t('0.367584132061126286388737525893882434841466343715624388', 208, 0, '0.3597724814184861706049359708725760725399541010443335199241305688647390727566491192283162657887706662854178453519329469670281232835219283549341770601770547894561501575123887962030382362432488199052855830602293');
  t('6037100796962571258924699832689568751272221617262916067216004215794584675943137084916218636472165856463288661128782343215556711193857', 261, 1, '306.432303351980694848977983253649940218996349825631220729835761021975885994686714338212496662861062662706962569228153184405588439298476011315510867179785806286740170315018054235709751412251740663181584840738282640031487850690715669087386344102410670360911394334');
  t('-799072854855.6998357', 187, 3, '-28.09986514166356486446509141273978847322739731205645403313801060966475988766633725821108841756817474182560889651851430003588575565760374644257916785538499433541772710725564312019300729079');
  t('-83763803916032247976144502.792038057889555024890662781469686439988483781996387646322', 230, 3, '-60.383190392418416349986450539898524000648860951394888785789268070963781827371850877431131695188364444110872498724716306515182106086564038986536014772240975359635733706121983583289831506065994867777945876997920571192581029085586165');
  t('5654760937373023349587621058298731932947839344035237806162.994829032396065238078638368107483978955317019053', 174, 4, '133.672995315336775861848409548594398693660618503728578056397823870221974685339676150562925744537269140459055690761343327345294412774932950559506383057237389754641841452337626');
  t('778886888888888.8888888888888888888885', 176, 3, '34.982034131417270839083982170531515191578046476117198615810954355978427651000605997812920427730253739047197944486588007402954684028936655152369643966594980320171662079693375001');
  t('-4658903.6047136700653389065961437064167004088317128656385908953270520065146', 258, 3, '-16.0474378810211445811636218676694804072814928703286211454760269336406522054153601407650119428943661716748257870166445775098549642034388497122740118035920793589121981979571486810247442103686789429089496033407090397113805196829129369316621280769799642905537927');
  t('-5.889366707797816682979', 119, 0, '-2.4734267504615186139236835507536613478975287315713354043928387764860403844401404606722168525274827004502965925721991266');
  t('-177777777777747.777777777', 249, 2, '-33.5047026273799779905475461097965592430080600099860133763005437967958985111151092673048331156322190316039868143507705270230205575146857978793009699303451996264117366478435682743541635628327135751123512604902805226015850469479152515587628479429381486');
  t('-589150125', 68, 4, '-20.887338770853622157671242204248278168980063227907971594762911773195');
  t('0.80159795233483842439088085288', 63, 3, '0.733915560918445907972859752758676655770208110230760479346569608');
  t('6777777777777777777581271572263367953', 297, 0, '85.4998598151826817999968304008294630439321553750342015261864174192801715102016760127222611574594908073903614530214547049814777161759090811130844181421209944297178878223547731349260819395072423265724046638463225224887008559756058356905537071662032808955147303927590896573844095412143673341489193033');
  t('0.003272574243467178120416207385598776479187657917333909800981439006', 298, 4, '0.003272568402090928380904115734582429540835230923332922187857095806652485022535906475312315390036730215045979010944991322023409604669621200865456994673259210246635371222116622115839352400661939933430907121112171374951784773625160565450653907952763153728183795213597348218353677211240765388753206528706');
  t('-1020000.00000000006', 180, 0, '-14.5284603658206394775700487379229466303600400730481962084815458669167756227284239360693820206407145217284285692706167810930926779000562268601186873897838577258914285074192452041418');
  t('-8361740752.29766', 83, 6, '-23.540079646886417265659203048654750497134716787194692554953276029744532444497829082');
  t('9060069461052273792697377', 120, 1, '58.1590661992253517351950504904893311733922032761959431247726509829116112135114691041302210873291758353978006895161873015');
  t('-0.10034', 188, 5, '-0.10017238584324626469537318977467444532904094945904700806484562185808963016200306165428227805195203657720577223503160370238744463179264729619340626580259101545328650679975680053481983499459');
  t('959363.783043541639323072180147603753657', 86, 3, '14.46717279830797941955692793012557501799148538229744443631547327264748755583447284086');
  t('-0.00014646860007896', 75, 1, '-0.000146468599555260285150687195543516588439055126517399139386767315063352429473');
  */
});
