import test from 'ava';
import plur from '.';

test('main', t => {
	t.is(plur('unicorn', 0), 'unicorns');
	t.is(plur('unicorn', 1), 'unicorn');
	t.is(plur('unicorn', 2), 'unicorns');
	t.is(plur('unicorn', 'horse', 0), 'horse');
	t.is(plur('unicorn', 'horse', 1), 'unicorn');
	t.is(plur('unicorn', 'horse', 2), 'horse');
	t.is(plur('bus', 2), 'buses');
	t.is(plur('box', 2), 'boxes');
	t.is(plur('fizz', 2), 'fizzes');
	t.is(plur('batch', 2), 'batches');
	t.is(plur('bush', 2), 'bushes');
	t.is(plur('Bush', 2), 'Bushes');
	t.is(plur('guppy', 2), 'guppies');
	t.is(plur('UNICORN', 2), 'UNICORNS');
	t.is(plur('puppY', 2), 'puppIES');
	t.is(plur('man', 2), 'men');
	t.is(plur('woman', 2), 'women');
	t.is(plur('fish', 2), 'fish');
	t.is(plur('sheep', 2), 'sheep');
	t.is(plur('tooth', 2), 'teeth');
	t.is(plur('tomato', 2), 'tomatoes');
	t.is(plur('wife', 2), 'wives');
	t.is(plur('shelf', 2), 'shelves');
	t.is(plur('day', 2), 'days');
	t.is(plur('diy', 2), 'diys');
	t.is(plur('child', 2), 'children');
	t.is(plur('child', 1), 'child');
	t.is(plur('unicorn', -1), 'unicorn');
	t.is(plur('unicorn', -2), 'unicorns');
	t.is(plur('shelf', 1), 'shelf');
	t.is(plur('shelf', 2), 'shelves');
	t.is(plur('Shelf', 1), 'Shelf');
	t.is(plur('Shelf', 2), 'Shelves');
	t.is(plur('SHELF', 1), 'SHELF');
	t.is(plur('SHELF', 2), 'SHELVES');
});
