# V1ValidationRule

ValidationRule describes a validation rule written in the CEL expression language.
## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**field_path** | **str** | fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute &#x60;foo&#x60; under a map &#x60;testMap&#x60;, the fieldPath could be set to &#x60;.testMap.foo&#x60; If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. &#x60;.testList&#x60; It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use &#x60;[&#39;specialName&#39;]&#x60; to refer the field name. e.g. for attribute &#x60;foo.34$&#x60; appears in a list &#x60;testList&#x60;, the fieldPath could be set to &#x60;.testList[&#39;foo.34$&#39;]&#x60; | [optional] 
**message** | **str** | Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is \&quot;failed rule: {Rule}\&quot;. e.g. \&quot;must be a URL with the host matching spec.host\&quot; | [optional] 
**message_expression** | **str** | MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: \&quot;x must be less than max (\&quot;+string(self.max)+\&quot;)\&quot; | [optional] 
**optional_old_self** | **bool** | optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.  When enabled &#x60;oldSelf&#x60; will be a CEL optional whose value will be &#x60;None&#x60; if there is no old value, or when the object is initially created.  You may check for presence of oldSelf using &#x60;oldSelf.hasValue()&#x60; and unwrap it after checking using &#x60;oldSelf.value()&#x60;. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes  May not be set unless &#x60;oldSelf&#x60; is used in &#x60;rule&#x60;. | [optional] 
**reason** | **str** | reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: \&quot;FieldValueInvalid\&quot;, \&quot;FieldValueForbidden\&quot;, \&quot;FieldValueRequired\&quot;, \&quot;FieldValueDuplicate\&quot;. If not set, default to use \&quot;FieldValueInvalid\&quot;. All future added reasons must be accepted by kubernetes.clients when reading this value and unknown reasons should be treated as FieldValueInvalid. | [optional] 
**rule** | **str** | Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The &#x60;self&#x60; variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {\&quot;rule\&quot;: \&quot;self.status.actual &lt;&#x3D; self.spec.maxDesired\&quot;}  If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via &#x60;self.field&#x60; and field presence can be checked via &#x60;has(self.field)&#x60;. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via &#x60;self[mapKey]&#x60;, map containment can be checked via &#x60;mapKey in self&#x60; and all entries of the map are accessible via CEL macros and functions such as &#x60;self.all(...)&#x60;. If the Rule is scoped to an array, the elements of the array are accessible via &#x60;self[i]&#x60; and also by macros and functions. If the Rule is scoped to a scalar, &#x60;self&#x60; is bound to the scalar value. Examples: - Rule scoped to a map of objects: {\&quot;rule\&quot;: \&quot;self.components[&#39;Widget&#39;].priority &lt; 10\&quot;} - Rule scoped to a list of integers: {\&quot;rule\&quot;: \&quot;self.values.all(value, value &gt;&#x3D; 0 &amp;&amp; value &lt; 100)\&quot;} - Rule scoped to a string value: {\&quot;rule\&quot;: \&quot;self.startsWith(&#39;kube&#39;)\&quot;}  The &#x60;apiVersion&#x60;, &#x60;kind&#x60;, &#x60;metadata.name&#x60; and &#x60;metadata.generateName&#x60; are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.  Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an \&quot;unknown type\&quot;. An \&quot;unknown type\&quot; is recursively defined as:   - A schema with no type and x-kubernetes-preserve-unknown-fields set to true   - An array where the items schema is of an \&quot;unknown type\&quot;   - An object where the additionalProperties schema is of an \&quot;unknown type\&quot;  Only property names of the form &#x60;[a-zA-Z_.-/][a-zA-Z0-9_.-/]*&#x60; are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - &#39;__&#39; escapes to &#39;__underscores__&#39; - &#39;.&#39; escapes to &#39;__dot__&#39; - &#39;-&#39; escapes to &#39;__dash__&#39; - &#39;/&#39; escapes to &#39;__slash__&#39; - Property names that exactly match a CEL RESERVED keyword escape to &#39;__{keyword}__&#39;. The keywords are:    \&quot;true\&quot;, \&quot;false\&quot;, \&quot;null\&quot;, \&quot;in\&quot;, \&quot;as\&quot;, \&quot;break\&quot;, \&quot;const\&quot;, \&quot;continue\&quot;, \&quot;else\&quot;, \&quot;for\&quot;, \&quot;function\&quot;, \&quot;if\&quot;,    \&quot;import\&quot;, \&quot;let\&quot;, \&quot;loop\&quot;, \&quot;package\&quot;, \&quot;namespace\&quot;, \&quot;return\&quot;. Examples:   - Rule accessing a property named \&quot;namespace\&quot;: {\&quot;rule\&quot;: \&quot;self.__namespace__ &gt; 0\&quot;}   - Rule accessing a property named \&quot;x-prop\&quot;: {\&quot;rule\&quot;: \&quot;self.x__dash__prop &gt; 0\&quot;}   - Rule accessing a property named \&quot;redact__d\&quot;: {\&quot;rule\&quot;: \&quot;self.redact__underscores__d &gt; 0\&quot;}  Equality on arrays with x-kubernetes-list-type of &#39;set&#39; or &#39;map&#39; ignores element order, i.e. [1, 2] &#x3D;&#x3D; [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:   - &#39;set&#39;: &#x60;X + Y&#x60; performs a union where the array positions of all elements in &#x60;X&#x60; are preserved and     non-intersecting elements in &#x60;Y&#x60; are appended, retaining their partial order.   - &#39;map&#39;: &#x60;X + Y&#x60; performs a merge where the array positions of all keys in &#x60;X&#x60; are preserved but the values     are overwritten by values in &#x60;Y&#x60; when the key sets of &#x60;X&#x60; and &#x60;Y&#x60; intersect. Elements in &#x60;Y&#x60; with     non-intersecting keys are appended, retaining their partial order.  If &#x60;rule&#x60; makes use of the &#x60;oldSelf&#x60; variable it is implicitly a &#x60;transition rule&#x60;.  By default, the &#x60;oldSelf&#x60; variable is the same type as &#x60;self&#x60;. When &#x60;optionalOldSelf&#x60; is true, the &#x60;oldSelf&#x60; variable is a CEL optional  variable whose value() is the same type as &#x60;self&#x60;. See the documentation for the &#x60;optionalOldSelf&#x60; field for details.  Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting &#x60;optionalOldSelf&#x60; to true. | 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


