% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-conditions.R
\name{format_error}
\alias{format_error}
\alias{format_warning}
\alias{format_message}
\title{Format an error, warning or diagnostic message}
\usage{
format_error(message, .envir = parent.frame())

format_warning(message, .envir = parent.frame())

format_message(message, .envir = parent.frame())
}
\arguments{
\item{message}{It is formatted via a call to \code{\link[=cli_bullets]{cli_bullets()}}.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
You can then throw this message with \code{\link[=stop]{stop()}} or \code{rlang::abort()}.
}
\details{
The messages can use inline styling, pluralization and glue
substitutions.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{n <- "boo"
stop(format_error(c(
        "\{.var n\} must be a numeric vector",
  "x" = "You've supplied a \{.cls \{class(n)\}\} vector."
)))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Error: `n` must be a numeric vector                                             
#> <span style="color: #DC322F;">✖</span> You've supplied a <span style="color: #268BD2;">&lt;character&gt;</span> vector.                                         
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{len <- 26
idx <- 100
stop(format_error(c(
        "Must index an existing element:",
  "i" = "There \{?is/are\} \{len\} element\{?s\}.",
  "x" = "You've tried to subset element \{idx\}."
)))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Error: Must index an existing element:                                          
#> <span style="color: #2AA198;">ℹ</span> There are 26 elements.                                                        
#> <span style="color: #DC322F;">✖</span> You've tried to subset element 100.                                           
</pre></div>
}}
}
\seealso{
These functions support \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
