% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superseded-simplify.R
\name{as_vector}
\alias{as_vector}
\alias{simplify}
\alias{simplify_all}
\title{Coerce a list to a vector}
\usage{
as_vector(.x, .type = NULL)

simplify(.x, .type = NULL)

simplify_all(.x, .type = NULL)
}
\arguments{
\item{.x}{A list of vectors}

\item{.type}{Can be a vector mold specifying both the type and the
length of the vectors to be concatenated, such as \code{numeric(1)}
or \code{integer(4)}. Alternatively, it can be a string describing
the type, one of: "logical", "integer", "double", "complex",
"character" or "raw".}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions were superseded in purrr 1.0.0 in favour of
\code{list_simplify()} which has more consistent semantics based on vctrs
principles:
\itemize{
\item \code{as_vector(x)} is now \code{list_simplify(x)}
\item \code{simplify(x)} is now \code{list_simplify(x, strict = FALSE)}
\item \code{simplify_all(x)} is \code{map(x, list_simplify, strict = FALSE)}
}

Superseded functions will not go away, but will only receive critical
bug fixes.
}
\examples{
# was
as.list(letters) |> as_vector("character")
# now
as.list(letters) |> list_simplify(ptype = character())

# was:
list(1:2, 3:4, 5:6) |> as_vector(integer(2))
# now:
list(1:2, 3:4, 5:6) |> list_c(ptype = integer())
}
\keyword{internal}
