### New features

* [#8796](https://github.com/rubocop/rubocop/pull/8796): Add new `Lint/HashCompareByIdentity` cop. ([@fatkodima][])
* [#8833](https://github.com/rubocop/rubocop/pull/8833): Add new `Style/ClassEqualityComparison` cop. ([@fatkodima][])
* [#8668](https://github.com/rubocop/rubocop/pull/8668): Add new `Lint/RedundantSafeNavigation` cop. ([@fatkodima][])
* [#8842](https://github.com/rubocop/rubocop/issues/8842): Add notification about cache being used to debug mode. ([@hatkyinc2][])
* [#8822](https://github.com/rubocop/rubocop/pull/8822): Make `Style/RedundantBegin` aware of `begin` without `rescue` or `ensure`. ([@koic][])

### Bug fixes

* [#8810](https://github.com/rubocop/rubocop/pull/8810): Fix multiple offense detection for `Style/RaiseArgs`. ([@pbernays][])
* [#8151](https://github.com/rubocop/rubocop/issues/8151): Fix a false positive for `Lint/BooleanSymbol` when used within `%i[...]`. ([@fatkodima][])
* [#8809](https://github.com/rubocop/rubocop/pull/8809): Fix multiple offense detection for `Style/For`. ([@pbernays][])
* [#8801](https://github.com/rubocop/rubocop/issues/8801): Fix `Layout/SpaceAroundEqualsInParameterDefault` only registered once in a line. ([@rdunlop][])
* [#8514](https://github.com/rubocop/rubocop/issues/8514): Correct multiple `Style/MethodDefParentheses` per file. ([@rdunlop][])
* [#8825](https://github.com/rubocop/rubocop/issues/8825): Fix crash in `Style/ExplicitBlockArgument` when code is called outside of a method. ([@ghiculescu][])
* [#8718](https://github.com/rubocop/rubocop/issues/8718): Fix undefined methods of pseudo location. ([@ybiquitous][])
* [#8354](https://github.com/rubocop/rubocop/issues/8354): Detect regexp named captures in `Style/CaseLikeIf` cop. ([@dsavochkin][])
* [#8821](https://github.com/rubocop/rubocop/issues/8821): Fix an incorrect autocorrect for `Style/NestedTernaryOperator` when using a nested ternary operator expression with no parentheses on the outside. ([@koic][])
* [#8834](https://github.com/rubocop/rubocop/issues/8834): Fix a false positive for `Style/ParenthesesAsGroupedExpression` when method argument parentheses are omitted and hash argument key is enclosed in parentheses. ([@koic][])
* [#8830](https://github.com/rubocop/rubocop/issues/8830): Fix bad autocorrect of `Style/StringConcatenation` when string includes double quotes. ([@tleish][])
* [#8807](https://github.com/rubocop/rubocop/pull/8807): Fix a false positive for `Style/RedundantCondition` when using assignment by hash key access. ([@koic][])
* [#8848](https://github.com/rubocop/rubocop/issues/8848): Fix a false positive for `Style/CombinableLoops` when using the same method with different arguments. ([@dvandersluis][])
* [#8843](https://github.com/rubocop/rubocop/issues/8843): Fix an incorrect autocorrect for `Lint/AmbiguousRegexpLiteral` when sending method to regexp literal receiver. ([@koic][])
* [#8842](https://github.com/rubocop/rubocop/issues/8842): Save actual status to cache, except corrected. ([@hatkyinc2][])
* [#8835](https://github.com/rubocop/rubocop/issues/8835): Fix an incorrect autocorrect for `Style/RedundantInterpolation` when using string interpolation for non-operator methods. ([@koic][])
* [#7495](https://github.com/rubocop/rubocop/issues/7495): Example for `Lint/AmbiguousBlockAssociation` cop. ([@AllanSiqueira][])
* [#8855](https://github.com/rubocop/rubocop/issues/8855): Fix an error for `Layout/EmptyLinesAroundAccessModifier` and `Style/AccessModifierDeclarations` when using only access modifier. ([@koic][])

### Changes

* [#8803](https://github.com/rubocop/rubocop/pull/8803): **(Breaking)** `RegexpNode#parsed_tree` now processes regexps including interpolation (by blanking the interpolation before parsing, rather than skipping). ([@owst][])
* [#8625](https://github.com/rubocop/rubocop/pull/8625): Improve `Style/RedundantRegexpCharacterClass` and `Style/RedundantRegexpEscape` by using `regexp_parser` gem. ([@owst][])
* [#8646](https://github.com/rubocop/rubocop/issues/8646): Faster find of all files in `TargetFinder` class which improves initial startup speed. ([@tleish][])
* [#8102](https://github.com/rubocop/rubocop/issues/8102): Consider class length instead of block length for `Struct.new`. ([@tejasbubane][])
* [#7408](https://github.com/rubocop/rubocop/issues/7408): Make `Gemspec/RequiredRubyVersion` cop aware of `Gem::Requirement`. ([@tejasbubane][])

[@fatkodima]: https://github.com/fatkodima
[@hatkyinc2]: https://github.com/hatkyinc2
[@koic]: https://github.com/koic
[@pbernays]: https://github.com/pbernays
[@rdunlop]: https://github.com/rdunlop
[@ghiculescu]: https://github.com/ghiculescu
[@ybiquitous]: https://github.com/ybiquitous
[@dsavochkin]: https://github.com/dsavochkin
[@tleish]: https://github.com/tleish
[@dvandersluis]: https://github.com/dvandersluis
[@AllanSiqueira]: https://github.com/AllanSiqueira
[@owst]: https://github.com/owst
[@tejasbubane]: https://github.com/tejasbubane
