// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gobject_sys as gobject;
use gstreamer_base_sys as gst_base;
use gstreamer_sys as gst;
use gstreamer_video_sys as gst_video;

mod manual;

pub use manual::*;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};
#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstGLBaseMemoryError = c_int;
pub const GST_GL_BASE_MEMORY_ERROR_FAILED: GstGLBaseMemoryError = 0;
pub const GST_GL_BASE_MEMORY_ERROR_OLD_LIBS: GstGLBaseMemoryError = 1;
pub const GST_GL_BASE_MEMORY_ERROR_RESOURCE_UNAVAILABLE: GstGLBaseMemoryError = 2;

pub type GstGLConfigCaveat = c_int;
pub const GST_GL_CONFIG_CAVEAT_NONE: GstGLConfigCaveat = 0;
pub const GST_GL_CONFIG_CAVEAT_SLOW: GstGLConfigCaveat = 1;
pub const GST_GL_CONFIG_CAVEAT_NON_CONFORMANT: GstGLConfigCaveat = 2;

pub type GstGLContextError = c_int;
pub const GST_GL_CONTEXT_ERROR_FAILED: GstGLContextError = 0;
pub const GST_GL_CONTEXT_ERROR_WRONG_CONFIG: GstGLContextError = 1;
pub const GST_GL_CONTEXT_ERROR_WRONG_API: GstGLContextError = 2;
pub const GST_GL_CONTEXT_ERROR_OLD_LIBS: GstGLContextError = 3;
pub const GST_GL_CONTEXT_ERROR_CREATE_CONTEXT: GstGLContextError = 4;
pub const GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE: GstGLContextError = 5;

pub type GstGLFormat = c_int;
pub const GST_GL_LUMINANCE: GstGLFormat = 6409;
pub const GST_GL_ALPHA: GstGLFormat = 6406;
pub const GST_GL_LUMINANCE_ALPHA: GstGLFormat = 6410;
pub const GST_GL_RED: GstGLFormat = 6403;
pub const GST_GL_R8: GstGLFormat = 33321;
pub const GST_GL_RG: GstGLFormat = 33319;
pub const GST_GL_RG8: GstGLFormat = 33323;
pub const GST_GL_RGB: GstGLFormat = 6407;
pub const GST_GL_RGB8: GstGLFormat = 32849;
pub const GST_GL_RGB565: GstGLFormat = 36194;
pub const GST_GL_RGB16: GstGLFormat = 32852;
pub const GST_GL_RGBA: GstGLFormat = 6408;
pub const GST_GL_RGBA8: GstGLFormat = 32856;
pub const GST_GL_RGBA16: GstGLFormat = 32859;
pub const GST_GL_DEPTH_COMPONENT16: GstGLFormat = 33189;
pub const GST_GL_DEPTH24_STENCIL8: GstGLFormat = 35056;
pub const GST_GL_RGB10_A2: GstGLFormat = 32857;
pub const GST_GL_R16: GstGLFormat = 33322;
pub const GST_GL_RG16: GstGLFormat = 33324;

pub type GstGLQueryType = c_int;
pub const GST_GL_QUERY_NONE: GstGLQueryType = 0;
pub const GST_GL_QUERY_TIME_ELAPSED: GstGLQueryType = 1;
pub const GST_GL_QUERY_TIMESTAMP: GstGLQueryType = 2;

pub type GstGLSLError = c_int;
pub const GST_GLSL_ERROR_COMPILE: GstGLSLError = 0;
pub const GST_GLSL_ERROR_LINK: GstGLSLError = 1;
pub const GST_GLSL_ERROR_PROGRAM: GstGLSLError = 2;

pub type GstGLSLVersion = c_int;
pub const GST_GLSL_VERSION_NONE: GstGLSLVersion = 0;
pub const GST_GLSL_VERSION_100: GstGLSLVersion = 100;
pub const GST_GLSL_VERSION_110: GstGLSLVersion = 110;
pub const GST_GLSL_VERSION_120: GstGLSLVersion = 120;
pub const GST_GLSL_VERSION_130: GstGLSLVersion = 130;
pub const GST_GLSL_VERSION_140: GstGLSLVersion = 140;
pub const GST_GLSL_VERSION_150: GstGLSLVersion = 150;
pub const GST_GLSL_VERSION_300: GstGLSLVersion = 300;
pub const GST_GLSL_VERSION_310: GstGLSLVersion = 310;
pub const GST_GLSL_VERSION_320: GstGLSLVersion = 320;
pub const GST_GLSL_VERSION_330: GstGLSLVersion = 330;
pub const GST_GLSL_VERSION_400: GstGLSLVersion = 400;
pub const GST_GLSL_VERSION_410: GstGLSLVersion = 410;
pub const GST_GLSL_VERSION_420: GstGLSLVersion = 420;
pub const GST_GLSL_VERSION_430: GstGLSLVersion = 430;
pub const GST_GLSL_VERSION_440: GstGLSLVersion = 440;
pub const GST_GLSL_VERSION_450: GstGLSLVersion = 450;

pub type GstGLStereoDownmix = c_int;
pub const GST_GL_STEREO_DOWNMIX_ANAGLYPH_GREEN_MAGENTA_DUBOIS: GstGLStereoDownmix = 0;
pub const GST_GL_STEREO_DOWNMIX_ANAGLYPH_RED_CYAN_DUBOIS: GstGLStereoDownmix = 1;
pub const GST_GL_STEREO_DOWNMIX_ANAGLYPH_AMBER_BLUE_DUBOIS: GstGLStereoDownmix = 2;

pub type GstGLTextureTarget = c_int;
pub const GST_GL_TEXTURE_TARGET_NONE: GstGLTextureTarget = 0;
pub const GST_GL_TEXTURE_TARGET_2D: GstGLTextureTarget = 1;
pub const GST_GL_TEXTURE_TARGET_RECTANGLE: GstGLTextureTarget = 2;
pub const GST_GL_TEXTURE_TARGET_EXTERNAL_OES: GstGLTextureTarget = 3;

pub type GstGLUploadReturn = c_int;
pub const GST_GL_UPLOAD_DONE: GstGLUploadReturn = 1;
pub const GST_GL_UPLOAD_ERROR: GstGLUploadReturn = -1;
pub const GST_GL_UPLOAD_UNSUPPORTED: GstGLUploadReturn = -2;
pub const GST_GL_UPLOAD_RECONFIGURE: GstGLUploadReturn = -3;
pub const GST_GL_UPLOAD_UNSHARED_GL_CONTEXT: GstGLUploadReturn = -100;

pub type GstGLWindowError = c_int;
pub const GST_GL_WINDOW_ERROR_FAILED: GstGLWindowError = 0;
pub const GST_GL_WINDOW_ERROR_OLD_LIBS: GstGLWindowError = 1;
pub const GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE: GstGLWindowError = 2;

// Constants
pub const GST_BUFFER_POOL_OPTION_GL_SYNC_META: &[u8] = b"GstBufferPoolOptionGLSyncMeta\0";
pub const GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_2D: &[u8] =
    b"GstBufferPoolOptionGLTextureTarget2D\0";
pub const GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_EXTERNAL_OES: &[u8] =
    b"GstBufferPoolOptionGLTextureTargetExternalOES\0";
pub const GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_RECTANGLE: &[u8] =
    b"GstBufferPoolOptionGLTextureTargetRectangle\0";
pub const GST_CAPS_FEATURE_MEMORY_GL_BUFFER: &[u8] = b"memory:GLBuffer\0";
pub const GST_CAPS_FEATURE_MEMORY_GL_MEMORY: &[u8] = b"memory:GLMemory\0";
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_ALLOC: c_int = 1;
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_BUFFER: c_int = 16;
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_USER: c_int = 65536;
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_VIDEO: c_int = 8;
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_WRAP_GPU_HANDLE: c_int = 4;
pub const GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_WRAP_SYSMEM: c_int = 2;
pub const GST_GL_API_GLES1_NAME: &[u8] = b"gles1\0";
pub const GST_GL_API_GLES2_NAME: &[u8] = b"gles2\0";
pub const GST_GL_API_OPENGL3_NAME: &[u8] = b"opengl3\0";
pub const GST_GL_API_OPENGL_NAME: &[u8] = b"opengl\0";
pub const GST_GL_BASE_MEMORY_ALLOCATOR_NAME: &[u8] = b"GLBaseMemory\0";
pub const GST_GL_BUFFER_ALLOCATOR_NAME: &[u8] = b"GLBuffer\0";
pub const GST_GL_CONFIG_STRUCTURE_NAME: &[u8] = b"gst-gl-context-config\0";
pub const GST_GL_CONTEXT_TYPE_CGL: &[u8] = b"gst.gl.context.CGL\0";
pub const GST_GL_CONTEXT_TYPE_EAGL: &[u8] = b"gst.gl.context.EAGL\0";
pub const GST_GL_CONTEXT_TYPE_EGL: &[u8] = b"gst.gl.context.EGL\0";
pub const GST_GL_CONTEXT_TYPE_GLX: &[u8] = b"gst.gl.context.GLX\0";
pub const GST_GL_CONTEXT_TYPE_WGL: &[u8] = b"gst.gl.context.WGL\0";
pub const GST_GL_DISPLAY_CONTEXT_TYPE: &[u8] = b"gst.gl.GLDisplay\0";
pub const GST_GL_MEMORY_ALLOCATOR_NAME: &[u8] = b"GLMemory\0";
pub const GST_GL_MEMORY_PBO_ALLOCATOR_NAME: &[u8] = b"GLMemoryPBO\0";
pub const GST_GL_RENDERBUFFER_ALLOCATOR_NAME: &[u8] = b"GLRenderbuffer\0";
pub const GST_GL_TEXTURE_TARGET_2D_STR: &[u8] = b"2D\0";
pub const GST_GL_TEXTURE_TARGET_EXTERNAL_OES_STR: &[u8] = b"external-oes\0";
pub const GST_GL_TEXTURE_TARGET_RECTANGLE_STR: &[u8] = b"rectangle\0";
pub const GST_MAP_GL: c_int = 131072;

// Flags
pub type GstGLAPI = c_uint;
pub const GST_GL_API_NONE: GstGLAPI = 0;
pub const GST_GL_API_OPENGL: GstGLAPI = 1;
pub const GST_GL_API_OPENGL3: GstGLAPI = 2;
pub const GST_GL_API_GLES1: GstGLAPI = 32768;
pub const GST_GL_API_GLES2: GstGLAPI = 65536;
pub const GST_GL_API_ANY: GstGLAPI = 4294967295;

pub type GstGLBaseMemoryTransfer = c_uint;
pub const GST_GL_BASE_MEMORY_TRANSFER_NEED_DOWNLOAD: GstGLBaseMemoryTransfer = 1048576;
pub const GST_GL_BASE_MEMORY_TRANSFER_NEED_UPLOAD: GstGLBaseMemoryTransfer = 2097152;

pub type GstGLConfigSurfaceType = c_uint;
pub const GST_GL_CONFIG_SURFACE_TYPE_NONE: GstGLConfigSurfaceType = 0;
pub const GST_GL_CONFIG_SURFACE_TYPE_WINDOW: GstGLConfigSurfaceType = 1;
pub const GST_GL_CONFIG_SURFACE_TYPE_PBUFFER: GstGLConfigSurfaceType = 2;
pub const GST_GL_CONFIG_SURFACE_TYPE_PIXMAP: GstGLConfigSurfaceType = 4;

pub type GstGLDisplayType = c_uint;
pub const GST_GL_DISPLAY_TYPE_NONE: GstGLDisplayType = 0;
pub const GST_GL_DISPLAY_TYPE_X11: GstGLDisplayType = 1;
pub const GST_GL_DISPLAY_TYPE_WAYLAND: GstGLDisplayType = 2;
pub const GST_GL_DISPLAY_TYPE_COCOA: GstGLDisplayType = 4;
pub const GST_GL_DISPLAY_TYPE_WIN32: GstGLDisplayType = 8;
pub const GST_GL_DISPLAY_TYPE_DISPMANX: GstGLDisplayType = 16;
pub const GST_GL_DISPLAY_TYPE_EGL: GstGLDisplayType = 32;
pub const GST_GL_DISPLAY_TYPE_VIV_FB: GstGLDisplayType = 64;
pub const GST_GL_DISPLAY_TYPE_GBM: GstGLDisplayType = 128;
#[cfg(feature = "v1_18")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
pub const GST_GL_DISPLAY_TYPE_EGL_DEVICE: GstGLDisplayType = 256;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_GL_DISPLAY_TYPE_EAGL: GstGLDisplayType = 512;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_GL_DISPLAY_TYPE_WINRT: GstGLDisplayType = 1024;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_GL_DISPLAY_TYPE_ANDROID: GstGLDisplayType = 2048;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_GL_DISPLAY_TYPE_EGL_SURFACELESS: GstGLDisplayType = 4096;
pub const GST_GL_DISPLAY_TYPE_ANY: GstGLDisplayType = 4294967295;

pub type GstGLPlatform = c_uint;
pub const GST_GL_PLATFORM_NONE: GstGLPlatform = 0;
pub const GST_GL_PLATFORM_EGL: GstGLPlatform = 1;
pub const GST_GL_PLATFORM_GLX: GstGLPlatform = 2;
pub const GST_GL_PLATFORM_WGL: GstGLPlatform = 4;
pub const GST_GL_PLATFORM_CGL: GstGLPlatform = 8;
pub const GST_GL_PLATFORM_EAGL: GstGLPlatform = 16;
pub const GST_GL_PLATFORM_ANY: GstGLPlatform = 4294967295;

pub type GstGLSLProfile = c_uint;
pub const GST_GLSL_PROFILE_NONE: GstGLSLProfile = 0;
pub const GST_GLSL_PROFILE_ES: GstGLSLProfile = 1;
pub const GST_GLSL_PROFILE_CORE: GstGLSLProfile = 2;
pub const GST_GLSL_PROFILE_COMPATIBILITY: GstGLSLProfile = 4;
pub const GST_GLSL_PROFILE_ANY: GstGLSLProfile = 4294967295;

// Callbacks
pub type GstGLAllocationParamsCopyFunc =
    Option<unsafe extern "C" fn(*mut GstGLAllocationParams, *mut GstGLAllocationParams)>;
pub type GstGLAllocationParamsFreeFunc = Option<unsafe extern "C" fn(gpointer)>;
pub type GstGLAsyncDebugLogGetMessage = Option<unsafe extern "C" fn(gpointer) -> *mut c_char>;
pub type GstGLBaseMemoryAllocatorAllocFunction = Option<
    unsafe extern "C" fn(
        *mut GstGLBaseMemoryAllocator,
        *mut GstGLAllocationParams,
    ) -> *mut GstGLBaseMemory,
>;
pub type GstGLBaseMemoryAllocatorCopyFunction =
    Option<unsafe extern "C" fn(*mut GstGLBaseMemory, ssize_t, ssize_t) -> *mut GstGLBaseMemory>;
pub type GstGLBaseMemoryAllocatorCreateFunction =
    Option<unsafe extern "C" fn(*mut GstGLBaseMemory, *mut *mut glib::GError) -> gboolean>;
pub type GstGLBaseMemoryAllocatorDestroyFunction =
    Option<unsafe extern "C" fn(*mut GstGLBaseMemory)>;
pub type GstGLBaseMemoryAllocatorMapFunction =
    Option<unsafe extern "C" fn(*mut GstGLBaseMemory, *mut gst::GstMapInfo, size_t) -> gpointer>;
pub type GstGLBaseMemoryAllocatorUnmapFunction =
    Option<unsafe extern "C" fn(*mut GstGLBaseMemory, *mut gst::GstMapInfo)>;
pub type GstGLContextThreadFunc = Option<unsafe extern "C" fn(*mut GstGLContext, gpointer)>;
pub type GstGLFilterRenderFunc =
    Option<unsafe extern "C" fn(*mut GstGLFilter, *mut GstGLMemory, gpointer) -> gboolean>;
pub type GstGLFramebufferFunc = Option<unsafe extern "C" fn(gpointer) -> gboolean>;
pub type GstGLWindowCB = Option<unsafe extern "C" fn(gpointer)>;
pub type GstGLWindowResizeCB = Option<unsafe extern "C" fn(gpointer, c_uint, c_uint)>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLAllocationParams {
    pub struct_size: size_t,
    pub copy: GstGLAllocationParamsCopyFunc,
    pub free: GstGLAllocationParamsFreeFunc,
    pub alloc_flags: c_uint,
    pub alloc_size: size_t,
    pub alloc_params: *mut gst::GstAllocationParams,
    pub context: *mut GstGLContext,
    pub notify: glib::GDestroyNotify,
    pub user_data: gpointer,
    pub wrapped_data: gpointer,
    pub gl_handle: gpointer,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLAllocationParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLAllocationParams @ {self:p}"))
            .field("struct_size", &self.struct_size)
            .field("copy", &self.copy)
            .field("free", &self.free)
            .field("alloc_flags", &self.alloc_flags)
            .field("alloc_size", &self.alloc_size)
            .field("alloc_params", &self.alloc_params)
            .field("context", &self.context)
            .field("notify", &self.notify)
            .field("user_data", &self.user_data)
            .field("wrapped_data", &self.wrapped_data)
            .field("gl_handle", &self.gl_handle)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLAsyncDebug {
    pub state_flags: c_uint,
    pub cat: *mut gst::GstDebugCategory,
    pub level: gst::GstDebugLevel,
    pub file: *const c_char,
    pub function: *const c_char,
    pub line: c_int,
    pub object: *mut gobject::GObject,
    pub debug_msg: *mut c_char,
    pub callback: GstGLAsyncDebugLogGetMessage,
    pub user_data: gpointer,
    pub notify: glib::GDestroyNotify,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLAsyncDebug {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLAsyncDebug @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseFilterClass {
    pub parent_class: gst_base::GstBaseTransformClass,
    pub supported_gl_api: GstGLAPI,
    pub gl_start: Option<unsafe extern "C" fn(*mut GstGLBaseFilter) -> gboolean>,
    pub gl_stop: Option<unsafe extern "C" fn(*mut GstGLBaseFilter)>,
    pub gl_set_caps: Option<
        unsafe extern "C" fn(
            *mut GstGLBaseFilter,
            *mut gst::GstCaps,
            *mut gst::GstCaps,
        ) -> gboolean,
    >,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseFilterClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseFilterClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("supported_gl_api", &self.supported_gl_api)
            .field("gl_start", &self.gl_start)
            .field("gl_stop", &self.gl_stop)
            .field("gl_set_caps", &self.gl_set_caps)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLBaseFilterPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLBaseFilterPrivate = _GstGLBaseFilterPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMemory {
    pub mem: gst::GstMemory,
    pub context: *mut GstGLContext,
    pub lock: glib::GMutex,
    pub map_flags: gst::GstMapFlags,
    pub map_count: c_int,
    pub gl_map_count: c_int,
    pub data: gpointer,
    pub query: *mut GstGLQuery,
    pub alloc_size: size_t,
    pub alloc_data: gpointer,
    pub notify: glib::GDestroyNotify,
    pub user_data: gpointer,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMemory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMemory @ {self:p}"))
            .field("mem", &self.mem)
            .field("context", &self.context)
            .field("lock", &self.lock)
            .field("map_flags", &self.map_flags)
            .field("map_count", &self.map_count)
            .field("gl_map_count", &self.gl_map_count)
            .field("data", &self.data)
            .field("query", &self.query)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMemoryAllocatorClass {
    pub parent_class: gst::GstAllocatorClass,
    pub alloc: GstGLBaseMemoryAllocatorAllocFunction,
    pub create: GstGLBaseMemoryAllocatorCreateFunction,
    pub map: GstGLBaseMemoryAllocatorMapFunction,
    pub unmap: GstGLBaseMemoryAllocatorUnmapFunction,
    pub copy: GstGLBaseMemoryAllocatorCopyFunction,
    pub destroy: GstGLBaseMemoryAllocatorDestroyFunction,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMemoryAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMemoryAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("alloc", &self.alloc)
            .field("create", &self.create)
            .field("map", &self.map)
            .field("unmap", &self.unmap)
            .field("copy", &self.copy)
            .field("destroy", &self.destroy)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMixerClass {
    pub parent_class: gst_video::GstVideoAggregatorClass,
    pub supported_gl_api: GstGLAPI,
    pub gl_start: Option<unsafe extern "C" fn(*mut GstGLBaseMixer) -> gboolean>,
    pub gl_stop: Option<unsafe extern "C" fn(*mut GstGLBaseMixer)>,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMixerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMixerClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("supported_gl_api", &self.supported_gl_api)
            .field("gl_start", &self.gl_start)
            .field("gl_stop", &self.gl_stop)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMixerPadClass {
    pub parent_class: gst_video::GstVideoAggregatorPadClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMixerPadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMixerPadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLBaseMixerPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLBaseMixerPrivate = _GstGLBaseMixerPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseSrcClass {
    pub parent_class: gst_base::GstPushSrcClass,
    pub supported_gl_api: GstGLAPI,
    pub gl_start: Option<unsafe extern "C" fn(*mut GstGLBaseSrc) -> gboolean>,
    pub gl_stop: Option<unsafe extern "C" fn(*mut GstGLBaseSrc)>,
    pub fill_gl_memory:
        Option<unsafe extern "C" fn(*mut GstGLBaseSrc, *mut GstGLMemory) -> gboolean>,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseSrcClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseSrcClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("supported_gl_api", &self.supported_gl_api)
            .field("gl_start", &self.gl_start)
            .field("gl_stop", &self.gl_stop)
            .field("fill_gl_memory", &self.fill_gl_memory)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLBaseSrcPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLBaseSrcPrivate = _GstGLBaseSrcPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBuffer {
    pub mem: GstGLBaseMemory,
    pub id: c_uint,
    pub target: c_uint,
    pub usage_hints: c_uint,
}

impl ::std::fmt::Debug for GstGLBuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBuffer @ {self:p}"))
            .field("mem", &self.mem)
            .field("id", &self.id)
            .field("target", &self.target)
            .field("usage_hints", &self.usage_hints)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBufferAllocationParams {
    pub parent: GstGLAllocationParams,
    pub gl_target: c_uint,
    pub gl_usage: c_uint,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBufferAllocationParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBufferAllocationParams @ {self:p}"))
            .field("parent", &self.parent)
            .field("gl_target", &self.gl_target)
            .field("gl_usage", &self.gl_usage)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBufferAllocatorClass {
    pub parent_class: GstGLBaseMemoryAllocatorClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBufferAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBufferAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBufferPoolClass {
    pub parent_class: gst::GstBufferPoolClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBufferPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBufferPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLBufferPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLBufferPoolPrivate = _GstGLBufferPoolPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLColorConvertClass {
    pub object_class: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLColorConvertClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLColorConvertClass @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLColorConvertPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLColorConvertPrivate = _GstGLColorConvertPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLContextClass {
    pub parent_class: gst::GstObjectClass,
    pub get_current_context: Option<unsafe extern "C" fn() -> uintptr_t>,
    pub get_gl_context: Option<unsafe extern "C" fn(*mut GstGLContext) -> uintptr_t>,
    pub get_gl_api: Option<unsafe extern "C" fn(*mut GstGLContext) -> GstGLAPI>,
    pub get_gl_platform: Option<unsafe extern "C" fn(*mut GstGLContext) -> GstGLPlatform>,
    pub get_proc_address: Option<unsafe extern "C" fn(GstGLAPI, *const c_char) -> gpointer>,
    pub activate: Option<unsafe extern "C" fn(*mut GstGLContext, gboolean) -> gboolean>,
    pub choose_format:
        Option<unsafe extern "C" fn(*mut GstGLContext, *mut *mut glib::GError) -> gboolean>,
    pub create_context: Option<
        unsafe extern "C" fn(
            *mut GstGLContext,
            GstGLAPI,
            *mut GstGLContext,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub destroy_context: Option<unsafe extern "C" fn(*mut GstGLContext)>,
    pub swap_buffers: Option<unsafe extern "C" fn(*mut GstGLContext)>,
    pub check_feature: Option<unsafe extern "C" fn(*mut GstGLContext, *const c_char) -> gboolean>,
    pub get_gl_platform_version:
        Option<unsafe extern "C" fn(*mut GstGLContext, *mut c_int, *mut c_int)>,
    pub get_config: Option<unsafe extern "C" fn(*mut GstGLContext) -> *mut gst::GstStructure>,
    pub request_config:
        Option<unsafe extern "C" fn(*mut GstGLContext, *mut gst::GstStructure) -> gboolean>,
    pub _reserved: [gpointer; 2],
}

impl ::std::fmt::Debug for GstGLContextClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLContextClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_current_context", &self.get_current_context)
            .field("get_gl_context", &self.get_gl_context)
            .field("get_gl_api", &self.get_gl_api)
            .field("get_gl_platform", &self.get_gl_platform)
            .field("get_proc_address", &self.get_proc_address)
            .field("activate", &self.activate)
            .field("choose_format", &self.choose_format)
            .field("create_context", &self.create_context)
            .field("destroy_context", &self.destroy_context)
            .field("swap_buffers", &self.swap_buffers)
            .field("check_feature", &self.check_feature)
            .field("get_gl_platform_version", &self.get_gl_platform_version)
            .field("get_config", &self.get_config)
            .field("request_config", &self.request_config)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLContextPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLContextPrivate = _GstGLContextPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLDisplayClass {
    pub object_class: gst::GstObjectClass,
    pub get_handle: Option<unsafe extern "C" fn(*mut GstGLDisplay) -> uintptr_t>,
    pub create_window: Option<unsafe extern "C" fn(*mut GstGLDisplay) -> *mut GstGLWindow>,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLDisplayClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLDisplayClass @ {self:p}"))
            .field("object_class", &self.object_class)
            .field("get_handle", &self.get_handle)
            .field("create_window", &self.create_window)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLDisplayPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLDisplayPrivate = _GstGLDisplayPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLFilterClass {
    pub parent_class: GstGLBaseFilterClass,
    pub set_caps: Option<
        unsafe extern "C" fn(*mut GstGLFilter, *mut gst::GstCaps, *mut gst::GstCaps) -> gboolean,
    >,
    pub filter: Option<
        unsafe extern "C" fn(
            *mut GstGLFilter,
            *mut gst::GstBuffer,
            *mut gst::GstBuffer,
        ) -> gboolean,
    >,
    pub filter_texture: Option<
        unsafe extern "C" fn(*mut GstGLFilter, *mut GstGLMemory, *mut GstGLMemory) -> gboolean,
    >,
    pub init_fbo: Option<unsafe extern "C" fn(*mut GstGLFilter) -> gboolean>,
    pub transform_internal_caps: Option<
        unsafe extern "C" fn(
            *mut GstGLFilter,
            gst::GstPadDirection,
            *mut gst::GstCaps,
            *mut gst::GstCaps,
        ) -> *mut gst::GstCaps,
    >,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLFilterClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLFilterClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("set_caps", &self.set_caps)
            .field("filter", &self.filter)
            .field("filter_texture", &self.filter_texture)
            .field("init_fbo", &self.init_fbo)
            .field("transform_internal_caps", &self.transform_internal_caps)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLFramebufferClass {
    pub object_class: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLFramebufferClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLFramebufferClass @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLFramebufferPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLFramebufferPrivate = _GstGLFramebufferPrivate;

#[repr(C)]
pub struct _GstGLFuncs {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLFuncs = _GstGLFuncs;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemory {
    pub mem: GstGLBaseMemory,
    pub tex_id: c_uint,
    pub tex_target: GstGLTextureTarget,
    pub tex_format: GstGLFormat,
    pub info: gst_video::GstVideoInfo,
    pub valign: gst_video::GstVideoAlignment,
    pub plane: c_uint,
    pub tex_scaling: [c_float; 2],
    pub texture_wrapped: gboolean,
    pub unpack_length: c_uint,
    pub tex_width: c_uint,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemory @ {self:p}"))
            .field("mem", &self.mem)
            .field("tex_id", &self.tex_id)
            .field("tex_target", &self.tex_target)
            .field("tex_format", &self.tex_format)
            .field("info", &self.info)
            .field("valign", &self.valign)
            .field("plane", &self.plane)
            .field("tex_scaling", &self.tex_scaling)
            .field("texture_wrapped", &self.texture_wrapped)
            .field("unpack_length", &self.unpack_length)
            .field("tex_width", &self.tex_width)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemoryAllocatorClass {
    pub parent_class: GstGLBaseMemoryAllocatorClass,
    pub map: GstGLBaseMemoryAllocatorMapFunction,
    pub copy: GstGLBaseMemoryAllocatorCopyFunction,
    pub unmap: GstGLBaseMemoryAllocatorUnmapFunction,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemoryAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemoryAllocatorClass @ {self:p}"))
            .field("map", &self.map)
            .field("copy", &self.copy)
            .field("unmap", &self.unmap)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemoryPBO {
    pub mem: GstGLMemory,
    pub pbo: *mut GstGLBuffer,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemoryPBO {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemoryPBO @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemoryPBOAllocatorClass {
    pub parent_class: GstGLMemoryAllocatorClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemoryPBOAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemoryPBOAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMixerClass {
    pub parent_class: GstGLBaseMixerClass,
    pub process_buffers:
        Option<unsafe extern "C" fn(*mut GstGLMixer, *mut gst::GstBuffer) -> gboolean>,
    pub process_textures:
        Option<unsafe extern "C" fn(*mut GstGLMixer, *mut GstGLMemory) -> gboolean>,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMixerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMixerClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("process_buffers", &self.process_buffers)
            .field("process_textures", &self.process_textures)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMixerPadClass {
    pub parent_class: GstGLBaseMixerPadClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMixerPadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMixerPadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLMixerPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLMixerPrivate = _GstGLMixerPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLOverlayCompositorClass {
    pub object_class: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLOverlayCompositorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLOverlayCompositorClass @ {self:p}"))
            .field("object_class", &self.object_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLQuery {
    pub context: *mut GstGLContext,
    pub query_type: c_uint,
    pub query_id: c_uint,
    pub supported: gboolean,
    pub start_called: gboolean,
    pub debug: GstGLAsyncDebug,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLQuery {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLQuery @ {self:p}")).finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLRenderbuffer {
    pub mem: GstGLBaseMemory,
    pub renderbuffer_id: c_uint,
    pub renderbuffer_format: GstGLFormat,
    pub width: c_uint,
    pub height: c_uint,
    pub renderbuffer_wrapped: gboolean,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLRenderbuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLRenderbuffer @ {self:p}"))
            .field("renderbuffer_id", &self.renderbuffer_id)
            .field("renderbuffer_format", &self.renderbuffer_format)
            .field("width", &self.width)
            .field("height", &self.height)
            .field("renderbuffer_wrapped", &self.renderbuffer_wrapped)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLRenderbufferAllocationParams {
    pub parent: GstGLAllocationParams,
    pub renderbuffer_format: GstGLFormat,
    pub width: c_uint,
    pub height: c_uint,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLRenderbufferAllocationParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLRenderbufferAllocationParams @ {self:p}"))
            .field("renderbuffer_format", &self.renderbuffer_format)
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLRenderbufferAllocatorClass {
    pub parent_class: GstGLBaseMemoryAllocatorClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLRenderbufferAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLRenderbufferAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLSLStageClass {
    pub parent: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLSLStageClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLSLStageClass @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLSLStagePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLSLStagePrivate = _GstGLSLStagePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLShaderClass {
    pub parent_class: gst::GstObjectClass,
}

impl ::std::fmt::Debug for GstGLShaderClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLShaderClass @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLShaderPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLShaderPrivate = _GstGLShaderPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLSyncMeta {
    pub parent: gst::GstMeta,
    pub context: *mut GstGLContext,
    pub data: gpointer,
    pub set_sync: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub set_sync_gl: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub wait: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub wait_gl: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub wait_cpu: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub wait_cpu_gl: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub copy: Option<
        unsafe extern "C" fn(
            *mut GstGLSyncMeta,
            *mut gst::GstBuffer,
            *mut GstGLSyncMeta,
            *mut gst::GstBuffer,
        ),
    >,
    pub free: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
    pub free_gl: Option<unsafe extern "C" fn(*mut GstGLSyncMeta, *mut GstGLContext)>,
}

impl ::std::fmt::Debug for GstGLSyncMeta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLSyncMeta @ {self:p}"))
            .field("parent", &self.parent)
            .field("context", &self.context)
            .field("data", &self.data)
            .field("set_sync", &self.set_sync)
            .field("set_sync_gl", &self.set_sync_gl)
            .field("wait", &self.wait)
            .field("wait_gl", &self.wait_gl)
            .field("wait_cpu", &self.wait_cpu)
            .field("wait_cpu_gl", &self.wait_cpu_gl)
            .field("copy", &self.copy)
            .field("free", &self.free)
            .field("free_gl", &self.free_gl)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLUploadClass {
    pub object_class: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLUploadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLUploadClass @ {self:p}"))
            .field("object_class", &self.object_class)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLUploadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLUploadPrivate = _GstGLUploadPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLVideoAllocationParams {
    pub parent: GstGLAllocationParams,
    pub v_info: *mut gst_video::GstVideoInfo,
    pub plane: c_uint,
    pub valign: *mut gst_video::GstVideoAlignment,
    pub target: GstGLTextureTarget,
    pub tex_format: GstGLFormat,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLVideoAllocationParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLVideoAllocationParams @ {self:p}"))
            .field("parent", &self.parent)
            .field("v_info", &self.v_info)
            .field("plane", &self.plane)
            .field("valign", &self.valign)
            .field("target", &self.target)
            .field("tex_format", &self.tex_format)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLViewConvertClass {
    pub object_class: gst::GstObjectClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLViewConvertClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLViewConvertClass @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLViewConvertPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLViewConvertPrivate = _GstGLViewConvertPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLWindowClass {
    pub parent_class: gst::GstObjectClass,
    pub get_display: Option<unsafe extern "C" fn(*mut GstGLWindow) -> uintptr_t>,
    pub set_window_handle: Option<unsafe extern "C" fn(*mut GstGLWindow, uintptr_t)>,
    pub get_window_handle: Option<unsafe extern "C" fn(*mut GstGLWindow) -> uintptr_t>,
    pub draw: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub run: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub quit: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub send_message: Option<unsafe extern "C" fn(*mut GstGLWindow, GstGLWindowCB, gpointer)>,
    pub send_message_async: Option<
        unsafe extern "C" fn(*mut GstGLWindow, GstGLWindowCB, gpointer, glib::GDestroyNotify),
    >,
    pub open: Option<unsafe extern "C" fn(*mut GstGLWindow, *mut *mut glib::GError) -> gboolean>,
    pub close: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub handle_events: Option<unsafe extern "C" fn(*mut GstGLWindow, gboolean)>,
    pub set_preferred_size: Option<unsafe extern "C" fn(*mut GstGLWindow, c_int, c_int)>,
    pub show: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub set_render_rectangle:
        Option<unsafe extern "C" fn(*mut GstGLWindow, c_int, c_int, c_int, c_int) -> gboolean>,
    pub queue_resize: Option<unsafe extern "C" fn(*mut GstGLWindow)>,
    pub controls_viewport: Option<unsafe extern "C" fn(*mut GstGLWindow) -> gboolean>,
    pub has_output_surface: Option<unsafe extern "C" fn(*mut GstGLWindow) -> gboolean>,
    pub _reserved: [gpointer; 2],
}

impl ::std::fmt::Debug for GstGLWindowClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLWindowClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_display", &self.get_display)
            .field("set_window_handle", &self.set_window_handle)
            .field("get_window_handle", &self.get_window_handle)
            .field("draw", &self.draw)
            .field("run", &self.run)
            .field("quit", &self.quit)
            .field("send_message", &self.send_message)
            .field("send_message_async", &self.send_message_async)
            .field("open", &self.open)
            .field("close", &self.close)
            .field("handle_events", &self.handle_events)
            .field("set_preferred_size", &self.set_preferred_size)
            .field("show", &self.show)
            .field("set_render_rectangle", &self.set_render_rectangle)
            .field("queue_resize", &self.queue_resize)
            .field("controls_viewport", &self.controls_viewport)
            .field("has_output_surface", &self.has_output_surface)
            .finish()
    }
}

#[repr(C)]
pub struct _GstGLWindowPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstGLWindowPrivate = _GstGLWindowPrivate;

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseFilter {
    pub parent: gst_base::GstBaseTransform,
    pub display: *mut GstGLDisplay,
    pub context: *mut GstGLContext,
    pub in_caps: *mut gst::GstCaps,
    pub out_caps: *mut gst::GstCaps,
    pub _padding: [gpointer; 4],
    pub priv_: *mut GstGLBaseFilterPrivate,
}

impl ::std::fmt::Debug for GstGLBaseFilter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseFilter @ {self:p}"))
            .field("parent", &self.parent)
            .field("display", &self.display)
            .field("context", &self.context)
            .field("in_caps", &self.in_caps)
            .field("out_caps", &self.out_caps)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMemoryAllocator {
    pub parent: gst::GstAllocator,
    pub fallback_mem_copy: gst::GstMemoryCopyFunction,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMemoryAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMemoryAllocator @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMixer {
    pub parent: gst_video::GstVideoAggregator,
    pub display: *mut GstGLDisplay,
    pub context: *mut GstGLContext,
    pub _padding: [gpointer; 4],
    pub priv_: *mut GstGLBaseMixerPrivate,
}

impl ::std::fmt::Debug for GstGLBaseMixer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMixer @ {self:p}"))
            .field("parent", &self.parent)
            .field("display", &self.display)
            .field("context", &self.context)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseMixerPad {
    pub parent: gst_video::GstVideoAggregatorPad,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBaseMixerPad {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseMixerPad @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBaseSrc {
    pub parent: gst_base::GstPushSrc,
    pub display: *mut GstGLDisplay,
    pub context: *mut GstGLContext,
    pub out_info: gst_video::GstVideoInfo,
    pub out_caps: *mut gst::GstCaps,
    pub running_time: gst::GstClockTime,
    pub _padding: [gpointer; 4],
    pub priv_: *mut GstGLBaseSrcPrivate,
}

impl ::std::fmt::Debug for GstGLBaseSrc {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBaseSrc @ {self:p}"))
            .field("parent", &self.parent)
            .field("display", &self.display)
            .field("context", &self.context)
            .field("out_info", &self.out_info)
            .field("out_caps", &self.out_caps)
            .field("running_time", &self.running_time)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBufferAllocator {
    pub parent: GstGLBaseMemoryAllocator,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBufferAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBufferAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLBufferPool {
    pub bufferpool: gst::GstBufferPool,
    pub context: *mut GstGLContext,
    pub priv_: *mut GstGLBufferPoolPrivate,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLBufferPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLBufferPool @ {self:p}"))
            .field("bufferpool", &self.bufferpool)
            .field("context", &self.context)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLColorConvert {
    pub parent: gst::GstObject,
    pub context: *mut GstGLContext,
    pub in_info: gst_video::GstVideoInfo,
    pub out_info: gst_video::GstVideoInfo,
    pub initted: gboolean,
    pub passthrough: gboolean,
    pub inbuf: *mut gst::GstBuffer,
    pub outbuf: *mut gst::GstBuffer,
    pub fbo: *mut GstGLFramebuffer,
    pub shader: *mut GstGLShader,
    pub priv_: *mut GstGLColorConvertPrivate,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLColorConvert {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLColorConvert @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLContext {
    pub parent: gst::GstObject,
    pub display: *mut GstGLDisplay,
    pub window: *mut GstGLWindow,
    pub gl_vtable: *mut GstGLFuncs,
    pub priv_: *mut GstGLContextPrivate,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLContext {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLContext @ {self:p}"))
            .field("gl_vtable", &self.gl_vtable)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLDisplay {
    pub object: gst::GstObject,
    pub type_: GstGLDisplayType,
    pub windows: *mut glib::GList,
    pub main_context: *mut glib::GMainContext,
    pub main_loop: *mut glib::GMainLoop,
    pub event_source: *mut glib::GSource,
    pub priv_: *mut GstGLDisplayPrivate,
}

impl ::std::fmt::Debug for GstGLDisplay {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLDisplay @ {self:p}")).finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLFilter {
    pub parent: GstGLBaseFilter,
    pub in_info: gst_video::GstVideoInfo,
    pub out_info: gst_video::GstVideoInfo,
    pub in_texture_target: GstGLTextureTarget,
    pub out_texture_target: GstGLTextureTarget,
    pub out_caps: *mut gst::GstCaps,
    pub fbo: *mut GstGLFramebuffer,
    pub gl_result: gboolean,
    pub inbuf: *mut gst::GstBuffer,
    pub outbuf: *mut gst::GstBuffer,
    pub default_shader: *mut GstGLShader,
    pub valid_attributes: gboolean,
    pub vao: c_uint,
    pub vbo_indices: c_uint,
    pub vertex_buffer: c_uint,
    pub draw_attr_position_loc: c_int,
    pub draw_attr_texture_loc: c_int,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLFilter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLFilter @ {self:p}"))
            .field("parent", &self.parent)
            .field("in_info", &self.in_info)
            .field("out_info", &self.out_info)
            .field("in_texture_target", &self.in_texture_target)
            .field("out_texture_target", &self.out_texture_target)
            .field("out_caps", &self.out_caps)
            .field("fbo", &self.fbo)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLFramebuffer {
    pub object: gst::GstObject,
    pub context: *mut GstGLContext,
    pub fbo_id: c_uint,
    pub attachments: *mut glib::GArray,
    pub _padding: [gpointer; 4],
    pub priv_: *mut GstGLFramebufferPrivate,
}

impl ::std::fmt::Debug for GstGLFramebuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLFramebuffer @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemoryAllocator {
    pub parent: GstGLBaseMemoryAllocator,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemoryAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemoryAllocator @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMemoryPBOAllocator {
    pub parent: GstGLMemoryAllocator,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMemoryPBOAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMemoryPBOAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMixer {
    pub parent: GstGLBaseMixer,
    pub out_caps: *mut gst::GstCaps,
    pub priv_: *mut GstGLMixerPrivate,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMixer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMixer @ {self:p}"))
            .field("parent", &self.parent)
            .field("out_caps", &self.out_caps)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLMixerPad {
    pub parent: GstGLBaseMixerPad,
    pub current_texture: c_uint,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLMixerPad {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLMixerPad @ {self:p}"))
            .field("parent", &self.parent)
            .field("current_texture", &self.current_texture)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLOverlayCompositor {
    pub parent: gst::GstObject,
    pub context: *mut GstGLContext,
    pub last_window_width: c_uint,
    pub last_window_height: c_uint,
    pub overlays: *mut glib::GList,
    pub shader: *mut GstGLShader,
    pub position_attrib: c_int,
    pub texcoord_attrib: c_int,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLOverlayCompositor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLOverlayCompositor @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLRenderbufferAllocator {
    pub parent: GstGLBaseMemoryAllocator,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLRenderbufferAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLRenderbufferAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLSLStage {
    pub parent: gst::GstObject,
    pub context: *mut GstGLContext,
    pub priv_: *mut GstGLSLStagePrivate,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLSLStage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLSLStage @ {self:p}")).finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLShader {
    pub parent: gst::GstObject,
    pub context: *mut GstGLContext,
    pub priv_: *mut GstGLShaderPrivate,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLShader {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLShader @ {self:p}"))
            .field("parent", &self.parent)
            .field("context", &self.context)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLUpload {
    pub parent: gst::GstObject,
    pub context: *mut GstGLContext,
    pub priv_: *mut GstGLUploadPrivate,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLUpload {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLUpload @ {self:p}"))
            .field("parent", &self.parent)
            .field("context", &self.context)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLViewConvert {
    pub object: gst::GstObject,
    pub context: *mut GstGLContext,
    pub shader: *mut GstGLShader,
    pub input_mode_override: gst_video::GstVideoMultiviewMode,
    pub input_flags_override: gst_video::GstVideoMultiviewFlags,
    pub output_mode_override: gst_video::GstVideoMultiviewMode,
    pub output_flags_override: gst_video::GstVideoMultiviewFlags,
    pub downmix_mode: GstGLStereoDownmix,
    pub in_info: gst_video::GstVideoInfo,
    pub out_info: gst_video::GstVideoInfo,
    pub from_texture_target: GstGLTextureTarget,
    pub to_texture_target: GstGLTextureTarget,
    pub caps_passthrough: gboolean,
    pub initted: gboolean,
    pub reconfigure: gboolean,
    pub fbo: *mut GstGLFramebuffer,
    pub priv_: *mut GstGLViewConvertPrivate,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLViewConvert {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLViewConvert @ {self:p}"))
            .field("object", &self.object)
            .field("context", &self.context)
            .field("shader", &self.shader)
            .field("input_mode_override", &self.input_mode_override)
            .field("input_flags_override", &self.input_flags_override)
            .field("output_mode_override", &self.output_mode_override)
            .field("output_flags_override", &self.output_flags_override)
            .field("downmix_mode", &self.downmix_mode)
            .field("in_info", &self.in_info)
            .field("out_info", &self.out_info)
            .field("from_texture_target", &self.from_texture_target)
            .field("to_texture_target", &self.to_texture_target)
            .field("caps_passthrough", &self.caps_passthrough)
            .field("initted", &self.initted)
            .field("reconfigure", &self.reconfigure)
            .field("fbo", &self.fbo)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstGLWindow {
    pub parent: gst::GstObject,
    pub lock: glib::GMutex,
    pub display: *mut GstGLDisplay,
    pub context_ref: gobject::GWeakRef,
    pub is_drawing: gboolean,
    pub draw: GstGLWindowCB,
    pub draw_data: gpointer,
    pub draw_notify: glib::GDestroyNotify,
    pub close: GstGLWindowCB,
    pub close_data: gpointer,
    pub close_notify: glib::GDestroyNotify,
    pub resize: GstGLWindowResizeCB,
    pub resize_data: gpointer,
    pub resize_notify: glib::GDestroyNotify,
    pub queue_resize: gboolean,
    pub main_context: *mut glib::GMainContext,
    pub priv_: *mut GstGLWindowPrivate,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstGLWindow {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstGLWindow @ {self:p}")).finish()
    }
}

#[link(name = "gstgl-1.0")]
extern "C" {

    //=========================================================================
    // GstGLBaseMemoryError
    //=========================================================================
    pub fn gst_gl_base_memory_error_get_type() -> GType;
    pub fn gst_gl_base_memory_error_quark() -> glib::GQuark;

    //=========================================================================
    // GstGLConfigCaveat
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_config_caveat_get_type() -> GType;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_config_caveat_to_string(caveat: GstGLConfigCaveat) -> *const c_char;

    //=========================================================================
    // GstGLContextError
    //=========================================================================
    pub fn gst_gl_context_error_get_type() -> GType;
    pub fn gst_gl_context_error_quark() -> glib::GQuark;

    //=========================================================================
    // GstGLFormat
    //=========================================================================
    pub fn gst_gl_format_get_type() -> GType;
    pub fn gst_gl_format_from_video_info(
        context: *mut GstGLContext,
        vinfo: *const gst_video::GstVideoInfo,
        plane: c_uint,
    ) -> GstGLFormat;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_format_is_supported(context: *mut GstGLContext, format: GstGLFormat) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_format_n_components(gl_format: GstGLFormat) -> c_uint;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_format_type_from_sized_gl_format(
        format: GstGLFormat,
        unsized_format: *mut GstGLFormat,
        gl_type: *mut c_uint,
    );
    pub fn gst_gl_format_type_n_bytes(format: c_uint, type_: c_uint) -> c_uint;

    //=========================================================================
    // GstGLQueryType
    //=========================================================================
    pub fn gst_gl_query_type_get_type() -> GType;

    //=========================================================================
    // GstGLSLError
    //=========================================================================
    pub fn gst_glsl_error_get_type() -> GType;
    pub fn gst_glsl_error_quark() -> glib::GQuark;

    //=========================================================================
    // GstGLSLVersion
    //=========================================================================
    pub fn gst_glsl_version_get_type() -> GType;
    pub fn gst_glsl_version_from_string(string: *const c_char) -> GstGLSLVersion;
    pub fn gst_glsl_version_profile_from_string(
        string: *const c_char,
        version_ret: *mut GstGLSLVersion,
        profile_ret: *mut GstGLSLProfile,
    ) -> gboolean;
    pub fn gst_glsl_version_profile_to_string(
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> *mut c_char;
    pub fn gst_glsl_version_to_string(version: GstGLSLVersion) -> *const c_char;

    //=========================================================================
    // GstGLStereoDownmix
    //=========================================================================
    pub fn gst_gl_stereo_downmix_get_type() -> GType;

    //=========================================================================
    // GstGLTextureTarget
    //=========================================================================
    pub fn gst_gl_texture_target_get_type() -> GType;
    pub fn gst_gl_texture_target_from_gl(target: c_uint) -> GstGLTextureTarget;
    pub fn gst_gl_texture_target_from_string(str: *const c_char) -> GstGLTextureTarget;
    pub fn gst_gl_texture_target_to_buffer_pool_option(target: GstGLTextureTarget)
        -> *const c_char;
    pub fn gst_gl_texture_target_to_gl(target: GstGLTextureTarget) -> c_uint;
    pub fn gst_gl_texture_target_to_string(target: GstGLTextureTarget) -> *const c_char;

    //=========================================================================
    // GstGLUploadReturn
    //=========================================================================
    pub fn gst_gl_upload_return_get_type() -> GType;

    //=========================================================================
    // GstGLWindowError
    //=========================================================================
    pub fn gst_gl_window_error_get_type() -> GType;
    pub fn gst_gl_window_error_quark() -> glib::GQuark;

    //=========================================================================
    // GstGLAPI
    //=========================================================================
    pub fn gst_gl_api_get_type() -> GType;
    pub fn gst_gl_api_from_string(api_s: *const c_char) -> GstGLAPI;
    pub fn gst_gl_api_to_string(api: GstGLAPI) -> *mut c_char;

    //=========================================================================
    // GstGLBaseMemoryTransfer
    //=========================================================================
    pub fn gst_gl_base_memory_transfer_get_type() -> GType;

    //=========================================================================
    // GstGLConfigSurfaceType
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_config_surface_type_get_type() -> GType;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_config_surface_type_to_string(
        surface_type: GstGLConfigSurfaceType,
    ) -> *const c_char;

    //=========================================================================
    // GstGLDisplayType
    //=========================================================================
    pub fn gst_gl_display_type_get_type() -> GType;

    //=========================================================================
    // GstGLPlatform
    //=========================================================================
    pub fn gst_gl_platform_get_type() -> GType;
    pub fn gst_gl_platform_from_string(platform_s: *const c_char) -> GstGLPlatform;
    pub fn gst_gl_platform_to_string(platform: GstGLPlatform) -> *mut c_char;

    //=========================================================================
    // GstGLSLProfile
    //=========================================================================
    pub fn gst_glsl_profile_get_type() -> GType;
    pub fn gst_glsl_profile_from_string(string: *const c_char) -> GstGLSLProfile;
    pub fn gst_glsl_profile_to_string(profile: GstGLSLProfile) -> *const c_char;

    //=========================================================================
    // GstGLAllocationParams
    //=========================================================================
    pub fn gst_gl_allocation_params_get_type() -> GType;
    pub fn gst_gl_allocation_params_copy(
        src: *mut GstGLAllocationParams,
    ) -> *mut GstGLAllocationParams;
    pub fn gst_gl_allocation_params_copy_data(
        src: *mut GstGLAllocationParams,
        dest: *mut GstGLAllocationParams,
    );
    pub fn gst_gl_allocation_params_free(params: *mut GstGLAllocationParams);
    pub fn gst_gl_allocation_params_free_data(params: *mut GstGLAllocationParams);
    pub fn gst_gl_allocation_params_init(
        params: *mut GstGLAllocationParams,
        struct_size: size_t,
        alloc_flags: c_uint,
        copy: GstGLAllocationParamsCopyFunc,
        free: GstGLAllocationParamsFreeFunc,
        context: *mut GstGLContext,
        alloc_size: size_t,
        alloc_params: *const gst::GstAllocationParams,
        wrapped_data: gpointer,
        gl_handle: gpointer,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> gboolean;

    //=========================================================================
    // GstGLAsyncDebug
    //=========================================================================
    pub fn gst_gl_async_debug_free(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_freeze(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_init(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_output_log_msg(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_store_log_msg(
        ad: *mut GstGLAsyncDebug,
        cat: *mut gst::GstDebugCategory,
        level: gst::GstDebugLevel,
        file: *const c_char,
        function: *const c_char,
        line: c_int,
        object: *mut gobject::GObject,
        format: *const c_char,
        ...
    );
    //pub fn gst_gl_async_debug_store_log_msg_valist(ad: *mut GstGLAsyncDebug, cat: *mut gst::GstDebugCategory, level: gst::GstDebugLevel, file: *const c_char, function: *const c_char, line: c_int, object: *mut gobject::GObject, format: *const c_char, varargs: /*Unimplemented*/va_list);
    pub fn gst_gl_async_debug_thaw(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_unset(ad: *mut GstGLAsyncDebug);
    pub fn gst_gl_async_debug_new() -> *mut GstGLAsyncDebug;

    //=========================================================================
    // GstGLBaseMemory
    //=========================================================================
    pub fn gst_gl_base_memory_get_type() -> GType;
    pub fn gst_gl_base_memory_alloc_data(gl_mem: *mut GstGLBaseMemory) -> gboolean;
    pub fn gst_gl_base_memory_init(
        mem: *mut GstGLBaseMemory,
        allocator: *mut gst::GstAllocator,
        parent: *mut gst::GstMemory,
        context: *mut GstGLContext,
        params: *const gst::GstAllocationParams,
        size: size_t,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    );
    pub fn gst_gl_base_memory_memcpy(
        src: *mut GstGLBaseMemory,
        dest: *mut GstGLBaseMemory,
        offset: ssize_t,
        size: ssize_t,
    ) -> gboolean;
    pub fn gst_gl_base_memory_alloc(
        allocator: *mut GstGLBaseMemoryAllocator,
        params: *mut GstGLAllocationParams,
    ) -> *mut GstGLBaseMemory;
    pub fn gst_gl_base_memory_init_once();

    //=========================================================================
    // GstGLBuffer
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_buffer_get_type() -> GType;
    pub fn gst_gl_buffer_init_once();

    //=========================================================================
    // GstGLBufferAllocationParams
    //=========================================================================
    pub fn gst_gl_buffer_allocation_params_get_type() -> GType;
    pub fn gst_gl_buffer_allocation_params_new(
        context: *mut GstGLContext,
        alloc_size: size_t,
        alloc_params: *const gst::GstAllocationParams,
        gl_target: c_uint,
        gl_usage: c_uint,
    ) -> *mut GstGLBufferAllocationParams;

    //=========================================================================
    // GstGLMemory
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_memory_get_type() -> GType;
    pub fn gst_gl_memory_copy_into(
        gl_mem: *mut GstGLMemory,
        tex_id: c_uint,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        width: c_int,
        height: c_int,
    ) -> gboolean;
    pub fn gst_gl_memory_copy_teximage(
        src: *mut GstGLMemory,
        tex_id: c_uint,
        out_target: GstGLTextureTarget,
        out_tex_format: GstGLFormat,
        out_width: c_int,
        out_height: c_int,
    ) -> gboolean;
    pub fn gst_gl_memory_get_texture_format(gl_mem: *mut GstGLMemory) -> GstGLFormat;
    pub fn gst_gl_memory_get_texture_height(gl_mem: *mut GstGLMemory) -> c_int;
    pub fn gst_gl_memory_get_texture_id(gl_mem: *mut GstGLMemory) -> c_uint;
    pub fn gst_gl_memory_get_texture_target(gl_mem: *mut GstGLMemory) -> GstGLTextureTarget;
    pub fn gst_gl_memory_get_texture_width(gl_mem: *mut GstGLMemory) -> c_int;
    pub fn gst_gl_memory_init(
        mem: *mut GstGLMemory,
        allocator: *mut gst::GstAllocator,
        parent: *mut gst::GstMemory,
        context: *mut GstGLContext,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        params: *const gst::GstAllocationParams,
        info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    );
    pub fn gst_gl_memory_read_pixels(gl_mem: *mut GstGLMemory, write_pointer: gpointer)
        -> gboolean;
    pub fn gst_gl_memory_texsubimage(gl_mem: *mut GstGLMemory, read_pointer: gpointer);
    pub fn gst_gl_memory_init_once();
    pub fn gst_gl_memory_setup_buffer(
        allocator: *mut GstGLMemoryAllocator,
        buffer: *mut gst::GstBuffer,
        params: *mut GstGLVideoAllocationParams,
        tex_formats: *mut GstGLFormat,
        wrapped_data: *mut gpointer,
        n_wrapped_pointers: size_t,
    ) -> gboolean;

    //=========================================================================
    // GstGLMemoryPBO
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_memory_pbo_get_type() -> GType;
    pub fn gst_gl_memory_pbo_copy_into_texture(
        gl_mem: *mut GstGLMemoryPBO,
        tex_id: c_uint,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        width: c_int,
        height: c_int,
        stride: c_int,
        respecify: gboolean,
    ) -> gboolean;
    pub fn gst_gl_memory_pbo_download_transfer(gl_mem: *mut GstGLMemoryPBO);
    pub fn gst_gl_memory_pbo_upload_transfer(gl_mem: *mut GstGLMemoryPBO);
    pub fn gst_gl_memory_pbo_init_once();

    //=========================================================================
    // GstGLMixerClass
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_mixer_class_add_rgba_pad_templates(klass: *mut GstGLMixerClass);

    //=========================================================================
    // GstGLQuery
    //=========================================================================
    pub fn gst_gl_query_counter(query: *mut GstGLQuery);
    pub fn gst_gl_query_end(query: *mut GstGLQuery);
    pub fn gst_gl_query_free(query: *mut GstGLQuery);
    pub fn gst_gl_query_init(
        query: *mut GstGLQuery,
        context: *mut GstGLContext,
        query_type: GstGLQueryType,
    );
    pub fn gst_gl_query_result(query: *mut GstGLQuery) -> u64;
    pub fn gst_gl_query_start(query: *mut GstGLQuery);
    pub fn gst_gl_query_unset(query: *mut GstGLQuery);
    pub fn gst_gl_query_local_gl_context(
        element: *mut gst::GstElement,
        direction: gst::GstPadDirection,
        context_ptr: *mut *mut GstGLContext,
    ) -> gboolean;
    pub fn gst_gl_query_new(
        context: *mut GstGLContext,
        query_type: GstGLQueryType,
    ) -> *mut GstGLQuery;

    //=========================================================================
    // GstGLRenderbuffer
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_renderbuffer_get_type() -> GType;
    pub fn gst_gl_renderbuffer_get_format(gl_mem: *mut GstGLRenderbuffer) -> GstGLFormat;
    pub fn gst_gl_renderbuffer_get_height(gl_mem: *mut GstGLRenderbuffer) -> c_int;
    pub fn gst_gl_renderbuffer_get_id(gl_mem: *mut GstGLRenderbuffer) -> c_uint;
    pub fn gst_gl_renderbuffer_get_width(gl_mem: *mut GstGLRenderbuffer) -> c_int;
    pub fn gst_gl_renderbuffer_init_once();

    //=========================================================================
    // GstGLRenderbufferAllocationParams
    //=========================================================================
    pub fn gst_gl_renderbuffer_allocation_params_get_type() -> GType;
    pub fn gst_gl_renderbuffer_allocation_params_new(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        renderbuffer_format: GstGLFormat,
        width: c_uint,
        height: c_uint,
    ) -> *mut GstGLRenderbufferAllocationParams;
    pub fn gst_gl_renderbuffer_allocation_params_new_wrapped(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        renderbuffer_format: GstGLFormat,
        width: c_uint,
        height: c_uint,
        gl_handle: gpointer,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut GstGLRenderbufferAllocationParams;

    //=========================================================================
    // GstGLSyncMeta
    //=========================================================================
    pub fn gst_gl_sync_meta_set_sync_point(
        sync_meta: *mut GstGLSyncMeta,
        context: *mut GstGLContext,
    );
    pub fn gst_gl_sync_meta_wait(sync_meta: *mut GstGLSyncMeta, context: *mut GstGLContext);
    pub fn gst_gl_sync_meta_wait_cpu(sync_meta: *mut GstGLSyncMeta, context: *mut GstGLContext);
    pub fn gst_gl_sync_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // GstGLVideoAllocationParams
    //=========================================================================
    pub fn gst_gl_video_allocation_params_get_type() -> GType;
    pub fn gst_gl_video_allocation_params_new(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        v_info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
    ) -> *mut GstGLVideoAllocationParams;
    pub fn gst_gl_video_allocation_params_new_wrapped_data(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        v_info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        wrapped_data: gpointer,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut GstGLVideoAllocationParams;
    pub fn gst_gl_video_allocation_params_new_wrapped_gl_handle(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        v_info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        gl_handle: gpointer,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut GstGLVideoAllocationParams;
    pub fn gst_gl_video_allocation_params_new_wrapped_texture(
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        v_info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        tex_id: c_uint,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut GstGLVideoAllocationParams;
    pub fn gst_gl_video_allocation_params_copy_data(
        src_vid: *mut GstGLVideoAllocationParams,
        dest_vid: *mut GstGLVideoAllocationParams,
    );
    pub fn gst_gl_video_allocation_params_free_data(params: *mut GstGLVideoAllocationParams);
    pub fn gst_gl_video_allocation_params_init_full(
        params: *mut GstGLVideoAllocationParams,
        struct_size: size_t,
        alloc_flags: c_uint,
        copy: GstGLAllocationParamsCopyFunc,
        free: GstGLAllocationParamsFreeFunc,
        context: *mut GstGLContext,
        alloc_params: *const gst::GstAllocationParams,
        v_info: *const gst_video::GstVideoInfo,
        plane: c_uint,
        valign: *const gst_video::GstVideoAlignment,
        target: GstGLTextureTarget,
        tex_format: GstGLFormat,
        wrapped_data: gpointer,
        gl_handle: gpointer,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> gboolean;

    //=========================================================================
    // GstGLBaseFilter
    //=========================================================================
    pub fn gst_gl_base_filter_get_type() -> GType;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_base_filter_find_gl_context(filter: *mut GstGLBaseFilter) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_base_filter_get_gl_context(filter: *mut GstGLBaseFilter) -> *mut GstGLContext;

    //=========================================================================
    // GstGLBaseMemoryAllocator
    //=========================================================================
    pub fn gst_gl_base_memory_allocator_get_type() -> GType;

    //=========================================================================
    // GstGLBaseMixer
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_base_mixer_get_type() -> GType;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_base_mixer_get_gl_context(mix: *mut GstGLBaseMixer) -> *mut GstGLContext;

    //=========================================================================
    // GstGLBaseMixerPad
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_base_mixer_pad_get_type() -> GType;

    //=========================================================================
    // GstGLBaseSrc
    //=========================================================================
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_base_src_get_type() -> GType;

    //=========================================================================
    // GstGLBufferAllocator
    //=========================================================================
    pub fn gst_gl_buffer_allocator_get_type() -> GType;

    //=========================================================================
    // GstGLBufferPool
    //=========================================================================
    pub fn gst_gl_buffer_pool_get_type() -> GType;
    pub fn gst_gl_buffer_pool_new(context: *mut GstGLContext) -> *mut gst::GstBufferPool;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_buffer_pool_get_gl_allocation_params(
        pool: *mut GstGLBufferPool,
    ) -> *mut GstGLAllocationParams;

    //=========================================================================
    // GstGLColorConvert
    //=========================================================================
    pub fn gst_gl_color_convert_get_type() -> GType;
    pub fn gst_gl_color_convert_new(context: *mut GstGLContext) -> *mut GstGLColorConvert;
    pub fn gst_gl_color_convert_fixate_caps(
        context: *mut GstGLContext,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        other: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_color_convert_swizzle_shader_string(context: *mut GstGLContext) -> *mut c_char;
    pub fn gst_gl_color_convert_transform_caps(
        context: *mut GstGLContext,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        filter: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_color_convert_yuv_to_rgb_shader_string(context: *mut GstGLContext)
        -> *mut c_char;
    pub fn gst_gl_color_convert_decide_allocation(
        convert: *mut GstGLColorConvert,
        query: *mut gst::GstQuery,
    ) -> gboolean;
    pub fn gst_gl_color_convert_perform(
        convert: *mut GstGLColorConvert,
        inbuf: *mut gst::GstBuffer,
    ) -> *mut gst::GstBuffer;
    pub fn gst_gl_color_convert_set_caps(
        convert: *mut GstGLColorConvert,
        in_caps: *mut gst::GstCaps,
        out_caps: *mut gst::GstCaps,
    ) -> gboolean;

    //=========================================================================
    // GstGLContext
    //=========================================================================
    pub fn gst_gl_context_get_type() -> GType;
    pub fn gst_gl_context_new(display: *mut GstGLDisplay) -> *mut GstGLContext;
    pub fn gst_gl_context_new_wrapped(
        display: *mut GstGLDisplay,
        handle: uintptr_t,
        context_type: GstGLPlatform,
        available_apis: GstGLAPI,
    ) -> *mut GstGLContext;
    pub fn gst_gl_context_default_get_proc_address(
        gl_api: GstGLAPI,
        name: *const c_char,
    ) -> gpointer;
    pub fn gst_gl_context_get_current() -> *mut GstGLContext;
    pub fn gst_gl_context_get_current_gl_api(
        platform: GstGLPlatform,
        major: *mut c_uint,
        minor: *mut c_uint,
    ) -> GstGLAPI;
    pub fn gst_gl_context_get_current_gl_context(context_type: GstGLPlatform) -> uintptr_t;
    pub fn gst_gl_context_get_proc_address_with_platform(
        context_type: GstGLPlatform,
        gl_api: GstGLAPI,
        name: *const c_char,
    ) -> gpointer;
    pub fn gst_gl_context_activate(context: *mut GstGLContext, activate: gboolean) -> gboolean;
    pub fn gst_gl_context_can_share(
        context: *mut GstGLContext,
        other_context: *mut GstGLContext,
    ) -> gboolean;
    pub fn gst_gl_context_check_feature(
        context: *mut GstGLContext,
        feature: *const c_char,
    ) -> gboolean;
    pub fn gst_gl_context_check_framebuffer_status(
        context: *mut GstGLContext,
        fbo_target: c_uint,
    ) -> gboolean;
    pub fn gst_gl_context_check_gl_version(
        context: *mut GstGLContext,
        api: GstGLAPI,
        maj: c_int,
        min: c_int,
    ) -> gboolean;
    pub fn gst_gl_context_clear_framebuffer(context: *mut GstGLContext);
    pub fn gst_gl_context_clear_shader(context: *mut GstGLContext);
    pub fn gst_gl_context_create(
        context: *mut GstGLContext,
        other_context: *mut GstGLContext,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_gl_context_destroy(context: *mut GstGLContext);
    pub fn gst_gl_context_fill_info(
        context: *mut GstGLContext,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_context_get_config(context: *mut GstGLContext) -> *mut gst::GstStructure;
    pub fn gst_gl_context_get_display(context: *mut GstGLContext) -> *mut GstGLDisplay;
    pub fn gst_gl_context_get_gl_api(context: *mut GstGLContext) -> GstGLAPI;
    pub fn gst_gl_context_get_gl_context(context: *mut GstGLContext) -> uintptr_t;
    pub fn gst_gl_context_get_gl_platform(context: *mut GstGLContext) -> GstGLPlatform;
    pub fn gst_gl_context_get_gl_platform_version(
        context: *mut GstGLContext,
        major: *mut c_int,
        minor: *mut c_int,
    );
    pub fn gst_gl_context_get_gl_version(
        context: *mut GstGLContext,
        maj: *mut c_int,
        min: *mut c_int,
    );
    pub fn gst_gl_context_get_proc_address(
        context: *mut GstGLContext,
        name: *const c_char,
    ) -> gpointer;
    pub fn gst_gl_context_get_thread(context: *mut GstGLContext) -> *mut glib::GThread;
    pub fn gst_gl_context_get_window(context: *mut GstGLContext) -> *mut GstGLWindow;
    pub fn gst_gl_context_is_shared(context: *mut GstGLContext) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_context_request_config(
        context: *mut GstGLContext,
        gl_config: *mut gst::GstStructure,
    ) -> gboolean;
    pub fn gst_gl_context_set_shared_with(context: *mut GstGLContext, share: *mut GstGLContext);
    pub fn gst_gl_context_set_window(
        context: *mut GstGLContext,
        window: *mut GstGLWindow,
    ) -> gboolean;
    pub fn gst_gl_context_supports_glsl_profile_version(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_context_supports_precision(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_context_supports_precision_highp(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> gboolean;
    pub fn gst_gl_context_swap_buffers(context: *mut GstGLContext);
    pub fn gst_gl_context_thread_add(
        context: *mut GstGLContext,
        func: GstGLContextThreadFunc,
        data: gpointer,
    );

    //=========================================================================
    // GstGLDisplay
    //=========================================================================
    pub fn gst_gl_display_get_type() -> GType;
    pub fn gst_gl_display_new() -> *mut GstGLDisplay;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_display_new_with_type(type_: GstGLDisplayType) -> *mut GstGLDisplay;
    pub fn gst_gl_display_add_context(
        display: *mut GstGLDisplay,
        context: *mut GstGLContext,
    ) -> gboolean;
    pub fn gst_gl_display_create_context(
        display: *mut GstGLDisplay,
        other_context: *mut GstGLContext,
        p_context: *mut *mut GstGLContext,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_gl_display_create_window(display: *mut GstGLDisplay) -> *mut GstGLWindow;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_display_ensure_context(
        display: *mut GstGLDisplay,
        other_context: *mut GstGLContext,
        context: *mut *mut GstGLContext,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_gl_display_filter_gl_api(display: *mut GstGLDisplay, gl_api: GstGLAPI);
    pub fn gst_gl_display_find_window(
        display: *mut GstGLDisplay,
        data: gpointer,
        compare_func: glib::GCompareFunc,
    ) -> *mut GstGLWindow;
    pub fn gst_gl_display_get_gl_api(display: *mut GstGLDisplay) -> GstGLAPI;
    pub fn gst_gl_display_get_gl_api_unlocked(display: *mut GstGLDisplay) -> GstGLAPI;
    pub fn gst_gl_display_get_gl_context_for_thread(
        display: *mut GstGLDisplay,
        thread: *mut glib::GThread,
    ) -> *mut GstGLContext;
    pub fn gst_gl_display_get_handle(display: *mut GstGLDisplay) -> uintptr_t;
    pub fn gst_gl_display_get_handle_type(display: *mut GstGLDisplay) -> GstGLDisplayType;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_display_remove_context(display: *mut GstGLDisplay, context: *mut GstGLContext);
    pub fn gst_gl_display_remove_window(
        display: *mut GstGLDisplay,
        window: *mut GstGLWindow,
    ) -> gboolean;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_display_retrieve_window(
        display: *mut GstGLDisplay,
        data: gpointer,
        compare_func: glib::GCompareFunc,
    ) -> *mut GstGLWindow;

    //=========================================================================
    // GstGLFilter
    //=========================================================================
    pub fn gst_gl_filter_get_type() -> GType;
    pub fn gst_gl_filter_add_rgba_pad_templates(klass: *mut GstGLFilterClass);
    pub fn gst_gl_filter_draw_fullscreen_quad(filter: *mut GstGLFilter);
    pub fn gst_gl_filter_filter_texture(
        filter: *mut GstGLFilter,
        input: *mut gst::GstBuffer,
        output: *mut gst::GstBuffer,
    ) -> gboolean;
    pub fn gst_gl_filter_render_to_target(
        filter: *mut GstGLFilter,
        input: *mut GstGLMemory,
        output: *mut GstGLMemory,
        func: GstGLFilterRenderFunc,
        data: gpointer,
    ) -> gboolean;
    pub fn gst_gl_filter_render_to_target_with_shader(
        filter: *mut GstGLFilter,
        input: *mut GstGLMemory,
        output: *mut GstGLMemory,
        shader: *mut GstGLShader,
    );

    //=========================================================================
    // GstGLFramebuffer
    //=========================================================================
    pub fn gst_gl_framebuffer_get_type() -> GType;
    pub fn gst_gl_framebuffer_new(context: *mut GstGLContext) -> *mut GstGLFramebuffer;
    pub fn gst_gl_framebuffer_new_with_default_depth(
        context: *mut GstGLContext,
        width: c_uint,
        height: c_uint,
    ) -> *mut GstGLFramebuffer;
    pub fn gst_gl_framebuffer_attach(
        fb: *mut GstGLFramebuffer,
        attachment_point: c_uint,
        mem: *mut GstGLBaseMemory,
    );
    pub fn gst_gl_framebuffer_bind(fb: *mut GstGLFramebuffer);
    pub fn gst_gl_framebuffer_draw_to_texture(
        fb: *mut GstGLFramebuffer,
        mem: *mut GstGLMemory,
        func: GstGLFramebufferFunc,
        user_data: gpointer,
    ) -> gboolean;
    pub fn gst_gl_framebuffer_get_effective_dimensions(
        fb: *mut GstGLFramebuffer,
        width: *mut c_uint,
        height: *mut c_uint,
    );
    pub fn gst_gl_framebuffer_get_id(fb: *mut GstGLFramebuffer) -> c_uint;

    //=========================================================================
    // GstGLMemoryAllocator
    //=========================================================================
    pub fn gst_gl_memory_allocator_get_type() -> GType;
    pub fn gst_gl_memory_allocator_get_default(
        context: *mut GstGLContext,
    ) -> *mut GstGLMemoryAllocator;

    //=========================================================================
    // GstGLMemoryPBOAllocator
    //=========================================================================
    pub fn gst_gl_memory_pbo_allocator_get_type() -> GType;

    //=========================================================================
    // GstGLMixer
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_mixer_get_type() -> GType;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_mixer_get_framebuffer(mix: *mut GstGLMixer) -> *mut GstGLFramebuffer;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_mixer_process_textures(
        mix: *mut GstGLMixer,
        outbuf: *mut gst::GstBuffer,
    ) -> gboolean;

    //=========================================================================
    // GstGLMixerPad
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_mixer_pad_get_type() -> GType;

    //=========================================================================
    // GstGLOverlayCompositor
    //=========================================================================
    pub fn gst_gl_overlay_compositor_get_type() -> GType;
    pub fn gst_gl_overlay_compositor_new(context: *mut GstGLContext)
        -> *mut GstGLOverlayCompositor;
    pub fn gst_gl_overlay_compositor_add_caps(caps: *mut gst::GstCaps) -> *mut gst::GstCaps;
    pub fn gst_gl_overlay_compositor_draw_overlays(compositor: *mut GstGLOverlayCompositor);
    pub fn gst_gl_overlay_compositor_free_overlays(compositor: *mut GstGLOverlayCompositor);
    pub fn gst_gl_overlay_compositor_upload_overlays(
        compositor: *mut GstGLOverlayCompositor,
        buf: *mut gst::GstBuffer,
    );

    //=========================================================================
    // GstGLRenderbufferAllocator
    //=========================================================================
    pub fn gst_gl_renderbuffer_allocator_get_type() -> GType;

    //=========================================================================
    // GstGLSLStage
    //=========================================================================
    pub fn gst_glsl_stage_get_type() -> GType;
    pub fn gst_glsl_stage_new(context: *mut GstGLContext, type_: c_uint) -> *mut GstGLSLStage;
    pub fn gst_glsl_stage_new_default_fragment(context: *mut GstGLContext) -> *mut GstGLSLStage;
    pub fn gst_glsl_stage_new_default_vertex(context: *mut GstGLContext) -> *mut GstGLSLStage;
    pub fn gst_glsl_stage_new_with_string(
        context: *mut GstGLContext,
        type_: c_uint,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
        str: *const c_char,
    ) -> *mut GstGLSLStage;
    pub fn gst_glsl_stage_new_with_strings(
        context: *mut GstGLContext,
        type_: c_uint,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
        n_strings: c_int,
        str: *mut *const c_char,
    ) -> *mut GstGLSLStage;
    pub fn gst_glsl_stage_compile(
        stage: *mut GstGLSLStage,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_glsl_stage_get_handle(stage: *mut GstGLSLStage) -> c_uint;
    pub fn gst_glsl_stage_get_profile(stage: *mut GstGLSLStage) -> GstGLSLProfile;
    pub fn gst_glsl_stage_get_shader_type(stage: *mut GstGLSLStage) -> c_uint;
    pub fn gst_glsl_stage_get_version(stage: *mut GstGLSLStage) -> GstGLSLVersion;
    pub fn gst_glsl_stage_set_strings(
        stage: *mut GstGLSLStage,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
        n_strings: c_int,
        str: *mut *const c_char,
    ) -> gboolean;

    //=========================================================================
    // GstGLShader
    //=========================================================================
    pub fn gst_gl_shader_get_type() -> GType;
    pub fn gst_gl_shader_new(context: *mut GstGLContext) -> *mut GstGLShader;
    pub fn gst_gl_shader_new_default(
        context: *mut GstGLContext,
        error: *mut *mut glib::GError,
    ) -> *mut GstGLShader;
    pub fn gst_gl_shader_new_link_with_stages(
        context: *mut GstGLContext,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut GstGLShader;
    pub fn gst_gl_shader_new_with_stages(
        context: *mut GstGLContext,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut GstGLShader;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_shader_string_fragment_external_oes_get_default(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> *mut c_char;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_shader_string_fragment_get_default(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> *mut c_char;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_shader_string_get_highest_precision(
        context: *mut GstGLContext,
        version: GstGLSLVersion,
        profile: GstGLSLProfile,
    ) -> *const c_char;
    pub fn gst_gl_shader_attach(shader: *mut GstGLShader, stage: *mut GstGLSLStage) -> gboolean;
    pub fn gst_gl_shader_attach_unlocked(
        shader: *mut GstGLShader,
        stage: *mut GstGLSLStage,
    ) -> gboolean;
    pub fn gst_gl_shader_bind_attribute_location(
        shader: *mut GstGLShader,
        index: c_uint,
        name: *const c_char,
    );
    pub fn gst_gl_shader_bind_frag_data_location(
        shader: *mut GstGLShader,
        index: c_uint,
        name: *const c_char,
    );
    pub fn gst_gl_shader_compile_attach_stage(
        shader: *mut GstGLShader,
        stage: *mut GstGLSLStage,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_gl_shader_detach(shader: *mut GstGLShader, stage: *mut GstGLSLStage);
    pub fn gst_gl_shader_detach_unlocked(shader: *mut GstGLShader, stage: *mut GstGLSLStage);
    pub fn gst_gl_shader_get_attribute_location(
        shader: *mut GstGLShader,
        name: *const c_char,
    ) -> c_int;
    pub fn gst_gl_shader_get_program_handle(shader: *mut GstGLShader) -> c_int;
    pub fn gst_gl_shader_is_linked(shader: *mut GstGLShader) -> gboolean;
    pub fn gst_gl_shader_link(shader: *mut GstGLShader, error: *mut *mut glib::GError) -> gboolean;
    pub fn gst_gl_shader_release(shader: *mut GstGLShader);
    pub fn gst_gl_shader_release_unlocked(shader: *mut GstGLShader);
    pub fn gst_gl_shader_set_uniform_1f(
        shader: *mut GstGLShader,
        name: *const c_char,
        value: c_float,
    );
    pub fn gst_gl_shader_set_uniform_1fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_1i(
        shader: *mut GstGLShader,
        name: *const c_char,
        value: c_int,
    );
    pub fn gst_gl_shader_set_uniform_1iv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_int,
    );
    pub fn gst_gl_shader_set_uniform_2f(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_float,
        v1: c_float,
    );
    pub fn gst_gl_shader_set_uniform_2fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_2i(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_int,
        v1: c_int,
    );
    pub fn gst_gl_shader_set_uniform_2iv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_int,
    );
    pub fn gst_gl_shader_set_uniform_3f(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_float,
        v1: c_float,
        v2: c_float,
    );
    pub fn gst_gl_shader_set_uniform_3fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_3i(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_int,
        v1: c_int,
        v2: c_int,
    );
    pub fn gst_gl_shader_set_uniform_3iv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_int,
    );
    pub fn gst_gl_shader_set_uniform_4f(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_float,
        v1: c_float,
        v2: c_float,
        v3: c_float,
    );
    pub fn gst_gl_shader_set_uniform_4fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_4i(
        shader: *mut GstGLShader,
        name: *const c_char,
        v0: c_int,
        v1: c_int,
        v2: c_int,
        v3: c_int,
    );
    pub fn gst_gl_shader_set_uniform_4iv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_uint,
        value: *const c_int,
    );
    pub fn gst_gl_shader_set_uniform_matrix_2fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_2x3fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_2x4fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_3fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_3x2fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_3x4fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_4fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_4x2fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_set_uniform_matrix_4x3fv(
        shader: *mut GstGLShader,
        name: *const c_char,
        count: c_int,
        transpose: gboolean,
        value: *const c_float,
    );
    pub fn gst_gl_shader_use(shader: *mut GstGLShader);

    //=========================================================================
    // GstGLUpload
    //=========================================================================
    pub fn gst_gl_upload_get_type() -> GType;
    pub fn gst_gl_upload_new(context: *mut GstGLContext) -> *mut GstGLUpload;
    pub fn gst_gl_upload_get_input_template_caps() -> *mut gst::GstCaps;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_upload_fixate_caps(
        upload: *mut GstGLUpload,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        othercaps: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;
    pub fn gst_gl_upload_get_caps(
        upload: *mut GstGLUpload,
        in_caps: *mut *mut gst::GstCaps,
        out_caps: *mut *mut gst::GstCaps,
    );
    pub fn gst_gl_upload_perform_with_buffer(
        upload: *mut GstGLUpload,
        buffer: *mut gst::GstBuffer,
        outbuf_ptr: *mut *mut gst::GstBuffer,
    ) -> GstGLUploadReturn;
    pub fn gst_gl_upload_propose_allocation(
        upload: *mut GstGLUpload,
        decide_query: *mut gst::GstQuery,
        query: *mut gst::GstQuery,
    );
    pub fn gst_gl_upload_set_caps(
        upload: *mut GstGLUpload,
        in_caps: *mut gst::GstCaps,
        out_caps: *mut gst::GstCaps,
    ) -> gboolean;
    pub fn gst_gl_upload_set_context(upload: *mut GstGLUpload, context: *mut GstGLContext);
    pub fn gst_gl_upload_transform_caps(
        upload: *mut GstGLUpload,
        context: *mut GstGLContext,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        filter: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;

    //=========================================================================
    // GstGLViewConvert
    //=========================================================================
    pub fn gst_gl_view_convert_get_type() -> GType;
    pub fn gst_gl_view_convert_new() -> *mut GstGLViewConvert;
    pub fn gst_gl_view_convert_fixate_caps(
        viewconvert: *mut GstGLViewConvert,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        othercaps: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;
    pub fn gst_gl_view_convert_get_output(
        viewconvert: *mut GstGLViewConvert,
        outbuf_ptr: *mut *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn;
    pub fn gst_gl_view_convert_perform(
        viewconvert: *mut GstGLViewConvert,
        inbuf: *mut gst::GstBuffer,
    ) -> *mut gst::GstBuffer;
    pub fn gst_gl_view_convert_reset(viewconvert: *mut GstGLViewConvert);
    pub fn gst_gl_view_convert_set_caps(
        viewconvert: *mut GstGLViewConvert,
        in_caps: *mut gst::GstCaps,
        out_caps: *mut gst::GstCaps,
    ) -> gboolean;
    pub fn gst_gl_view_convert_set_context(
        viewconvert: *mut GstGLViewConvert,
        context: *mut GstGLContext,
    );
    pub fn gst_gl_view_convert_submit_input_buffer(
        viewconvert: *mut GstGLViewConvert,
        is_discont: gboolean,
        input: *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn;
    pub fn gst_gl_view_convert_transform_caps(
        viewconvert: *mut GstGLViewConvert,
        direction: gst::GstPadDirection,
        caps: *mut gst::GstCaps,
        filter: *mut gst::GstCaps,
    ) -> *mut gst::GstCaps;

    //=========================================================================
    // GstGLWindow
    //=========================================================================
    pub fn gst_gl_window_get_type() -> GType;
    pub fn gst_gl_window_new(display: *mut GstGLDisplay) -> *mut GstGLWindow;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_gl_window_controls_viewport(window: *mut GstGLWindow) -> gboolean;
    pub fn gst_gl_window_draw(window: *mut GstGLWindow);
    pub fn gst_gl_window_get_context(window: *mut GstGLWindow) -> *mut GstGLContext;
    pub fn gst_gl_window_get_display(window: *mut GstGLWindow) -> uintptr_t;
    pub fn gst_gl_window_get_surface_dimensions(
        window: *mut GstGLWindow,
        width: *mut c_uint,
        height: *mut c_uint,
    );
    pub fn gst_gl_window_get_window_handle(window: *mut GstGLWindow) -> uintptr_t;
    pub fn gst_gl_window_handle_events(window: *mut GstGLWindow, handle_events: gboolean);
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_window_has_output_surface(window: *mut GstGLWindow) -> gboolean;
    pub fn gst_gl_window_queue_resize(window: *mut GstGLWindow);
    pub fn gst_gl_window_quit(window: *mut GstGLWindow);
    pub fn gst_gl_window_resize(window: *mut GstGLWindow, width: c_uint, height: c_uint);
    pub fn gst_gl_window_run(window: *mut GstGLWindow);
    pub fn gst_gl_window_send_key_event(
        window: *mut GstGLWindow,
        event_type: *const c_char,
        key_str: *const c_char,
    );
    pub fn gst_gl_window_send_message(
        window: *mut GstGLWindow,
        callback: GstGLWindowCB,
        data: gpointer,
    );
    pub fn gst_gl_window_send_message_async(
        window: *mut GstGLWindow,
        callback: GstGLWindowCB,
        data: gpointer,
        destroy: glib::GDestroyNotify,
    );
    pub fn gst_gl_window_send_mouse_event(
        window: *mut GstGLWindow,
        event_type: *const c_char,
        button: c_int,
        posx: c_double,
        posy: c_double,
    );
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_gl_window_send_scroll_event(
        window: *mut GstGLWindow,
        posx: c_double,
        posy: c_double,
        delta_x: c_double,
        delta_y: c_double,
    );
    pub fn gst_gl_window_set_close_callback(
        window: *mut GstGLWindow,
        callback: GstGLWindowCB,
        data: gpointer,
        destroy_notify: glib::GDestroyNotify,
    );
    pub fn gst_gl_window_set_draw_callback(
        window: *mut GstGLWindow,
        callback: GstGLWindowCB,
        data: gpointer,
        destroy_notify: glib::GDestroyNotify,
    );
    pub fn gst_gl_window_set_preferred_size(window: *mut GstGLWindow, width: c_int, height: c_int);
    pub fn gst_gl_window_set_render_rectangle(
        window: *mut GstGLWindow,
        x: c_int,
        y: c_int,
        width: c_int,
        height: c_int,
    ) -> gboolean;
    pub fn gst_gl_window_set_resize_callback(
        window: *mut GstGLWindow,
        callback: GstGLWindowResizeCB,
        data: gpointer,
        destroy_notify: glib::GDestroyNotify,
    );
    pub fn gst_gl_window_set_window_handle(window: *mut GstGLWindow, handle: uintptr_t);
    pub fn gst_gl_window_show(window: *mut GstGLWindow);

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_buffer_add_gl_sync_meta(
        context: *mut GstGLContext,
        buffer: *mut gst::GstBuffer,
    ) -> *mut GstGLSyncMeta;
    pub fn gst_buffer_add_gl_sync_meta_full(
        context: *mut GstGLContext,
        buffer: *mut gst::GstBuffer,
        data: gpointer,
    ) -> *mut GstGLSyncMeta;
    pub fn gst_buffer_pool_config_get_gl_allocation_params(
        config: *mut gst::GstStructure,
    ) -> *mut GstGLAllocationParams;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_buffer_pool_config_get_gl_min_free_queue_size(
        config: *mut gst::GstStructure,
    ) -> c_uint;
    pub fn gst_buffer_pool_config_set_gl_allocation_params(
        config: *mut gst::GstStructure,
        params: *const GstGLAllocationParams,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_buffer_pool_config_set_gl_min_free_queue_size(
        config: *mut gst::GstStructure,
        queue_size: c_uint,
    );
    pub fn gst_context_get_gl_display(
        context: *mut gst::GstContext,
        display: *mut *mut GstGLDisplay,
    ) -> gboolean;
    pub fn gst_context_set_gl_display(context: *mut gst::GstContext, display: *mut GstGLDisplay);
    pub fn gst_gl_check_extension(name: *const c_char, ext: *const c_char) -> gboolean;
    pub fn gst_gl_element_propagate_display_context(
        element: *mut gst::GstElement,
        display: *mut GstGLDisplay,
    );
    pub fn gst_gl_ensure_element_data(
        element: *mut gst::GstElement,
        display_ptr: *mut *mut GstGLDisplay,
        other_context_ptr: *mut *mut GstGLContext,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_get_affine_transformation_meta_as_ndc(
        meta: *mut gst_video::GstVideoAffineTransformationMeta,
        matrix: *mut [c_float; 16],
    );
    pub fn gst_gl_get_plane_data_size(
        info: *const gst_video::GstVideoInfo,
        align: *const gst_video::GstVideoAlignment,
        plane: c_uint,
    ) -> size_t;
    pub fn gst_gl_get_plane_start(
        info: *const gst_video::GstVideoInfo,
        valign: *const gst_video::GstVideoAlignment,
        plane: c_uint,
    ) -> size_t;
    pub fn gst_gl_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        display: *mut GstGLDisplay,
        context: *mut GstGLContext,
        other_context: *mut GstGLContext,
    ) -> gboolean;
    pub fn gst_gl_handle_set_context(
        element: *mut gst::GstElement,
        context: *mut gst::GstContext,
        display: *mut *mut GstGLDisplay,
        other_context: *mut *mut GstGLContext,
    ) -> gboolean;
    pub fn gst_gl_insert_debug_marker(context: *mut GstGLContext, format: *const c_char, ...);
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_multiply_matrix4(
        a: *const [c_float; 16],
        b: *const [c_float; 16],
        result: *mut [c_float; 16],
    );
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_gl_set_affine_transformation_meta_from_ndc(
        meta: *mut gst_video::GstVideoAffineTransformationMeta,
        matrix: *const [c_float; 16],
    );
    pub fn gst_gl_sized_gl_format_from_gl_format_type(
        context: *mut GstGLContext,
        format: c_uint,
        type_: c_uint,
    ) -> c_uint;
    pub fn gst_gl_stereo_downmix_mode_get_type() -> GType;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_swizzle_invert(swizzle: *mut [c_int; 4], inversion: *mut [c_int; 4]);
    pub fn gst_gl_sync_meta_api_get_type() -> GType;
    pub fn gst_gl_value_get_texture_target_mask(
        value: *const gobject::GValue,
    ) -> GstGLTextureTarget;
    pub fn gst_gl_value_set_texture_target(
        value: *mut gobject::GValue,
        target: GstGLTextureTarget,
    ) -> gboolean;
    pub fn gst_gl_value_set_texture_target_from_mask(
        value: *mut gobject::GValue,
        target_mask: GstGLTextureTarget,
    ) -> gboolean;
    pub fn gst_gl_version_to_glsl_version(
        gl_api: GstGLAPI,
        maj: c_int,
        min: c_int,
    ) -> GstGLSLVersion;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_gl_video_format_swizzle(
        video_format: gst_video::GstVideoFormat,
        swizzle: *mut [c_int; 4],
    ) -> gboolean;
    pub fn gst_glsl_string_get_version_profile(
        s: *const c_char,
        version: *mut GstGLSLVersion,
        profile: *mut GstGLSLProfile,
    ) -> gboolean;
    pub fn gst_is_gl_base_memory(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_gl_buffer(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_gl_memory(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_gl_memory_pbo(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_gl_renderbuffer(mem: *mut gst::GstMemory) -> gboolean;

}
