// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, Container, DestDefaults, IconSize, Orientable, Orientation,
    ResizeMode, Scrollable, ScrollablePolicy, SelectionData, TargetEntry, ToolItem, ToolItemGroup,
    ToolPaletteDragTargets, ToolbarStyle, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkToolPalette")]
    pub struct ToolPalette(Object<ffi::GtkToolPalette, ffi::GtkToolPaletteClass>) @extends Container, Widget, @implements Buildable, Orientable, Scrollable;

    match fn {
        type_ => || ffi::gtk_tool_palette_get_type(),
    }
}

impl ToolPalette {
    pub const NONE: Option<&'static ToolPalette> = None;

    #[doc(alias = "gtk_tool_palette_new")]
    pub fn new() -> ToolPalette {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_tool_palette_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ToolPalette`] objects.
    ///
    /// This method returns an instance of [`ToolPaletteBuilder`](crate::builders::ToolPaletteBuilder) which can be used to create [`ToolPalette`] objects.
    pub fn builder() -> ToolPaletteBuilder {
        ToolPaletteBuilder::new()
    }

    #[doc(alias = "gtk_tool_palette_get_drag_target_group")]
    #[doc(alias = "get_drag_target_group")]
    pub fn drag_target_group() -> Option<TargetEntry> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_tool_palette_get_drag_target_group()) }
    }

    #[doc(alias = "gtk_tool_palette_get_drag_target_item")]
    #[doc(alias = "get_drag_target_item")]
    pub fn drag_target_item() -> Option<TargetEntry> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_tool_palette_get_drag_target_item()) }
    }
}

impl Default for ToolPalette {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ToolPalette`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ToolPaletteBuilder {
    builder: glib::object::ObjectBuilder<'static, ToolPalette>,
}

impl ToolPaletteBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn icon_size(self, icon_size: IconSize) -> Self {
        Self {
            builder: self.builder.property("icon-size", icon_size),
        }
    }

    pub fn icon_size_set(self, icon_size_set: bool) -> Self {
        Self {
            builder: self.builder.property("icon-size-set", icon_size_set),
        }
    }

    pub fn toolbar_style(self, toolbar_style: ToolbarStyle) -> Self {
        Self {
            builder: self.builder.property("toolbar-style", toolbar_style),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn orientation(self, orientation: Orientation) -> Self {
        Self {
            builder: self.builder.property("orientation", orientation),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ToolPalette`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ToolPalette {
        self.builder.build()
    }
}

pub trait ToolPaletteExt: 'static {
    #[doc(alias = "gtk_tool_palette_add_drag_dest")]
    fn add_drag_dest(
        &self,
        widget: &impl IsA<Widget>,
        flags: DestDefaults,
        targets: ToolPaletteDragTargets,
        actions: gdk::DragAction,
    );

    #[doc(alias = "gtk_tool_palette_get_drag_item")]
    #[doc(alias = "get_drag_item")]
    fn drag_item(&self, selection: &SelectionData) -> Option<Widget>;

    #[doc(alias = "gtk_tool_palette_get_drop_group")]
    #[doc(alias = "get_drop_group")]
    fn drop_group(&self, x: i32, y: i32) -> Option<ToolItemGroup>;

    #[doc(alias = "gtk_tool_palette_get_drop_item")]
    #[doc(alias = "get_drop_item")]
    fn drop_item(&self, x: i32, y: i32) -> Option<ToolItem>;

    #[doc(alias = "gtk_tool_palette_get_exclusive")]
    #[doc(alias = "get_exclusive")]
    fn is_exclusive(&self, group: &impl IsA<ToolItemGroup>) -> bool;

    #[doc(alias = "gtk_tool_palette_get_expand")]
    #[doc(alias = "get_expand")]
    fn expands(&self, group: &impl IsA<ToolItemGroup>) -> bool;

    #[doc(alias = "gtk_tool_palette_get_group_position")]
    #[doc(alias = "get_group_position")]
    fn group_position(&self, group: &impl IsA<ToolItemGroup>) -> i32;

    #[doc(alias = "gtk_tool_palette_get_icon_size")]
    #[doc(alias = "get_icon_size")]
    fn icon_size(&self) -> IconSize;

    #[doc(alias = "gtk_tool_palette_get_style")]
    #[doc(alias = "get_style")]
    fn style(&self) -> ToolbarStyle;

    #[doc(alias = "gtk_tool_palette_set_drag_source")]
    fn set_drag_source(&self, targets: ToolPaletteDragTargets);

    #[doc(alias = "gtk_tool_palette_set_exclusive")]
    fn set_exclusive(&self, group: &impl IsA<ToolItemGroup>, exclusive: bool);

    #[doc(alias = "gtk_tool_palette_set_expand")]
    fn set_expand(&self, group: &impl IsA<ToolItemGroup>, expand: bool);

    #[doc(alias = "gtk_tool_palette_set_group_position")]
    fn set_group_position(&self, group: &impl IsA<ToolItemGroup>, position: i32);

    #[doc(alias = "gtk_tool_palette_set_icon_size")]
    fn set_icon_size(&self, icon_size: IconSize);

    #[doc(alias = "gtk_tool_palette_set_style")]
    fn set_style(&self, style: ToolbarStyle);

    #[doc(alias = "gtk_tool_palette_unset_icon_size")]
    fn unset_icon_size(&self);

    #[doc(alias = "gtk_tool_palette_unset_style")]
    fn unset_style(&self);

    #[doc(alias = "icon-size-set")]
    fn is_icon_size_set(&self) -> bool;

    #[doc(alias = "icon-size-set")]
    fn set_icon_size_set(&self, icon_size_set: bool);

    #[doc(alias = "toolbar-style")]
    fn toolbar_style(&self) -> ToolbarStyle;

    #[doc(alias = "toolbar-style")]
    fn set_toolbar_style(&self, toolbar_style: ToolbarStyle);

    #[doc(alias = "icon-size")]
    fn connect_icon_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-size-set")]
    fn connect_icon_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "toolbar-style")]
    fn connect_toolbar_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ToolPalette>> ToolPaletteExt for O {
    fn add_drag_dest(
        &self,
        widget: &impl IsA<Widget>,
        flags: DestDefaults,
        targets: ToolPaletteDragTargets,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_tool_palette_add_drag_dest(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                flags.into_glib(),
                targets.into_glib(),
                actions.into_glib(),
            );
        }
    }

    fn drag_item(&self, selection: &SelectionData) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_tool_palette_get_drag_item(
                self.as_ref().to_glib_none().0,
                selection.to_glib_none().0,
            ))
        }
    }

    fn drop_group(&self, x: i32, y: i32) -> Option<ToolItemGroup> {
        unsafe {
            from_glib_none(ffi::gtk_tool_palette_get_drop_group(
                self.as_ref().to_glib_none().0,
                x,
                y,
            ))
        }
    }

    fn drop_item(&self, x: i32, y: i32) -> Option<ToolItem> {
        unsafe {
            from_glib_none(ffi::gtk_tool_palette_get_drop_item(
                self.as_ref().to_glib_none().0,
                x,
                y,
            ))
        }
    }

    fn is_exclusive(&self, group: &impl IsA<ToolItemGroup>) -> bool {
        unsafe {
            from_glib(ffi::gtk_tool_palette_get_exclusive(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
            ))
        }
    }

    fn expands(&self, group: &impl IsA<ToolItemGroup>) -> bool {
        unsafe {
            from_glib(ffi::gtk_tool_palette_get_expand(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
            ))
        }
    }

    fn group_position(&self, group: &impl IsA<ToolItemGroup>) -> i32 {
        unsafe {
            ffi::gtk_tool_palette_get_group_position(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
            )
        }
    }

    fn icon_size(&self) -> IconSize {
        unsafe {
            from_glib(ffi::gtk_tool_palette_get_icon_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn style(&self) -> ToolbarStyle {
        unsafe {
            from_glib(ffi::gtk_tool_palette_get_style(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_drag_source(&self, targets: ToolPaletteDragTargets) {
        unsafe {
            ffi::gtk_tool_palette_set_drag_source(
                self.as_ref().to_glib_none().0,
                targets.into_glib(),
            );
        }
    }

    fn set_exclusive(&self, group: &impl IsA<ToolItemGroup>, exclusive: bool) {
        unsafe {
            ffi::gtk_tool_palette_set_exclusive(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
                exclusive.into_glib(),
            );
        }
    }

    fn set_expand(&self, group: &impl IsA<ToolItemGroup>, expand: bool) {
        unsafe {
            ffi::gtk_tool_palette_set_expand(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
                expand.into_glib(),
            );
        }
    }

    fn set_group_position(&self, group: &impl IsA<ToolItemGroup>, position: i32) {
        unsafe {
            ffi::gtk_tool_palette_set_group_position(
                self.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    fn set_icon_size(&self, icon_size: IconSize) {
        unsafe {
            ffi::gtk_tool_palette_set_icon_size(
                self.as_ref().to_glib_none().0,
                icon_size.into_glib(),
            );
        }
    }

    fn set_style(&self, style: ToolbarStyle) {
        unsafe {
            ffi::gtk_tool_palette_set_style(self.as_ref().to_glib_none().0, style.into_glib());
        }
    }

    fn unset_icon_size(&self) {
        unsafe {
            ffi::gtk_tool_palette_unset_icon_size(self.as_ref().to_glib_none().0);
        }
    }

    fn unset_style(&self) {
        unsafe {
            ffi::gtk_tool_palette_unset_style(self.as_ref().to_glib_none().0);
        }
    }

    fn is_icon_size_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "icon-size-set")
    }

    fn set_icon_size_set(&self, icon_size_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "icon-size-set", icon_size_set)
    }

    fn toolbar_style(&self) -> ToolbarStyle {
        glib::ObjectExt::property(self.as_ref(), "toolbar-style")
    }

    fn set_toolbar_style(&self, toolbar_style: ToolbarStyle) {
        glib::ObjectExt::set_property(self.as_ref(), "toolbar-style", toolbar_style)
    }

    fn connect_icon_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_size_trampoline<
            P: IsA<ToolPalette>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkToolPalette,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ToolPalette::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_size_set_trampoline<
            P: IsA<ToolPalette>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkToolPalette,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ToolPalette::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_toolbar_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_toolbar_style_trampoline<
            P: IsA<ToolPalette>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkToolPalette,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ToolPalette::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::toolbar-style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_toolbar_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for ToolPalette {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ToolPalette")
    }
}
