C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.
         SUBROUTINE  OED__RYS_5_ROOTS_WEIGHTS
     +
     +                    ( NT,NTGQP,
     +                      TVAL,
     +
     +                             RTS,
     +                             WTS )
     +
C------------------------------------------------------------------------
C  OPERATION   : OED__RYS_5_ROOTS_WEIGHTS
C  MODULE      : ONE ELECTRON INTEGRALS DIRECT
C  MODULE-ID   : OED
C  SUBROUTINES : none
C  DESCRIPTION : This operation returns Rys polynomial roots and weights
C                in case the number of roots and weights required
C                is = 5. All T's are treated at once so the complete
C                set of roots and weights is returned.
C
C                For the moment taken essentially unchanged from the
C                GAMESS package (routine ROOT5, but removing their
C                'spaghetti' code from the 70's of unreadable
C                internested IFs and GOTOs!).
C
C                One interesting aspect of the GAMESS routines is that
C                their code returns scaled roots, i.e. their roots
C                do not ly between the range 0 and 1. To get to the
C                proper roots as needed for our package, we simply
C                set:
C
C                   root (our) = root (gamess) / (1 + root (games))
C
C
C                  Input:
C
C                    NT           =  # of T-exponents
C                    NTGQP        =  # of roots times # of T-exponents
C                                    (= 5 * NT)
C                    TVAL         =  the set of NT T-exponents defining
C                                    the Rys weight functions
C
C                  Output:
C
C                    RTS          =  all NTGQP quadrature roots
C                    WTS          =  all NTGQP quadrature weights
C
C
C  AUTHOR      : Norbert Flocke
C------------------------------------------------------------------------
C
C
C             ...include files and declare variables.
C
C
         IMPLICIT   NONE

         INTEGER    M,N
         INTEGER    NT,NTGQP
         INTEGER    TCASE

         INTEGER    JUMP5 (1:60)

         DOUBLE PRECISION   E,T,X
         DOUBLE PRECISION   PI4
         DOUBLE PRECISION   R1,R2,R3,R4,R5
         DOUBLE PRECISION   R15,R25,R35,R45,R55
         DOUBLE PRECISION   T5MAX
         DOUBLE PRECISION   W1,W2,W3,W4,W5
         DOUBLE PRECISION   W25,W35,W45,W55
         DOUBLE PRECISION   HALF,ONE,THREE,
     +                      HALFP7,HALFP12,HALFP17,HALFP22

         DOUBLE PRECISION   TVAL (1:NT)
         DOUBLE PRECISION   RTS  (1:NTGQP)
         DOUBLE PRECISION   WTS  (1:NTGQP)

         PARAMETER  (R15 = 1.17581320211778D-01)
         PARAMETER  (R25 = 1.07456201243690D+00)
         PARAMETER  (R35 = 3.08593744371754D+00)
         PARAMETER  (R45 = 6.41472973366203D+00)
         PARAMETER  (R55 = 1.18071894899717D+01)

         PARAMETER  (W25 = 2.70967405960535D-01)
         PARAMETER  (W35 = 3.82231610015404D-02)
         PARAMETER  (W45 = 1.51614186862443D-03)
         PARAMETER  (W55 = 8.62130526143657D-06)

         PARAMETER  (PI4 = 7.85398163397448D-01)

         PARAMETER  (T5MAX = 60.D0)

         PARAMETER  (HALF    = 0.5D0)
         PARAMETER  (ONE     = 1.D0)
         PARAMETER  (THREE   = 3.D0)
         PARAMETER  (HALFP7  = 7.5D0)
         PARAMETER  (HALFP12 = 12.5D0)
         PARAMETER  (HALFP17 = 17.5D0)
         PARAMETER  (HALFP22 = 22.5D0)

         DATA  JUMP5  /1,2,2,2,2,3,3,3,3,3,
     +                 4,4,4,4,4,5,5,5,5,5,
     +                 6,6,6,6,6,7,7,7,7,7,
     +                 7,7,7,7,7,7,7,7,7,7,
     +                 8,8,8,8,8,8,8,8,8,8,
     +                 8,8,8,8,8,8,8,8,8,9/
C
C
C------------------------------------------------------------------------
C
C
C                 ********************************
C             ... *  # of roots and weights = 5  *
C                 ********************************
C
C
      M = 1

      DO 500 N = 1,NT

         T = TVAL (N)

         IF (T. LE. 3.0D-07) THEN
C
C
C             ...T-range: T essentially 0
C
C
             R1 = 2.26659266316985D-02 - 2.15865967920897D-03 * T
             R2 = 2.31271692140903D-01 - 2.20258754389745D-02 * T
             R3 = 8.57346024118836D-01 - 8.16520023025515D-02 * T
             R4 = 2.97353038120346D+00 - 2.83193369647137D-01 * T
             R5 = 1.84151859759051D+01 - 1.75382723579439D+00 * T

             WTS (M)   = 2.95524224714752D-01 - 1.96867576909777D-02 * T
             WTS (M+1) = 2.69266719309995D-01 - 5.61737590184721D-02 * T
             WTS (M+2) = 2.19086362515981D-01 - 9.71152726793658D-02 * T
             WTS (M+3) = 1.49451349150580D-01 - 1.02979262193565D-01 * T
             WTS (M+4) = 6.66713443086877D-02 - 5.73782817488315D-02 * T

             RTS (M)   = R1 / (ONE + R1)
             RTS (M+1) = R2 / (ONE + R2)
             RTS (M+2) = R3 / (ONE + R3)
             RTS (M+3) = R4 / (ONE + R4)
             RTS (M+4) = R5 / (ONE + R5)

             M = M + 5

             GOTO 500
         END IF

         TCASE = INT ( MIN (T+ONE,T5MAX))

         GOTO (5100,5200,5300,5400,
     +         5500,5600,5700,5800,5900) JUMP5 (TCASE)
C
C
C             ...T-range: 0 < T < 1
C
C
 5100    WTS (M) = ((((((-2.03822632771791D-09  * T
     +                   +3.89110229133810D-08) * T
     +                   -5.84914787904823D-07) * T
     +                   +8.30316168666696D-06) * T
     +                   -1.13218402310546D-04) * T
     +                   +1.49128888586790D-03) * T
     +                   -1.96867576904816D-02) * T
     +                   +2.95524224714749D-01

         WTS (M+1) = ((((((( 8.62848118397570D-09  * T
     +                      -1.38975551148989D-07) * T
     +                      +1.602894068228D-06)   * T
     +                      -1.646364300836D-05)   * T
     +                      +1.538445806778D-04)   * T
     +                      -1.28848868034502D-03) * T
     +                      +9.38866933338584D-03) * T
     +                      -5.61737590178812D-02) * T
     +                      +2.69266719309991D-01

         WTS (M+2) = ((((((((-9.41953204205665D-09  * T
     +                       +1.47452251067755D-07) * T
     +                       -1.57456991199322D-06) * T
     +                       +1.45098401798393D-05) * T
     +                       -1.18858834181513D-04) * T
     +                       +8.53697675984210D-04) * T
     +                       -5.22877807397165D-03) * T
     +                       +2.60854524809786D-02) * T
     +                       -9.71152726809059D-02) * T
     +                       +2.19086362515979D-01

         WTS (M+3) = ((((((((-3.84961617022042D-08  * T
     +                       +5.66595396544470D-07) * T
     +                       -5.52351805403748D-06) * T
     +                       +4.53160377546073D-05) * T
     +                       -3.22542784865557D-04) * T
     +                       +1.95682017370967D-03) * T
     +                       -9.77232537679229D-03) * T
     +                       +3.79455945268632D-02) * T
     +                       -1.02979262192227D-01) * T
     +                       +1.49451349150573D-01

         WTS (M+4) = ((((((((( 4.09594812521430D-09  * T
     +                        -6.47097874264417D-08) * T
     +                        +6.743541482689D-07)   * T
     +                        -5.917993920224D-06)   * T
     +                        +4.531969237381D-05)   * T
     +                        -2.99102856679638D-04) * T
     +                        +1.65695765202643D-03) * T
     +                        -7.40671222520653D-03) * T
     +                        +2.50889946832192D-02) * T
     +                        -5.73782817487958D-02) * T
     +                        +6.66713443086877D-02

         R1      = ((((((-4.46679165328413D-11  * T
     +                   +1.21879111988031D-09) * T
     +                   -2.62975022612104D-08) * T
     +                   +5.15106194905897D-07) * T
     +                   -9.27933625824749D-06) * T
     +                   +1.51794097682482D-04) * T
     +                   -2.15865967920301D-03) * T
     +                   +2.26659266316985D-02

         R2        = (((((( 1.93117331714174D-10  * T
     +                     -4.57267589660699D-09) * T
     +                     +2.48339908218932D-08) * T
     +                     +1.50716729438474D-06) * T
     +                     -6.07268757707381D-05) * T
     +                     +1.37506939145643D-03) * T
     +                     -2.20258754419939D-02) * T
     +                     +2.31271692140905D-01

         R3        = ((((( 4.84989776180094D-09  * T
     +                    +1.31538893944284D-07) * T
     +                    -2.766753852879D-06)   * T
     +                    -7.651163510626D-05)   * T
     +                    +4.033058545972D-03)   * T
     +                    -8.16520022916145D-02) * T
     +                    +8.57346024118779D-01

         R4        = ((((-2.48581772214623D-07  * T
     +                   -4.34482635782585D-06) * T
     +                   -7.46018257987630D-07) * T
     +                   +1.01210776517279D-02) * T
     +                   -2.83193369640005D-01) * T
     +                   +2.97353038120345D+00

         R5        = (((((-8.92432153868554D-09  * T
     +                    +1.77288899268988D-08) * T
     +                    +3.040754680666D-06)   * T
     +                    +1.058229325071D-04)   * T
     +                    +4.596379534985D-02)   * T
     +                    -1.75382723579114D+00) * T
     +                    +1.84151859759049D+01

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 1 =< T < 5
C
C
 5200    X = T - THREE

         WTS (M) = ((((((((( 1.04348658616398D-13  * X
     +                      -1.94147461891055D-12) * X
     +                      +3.485512360993D-11)   * X
     +                      -6.277497362235D-10)   * X
     +                      +1.100758247388D-08)   * X
     +                      -1.88329804969573D-07) * X
     +                      +3.12338120839468D-06) * X
     +                      -5.04404167403568D-05) * X
     +                      +8.00338056610995D-04) * X
     +                      -1.30892406559521D-02) * X
     +                      +2.47383140241103D-01

         WTS (M+1) = ((((((((((( 3.23496149760478D-14  * X
     +                          -5.24314473469311D-13) * X
     +                          +7.743219385056D-12)   * X
     +                          -1.146022750992D-10)   * X
     +                          +1.615238462197D-09)   * X
     +                          -2.15479017572233D-08) * X
     +                          +2.70933462557631D-07) * X
     +                          -3.18750295288531D-06) * X
     +                          +3.47425221210099D-05) * X
     +                          -3.45558237388223D-04) * X
     +                          +3.05779768191621D-03) * X
     +                          -2.29118251223003D-02) * X
     +                          +1.59834227924213D-01

         WTS (M+2) = ((((((((((((-3.42790561802876D-14  * X
     +                           +5.26475736681542D-13) * X
     +                           -7.184330797139D-12)   * X
     +                           +9.763932908544D-11)   * X
     +                           -1.244014559219D-09)   * X
     +                           +1.472744068942D-08)   * X
     +                           -1.611749975234D-07)   * X
     +                           +1.616487851917D-06)   * X
     +                           -1.46852359124154D-05) * X
     +                           +1.18900349101069D-04) * X
     +                           -8.37562373221756D-04) * X
     +                           +4.93752683045845D-03) * X
     +                           -2.25514728915673D-02) * X
     +                           +6.95211812453929D-02

         WTS (M+3) = ((((((((((((( 1.04072340345039D-14  * X
     +                            -1.60808044529211D-13) * X
     +                            +2.183534866798D-12)   * X
     +                            -2.939403008391D-11)   * X
     +                            +3.679254029085D-10)   * X
     +                            -4.23775673047899D-09) * X
     +                            +4.46559231067006D-08) * X
     +                            -4.26488836563267D-07) * X
     +                            +3.64721335274973D-06) * X
     +                            -2.74868382777722D-05) * X
     +                            +1.78586118867488D-04) * X
     +                            -9.68428981886534D-04) * X
     +                            +4.16002324339929D-03) * X
     +                            -1.28290192663141D-02) * X
     +                            +2.22353727685016D-02

         WTS (M+4) = ((((((((((((((-8.16770412525963D-16  * X
     +                             +1.31376515047977D-14) * X
     +                             -1.856950818865D-13)   * X
     +                             +2.596836515749D-12)   * X
     +                             -3.372639523006D-11)   * X
     +                             +4.025371849467D-10)   * X
     +                             -4.389453269417D-09)   * X
     +                             +4.332753856271D-08)   * X
     +                             -3.82673275931962D-07) * X
     +                             +2.98006900751543D-06) * X
     +                             -2.00718990300052D-05) * X
     +                             +1.13876001386361D-04) * X
     +                             -5.23627942443563D-04) * X
     +                             +1.83524565118203D-03) * X
     +                             -4.37785737450783D-03) * X
     +                             +5.36963805223095D-03

         R1      = ((((((((-2.58163897135138D-14  * X
     +                     +8.14127461488273D-13) * X
     +                     -2.11414838976129D-11) * X
     +                     +5.09822003260014D-10) * X
     +                     -1.16002134438663D-08) * X
     +                     +2.46810694414540D-07) * X
     +                     -4.92556826124502D-06) * X
     +                     +9.02580687971053D-05) * X
     +                     -1.45190025120726D-03) * X
     +                     +1.73416786387475D-02

         R2        = ((((((((( 1.04525287289788D-14  * X
     +                        +5.44611782010773D-14) * X
     +                        -4.831059411392D-12)   * X
     +                        +1.136643908832D-10)   * X
     +                        -1.104373076913D-09)   * X
     +                        -2.35346740649916D-08) * X
     +                        +1.43772622028764D-06) * X
     +                        -4.23405023015273D-05) * X
     +                        +9.12034574793379D-04) * X
     +                        -1.52479441718739D-02) * X
     +                        +1.76055265928744D-01

         R3        = (((((((((-6.89693150857911D-14  * X
     +                        +5.92064260918861D-13) * X
     +                        +1.847170956043D-11)   * X
     +                        -3.390752744265D-10)   * X
     +                        -2.995532064116D-09)   * X
     +                        +1.57456141058535D-07) * X
     +                        -3.95859409711346D-07) * X
     +                        -9.58924580919747D-05) * X
     +                        +3.23551502557785D-03) * X
     +                        -5.97587007636479D-02) * X
     +                        +6.46432853383057D-01

         R4        = ((((((((-3.61293809667763D-12  * X
     +                       -2.70803518291085D-11) * X
     +                       +8.83758848468769D-10) * X
     +                       +1.59166632851267D-08) * X
     +                       -1.32581997983422D-07) * X
     +                       -7.60223407443995D-06) * X
     +                       -7.41019244900952D-05) * X
     +                       +9.81432631743423D-03) * X
     +                       -2.23055570487771D-01) * X
     +                       +2.21460798080643D+00

         R5        = ((((((((( 7.12332088345321D-13  * X
     +                        +3.16578501501894D-12) * X
     +                        -8.776668218053D-11)   * X
     +                        -2.342817613343D-09)   * X
     +                        -3.496962018025D-08)   * X
     +                        -3.03172870136802D-07) * X
     +                        +1.50511293969805D-06) * X
     +                        +1.37704919387696D-04) * X
     +                        +4.70723869619745D-02) * X
     +                        -1.47486623003693D+00) * X
     +                        +1.35704792175847D+01

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 5 =< T < 10
C
C
 5300    X = T - HALFP7

         WTS (M) = ((((((((( 7.95526040108997D-15  * X
     +                      -2.48593096128045D-13) * X
     +                      +4.761246208720D-12)   * X
     +                      -9.535763686605D-11)   * X
     +                      +2.225273630974D-09)   * X
     +                      -4.49796778054865D-08) * X
     +                      +9.17812870287386D-07) * X
     +                      -1.86764236490502D-05) * X
     +                      +3.76807779068053D-04) * X
     +                      -8.10456360143408D-03) * X
     +                      +2.01097936411496D-01

         WTS (M+1) = ((((((((((( 1.25678686624734D-15  * X
     +                          -2.34266248891173D-14) * X
     +                          +3.973252415832D-13)   * X
     +                          -6.830539401049D-12)   * X
     +                          +1.140771033372D-10)   * X
     +                          -1.82546185762009D-09) * X
     +                          +2.77209637550134D-08) * X
     +                          -4.01726946190383D-07) * X
     +                          +5.48227244014763D-06) * X
     +                          -6.95676245982121D-05) * X
     +                          +8.05193921815776D-04) * X
     +                          -8.15528438784469D-03) * X
     +                          +9.71769901268114D-02

         WTS (M+2) = ((((((((((((-8.20929494859896D-16  * X
     +                           +1.37356038393016D-14) * X
     +                           -2.022863065220D-13)   * X
     +                           +3.058055403795D-12)   * X
     +                           -4.387890955243D-11)   * X
     +                           +5.923946274445D-10)   * X
     +                           -7.503659964159D-09)   * X
     +                           +8.851599803902D-08)   * X
     +                           -9.65561998415038D-07) * X
     +                           +9.60884622778092D-06) * X
     +                           -8.56551787594404D-05) * X
     +                           +6.66057194311179D-04) * X
     +                           -4.17753183902198D-03) * X
     +                           +2.25443826852447D-02

         WTS (M+3) = ((((((((((((((-1.08764612488790D-17  * X
     +                             +1.85299909689937D-16) * X
     +                             -2.730195628655D-15)   * X
     +                             +4.127368817265D-14)   * X
     +                             -5.881379088074D-13)   * X
     +                             +7.805245193391D-12)   * X
     +                             -9.632707991704D-11)   * X
     +                             +1.099047050624D-09)   * X
     +                             -1.15042731790748D-08) * X
     +                             +1.09415155268932D-07) * X
     +                             -9.33687124875935D-07) * X
     +                             +7.02338477986218D-06) * X
     +                             -4.53759748787756D-05) * X
     +                             +2.41722511389146D-04) * X
     +                             -9.75935943447037D-04) * X
     +                             +2.57520532789644D-03

         WTS (M+4) = ((((((((((((((( 7.28996979748849D-19  * X
     +                              -1.26518146195173D-17) * X
     +                              +1.886145834486D-16)   * X
     +                              -2.876728287383D-15)   * X
     +                              +4.114588668138D-14)   * X
     +                              -5.44436631413933D-13) * X
     +                              +6.64976446790959D-12) * X
     +                              -7.44560069974940D-11) * X
     +                              +7.57553198166848D-10) * X
     +                              -6.92956101109829D-09) * X
     +                              +5.62222859033624D-08) * X
     +                              -3.97500114084351D-07) * X
     +                              +2.39039126138140D-06) * X
     +                              -1.18023950002105D-05) * X
     +                              +4.52254031046244D-05) * X
     +                              -1.21113782150370D-04) * X
     +                              +1.75013126731224D-04

         R1      = ((((((((-1.13825201010775D-14  * X
     +                     +1.89737681670375D-13) * X
     +                     -4.81561201185876D-12) * X
     +                     +1.56666512163407D-10) * X
     +                     -3.73782213255083D-09) * X
     +                     +9.15858355075147D-08) * X
     +                     -2.13775073585629D-06) * X
     +                     +4.56547356365536D-05) * X
     +                     -8.68003909323740D-04) * X
     +                     +1.22703754069176D-02

         R2        = (((((((((-3.67160504428358D-15  * X
     +                        +1.27876280158297D-14) * X
     +                        -1.296476623788D-12)   * X
     +                        +1.477175434354D-11)   * X
     +                        +5.464102147892D-10)   * X
     +                        -2.42538340602723D-08) * X
     +                        +8.20460740637617D-07) * X
     +                        -2.20379304598661D-05) * X
     +                        +4.90295372978785D-04) * X
     +                        -9.14294111576119D-03) * X
     +                        +1.22590403403690D-01

         R3        = ((((((((( 1.39017367502123D-14  * X
     +                        -6.96391385426890D-13) * X
     +                        +1.176946020731D-12)   * X
     +                        +1.725627235645D-10)   * X
     +                        -3.686383856300D-09)   * X
     +                        +2.87495324207095D-08) * X
     +                        +1.71307311000282D-06) * X
     +                        -7.94273603184629D-05) * X
     +                        +2.00938064965897D-03) * X
     +                        -3.63329491677178D-02) * X
     +                        +4.34393683888443D-01

         R4        = ((((((((((-1.27815158195209D-14  * X
     +                         +1.99910415869821D-14) * X
     +                         +3.753542914426D-12)   * X
     +                         -2.708018219579D-11)   * X
     +                         -1.190574776587D-09)   * X
     +                         +1.106696436509D-08)   * X
     +                         +3.954955671326D-07)   * X
     +                         -4.398596059588D-06)   * X
     +                         -2.01087998907735D-04) * X
     +                         +7.89092425542937D-03) * X
     +                         -1.42056749162695D-01) * X
     +                         +1.39964149420683D+00

         R5        = ((((((((((-1.19442341030461D-13  * X
     +                         -2.34074833275956D-12) * X
     +                         +6.861649627426D-12)   * X
     +                         +6.082671496226D-10)   * X
     +                         +5.381160105420D-09)   * X
     +                         -6.253297138700D-08)   * X
     +                         -2.135966835050D-06)   * X
     +                         -2.373394341886D-05)   * X
     +                         +2.88711171412814D-06) * X
     +                         +4.85221195290753D-02) * X
     +                         -1.04346091985269D+00) * X
     +                         +7.89901551676692D+00

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 10 =< T < 15
C
C
 5400    X = T - HALFP12

         WTS (M) = ((((((((( 8.98007931950169D-15  * X
     +                      +7.25673623859497D-14) * X
     +                      +5.851494250405D-14)   * X
     +                      -4.234204823846D-11)   * X
     +                      +3.911507312679D-10)   * X
     +                      -9.65094802088511D-09) * X
     +                      +3.42197444235714D-07) * X
     +                      -7.51821178144509D-06) * X
     +                      +1.94218051498662D-04) * X
     +                      -5.38533819142287D-03) * X
     +                      +1.68122596736809D-01

         WTS (M+1) = ((((((((((-1.05490525395105D-15  * X
     +                         +1.96855386549388D-14) * X
     +                         -5.500330153548D-13)   * X
     +                         +1.003849567976D-11)   * X
     +                         -1.720997242621D-10)   * X
     +                         +3.533277061402D-09)   * X
     +                         -6.389171736029D-08)   * X
     +                         +1.046236652393D-06)   * X
     +                         -1.73148206795827D-05) * X
     +                         +2.57820531617185D-04) * X
     +                         -3.46188265338350D-03) * X
     +                         +7.03302497508176D-02

         WTS (M+2) = ((((((((((( 3.60020423754545D-16  * X
     +                          -6.24245825017148D-15) * X
     +                          +9.945311467434D-14)   * X
     +                          -1.749051512721D-12)   * X
     +                          +2.768503957853D-11)   * X
     +                          -4.08688551136506D-10) * X
     +                          +6.04189063303610D-09) * X
     +                          -8.23540111024147D-08) * X
     +                          +1.01503783870262D-06) * X
     +                          -1.20490761741576D-05) * X
     +                          +1.26928442448148D-04) * X
     +                          -1.05539461930597D-03) * X
     +                          +1.15543698537013D-02

         WTS (M+3) = ((((((((((((( 2.51163533058925D-18  * X
     +                            -4.31723745510697D-17) * X
     +                            +6.557620865832D-16)   * X
     +                            -1.016528519495D-14)   * X
     +                            +1.491302084832D-13)   * X
     +                            -2.06638666222265D-12) * X
     +                            +2.67958697789258D-11) * X
     +                            -3.23322654638336D-10) * X
     +                            +3.63722952167779D-09) * X
     +                            -3.75484943783021D-08) * X
     +                            +3.49164261987184D-07) * X
     +                            -2.92658670674908D-06) * X
     +                            +2.12937256719543D-05) * X
     +                            -1.19434130620929D-04) * X
     +                            +6.45524336158384D-04

         WTS (M+4) = ((((((((((((((-1.29043630202811D-19  * X
     +                             +2.16234952241296D-18) * X
     +                             -3.107631557965D-17)   * X
     +                             +4.570804313173D-16)   * X
     +                             -6.301348858104D-15)   * X
     +                             +8.031304476153D-14)   * X
     +                             -9.446196472547D-13)   * X
     +                             +1.018245804339D-11)   * X
     +                             -9.96995451348129D-11) * X
     +                             +8.77489010276305D-10) * X
     +                             -6.84655877575364D-09) * X
     +                             +4.64460857084983D-08) * X
     +                             -2.66924538268397D-07) * X
     +                             +1.24621276265907D-06) * X
     +                             -4.30868944351523D-06) * X
     +                             +9.94307982432868D-06

         R1      = ((((((((((-4.16387977337393D-17  * X
     +                       +7.20872997373860D-16) * X
     +                       +1.395993802064D-14)   * X
     +                       +3.660484641252D-14)   * X
     +                       -4.154857548139D-12)   * X
     +                       +2.301379846544D-11)   * X
     +                       -1.033307012866D-09)   * X
     +                       +3.997777641049D-08)   * X
     +                       -9.35118186333939D-07) * X
     +                       +2.38589932752937D-05) * X
     +                       -5.35185183652937D-04) * X
     +                       +8.85218988709735D-03

         R2        = ((((((((((-4.56279214732217D-16  * X
     +                         +6.24941647247927D-15) * X
     +                         +1.737896339191D-13)   * X
     +                         +8.964205979517D-14)   * X
     +                         -3.538906780633D-11)   * X
     +                         +9.561341254948D-11)   * X
     +                         -9.772831891310D-09)   * X
     +                         +4.240340194620D-07)   * X
     +                         -1.02384302866534D-05) * X
     +                         +2.57987709704822D-04) * X
     +                         -5.54735977651677D-03) * X
     +                         +8.68245143991948D-02

         R3        = ((((((((((-2.52879337929239D-15  * X
     +                         +2.13925810087833D-14) * X
     +                         +7.884307667104D-13)   * X
     +                         -9.023398159510D-13)   * X
     +                         -5.814101544957D-11)   * X
     +                         -1.333480437968D-09)   * X
     +                         -2.217064940373D-08)   * X
     +                         +1.643290788086D-06)   * X
     +                         -4.39602147345028D-05) * X
     +                         +1.08648982748911D-03) * X
     +                         -2.13014521653498D-02) * X
     +                         +2.94150684465425D-01

         R4        = ((((((((((-6.42391438038888D-15  * X
     +                         +5.37848223438815D-15) * X
     +                         +8.960828117859D-13)   * X
     +                         +5.214153461337D-11)   * X
     +                         -1.106601744067D-10)   * X
     +                         -2.007890743962D-08)   * X
     +                         +1.543764346501D-07)   * X
     +                         +4.520749076914D-06)   * X
     +                         -1.88893338587047D-04) * X
     +                         +4.73264487389288D-03) * X
     +                         -7.91197893350253D-02) * X
     +                         +8.60057928514554D-01

         R5        = (((((((((((-2.24366166957225D-14  * X
     +                          +4.87224967526081D-14) * X
     +                          +5.587369053655D-12)   * X
     +                          -3.045253104617D-12)   * X
     +                          -1.223983883080D-09)   * X
     +                          -2.05603889396319D-09) * X
     +                          +2.58604071603561D-07) * X
     +                          +1.34240904266268D-06) * X
     +                          -5.72877569731162D-05) * X
     +                          -9.56275105032191D-04) * X
     +                          +4.23367010370921D-02) * X
     +                          -5.76800927133412D-01) * X
     +                          +3.87328263873381D+00

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 15 =< T < 20
C
C
 5500    X = T - HALFP17

         WTS (M) = (((((((((( 1.74841995087592D-15  * X
     +                       -6.95671892641256D-16) * X
     +                       -3.000659497257D-13)   * X
     +                       +2.021279817961D-13)   * X
     +                       +3.853596935400D-11)   * X
     +                       +1.461418533652D-10)   * X
     +                       -1.014517563435D-08)   * X
     +                       +1.132736008979D-07)   * X
     +                       -2.86605475073259D-06) * X
     +                       +1.21958354908768D-04) * X
     +                       -3.86293751153466D-03) * X
     +                       +1.45298342081522D-01

         WTS (M+1) = ((((((((((-1.11199320525573D-15  * X
     +                         +1.85007587796671D-15) * X
     +                         +1.220613939709D-13)   * X
     +                         +1.275068098526D-12)   * X
     +                         -5.341838883262D-11)   * X
     +                         +6.161037256669D-10)   * X
     +                         -1.009147879750D-08)   * X
     +                         +2.907862965346D-07)   * X
     +                         -6.12300038720919D-06) * X
     +                         +1.00104454489518D-04) * X
     +                         -1.80677298502757D-03) * X
     +                         +5.78009914536630D-02

         WTS (M+2) = ((((((((((-9.49816486853687D-16  * X
     +                         +6.67922080354234D-15) * X
     +                         +2.606163540537D-15)   * X
     +                         +1.983799950150D-12)   * X
     +                         -5.400548574357D-11)   * X
     +                         +6.638043374114D-10)   * X
     +                         -8.799518866802D-09)   * X
     +                         +1.791418482685D-07)   * X
     +                         -2.96075397351101D-06) * X
     +                         +3.38028206156144D-05) * X
     +                         -3.58426847857878D-04) * X
     +                         +8.39213709428516D-03

         WTS (M+3) = ((((((((((( 1.33829971060180D-17  * X
     +                          -3.44841877844140D-16) * X
     +                          +4.745009557656D-15)   * X
     +                          -6.033814209875D-14)   * X
     +                          +1.049256040808D-12)   * X
     +                          -1.70859789556117D-11) * X
     +                          +2.15219425727959D-10) * X
     +                          -2.52746574206884D-09) * X
     +                          +3.27761714422960D-08) * X
     +                          -3.90387662925193D-07) * X
     +                          +3.46340204593870D-06) * X
     +                          -2.43236345136782D-05) * X
     +                          +3.54846978585226D-04

         WTS (M+4) = ((((((((((((( 2.69412277020887D-20  * X
     +                            -4.24837886165685D-19) * X
     +                            +6.030500065438D-18)   * X
     +                            -9.069722758289D-17)   * X
     +                            +1.246599177672D-15)   * X
     +                            -1.56872999797549D-14) * X
     +                            +1.87305099552692D-13) * X
     +                            -2.09498886675861D-12) * X
     +                            +2.11630022068394D-11) * X
     +                            -1.92566242323525D-10) * X
     +                            +1.62012436344069D-09) * X
     +                            -1.23621614171556D-08) * X
     +                            +7.72165684563049D-08) * X
     +                            -3.59858901591047D-07) * X
     +                            +2.43682618601000D-06

         R1      = (((((((((( 1.91875764545740D-16  * X
     +                       +7.8357401095707D-16)  * X
     +                       -3.260875931644D-14)   * X
     +                       -1.186752035569D-13)   * X
     +                       +4.275180095653D-12)   * X
     +                       +3.357056136731D-11)   * X
     +                       -1.123776903884D-09)   * X
     +                       +1.231203269887D-08)   * X
     +                       -3.99851421361031D-07) * X
     +                       +1.45418822817771D-05) * X
     +                       -3.49912254976317D-04) * X
     +                       +6.67768703938812D-03

         R2        = (((((((((( 2.02778478673555D-15  * X
     +                         +1.01640716785099D-14) * X
     +                         -3.385363492036D-13)   * X
     +                         -1.615655871159D-12)   * X
     +                         +4.527419140333D-11)   * X
     +                         +3.853670706486D-10)   * X
     +                         -1.184607130107D-08)   * X
     +                         +1.347873288827D-07)   * X
     +                         -4.47788241748377D-06) * X
     +                         +1.54942754358273D-04) * X
     +                         -3.55524254280266D-03) * X
     +                         +6.44912219301603D-02

         R3        = (((((((((( 7.79850771456444D-15  * X
     +                         +6.00464406395001D-14) * X
     +                         -1.249779730869D-12)   * X
     +                         -1.020720636353D-11)   * X
     +                         +1.814709816693D-10)   * X
     +                         +1.766397336977D-09)   * X
     +                         -4.603559449010D-08)   * X
     +                         +5.863956443581D-07)   * X
     +                         -2.03797212506691D-05) * X
     +                         +6.31405161185185D-04) * X
     +                         -1.30102750145071D-02) * X
     +                         +2.10244289044705D-01

         R4        = (((((((((((-2.92397030777912D-15  * X
     +                          +1.94152129078465D-14) * X
     +                          +4.859447665850D-13)   * X
     +                          -3.217227223463D-12)   * X
     +                          -7.484522135512D-11)   * X
     +                          +7.19101516047753D-10) * X
     +                          +6.88409355245582D-09) * X
     +                          -1.44374545515769D-07) * X
     +                          +2.74941013315834D-06) * X
     +                          -1.02790452049013D-04) * X
     +                          +2.59924221372643D-03) * X
     +                          -4.35712368303551D-02) * X
     +                          +5.62170709585029D-01

         R5        = ((((((((((( 1.17976126840060D-14  * X
     +                          +1.24156229350669D-13) * X
     +                          -3.892741622280D-12)   * X
     +                          -7.755793199043D-12)   * X
     +                          +9.492190032313D-10)   * X
     +                          -4.98680128123353D-09) * X
     +                          -1.81502268782664D-07) * X
     +                          +2.69463269394888D-06) * X
     +                          +2.50032154421640D-05) * X
     +                          -1.33684303917681D-03) * X
     +                          +2.29121951862538D-02) * X
     +                          -2.45653725061323D-01) * X
     +                          +1.89999883453047D+00

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 20 =< T < 25
C
C
 5600    X = T - HALFP22

         WTS (M) = (((((((((-9.10338640266542D-15  * X
     +                      +1.00438927627833D-13) * X
     +                      +7.817349237071D-13)   * X
     +                      -2.547619474232D-11)   * X
     +                      +1.479321506529D-10)   * X
     +                      +1.52314028857627D-09) * X
     +                      +9.20072040917242D-09) * X
     +                      -2.19427111221848D-06) * X
     +                      +8.65797782880311D-05) * X
     +                      -2.82718629312875D-03) * X
     +                      +1.28718310443295D-01

         WTS (M+1) = ((((((((( 5.52380927618760D-15  * X
     +                        -6.43424400204124D-14) * X
     +                        -2.358734508092D-13)   * X
     +                        +8.261326648131D-12)   * X
     +                        +9.229645304956D-11)   * X
     +                        -5.68108973828949D-09) * X
     +                        +1.22477891136278D-07) * X
     +                        -2.11919643127927D-06) * X
     +                        +4.23605032368922D-05) * X
     +                        -1.14423444576221D-03) * X
     +                        +5.06607252890186D-02

         WTS (M+2) = ((((((((( 3.99457454087556D-15  * X
     +                        -5.11826702824182D-14) * X
     +                        -4.157593182747D-14)   * X
     +                        +4.214670817758D-12)   * X
     +                        +6.705582751532D-11)   * X
     +                        -3.36086411698418D-09) * X
     +                        +6.07453633298986D-08) * X
     +                        -7.40736211041247D-07) * X
     +                        +8.84176371665149D-06) * X
     +                        -1.72559275066834D-04) * X
     +                        +7.16639814253567D-03

         WTS (M+3) = (((((((((((-2.14649508112234D-18  * X
     +                          -2.45525846412281D-18) * X
     +                          +6.126212599772D-16)   * X
     +                          -8.526651626939D-15)   * X
     +                          +4.826636065733D-14)   * X
     +                          -3.39554163649740D-13) * X
     +                          +1.67070784862985D-11) * X
     +                          -4.42671979311163D-10) * X
     +                          +6.77368055908400D-09) * X
     +                          -7.03520999708859D-08) * X
     +                          +6.04993294708874D-07) * X
     +                          -7.80555094280483D-06) * X
     +                          +2.85954806605017D-04

         WTS (M+4) = ((((((((((((-5.63938733073804D-21  * X
     +                           +6.92182516324628D-20) * X
     +                           -1.586937691507D-18)   * X
     +                           +3.357639744582D-17)   * X
     +                           -4.810285046442D-16)   * X
     +                           +5.386312669975D-15)   * X
     +                           -6.117895297439D-14)   * X
     +                           +8.441808227634D-13)   * X
     +                           -1.18527596836592D-11) * X
     +                           +1.36296870441445D-10) * X
     +                           -1.17842611094141D-09) * X
     +                           +7.80430641995926D-09) * X
     +                           -5.97767417400540D-08) * X
     +                           +1.65186146094969D-06

         R1      = (((((((((-1.13927848238726D-15  * X
     +                      +7.39404133595713D-15) * X
     +                      +1.445982921243D-13)   * X
     +                      -2.676703245252D-12)   * X
     +                      +5.823521627177D-12)   * X
     +                      +2.17264723874381D-10) * X
     +                      +3.56242145897468D-09) * X
     +                      -3.03763737404491D-07) * X
     +                      +9.46859114120901D-06) * X
     +                      -2.30896753853196D-04) * X
     +                      +5.24663913001114D-03

         R2        = (((((((((( 2.89872355524581D-16  * X
     +                         -1.22296292045864D-14) * X
     +                         +6.184065097200D-14)   * X
     +                         +1.649846591230D-12)   * X
     +                         -2.729713905266D-11)   * X
     +                         +3.709913790650D-11)   * X
     +                         +2.216486288382D-09)   * X
     +                         +4.616160236414D-08)   * X
     +                         -3.32380270861364D-06) * X
     +                         +9.84635072633776D-05) * X
     +                         -2.30092118015697D-03) * X
     +                         +5.00845183695073D-02

         R3        = (((((((((( 1.97068646590923D-15  * X
     +                         -4.89419270626800D-14) * X
     +                         +1.136466605916D-13)   * X
     +                         +7.546203883874D-12)   * X
     +                         -9.635646767455D-11)   * X
     +                         -8.295965491209D-11)   * X
     +                         +7.534109114453D-09)   * X
     +                         +2.699970652707D-07)   * X
     +                         -1.42982334217081D-05) * X
     +                         +3.78290946669264D-04) * X
     +                         -8.03133015084373D-03) * X
     +                         +1.58689469640791D-01

         R4        = (((((((((( 1.33642069941389D-14  * X
     +                         -1.55850612605745D-13) * X
     +                         -7.522712577474D-13)   * X
     +                         +3.209520801187D-11)   * X
     +                         -2.075594313618D-10)   * X
     +                         -2.070575894402D-09)   * X
     +                         +7.323046997451D-09)   * X
     +                         +1.851491550417D-06)   * X
     +                         -6.37524802411383D-05) * X
     +                         +1.36795464918785D-03) * X
     +                         -2.42051126993146D-02) * X
     +                         +3.97847167557815D-01

         R5        = ((((((((((-6.07053986130526D-14  * X
     +                         +1.04447493138843D-12) * X
     +                         -4.286617818951D-13)   * X
     +                         -2.632066100073D-10)   * X
     +                         +4.804518986559D-09)   * X
     +                         -1.835675889421D-08)   * X
     +                         -1.068175391334D-06)   * X
     +                         +3.292234974141D-05)   * X
     +                         -5.94805357558251D-04) * X
     +                         +8.29382168612791D-03) * X
     +                         -9.93122509049447D-02) * X
     +                         +1.09857804755042D+00

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 25 =< T < 40
C
C
 5700    E = DEXP (-T)

         W1 = -0.01962D+00 * E + DSQRT (PI4/T)

         W2 = (((((((( 2.77778345870650D-05  * T
     +                -2.22835017655890D-03) * T
     +                +1.61077633475573D-01) * T
     +                -8.96743743396132D+00) * T
     +                +3.28062687293374D+02) * T
     +                -7.65722701219557D+03) * T
     +                +1.10255055017664D+05) * T
     +                -8.92528122219324D+05) * T
     +                +3.10638627744347D+06) * E + W25 * W1

         W3 = (((((((( 1.83574464457207D-05  * T
     +                -1.54837969489927D-03) * T
     +                +1.18520453711586D-01) * T
     +                -6.69649981309161D+00) * T
     +                +2.44789386487321D+02) * T
     +                -5.68832664556359D+03) * T
     +                +8.14507604229357D+04) * T
     +                -6.55181056671474D+05) * T
     +                +2.26410896607237D+06) * E + W35 * W1

         W4 = (((((((((-2.40799435809950D-08  * T
     +                 +8.12621667601546D-06) * T
     +                 -9.04491430884113D-04) * T
     +                 +6.37686375770059D-02) * T
     +                 -2.96135703135647D+00) * T
     +                 +9.15142356996330D+01) * T
     +                 -1.86971865249111D+03) * T
     +                 +2.42945528916947D+04) * T
     +                 -1.81852473229081D+05) * T
     +                 +5.96854758661427D+05) * E + W45 * W1

         W5 = (((((((((-4.61100906133970D-10  * T
     +                 +1.43069932644286D-07) * T
     +                 -1.63960915431080D-05) * T
     +                 +1.15791154612838D-03) * T
     +                 -5.30573476742071D-02) * T
     +                 +1.61156533367153D+00) * T
     +                 -3.23248143316007D+01) * T
     +                 +4.12007318109157D+02) * T
     +                 -3.02260070158372D+03) * T
     +                 +9.71575094154768D+03) * E + W55 * W1

         WTS (M)   = W1 - W2 - W3 - W4 - W5
         WTS (M+1) = W2
         WTS (M+2) = W3
         WTS (M+3) = W4
         WTS (M+4) = W5

         R1      = ((((((((-1.73363958895356D-06  * T
     +                     +1.19921331441483D-04) * T
     +                     -1.59437614121125D-02) * T
     +                     +1.13467897349442D+00) * T
     +                     -4.47216460864586D+01) * T
     +                     +1.06251216612604D+03) * T
     +                     -1.52073917378512D+04) * T
     +                     +1.20662887111273D+05) * T
     +                     -4.07186366852475D+05) * E + R15/(T-R15)

         R2        = ((((((((-1.60102542621710D-05  * T
     +                       +1.10331262112395D-03) * T
     +                       -1.50043662589017D-01) * T
     +                       +1.05563640866077D+01) * T
     +                       -4.10468817024806D+02) * T
     +                       +9.62604416506819D+03) * T
     +                       -1.35888069838270D+05) * T
     +                       +1.06107577038340D+06) * T
     +                       -3.51190792816119D+06) * E + R25/(T-R25)

         R3        = ((((((((-4.48880032128422D-05  * T
     +                       +2.69025112122177D-03) * T
     +                       -4.01048115525954D-01) * T
     +                       +2.78360021977405D+01) * T
     +                       -1.04891729356965D+03) * T
     +                       +2.36985942687423D+04) * T
     +                       -3.19504627257548D+05) * T
     +                       +2.34879693563358D+06) * T
     +                       -7.16341568174085D+06) * E + R35/(T-R35)

         R4        = ((((((((-6.38526371092582D-05  * T
     +                       -2.29263585792626D-03) * T
     +                       -7.65735935499627D-02) * T
     +                       +9.12692349152792D+00) * T
     +                       -2.32077034386717D+02) * T
     +                       +2.81839578728845D+02) * T
     +                       +9.59529683876419D+04) * T
     +                       -1.77638956809518D+06) * T
     +                       +1.02489759645410D+07) * E + R45/(T-R45)

         R5        = ((((((((-3.59049364231569D-05  * T
     +                       -2.25963977930044D-02) * T
     +                       +1.12594870794668D+00) * T
     +                       -4.56752462103909D+01) * T
     +                       +1.05804526830637D+03) * T
     +                       -1.16003199605875D+04) * T
     +                       -4.07297627297272D+04) * T
     +                       +2.22215528319857D+06) * T
     +                       -1.61196455032613D+07) * E + R55/(T-R55)

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         M = M + 5

         GOTO 500
C
C
C             ...T-range: 40 =< T < 59
C
C
 5800    X = T * T * T
         E = DEXP (-T) * X

         R1 = (((-2.43758528330205D-02  * T
     +           +2.07301567989771D+00) * T
     +           -6.45964225381113D+01) * T
     +           +7.14160088655470D+02) * E + R15 / (T - R15)

         R2 = (((-2.28861955413636D-01  * T
     +           +1.93190784733691D+01) * T
     +           -5.99774730340912D+02) * T
     +           +6.61844165304871D+03) * E + R25 / (T - R25)

         R3 = (((-6.95053039285586D-01  * T
     +           +5.76874090316016D+01) * T
     +           -1.77704143225520D+03) * T
     +           +1.95366082947811D+04) * E + R35 / (T - R35)

         R4 = (((-1.58072809087018D+00  * T
     +           +1.27050801091948D+02) * T
     +           -3.86687350914280D+03) * T
     +           +4.23024828121420D+04) * E + R45 / (T - R45)

         R5 = (((-3.33963830405396D+00  * T
     +           +2.51830424600204D+02) * T
     +           -7.57728527654961D+03) * T
     +           +8.21966816595690D+04) * E + R55 / (T - R55)

         RTS (M)   = R1 / (ONE + R1)
         RTS (M+1) = R2 / (ONE + R2)
         RTS (M+2) = R3 / (ONE + R3)
         RTS (M+3) = R4 / (ONE + R4)
         RTS (M+4) = R5 / (ONE + R5)

         E = E * X
         W1 = DSQRT (PI4/T)

         W2 = (( 2.09539509123135D-05  * T
     +          -6.87646614786982D-04) * T
     +          +6.68743788585688D-03) * E + W25 * W1

         W3 = (( 1.34547929260279D-05  * T
     +          -4.19389884772726D-04) * T
     +          +3.87706687610809D-03) * E + W35 * W1

         W4 = (( 1.23464092261605D-06  * T
     +          -3.55224564275590D-05) * T
     +          +3.03274662192286D-04) * E + W45 * W1

         W5 = (( 1.35482430510942D-08  * T
     +          -3.27722199212781D-07) * T
     +          +2.41522703684296D-06) * E + W55 * W1

         WTS (M)   = W1 - W2 - W3 - W4 - W5
         WTS (M+1) = W2
         WTS (M+2) = W3
         WTS (M+3) = W4
         WTS (M+4) = W5

         M = M + 5

         GOTO 500
C
C
C             ...T-range: T >= 59
C
C
 5900    W1 = DSQRT (PI4/T)

         W2 = W25 * W1
         W3 = W35 * W1
         W4 = W45 * W1
         W5 = W55 * W1

C         R1 = R15 / (T - R15)
C         R2 = R25 / (T - R25)
C         R3 = R35 / (T - R35)
C         R4 = R45 / (T - R45)
C         R5 = R55 / (T - R55)
C         RTS (M)   = R1 / (ONE + R1)
C         RTS (M+1) = R2 / (ONE + R2)
C         RTS (M+2) = R3 / (ONE + R3)
C         RTS (M+3) = R4 / (ONE + R4)
C         RTS (M+4) = R5 / (ONE + R5)

         WTS (M)   = W1 - W2 - W3 - W4 - W5
         WTS (M+1) = W2
         WTS (M+2) = W3
         WTS (M+3) = W4
         WTS (M+4) = W5

         RTS (M)   = R15 / T
         RTS (M+1) = R25 / T
         RTS (M+2) = R35 / T
         RTS (M+3) = R45 / T
         RTS (M+4) = R55 / T

         M = M + 5

  500 CONTINUE
C
C
C             ...ready!
C
C
      RETURN
      END
