/**
 * Scaffolding file used to store all the setups needed to run 
 * tests automatically generated by EvoSuite
 * Fri Jan 12 16:52:00 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.junit.BeforeClass;
import org.junit.Before;
import org.junit.After;
import org.junit.AfterClass;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.sandbox.Sandbox.SandboxMode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import static org.evosuite.shaded.org.mockito.Mockito.*;
@EvoSuiteClassExclude
public class FTPSeekableStream_ESTest_scaffolding {

  @org.junit.Rule 
  public org.evosuite.runtime.vnet.NonFunctionalRequirementRule nfr = new org.evosuite.runtime.vnet.NonFunctionalRequirementRule();

  protected static ExecutorService executor; 

  private static final java.util.Properties defaultProperties = (java.util.Properties) java.lang.System.getProperties().clone(); 

  private org.evosuite.runtime.thread.ThreadStopper threadStopper =  new org.evosuite.runtime.thread.ThreadStopper (org.evosuite.runtime.thread.KillSwitchHandler.getInstance(), 3000);


  @BeforeClass 
  public static void initEvoSuiteFramework() { 
    org.evosuite.runtime.RuntimeSettings.className = "uk.ac.sanger.artemis.util.FTPSeekableStream"; 
    org.evosuite.runtime.GuiSupport.initialize(); 
    org.evosuite.runtime.RuntimeSettings.maxNumberOfThreads = 100; 
    org.evosuite.runtime.RuntimeSettings.maxNumberOfIterationsPerLoop = 10000; 
    org.evosuite.runtime.RuntimeSettings.mockSystemIn = true; 
    org.evosuite.runtime.RuntimeSettings.sandboxMode = org.evosuite.runtime.sandbox.Sandbox.SandboxMode.RECOMMENDED; 
    org.evosuite.runtime.sandbox.Sandbox.initializeSecurityManagerForSUT(); 
    executor = Executors.newCachedThreadPool(); 
    org.evosuite.runtime.classhandling.JDKClassResetter.init();
    setSystemProperties();
    initializeClasses();
    org.evosuite.runtime.Runtime.getInstance().resetRuntime(); 
    try { initMocksToAvoidTimeoutsInTheTests(); } catch(ClassNotFoundException e) {} 
  } 

  @AfterClass 
  public static void clearEvoSuiteFramework(){ 
    Sandbox.resetDefaultSecurityManager(); 
    executor.shutdownNow(); 
    java.lang.System.setProperties((java.util.Properties) defaultProperties.clone()); 
  } 

  @Before 
  public void initTestCase(){ 
    threadStopper.storeCurrentThreads();
    threadStopper.startRecordingTime();
    org.evosuite.runtime.jvm.ShutdownHookHandler.getInstance().initHandler(); 
    org.evosuite.runtime.sandbox.Sandbox.goingToExecuteSUTCode(); 
    setSystemProperties(); 
    org.evosuite.runtime.GuiSupport.setHeadless(); 
    org.evosuite.runtime.Runtime.getInstance().resetRuntime(); 
    org.evosuite.runtime.agent.InstrumentingAgent.activate(); 
  } 

  @After 
  public void doneWithTestCase(){ 
    threadStopper.killAndJoinClientThreads();
    org.evosuite.runtime.jvm.ShutdownHookHandler.getInstance().safeExecuteAddedHooks(); 
    org.evosuite.runtime.classhandling.JDKClassResetter.reset(); 
    resetClasses(); 
    org.evosuite.runtime.sandbox.Sandbox.doneWithExecutingSUTCode(); 
    org.evosuite.runtime.agent.InstrumentingAgent.deactivate(); 
    org.evosuite.runtime.GuiSupport.restoreHeadlessMode(); 
  } 

  public static void setSystemProperties() {
 
    java.lang.System.setProperties((java.util.Properties) defaultProperties.clone()); 
    java.lang.System.setProperty("file.encoding", "UTF-8"); 
    java.lang.System.setProperty("java.awt.headless", "true"); 
    java.lang.System.setProperty("user.country", "GB"); 
    java.lang.System.setProperty("user.language", "en"); 
    java.lang.System.setProperty("user.timezone", "Europe/London"); 
    java.lang.System.setProperty("log4j.configuration", "SUT.log4j.properties"); 
  }

  private static void initializeClasses() {
    org.evosuite.runtime.classhandling.ClassStateSupport.initializeClasses(FTPSeekableStream_ESTest_scaffolding.class.getClassLoader() ,
      "org.apache.commons.net.ftp.FTPConnectionClosedException",
      "htsjdk.variant.variantcontext.Allele",
      "org.apache.commons.net.ftp.FTP",
      "htsjdk.variant.vcf.VCFHeader",
      "org.apache.log4j.or.ObjectRenderer",
      "org.apache.commons.net.ftp.FTPClient$HostnameResolver",
      "htsjdk.variant.variantcontext.CommonInfo",
      "org.apache.log4j.DefaultCategoryFactory",
      "org.apache.commons.net.io.SocketInputStream",
      "org.apache.commons.net.ProtocolCommandSupport",
      "org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory",
      "htsjdk.samtools.util.Log$LogLevel",
      "org.apache.commons.net.ftp.FTPFileEntryParser",
      "org.apache.log4j.or.RendererMap",
      "org.apache.commons.net.ftp.FTPCmd",
      "htsjdk.tribble.TribbleException",
      "uk.ac.sanger.artemis.util.FTPSeekableStream",
      "org.apache.log4j.Logger",
      "htsjdk.variant.vcf.VCFCompoundHeaderLine",
      "htsjdk.samtools.util.StringUtil",
      "org.apache.log4j.Level",
      "org.apache.commons.net.ftp.parser.ParserInitializationException",
      "org.apache.commons.net.ftp.FTPClient",
      "org.apache.commons.net.ftp.FTPClientConfig",
      "org.apache.commons.net.DefaultSocketFactory",
      "org.apache.log4j.helpers.LogLog",
      "org.apache.log4j.Category",
      "org.apache.commons.net.io.ToNetASCIIOutputStream",
      "org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory",
      "htsjdk.variant.vcf.VCFSimpleHeaderLine",
      "htsjdk.samtools.SAMException",
      "htsjdk.samtools.util.BinaryCodec",
      "org.apache.commons.net.io.SocketOutputStream",
      "org.apache.log4j.spi.RepositorySelector",
      "htsjdk.variant.variantcontext.VariantContextComparator",
      "htsjdk.variant.vcf.VCFIDHeaderLine",
      "htsjdk.variant.variantcontext.GenotypesContext",
      "org.apache.log4j.spi.LoggerFactory",
      "org.apache.log4j.CategoryKey",
      "htsjdk.variant.variantcontext.StructuralVariantType",
      "org.apache.log4j.spi.Configurator",
      "org.apache.commons.net.ftp.Configurable",
      "htsjdk.variant.vcf.VCFInfoHeaderLine",
      "htsjdk.variant.variantcontext.VariantContext",
      "org.apache.commons.net.ProtocolCommandListener",
      "org.apache.commons.net.ftp.FTPFile",
      "org.apache.log4j.or.DefaultRenderer",
      "htsjdk.variant.variantcontext.VariantContextBuilder",
      "org.apache.commons.net.io.FromNetASCIIInputStream",
      "htsjdk.variant.vcf.VCFHeaderLine",
      "htsjdk.variant.variantcontext.Genotype",
      "htsjdk.samtools.util.RuntimeEOFException",
      "htsjdk.samtools.AbstractSAMHeaderRecord",
      "org.apache.log4j.PropertyWatchdog",
      "org.apache.commons.net.ftp.FTPListParseEngine",
      "org.apache.commons.net.MalformedServerReplyException",
      "org.apache.log4j.PropertyConfigurator",
      "htsjdk.tribble.TribbleException$InvalidHeader",
      "org.apache.log4j.helpers.Loader",
      "org.apache.log4j.ProvisionNode",
      "org.apache.log4j.Hierarchy",
      "htsjdk.variant.variantcontext.VariantContext$Validation",
      "org.apache.log4j.helpers.FileWatchdog",
      "org.apache.commons.net.SocketClient",
      "org.apache.log4j.Appender",
      "htsjdk.tribble.Feature",
      "htsjdk.samtools.util.RuntimeIOException",
      "org.apache.commons.net.ftp.FTPClient$NatServerResolverImpl",
      "org.apache.commons.net.ftp.FTPFileFilter",
      "htsjdk.tribble.TribbleException$InternalCodecException",
      "htsjdk.variant.vcf.VCFFilterHeaderLine",
      "htsjdk.samtools.util.Locatable",
      "org.apache.log4j.spi.DefaultRepositorySelector",
      "org.apache.log4j.spi.RootLogger",
      "htsjdk.variant.vcf.VCFContigHeaderLine",
      "htsjdk.samtools.SAMSequenceDictionary",
      "org.apache.log4j.spi.AppenderAttachable",
      "org.apache.log4j.spi.LoggingEvent",
      "org.apache.log4j.spi.RendererSupport",
      "htsjdk.samtools.seekablestream.SeekableStream",
      "org.apache.log4j.Priority",
      "htsjdk.samtools.util.Log",
      "htsjdk.variant.vcf.VCFFormatHeaderLine",
      "org.apache.log4j.spi.LoggerRepository",
      "org.apache.log4j.LogManager",
      "htsjdk.samtools.SAMSequenceRecord",
      "htsjdk.variant.variantcontext.VariantContext$Type",
      "org.apache.log4j.helpers.OptionConverter",
      "org.apache.commons.net.io.CRLFLineReader",
      "org.apache.commons.net.util.ListenerList",
      "org.apache.commons.net.io.CopyStreamListener"
    );
  } 
  private static void initMocksToAvoidTimeoutsInTheTests() throws ClassNotFoundException { 
    mock(Class.forName("java.net.URLStreamHandler", false, FTPSeekableStream_ESTest_scaffolding.class.getClassLoader()));
  }

  private static void resetClasses() {
    org.evosuite.runtime.classhandling.ClassResetter.getInstance().setClassLoader(FTPSeekableStream_ESTest_scaffolding.class.getClassLoader()); 

    org.evosuite.runtime.classhandling.ClassStateSupport.resetClasses(
      "org.apache.log4j.Category",
      "org.apache.log4j.Logger",
      "org.apache.log4j.Priority",
      "org.apache.log4j.Level",
      "org.apache.log4j.or.RendererMap",
      "org.apache.log4j.helpers.OptionConverter",
      "org.apache.log4j.helpers.Loader",
      "org.apache.log4j.helpers.LogLog",
      "org.apache.log4j.PropertyConfigurator",
      "org.apache.log4j.LogManager",
      "org.apache.log4j.CategoryKey",
      "org.apache.log4j.ProvisionNode",
      "uk.ac.sanger.artemis.util.FTPSeekableStream",
      "org.apache.commons.net.SocketClient",
      "org.apache.commons.net.ftp.FTP",
      "org.apache.commons.net.ftp.FTPClient",
      "org.apache.commons.net.ProtocolCommandSupport",
      "org.apache.commons.net.util.ListenerList",
      "org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory",
      "htsjdk.samtools.AbstractSAMHeaderRecord",
      "htsjdk.samtools.SAMSequenceRecord",
      "htsjdk.variant.vcf.VCFHeader",
      "htsjdk.variant.variantcontext.GenotypesContext",
      "htsjdk.variant.variantcontext.VariantContext$Validation",
      "htsjdk.variant.variantcontext.VariantContext",
      "htsjdk.samtools.util.StringUtil",
      "htsjdk.variant.variantcontext.Allele",
      "htsjdk.variant.vcf.VCFHeaderLine",
      "htsjdk.samtools.util.Log$LogLevel",
      "htsjdk.samtools.util.Log",
      "htsjdk.samtools.SAMSequenceDictionary"
    );
  }
}
