# Camera|deepin-camera|

## Overview

Camera is an easy-to-use camera application that supports multiple functions such as taking photos, recording videos, and switching between multiple camera devices.

## Guide

You can run, close or create a desktop shortcut for Camera in the following ways.

### Run Camera

1. Click the Launcher icon ![launcher](../common/deepin_launcher.svg) in the Dock and enter the Launcher interface.
2. Locate Camera ![camera](../common/camera.svg) by scrolling the mouse wheel or searching "camera" in the Launcher interface and click it to run.
3. Right-click ![camera](../common/camera.svg) and you can:

 - Click **Send to desktop** to create a desktop shortcut.
 - Click **Send to dock** to fix the application in the Dock.
 - Click **Add to startup** to add the application to startup and it will automatically run when the system starts up.

### Exit Camera

- On the Camera interface, click![close_icon](../common/close.svg)to exit Camera.
- Right-click ![camera](../common/camera.svg) in the Dock and select **Close All** to exit Camera.
- On the Camera interface, click ![icon_menu](../common/icon_menu.svg) and select **Exit** to exit Camera.

## Icon Descriptions
<table class="block1">
    <tbody>
        <tr>
            <td><img src="../common/photograph.png" alt="Photo" class="inline" /></td>
            <td>Photo</td>
            <td><img src="../common/record.png" alt="Video" class="inline" /></td>
            <td>Video</td>
            <td><img src="../common/switch.png" alt="Switch Cameras" class="inline" /></td>
            <td>Switch Cameras</td>
        </tr>
        <tr>
            <td><img src="../common/more.png" alt="Fold" class="inline" /></td>
            <td>Fold Toolbar</td>
            <td><img src="../common/fold.png" alt="Unfold Toolbar" class="inline" /></td>
            <td>Unfold Toolbar</td>
            <td><img src="../common/delay.png" alt="Delay Capture" class="inline" /></td>
            <td>Delay Capture</td>
       </tr>   
       <tr>
            <td><img src="../common/flashlight.png" alt="flashlight" class="inline" /></td>
            <td>Enable flashlight</td>
            <td><img src="../common/filter.png" alt="Filters" class="inline" /></td>
            <td>Set filters</td>
            <td><img src="../common/exposure.png" alt="Exposure" class="inline" /></td>
            <td>Adjust the exposure level</td>
        </tr>
    </tbody>
</table>


> ![notes](../common/notes.svg) Notes: The camera switching icon ![1](fig/switch.png) only shows when there are multiple cameras connected.

## Operations

You can use the Camera application if your computer comes with a camera or is connected to a camera. Select the photo or video mode on the Camera interface to take photos and record videos. You can also enable the **Mirror mode** in **Settings > Shoot** to flip the photo horizontally.

> ![notes](../common/notes.svg) Notes: The actual functions supported may differ according to the decoding method adopted.  Please refer to the interface.

### Take Photos

Photo mode is defaulted when Camera starts up. Click the ![photograph](../common/photograph.png) icon to take photos, and the photos will be displayed on the interface.

![image](fig/image.png)

### Record Videos

On the Camera interface, click **Video** to to enter the video mode. Click  the![transcribe](../common/record.svg) icon to start recording, and click the ![stop](../common/stop.svg) icon to stop recording after video recording is completed. Video files will be displayed on the interface, and will also be saved in the default path.

![video](fig/video.png)

### Process Photos and Videos

On the Camera interface, right-click the photos or video files to select copy, delete, print and open folder.

> ![notes](../common/notes.svg) Notes: The printing function is only available for photo files. 

- Copy: Copy the selected photo/video to another path.

- Delete: Delete the selected photo/video.

- Print: Print the selected photo. Click **Print** and you will be direct to the print preview interface. Set the relevant printing parameters and click the **Save** icon to finish printing.

- Open folder: Open the folder where photos and videos are located.


![rightmenu](fig/right_menu.png)

## Main Menu

On the main menu, you can change settings for Camera, switch window themes, view help manual, and get more information about Camera.

### Settings

1. Click ![icon_menu](../common/icon_menu.svg) on the Camera interface.
2. Click **Settings** to adjust **Basic**, **Shoot** and **Output** settings.

   - **Basic** settings: set up the **File location** for photos and videos as well as gridlines for photos.
   - **Shoot** settings: set up the **Sound effects**, **Burst mode**, **Self-timer delay**, **Mirror mode** and **Flashlight** options.
   - **Output** settings: check the **Output format** of photos,  choose a format of videos, and set up **Resolution settings** for both.

     

### Theme

There are three window themes, namely Light Theme, Dark Theme, and System Theme.

1.  Click ![icon_menu](../common/icon_menu.svg) on the Camera interface.
2.  Click **Theme** to select a theme.

### Help

1.  Click ![icon_menu](../common/icon_menu.svg) on the Camera interface.
2.  Click **Help** to view the manual of Camera.

### About

1.  Click ![icon_menu](../common/icon_menu.svg) on the Camera interface.
2.  Click **About** to view the version and introduction of Camera. 

### Exit

1.  Click ![icon_menu](../common/icon_menu.svg) on the Camera interface.
2.  Click **Exit** to exit Camera.