#ifndef TUI_H_included
#define TUI_H_included 1

#include <stdbool.h>
#include <stdio.h>

#define MAX_TITLE_LEN       256
#define MAX_FILE_NAME_LEN    1024
#define MAX_CONTENT_LEN      1024
#define MAX_ITEMS_NUM        8
#define MAX_ITEM_NAME_LEN     256

typedef int (*menu_item_handler)(void *data);

typedef enum MENU_ITEM {
    MENU_ITEM_FIX_ROOT = 1,
    MENU_ITEM_ENTER_CMD_MODE,
    MENU_ITEM_REBOOT,
    MENU_ITEM_SHUTDOWN,
    MENU_ITEM_ENTER_LIVE,
    MENU_ITEM_MAX
} MENU_ITEM;

typedef struct menu_item_t {
    MENU_ITEM id;
    char *item_str;
    menu_item_handler callback;
}menu_item_t;

typedef struct menu_args {
    char title[MAX_TITLE_LEN];
    char content[MAX_CONTENT_LEN];
    int height;
    int width;
    int menu_height;
    MENU_ITEM menus[MAX_ITEMS_NUM];
}menu_args;

void init_tui_dialog();
int create_menu(const menu_args *arg);
int create_yesno(const char *title,const char *content,int height,int width,char *yes_l,char *no_l);
int create_infobox(const char *title,const char *content,int height,int width);
void end_infobox();
#endif
