# 桌面环境|dde|

## 概述
深之度操作系统(deepin)是一款美观易用、安全可靠的国产桌面操作系统。deepin预装了文件管理器、应用商店、看图、影院等一系列原生应用。它既能让您体验到丰富多彩的娱乐生活，也可以满足您的日常工作需要。随着功能的不断升级和完善，深之度操作系统已成为国内最受欢迎的桌面操作系统之一。

![1|desk](fig/d_desk.jpg)

### 系统简介
初次进入深之度操作系统，会自动打开欢迎程序。您可以观看视频了解系统功能，选择桌面模式和图标主题，进一步了解该系统。

![welcome](fig/d_welcome.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

成功登录系统后，即可体验deepin桌面环境。桌面环境主要由桌面、任务栏、启动器、控制中心和窗口管理器等组成，是您使用该操作系统的基础。

## 桌面
桌面是您登录后看到的主屏幕区域。在桌面上，您可以新建文件/文件夹、排列文件、打开终端、设置壁纸和屏保等，还可以通过 [发送到桌面](#设置快捷方式) 向桌面添加应用的快捷方式。

![0|rightbuttonmenu](fig/contextmenu.png)

> ![notes](../common/notes.svg)说明：在触控板上：四指/五指向下移动显示桌面，紧接着向上移动隐藏桌面， 对应 **Super** + **D** 快捷键。


### 新建文件夹/文档

在桌面新建文件夹或文档，也可以对文件进行常规操作，和在文件管理器中一样。

- 在桌面上，单击鼠标右键，单击 **新建文件夹**，输入新建文件夹的名称。
- 在桌面上，单击鼠标右键，单击 **新建文档**，选择新建文档的类型，输入新建文档的名称。

在桌面文件或文件夹上，单击鼠标右键，您可以使用文件管理器的相关功能：

|功能| 说明 |
| ----------- |------------------------------------------ |
| 打开方式    | 选定系统默认打开方式，也可以选择其他关联应用程序来打开。 |
| 剪切      |移动文件或文件夹。             |
| 复制      |复制文件或文件夹。             |
| 重命名      |重命名文件或文件夹。            |
| 删除        |删除文件或文件夹。              |
| 创建链接    |创建一个快捷方式。                         |
| 标记信息    |添加标记信息，以对文件或文件夹进行标签化管理。      |
| 压缩/解压缩 |压缩文件或文件夹，或对压缩文件进行解压。 |
| 属性        |查看文件或文件夹的基本信息，共享方式，及其权限。      |

> ![notes](../common/notes.svg)说明：
> - 当使用触屏电脑时，在触摸屏上长按1秒再抬起即打开当前对象的右键菜单。
> - 在触控板上，二指单击，显示右键菜单。
> - 在键盘上按下 **Ctrl** + **M** 快捷键，打开右键菜单。


### 设置排列方式
您可以对桌面上的图标按照需要进行排序。

1. 在桌面上，单击鼠标右键。
2. 单击 **排序方式**，您可以：
  - 单击 **名称**，将按文件的名称顺序显示。
  - 单击 **大小**，将按文件的大小顺序显示。
  - 单击 **类型**，将按文件的类型顺序显示。
  - 单击 **修改时间**，文件将按最近一次的修改日期顺序显示。

> ![tips](../common/tips.svg)窍门：您也可以勾选 **自动排列**，桌面图标将从上往下，从左往右按照当前排序规则排列，有图标被删除时后面的图标会自动向前填充。


### 调整图标大小
1. 在桌面上，单击鼠标右键。
2. 单击 **图标大小**。
3. 选择一个合适的图标大小。

> ![tips](../common/tips.svg)窍门：您也可以用 **Ctrl** + ![=](../common/=.svg)/![-](../common/-.svg)/鼠标滚动来调整桌面和启动器中的图标大小。

### 设置显示器
从桌面单击右键菜单选择“显示设置”，可以快速进入控制中心设置显示器的缩放比例、分辨率和亮度等。

1. 在桌面上，单击鼠标右键。
2. 单击 **显示设置**，快速进入控制中心的显示设置界面。

> ![notes](../common/notes.svg)说明：关于显示的设置，具体操作请参阅 [显示设置](#显示设置) 。

 ### 更改壁纸
选择一些精美、时尚的壁纸来美化桌面，让您的电脑显示与众不同。


1. 在桌面上，单击鼠标右键。
2. 单击 **壁纸与屏保**，在桌面底部预览所有壁纸。
3. 选择某一壁纸后，壁纸就会在桌面和锁屏中生效。
4. 单击 **仅设置桌面** 和 **仅设置锁屏** 来控制壁纸的生效范围。

![1|wallpaper](fig/d_wallpaper.jpg)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
> ![tips](../common/tips.svg)窍门：
> - 勾选 **自动更换壁纸**，设置自动更换壁纸的时间间隔。您还可以设置在“登录时”和“唤醒时”自动更换壁纸。
> - 您还可以在图片查看器中设置您喜欢的图片为桌面壁纸。


### 设置屏保
屏幕保护程序原本是为了保护显像管，现在一般用来防范他人偷窥您电脑上的一些隐私。

1. 在桌面上，单击鼠标右键。
2. 单击 **壁纸与屏保**，单击 **屏保**，在桌面底部预览所有屏保。
3. 选择其中一个屏保，单击 **设置屏保**，在上方选择 **闲置时间**。
4. 勾选 **恢复时需要密码**，以便更好地保护您的隐私。
5. 待电脑空闲指定时间后，将启动您选择的屏幕保护程序。

![1|screensaver](fig/screensaver.jpg)

### 剪贴板
剪贴板展示当前用户登录系统后复制和剪切的所有文本、图片和文件。使用剪贴板可以快速复制其中的某项内容。注销或关机后，剪贴板会自动清空。

1. 使用快捷键 **Ctrl** + **AIt** + **V** 唤出剪贴板。
2. 双击剪贴板内的某一区块，会快速复制当前内容， 且当前区块会被移动到剪贴板顶部。
3. 选择目标位置粘贴。
4. 鼠标移入剪贴板的某一区块，单击上方的![close](../common/close_normal.svg)，删除当前内容；单击顶部的 **全部清除**，清空剪贴板。

![1|clipboard](fig/clipboard.png)

> ![notes](../common/notes.svg)说明：当使用触屏电脑时，在触摸屏上从屏幕左侧边缘划入超过任务栏高度，唤出剪贴板。

## 任务栏

任务栏是指位于桌面底部的长条，主要由启动器、应用程序图标、托盘区、系统插件等组成。在任务栏，您可以打开启动器、显示桌面、进入工作区，对其上的应用程序进行打开、新建、关闭、强制退出等操作，还可以设置输入法，调节音量，连接网络，查看日历，进入关机界面等。

### 认识任务栏图标
任务栏图标包括启动器图标、应用程序图标、托盘区图标、系统插件图标等。

![1|fashion](fig/d_efficient.png)

| 图标 | 说明 | 图标 | 说明 |
| ------------------------------------------------------------ | :---------------------------------- | -------------------------------------------------------- | --------------------------------------------------- |
| ![launcher](../common/deepin-launcher.svg)                   | 启动器 - 单击查看所有已安装的应用。 | ![deepin-toggle-desktop](../common/deepin-toggle-desktop.svg) | 显示桌面。                                          |
| ![deepin-multitasking-view](../common/deepin-multitasking-view.svg) | 多任务视图 - 单击显示工作区。     | ![dde-file-manager](../common/dde-file-manager.svg)      | 文件管理器 - 单击查看磁盘中的文件、文件夹。       |
| ![deepin-appstore](../common/deepin-appstore.svg) | 应用商店 - 搜索安装应用软件。 | ![ deepin-album](../common/deepin-album.svg) | 相册 - 导入并管理照片。 |
| ![deepin-music](../common/deepin-music.svg)             | 音乐 - 播放本地音乐。 |  ![dde-calendar](../common/dde-calendar.svg)             | 日历 - 查看日期、新建日程。                |
| ![controlcenter](../common/controlcenter.svg)                | 控制中心 - 单击进入系统设置。     | ![notification](../common/notification.svg)              | 通知中心 - 显示所有系统和应用的通知。               |
| ![onboard](../common/onboard.svg)   | 屏幕键盘 - 单击使用虚拟键盘。 |![shutdown](../common/system-shutdown.svg) | 电源 - 单击进入关机界面。 |
| ![trash](../common/trash_icon.svg) | 回收站。        |                         |                                             |

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
> ![tips](../common/tips.svg)窍门：在高效模式下，单击任务栏右侧可显示桌面。将鼠标指针移到任务栏上已打开窗口的图标时，会显示相应的预览窗口。

### 切换显示模式
任务栏提供两种显示模式：时尚模式和高效模式，显示不同的图标大小和应用窗口激活效果。


![1|fashion](fig/d_fashion.png)

![1|efficient](fig/d_efficient.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

您可以通过以下操作来切换显示模式：

1. 右键单击任务栏。
2. 在 **模式** 子菜单中选择一种显示模式。

### 设置任务栏位置
您可以将任务栏放置在桌面的任意方向。

1. 右键单击任务栏。
2. 在 **位置** 子菜单中选择一个方向。

### 调整任务栏高度 
鼠标拖动任务栏边缘，改变任务栏高度。

### 显示/隐藏任务栏
任务栏可以隐藏，以便最大程度的扩展桌面的可操作区域。

1. 右键单击任务栏。
2. 在 **状态** 子菜单中您可以：
  - 选择 **一直显示**，任务栏将会一直显示在桌面上。
  - 选择 **一直隐藏**，任务栏将会隐藏起来，只有在鼠标移至任务栏区域时才会显示。
  - 选择 **智能隐藏**，当占用任务栏区域时，任务栏自动隐藏。

> ![notes](../common/notes.svg)说明：当使用触屏电脑时，在触摸屏上：
> 当任务栏设置为“智能隐藏”或“一直隐藏”时，如果任务栏在底部，在屏幕边缘从下往上划入，唤出任务栏；如果任务栏在顶部，在屏幕边缘从上往下划入，唤出任务栏。

### 显示/隐藏插件

1. 右键单击任务栏。
2. 在 **插件** 子菜单中勾选或取消勾选 **回收站、电源、显示桌面、屏幕键盘、通知中心、多任务视图、时间**，可以设置这些插件在任务栏上的显示和隐藏效果。

### 查看通知
当有系统或应用通知时，会在桌面上方弹出通知消息。若有按钮，单击按钮执行对应操作；若无按钮，单击关闭此消息。

![1|message](fig/d_message.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

此外，还可以单击任务栏上的 ![notification](../common/notification.svg)， 打开通知中心，查看所有通知。

> ![notes](../common/notes.svg)说明：当使用触屏电脑时，手指从屏幕右侧边缘划入超过任务栏高度，唤出通知中心。

### 查看日期时间

- 鼠标指针悬停在任务栏的时间上，查看当前日期、星期和时间。
- 单击时间，打开日历。

### 进入关机界面
您可以单击任务栏上的 ![shutdown](../common/system-shutdown.svg) 进入关机界面，也可以在启动器的小窗口模式中单击 ![poweroff_normal](../common/poweroff_normal.svg)。

|功能|说明|
|--|---|
|关机![poweroff_normal](../common/poweroff_normal.svg)|关闭电脑。|
|重启![reboot_normal](../common/reboot_normal.svg)|关机后再次重新运行您的电脑。|
|待机![suspend_normal](../common/suspend_normal.svg)|整个系统将处于低能耗运转的状态。|
|休眠![sleep_hover](../common/sleep_hover.svg)|没有swap分区不显示此项。有swap分区的机器休眠挂载到硬盘。|
|锁定![lock_normal](../common/lock_normal.svg)|锁定电脑，按下快捷键 **Super** + **L** 锁定。|
|切换用户![userswitch_normal](../common/userswitch_normal.svg)|选择另一个用户帐户登录。|
|注销![logout_normal](../common/logout_normal.svg)|清除当前登录用户的信息。|
|系统监视器![deepin-system-monitor](../common/deepin-system-monitor.svg)|快速启动系统监视器。|

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
> ![notes](../common/notes.svg)说明：当系统存在多个帐户时才显示 ![userswitch_normal](../common/userswitch_normal.svg)。


### 回收站
在回收站中，可以找到电脑中临时被删除的文件，也可以选择还原或清空这些文件。

#### 还原文件
临时被删除的文件，可以在回收站进行还原，或使用快捷键 **Ctrl** + **Z** 还原刚删除的文件。

1. 在回收站中，选择要恢复的文件。
2. 单击鼠标右键，选择 **还原**。
3. 还原文件到原来的存储路径下。

> ![attention](../common/attention.svg)注意：如果原来所在的文件夹已经删除，还原文件时会自动新建文件夹。

#### 删除文件

回收站中可以单独清除某一文件。

1. 在回收站中，选择要删除的文件。
2. 单击鼠标右键，选择 **删除**，即可删除回收站的文件。

#### 清空回收站

在回收站中，单击 **清空**，将彻底删除回收站的所有内容。

## 启动器
启动器 ![launcher](../common/deepin-launcher.svg) 帮助您管理系统中已安装的所有应用，在启动器中使用分类导航或搜索功能可以快速找到您需要的应用程序。

您可以进入启动器查看新安装的应用。新安装应用的旁边会出现一个小蓝点提示。

> ![notes](../common/notes.svg)说明：在触控板上，四指/五指单击，显示/隐藏启动器， 对应 **Super** 快捷键。

### 切换模式
启动器有全屏和小窗口两种模式。单击启动器界面右上角的图标来切换模式。

两种模式均支持搜索应用、设置快捷方式等操作。

小窗口模式还支持快速打开文件管理器，控制中心和进入关机界面等功能。

![1|launch](fig/d_fullscreen.jpg)![1|launch](fig/d_mini.jpg)


### 排列应用

在全屏模式下，系统默认按照安装时间排列所有应用。

- 将鼠标悬停在应用图标上，按住鼠标左键不放，将应用图标拖拽到指定的位置自由排列。
- 单击启动器界面左上角分类图标![category](../common/category_icon.svg)进行排列。

![1|sortapp](fig/d_sortapp.jpg)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

在小窗口模式下，默认按照使用频率排列应用。

### 查找应用

在启动器中，您可以滚动鼠标滚轮或切换分类导航查找应用。

如果知道应用名称，直接在搜索框中输入关键字，快速定位到需要的应用。

### 设置快捷方式
快捷方式提供了一种简单快捷地启动应用的方法。

#### 创建快捷方式
将应用发送到桌面或任务栏上，方便您的后续操作。

在启动器中，右键单击应用图标，您可以：

- 单击 **发送到桌面**，在桌面创建快捷方式。

- 单击 **发送到任务栏**，将应用固定到任务栏。

![0|sendto](fig/sendto.png)

> ![notes](../common/notes.svg)说明：您还可以从启动器拖拽应用图标到任务栏上放置。但是当应用处于运行状态时您将无法拖拽固定，此时您可以右键单击任务栏上的应用图标，选择 **驻留** 将应用固定到任务栏，以便下次使用时从任务栏上快速打开。

#### 删除快捷方式
您既可以在桌面直接删除应用的快捷方式，也可以在任务栏和启动器中删除。

**从任务栏上删除**

- 在任务栏上，按住鼠标左键不放，将应用图标拖拽到任务栏以外的区域移除快捷方式。
- 当应用处于运行状态时您将无法拖拽移除，此时可以右键单击任务栏上的应用图标，选择 **移除驻留** 将应用从任务栏上移除。

**从启动器中删除**

在启动器中，右键单击应用图标，您可以：

- 单击 **从桌面上移除**，删除桌面快捷方式。
- 单击 **从任务栏上移除**，将固定到任务栏上的应用移除。

> ![notes](../common/notes.svg)说明：以上操作，只会删除应用的快捷方式，而不会卸载应用。

### 安装应用
如果启动器中没有您需要的应用，可以在应用商店一键下载安装。

![0|appstore](fig/d_appstore.png)

### 运行应用
对于已经创建了桌面快捷方式或固定到任务栏上的应用，您可以通过以下途径来打开应用。

- 双击桌面图标，或右键单击桌面图标选择 **打开**。
- 直接单击任务栏上的应用图标，或右键单击任务栏上的应用图标选择 **打开**。

在启动器中，直接单击应用图标打开，或右键单击应用图标选择 **打开**。

> ![tips](../common/tips.svg)窍门：对于经常使用的应用，您可以在启动器中，右键单击应用图标选择 **开机自动启动**。


### 卸载应用
对于不再使用的应用，您可以选择将其卸载，以节省硬盘空间。

1. 在启动器中，右键单击应用图标。
2. 单击 **卸载**。

> ![tips](../common/tips.svg)窍门：在 **时尚模式** 下，您还可以在启动器的全屏模式界面，按住鼠标左键不放，将应用图标拖拽到任务栏的 ![trash](../common/trash_icon.svg) 中卸载应用。


## 控制中心
深之度操作系统通过控制中心来管理系统的基本设置，包括帐户管理、网络设置、日期和时间、个性化设置、显示设置、系统升级等。当您进入桌面环境后，单击任务栏上的![controlcenter](../common/controlcenter.svg) 即可打开控制中心窗口。

> ![notes](../common/notes.svg)说明：在触控板上，二指从触控板右边缘向左滑动，显示控制中心；二指从触控板左边缘向右滑动，隐藏控制中心。

### 首页介绍

控制中心首页主要展示各个设置模块，方便日常查看和快速设置。

![2|dcchomepage](fig/d_dcc.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

打开控制中心的某一设置模块后，可以通过左侧导航栏快速切换到另一设置模块。

![2|cc-navigation](fig/d_default.png)



#### 标题栏
标题栏包含返回按钮，搜索框，主菜单及窗口按钮。

- 返回按钮：若要返回首页，单击 ![back](../common/back.svg)。
- 搜索框：输入关键字，回车，搜索相应设置。
- 主菜单：单击![menu](../common/icon_menu.svg) 进入主菜单。在主菜单中，您可以设置窗口主题，查看版本，或退出控制中心。

### 帐户设置
在安装系统时您已经创建了一个帐户。在这里，您可以修改帐户设置或创建一个新帐户。

![0|account](fig/d_account.png)

#### 创建新帐户

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击 **创建帐户** 按钮![add](../common/add.svg)。
3. 输入用户名、密码和重复密码。
4. 单击 **创建**。
5. 在授权对话框输入当前帐户的密码，新帐户就会添加到帐户列表中。

#### 更改头像

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击列表中的帐户。
3. 单击帐户头像，选择一个头像或添加本地头像，头像就替换完成了。

#### 设置全名

帐户全名会显示在帐户列表和系统登录界面，可根据需要设置。

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击列表中的帐户。
3. 单击 **设置全名** 后的 ![edit](../common/edit.svg)，输入帐户全名。


#### 修改密码

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击当前帐户。
3. 单击 **修改密码**，进入修改密码页面。
4. 输入当前密码、新密码和重复密码。

#### 自动登录
开启“自动登录”后， 下次启动系统时（重启、开机）可直接进入桌面。在锁屏和注销后再次登录需要密码。
1. 在控制中心首页，单击![account_normal](../common/account_normal.svg)。
2. 单击当前帐户。
3. 打开 **自动登录** 开关，开启自动登录功能。

#### 无密码登录
开启“无密码登录”后，下次登录系统时（重启，开机，和在注销后再次登录），不需要密码，单击 **登录** 按钮 ![login](../common/login.svg) 即可登录系统。
1. 在控制中心首页，单击![account_normal](../common/account_normal.svg)。
2. 单击当前帐户。
3. 打开 **无密码登录** 开关，开启后可以不用输入密码登录系统。

> ![tips](../common/tips.svg)窍门： 
> - 若“无密码登录”和“自动登录”同时打开，下次启动系统（重启、开机）则直接进入桌面。
> - 默认勾选“清空钥匙环密码”，在无密码登录情况下登录已经记录密码的程序时不需要再次输入系统登录密码，反之则每次都需要输入系统登录密码。

#### 设置指纹密码

指纹密码可以用来登录系统、解锁屏幕、特殊操作授权。当需要输入帐户密码时，请扫描您的指纹。

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击当前帐户。
3. 单击 **添加指纹** 。
4. 使用指纹设备录入指纹。
5. 待指纹添加成功之后单击 **完成**。

> ![notes](../common/notes.svg)说明：您可以添加多个指纹密码；也可以删除一个个指纹密码。


#### 删除帐户

1. 在控制中心首页，单击 ![account_normal](../common/account_normal.svg)。
2. 单击其他未登录的帐户。
3. 单击 **删除帐户** 。
4. 在弹出的确认界面中单击 **删除**。

> ![attention](../common/attention.svg)注意: 已登录的帐户无法被删除。

### Deepin ID 

登录 Deepin ID 后，您可以使用云同步、应用商店等相关云服务功能。

首次登录时，会弹出 **隐私政策** 窗口，如果用户需要开启云服务等功能，可以勾选 **我已阅读并同意《隐私政策》**，单击 **确定** 开启云服务等功能。

开启云同步，可自动同步各种系统配置到云端，如网络、声音、鼠标、更新、任务栏、启动器、壁纸、主题、电源等。若想在另一台电脑上使用相同的系统配置，只需登录此网络帐户，即可一键同步以上配置到该设备。

> ![tips](../common/tips.svg)窍门： 当“自动同步配置”开启时，可以选择同步项；关闭时，全部不能同步。

![0|sync](fig/d_sync.png)



### 显示设置
设置显示器的亮度、分辨率、屏幕方向以及缩放倍数等，让您的电脑显示到达最佳状态。

![0|video](fig/d_display.png)

#### 单屏设置

##### 调节亮度

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在亮度区域，拖动亮度条滑块，调节屏幕亮度。

##### 调节色温

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在色温区域，可以：
   - 打开 **自动调节色温** 开关，开启进入护眼模式，自动调节色温。
   - 打开 **手动调节** 色温开关，可以手动拖动色温条滑块调节屏幕色温。

> ![notes](../common/notes.svg)说明：当打开 **自动调节色温** 开关时，系统将自动关闭 **手动调节** 色温开关，反之亦然。

##### 设置屏幕缩放

当桌面和窗口显示过大或过小时，您可能需要调节屏幕缩放，以便正常显示。

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在屏幕缩放区域， 单击或拖动滑块调整缩放倍数。
3. 注销后重新登录系统屏幕缩放操作即可生效。

> ![notes](../common/notes.svg)说明：
> - 当检测到屏幕为高分屏时，会自动调整缩放倍数。
> - 部分应用可能不支持屏幕缩放，您可以在启动器中右键单击该应用，选择 **禁用屏幕缩放**，以获得更好的显示效果。

##### 更改分辨率

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在分辨率区域的下拉列表中，选择合适的分辨率参数。
3. 单击 **保存**。

##### 设置屏幕刷新率

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在刷新率区域的下拉列表中，选择一个合适的刷新率。
3. 单击 **保存**。

##### 改变屏幕方向

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在方向区域的下拉列表中，选择一个合适的方向参数，改变屏幕方向。
3. 单击 **保存**。

#### 多屏设置

多屏显示可以让屏幕的视野无限延伸，使用VGA、HDMI、DP等线缆将电脑和另一台显示器、投影仪等连接起来，电脑上的内容即可同时在多个屏幕中显示。当电脑设备连接上另一台显示设备，多屏显示模式设置模块才会出现。

![0|display](fig/d_displayMulti.png)

1. 在控制中心首页，单击 ![display_normal](../common/display_normal.svg)。
2. 在多屏设置区域，模式下拉框中选择屏幕显示样式。
 - **复制**将主屏的显示内容复制到其他屏幕。
 - **扩展** 将主屏的显示内容扩展到其他屏幕，扩大桌面区域。
 - **仅在xxx显示 **只在某个屏幕显示内容。

在多屏环境下，按下快捷键 **Super** + **P**调出多屏显示模式的OSD。
详细操作方法如下。

1. 按住 **Super** 不放，再按下 **P** 或鼠标单击来进行模式选择。
2. 松开按键，确认选择，模式生效。

> ![notes](../common/notes.svg)说明：当多屏显示模式为为扩展模式时，仅主屏支持桌面图标显示、右键菜单操作等功能，而副屏不支持。

### 默认程序设置

当安装有多个功能相似的应用程序时，可以通过右键菜单或控制中心为某种类型的文件指定其中的一个应用作为打开文件的默认启动程序。

![0|default](fig/d_default.png)

#### 设置默认程序

1. 右键单击文件，选择 **打开方式** > **选择默认程序**。
2. 选择一个应用，自动勾选"设为默认"，单击 **确定**。
3. 该应用将自动添加到控制中心的默认程序列表。

#### 更改默认程序

1. 在控制中心首页，单击 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 选择一个文件类型进入默认程序列表。
3. 在列表中选择另一个应用程序。

#### 添加默认程序

1. 在控制中心首页，单击 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 选择文件类型进入默认程序列表。
3. 单击列表下的 **添加默认程序** 按钮![add](../common/add.svg)，选择desktop文件（一般在/usr/share/applications)，或特定的二进制文件。
4. 该程序将添加到列表，并自动设置为默认程序。

#### 删除默认程序

在默认程序列表中，您只能删除自己添加的应用程序，不能删除系统已经安装的应用。要删除系统已经安装的应用，只能卸载应用。卸载后该应用将自动从默认程序列表中删除。

可用以下方法删除自己添加的默认程序。

1. 在控制中心首页，单击 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 选择文件类型进入默认程序列表。
3. 单击程序后面的![close](../common/close_normal.svg)，删除默认程序。

### 个性化设置
在控制中心个性化设置模块可以进行一些通用的个性化设置，包括系统主题、活动用色、字体、窗口特效和透明度，改变桌面和窗口的外观。除此之外还可设置图标主题、光标主题和字体。

![0|personalise](fig/d_personalise.png)

#### 设置窗口主题
1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **通用**，选择一种窗口主题。
3. 该主题即为系统窗口主题。

> ![tips](../common/tips.svg)窍门：自动主题表示根据当前时区的时间，根据日出日落的时间自动更换窗口主题。日出后是浅色，日落后是深色。

#### 更改活动用色
活动用色是指选中某一选项时的强调色。

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **通用**。
3. 单击 **活动用色** 下的一种颜色，可实时查看该颜色效果。

#### 开启窗口特效
开启窗口特效可以让桌面和窗口更美观精致。

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **通用**。
3. 打开 **窗口特效** 开关，开启窗口特效。

> ![notes](../common/notes.svg)说明：开启窗口特效后，可以设置最小化时效果为缩放或魔灯，调节窗口圆角的大小。

#### 调节透明度

您可以设置任务栏、启动器（小窗口模式）的透明度。滑块越靠左越透明，越靠右越不透明。

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **通用**，开启 **窗口特效**。
3. 单击 **透明度调节**，可实时体验透明效果。

#### 设置图标主题

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **图标主题**，选择一款图标样式。

#### 设置光标主题

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **光标主题**，选择一款光标样式。

#### 更改系统字体

1. 在控制中心首页，单击 ![personalization_normal](../common/personalization_normal.svg)。
2. 单击 **字体**，进入设置字体界面。
3. 设置系统字号和字体。

### 网络设置
登录系统后，您需要连接网络，才能接收邮件、浏览新闻、下载文件、聊天、网上购物等。

> ![tips](../common/tips.svg)窍门：您可以单击任务栏托盘区的网络图标，查看当前网络状态。

![0|network](fig/d_network.png)

#### 有线网络

有线网络安全快速稳定，是最常见的网络连接方式。当您设置好路由器后，把网线两端分别插入电脑和路由器，即可连接有线网络。

1. 将网线插入电脑上的网络插孔。
2. 将网线的另一端插入路由器或网络端口。
3. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
4. 单击 **有线网络**，进入有线网络设置界面。
5. 打开 **有线网卡**，开启有线网络连接功能。
6. 当网络连接成功后，桌面右上角将弹出“已连接有线连接”的提示信息。

您还可以在有线网络的设置界面，编辑或新建有线网络设置。

#### 无线网络

无线网络帮助您摆脱线缆的束缚，上网形式更加灵活，支持更多设备使用。

##### 连接无线网络

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **无线网络**，进入无线网络设置界面。
3. 打开 **无线网卡**，开启无线网络连接功能。
4. 电脑会自动搜索并显示附近可用的无线网络。
5. 选择需要连接的无线网络。
 - 如果该网络是开放的，将自动连接到此网络。
 - 如果该网络是加密的，请根据提示输入密码，单击 **连接**，然后将自动完成连接。

##### 连接隐藏网络

为了防止他人扫描到自己的WiFi，进而破解WiFi密码连接您的网络，您可以在路由器设置界面隐藏无线网络。设置后，您需要手动连接隐藏网络才能上网。

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **无线网络**，进入无线网络设置界面。
3. 单击 **连接到隐藏网络**。
4. 输入网络名称、SSID和其他必填选项。
5. 单击 **保存** 。

#### 无线热点

无线热点将电脑连接的网络信号转换为WiFi热点，以供一定距离内的其他设备无线上网。要开启无线热点，电脑必须连接到网络并装有无线网卡。

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **个人热点**。
3. 打开 **热点** 开关，设置热点信息。
4. 单击 **保存** 。

#### 移动网络

当您处于一个没有网络信号的地方时，可以使用无线上网卡来上网。在有电话信号覆盖的任何地方，无线上网卡通过运营商的移动数据网络接入宽带服务。

1. 将移动网卡插入电脑上的USB接口中。
2. 电脑将根据移动网卡和运营商信息，自动适配并自动连接网络。
3. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
4. 单击 **移动网络**，查看详细设置信息。

#### 拨号网络

拨号上网（DSL）是指通过本地电话拨号连接到网络的连接方式。配置好调制解调器，把电话线插入电脑的网络接口，创建宽带拨号连接，输入运营商提供的用户名和密码，即可拨号连接到Internet上。

##### 新建拨号连接

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **DSL**，并单击 **创建PPPoE连接** 按钮 ![add](../common/add.svg)。
3. 输入宽带名称、帐户、密码。
4. 单击 **保存**，系统自动创建宽带连接并尝试连接。

#### VPN

VPN即虚拟专用网络，其主要功能是在公用网络上建立专用网络，进行加密通讯。无论您是在外地出差还是在家中办公，只要能上网就能利用VPN访问企业的内网资源。您还可以使用VPN加速访问其他国家的网站。

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **VPN**，选择 **添加VPN** 按钮 ![add](../common/add.svg) 或 **导入VPN** 按钮 ![import](../common/import.svg)。
3. 选择VPN协议类型，并输入名称、网关、帐号、密码等信息。（导入VPN会自动填充信息）
4. 单击 **保存**，系统自动尝试连接VPN网络。
5. 您可以将VPN设置导出，备用或共享给其他用户。

> ![notes](../common/notes.svg)说明：打开 **仅用于相对应的网络上的资源** 开关，可以不将VPN设置为默认路由，只在特定的网络资源上生效。

#### 系统代理

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **系统代理**，进入系统代理界面。
 - 单击 **无**，关闭代理服务器功能。
 - 单击 **手动**，输入代理服务器的地址和端口信息。
 - 单击 **自动**，输入URL，系统将自动配置代理服务器的信息。

#### 应用代理

1. 在控制中心首页，单击  ![network_normal](../common/network_normal.svg)。
2. 单击 **应用代理**。
3. 设置应用代理参数。
4. 单击 **保存**。

> ![notes](../common/notes.svg)说明：应用代理设置成功后，打开启动器，右键单击应用图标，可以选择 **使用代理**。


#### 网络详情

在网络详情界面，您可以查看MAC、IP地址、网关和其他网络信息。

1. 在控制中心首页，单击 ![network_normal](../common/network_normal.svg)。
2. 单击 **网络详情**，进入网络信息界面。
3. 查看当前有线网络或无线网络的信息。

### 通知设置

设置通知勿扰模式，开启或关闭某些应用的通知显示。

![0|sound](fig/d_notification.png)

#### 设置系统通知

设置系统通知的勿扰模式及是否在任务栏显示通知图标。

1. 在控制中心首页，单击 ![dcc_nav_notification_36px](../common/dcc_nav_notification_36px.svg)。

2. 单击 **系统通知**，进入系统通知界面。

   - 开启或关闭勿扰模式。
      当开启勿扰模式后，可以设置勿扰模式的开启时间、结束时间；也可以设置 **在屏幕锁屏时** 显示通知。开启勿扰模式可以使所有通知静音，但您可以在通知中心查看所有消息。
   - 设置是否在任务栏显示通知图标。

#### 设置应用通知

自定义设置个性化的应用通知显示。

1. 在控制中心首页，单击 ![dcc_nav_notification_36px](../common/dcc_nav_notification_36px.svg)。
2. 在应用通知区域选择一个应用，开启后，您可以勾选：
   - 通知时提示声音
   - 锁屏时显示消息
   - 在通知中心显示
   - 显示消息预览

### 声音设置

输入输出设备声音的设置（如设置扬声器和麦克风），让您听得更舒适，录音更清晰。

![0|sound](fig/d_sound.png)

#### 输出设备

1. 在控制中心首页，单击 ![sound_normal](../common/sound_normal.svg)。
2. 单击 **输出**，进入输出设备配置界面，您可以：
   - 在输出设备后面的下拉框中选择输出设备类型。
   - 通过拖曳滑块调节输出音量和左/右声道平衡。
   - 打开 **音量增强**，音量的可调节区间由0~100% 转变为0~150%。

#### 输入设备

1. 在控制中心首页，单击 ![sound_normal](../common/sound_normal.svg)。
2. 单击 **输入**，进入输入设备配置界面，您可以：
   - 在输入设备后面的下拉框中选择输入设备类型。
   - 通过拖曳滑块调节输入音量。
   - 还可以打开 **噪音抑制** 功能。

> ![tips](../common/tips.svg)窍门：通常，需要调大输入音量，确保能够听到声源的声音，但是音量不宜过大，因为这会导致声音失真。可以对着输入设备如麦克风以正常说话的音量讲话，并观察反馈音量的变化，变化较明显，则说明输入音量合适。

#### 系统音效

1. 在控制中心首页，单击 ![sound_normal](../common/sound_normal.svg)。
2. 单击 **系统音效**，勾选选项，开启某一事件发生时的声音效果。

> ![tips](../common/tips.svg)窍门：您可以单击试听音效。

### 蓝牙设置
蓝牙能够实现短距离的无线通信。通过蓝牙无需网络或连接线就可以与附近的其它蓝牙设备连接。常见的蓝牙设备包括：蓝牙键盘、蓝牙鼠标、蓝牙耳机、蓝牙音响等。

![0|bluetooth](fig/d_bluetooth.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

> ![notes](../common/notes.svg)说明：大多数笔记本电脑都配备有蓝牙模块，您只需开启蓝牙开关；而大部分台式电脑都没有配备蓝牙，您可以购买蓝牙适配器，插入到电脑的USB端口中使用。

#### 修改蓝牙名称

1. 在控制中心首页，单击  ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 单击蓝牙名称旁的 ![edit](../common/edit.svg)，输入本机新的蓝牙名称。

> ![notes](../common/notes.svg)说明：修改蓝牙名称后，将自动对外广播蓝牙设备的新名字，需要其他设备重新进行搜索。

#### 连接蓝牙设备

1. 在控制中心首页，单击 ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 开启 **蓝牙**，系统将自动扫描附近的蓝牙设备，并显示在 **其他设备** 列表。
3. 单击想连接的蓝牙设备，在该设备上输入蓝牙配对码（若需要），配对成功后将自动连接。
4. 连接成功后，蓝牙设备会添加到 **我的设备** 列表中。
5. 在列表中单击该设备，您可以 **断开连接**，或修改设备名称。

#### 使用蓝牙传送/接收文件

Deepin PC与非Deepin PC或者Deepin PC与移动设备（手机/平板）之间通过蓝牙设备传送/接收文件。

前提条件：发送端蓝牙设备与接收端蓝牙设备已配对并连接成功。

**使用Deepin PC端蓝牙传送文件**

场景：发送端（Deepin PC）通过蓝牙向接收端（非Deepin PC/手机/平板）传送文件。


1. 在控制中心首页，单击 ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 开启 **蓝牙**，系统将自动扫描附近的蓝牙设备。
3. 进入“我的设备”选择已配对连接的蓝牙设备，单击进入详情，单击 **发送文件** 按钮（仅PC/手机/平板的蓝牙设备有该按钮），在弹出的文件管理器窗口中选择要发送的文件，单击 **打开**。
4. 在弹出的选择接收此文件的蓝牙设备窗口中，单击 **发送**，发送传输文件请求。

**使用手机端蓝牙传送文件**

场景：发送端（以安卓手机为例）通过蓝牙向接收端（Deepin PC）传送文件。

1. 开启 **蓝牙**，系统将自动扫描附近的蓝牙设备。
2. 选择已配对并连接成功的蓝牙设备。
3. 在手机中选择文件，单击 **发送**，通过蓝牙发送文件。

**使用蓝牙接收文件**

发送端发送文件后，接收端弹出提示窗口，用户可以单击 **接受** 或 **拒绝** 文件。

- 如果接收端蓝牙设备同意接收，则发送端开始传输文件并显示发送文件窗口，文件传输完成后，接收端会弹出提示信息，用户可以查看接收成功的文件。
- 如果接收端为如下情况，发送端部分文件传输失败，会显示在传输失败列表。
  - 接收端蓝牙设备选择拒绝，则结束传输，显示传输失败。
  - 接收端蓝牙设备超时未操作或超出传输范围，则显示传输失败（蓝牙设备连接失败）。
  - 接收端即不单击接收也不单击拒绝，默认1分钟后则结束传输，显示传输失败。

### 时间日期

选择正确的所在时区，即可在电脑上显示所在地的时间和日期，也可以手动修改时间和日期。

![0|time](fig/d_time.png)

#### 修改时区
在您安装系统时，已选择了系统时区。若要修改系统时区，请按如下步骤设置。

1. 在控制中心首页，单击 ![time](../common/time.svg)。
2. 单击 **时区列表**。
3. 单击 **修改系统时区**， 通过搜索或单击地图选择时区。
4. 单击 **确定**。

#### 添加时区

您可以同时使用多个时区，以便查看另一时区的时间。

1. 在控制中心首页，单击 ![time](../common/time.svg)。
2. 单击 **时区列表**。
3. 单击 **添加时区** 按钮![add](../common/add.svg)，通过搜索或单击地图选择时区。
4. 单击 **添加**。

#### 删除时区

1. 在控制中心首页，单击 ![time](../common/time.svg)。
2. 单击 **时区列表**。
3. 单击时区列表后面的 **编辑**。
4. 单击 ![delete](../common/delete.svg)，删除已添加的时区。

#### 修改时间和日期
默认情况下，系统通过网络自动同步该时区的本地时间和日期。您也可以关闭自动同步配置，手动修改时间和日期。
1. 在控制中心首页，单击 ![time](../common/time.svg)。
2. 单击 **时间设置** 。
3. 输入正确的时间和日期。
4. 单击 **确定**。

#### 设置时间日期格式

系统支持即时设置时间日期的格式。

1. 在控制中心首页，单击 ![time](../common/time.svg)。
2. 单击 **格式设置**，可以设置星期、长短日期、长短时间等格式。

### 电源管理

对系统电源进行一些设置，让笔记本电池更耐用，让系统更安全。

![0|power](fig/d_power.png)

#### 调整性能模式

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **通用**。
3. 在性能模式区域，选择 **平衡模式**、**高性能模式** 或 **节能模式**。

> ![notes](../common/notes.svg)说明：仅当硬件支持高性能模式时，才显示 **高性能模式** 选项。

#### 设置节能模式

为降低电脑的耗电量，您可以打开节能模式，降低屏幕亮度。

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **通用**。
3. 选择 **节能模式**。
4. 在节能设置下：
   - 打开 **低电量时自动开启** 节能模式（仅笔记本电脑支持）。
   - 打开 **使用电池时自动开启** 节能模式（仅笔记本电脑支持）。
   - 拖动 **自动降低亮度** 条滑块，调节亮度。

> ![notes](../common/notes.svg)说明：当关闭 **使用电池时自动开启** 节能模式时，则直接进入 **平衡模式**。

#### 唤醒时需要密码

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **通用**。
3. 打开 **待机恢复时需要密码**/**唤醒显示器时需要密码**，开启相应安全设置。

#### 设置电量显示模式

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **通用**。
   - 打开 **显示剩余使用时间及剩余充电时间**，显示剩余电量及剩余充电时间（将鼠标指针置于托盘区电源图标上）。
   - 关闭 **显示剩余电量及剩余充电时间**，则仅显示剩余电量（将鼠标指针置于托盘区电源图标上）。

> ![notes](../common/notes.svg)说明：仅笔记本电脑支持设置电量显示模式。

#### 设置显示器关闭时间

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电源** 或 **使用电池**。
3. 选择关闭显示器的时间。

> ![notes](../common/notes.svg)说明：笔记本电脑用户可以在“使用电源”和“使用电池”下对同一设置项分别设置不同的时间。

#### 设置电脑待机时间

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电源** 或 **使用电池**。
3. 选择电脑开始待机的时间。

> ![tips](../common/tips.svg)窍门：笔记本电脑用户还可以开启 **合上笔记本时待机**，以便在使用电源时合盖待机。

#### 设置自动锁屏时间

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电源** 或 **使用电池**。
3. 选择自动锁屏的时间。

#### 设置合盖显示状态

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电源** 或 **使用电池**。
3. 设置 **笔记本合盖时** 为 **待机**、**休眠**、**关闭显示器** 或 **无任何操作**。

> ![notes](../common/notes.svg)说明：仅笔记本电脑支持设置合盖显示状态。

#### 设置按电源按钮时显示状态

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电源** 或 **使用电池**。
3. 选择按电源按钮时的显示状态 **关机**、**待机**、**休眠**、**关闭显示器** 或 **无任何操作**，更改按电源按钮时的设置。

更改设置后会即时生效，并有通知提示。


#### 设置低电量通知

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电池**。
3. 打开 **低电量通知**，当电池剩余电量低于设置的阈值（例如，20%）时，系统会发出低电量通知。

通过拖拽低电量滑块，调节低电量的阈值；或通过拖拽自动待机电量滑块，调节待机电量的阈值。

> ![notes](../common/notes.svg)说明：仅笔记本电脑支持设置低电量通知。

#### 设置自动待机电量

1. 在控制中心首页，单击 ![power_normal](../common/power_normal.svg)。
2. 单击 **使用电池**。
3. 拖动 **自动待机电量** 条滑块，调节自动待机电量。

> ![notes](../common/notes.svg)说明：仅笔记本电脑支持设置自动待机电量。

### 鼠标和触控板

鼠标和触控板是电脑常用的输入设备。使用鼠标，可以使操作更加简便快捷。对于笔记本电脑用户，当没有鼠标时，也可以使用触控板代替鼠标进行操作。部分设备还支持指点杆，使用指点杆不需要将手指从基准键上移开便能操纵鼠标。在控制中心鼠标设置模块，用户可以对鼠标、触控板和指点杆进行设置，从而让设备使用体验更加符合自己的使用习惯。

![0|mouse](fig/d_mouse.png)

#### 通用设置

1. 在控制中心首页，单击 ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg)。
2. 单击 **通用**。
3. 开启 **左手模式**，调节鼠标和触控板的**滚动速度**，**双击速度**。

> ![notes](../common/notes.svg)说明：开启左手模式后，鼠标和触控板的左右键功能互换。

#### 鼠标设置

插入或连接鼠标后，在控制中心进行相关设置，让其更符合您的使用习惯。

> ![notes](../common/notes.svg)说明：当没有触控板时，不会显示 “插入鼠标时禁用触控板”。

1. 在控制中心首页，单击 ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg)。
2. 单击 **鼠标**。
3. 调节 **指针速度**， 控制鼠标移动时指针移动的速度。
4. 单击 **自然滚动** / **鼠标加速** 开关，开启相应功能。


> ![notes](../common/notes.svg)说明：
>
> - 开启鼠标加速，提高了指针精确度，鼠标指针在屏幕上的移动距离会根据移动速度的加快而增加。可以根据使用情况开启或关闭。
> - 自然滚动开启后，鼠标滚轮向下滚动，内容会向下滚动；鼠标滚轮向上滚动，内容会向上滚动。



#### 触控板设置

![0|touchpad](fig/d_touchpad.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

若您使用的是笔记本电脑，可以开启 **输入时禁用触控板**，**插入鼠标时禁用触控板**，并开启 **掌压检测** 设置 **最小接触面** 和 **最小压力值**，以避免误触触控板。

您还可以调节触控板的 **指针速度**，控制手指移动时指针移动的速度；开启自然滚动，变更滚动方向。


#### 指点杆设置
指点杆，常称为小红帽，是一种主要应用于笔记本电脑的定点设备，可用来控制指针的移动。

1. 在控制中心首页，单击 ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg)。 
2. 单击 **指点杆**。
3. 调节 **指针速度**， 控制使用指点杆时指针移动的速度。

### 数位板
数位板，又名绘图板、绘画板、手绘板等，主要用作绘画创作，是计算机的一种输入设备。
连接到电脑后，您可以设置数位板的压感力度，即笔尖和橡皮擦的压力感应值。

> ![notes](../common/notes.svg)说明： 连接数位板设备后，该模块才会显示。

![0|graphics-tablet](fig/d_graphics-tablet.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

1. 在控制中心首页，单击![drawing](../common/drawing.svg) 。
2. 选择 **笔** 模式。
3. 调节 **压感力度**。

### 键盘和语言
在此模块可以设置键盘属性，以便符合个人的输入习惯，还可以根据国家和语言调整键盘布局，设置系统语言，以及自定义快捷键。

![0|keyboard](fig/d_keyboard.png)

#### 键盘属性

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **通用**。
2. 调节 **重复延迟**/**重复速度**。
3. 单击“请在此测试”，按下键盘上的任意字符不松开，查看调节效果。
4. 单击 **启用数字键盘**/**大写锁定提示** 开关，开启相应功能。

#### 键盘布局
 键盘布局可以为当前语言设置自定义键盘。完成键盘布局设置后，按下键盘上的按键，屏幕上会按照键盘布局设置好的字符进行显示。更改键盘布局后，屏幕上的字符可能与键盘按键上的字符不相符。

一般在安装系统时就已经设置了键盘布局，可以根据需求添加或删除其他的键盘布局。

![layout](fig/d_layout.png)

##### 添加键盘布局

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **键盘布局**，进入键盘布局界面。
3. 单击 **添加** 按钮![add](../common/add.svg)，单击某一键盘布局即可添加到列表。

##### 删除键盘布局

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **键盘布局**，进入键盘布局界面。
3. 单击”键盘布局“后的 **编辑**。
4. 单击 ![delete](../common/delete.svg)，删除该键盘布局。

##### 切换键盘布局

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **键盘布局**，进入键盘布局界面。
3. 选择一个键盘布局进行切换。
4. 切换成功后，该键盘布局将标记为已选择。

> ![tips](../common/tips.svg)窍门：您也可以选择一组或多组快捷键，按顺序切换已添加的键盘布局。选择 **切换方式**， 让切换后的键盘布局应用于整个系统或当前应用。

#### 系统语言

系统语言默认为您安装系统时所选择的语言，可以随时更改。

##### 添加系统语言
您可以添加多个语言到系统语言列表，以便切换系统语言。

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **系统语言**，进入系统语言界面。
3. 单击 **添加** 按钮 ![add](../common/add.svg) 进入语言列表。
4. 选择语言，该语言将自动添加到系统语言列表。

##### 设置系统语言

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **系统语言**，进入系统语言界面。
3. 选择要切换的语言，系统将自动开始安装语言包。
4. 语言包安装完成后，需要注销后重新登录，以便设置生效。

> ![attention](../common/attention.svg)注意：更改系统语言后，键盘布局可能也会发生改变。重新登录时，请确保使用正确的键盘布局来输入密码。


#### 快捷键
快捷键列表显示了系统所有的快捷键，在这里查看、修改和自定义快捷键。

![0|shortcut](fig/d_shortcut.png)

##### 查看快捷键

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **快捷键**，进入快捷键设置界面。
3. 搜索或查看默认的系统快捷键、窗口快捷键和工作区快捷键。

##### 修改快捷键

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **快捷键**，进入快捷键设置界面。
3. 单击需要修改的快捷键。
4. 使用键盘输入新的快捷键。

> ![tips](../common/tips.svg)窍门：若要禁用快捷键，请按下键盘上的 ![Backspace](../common/Backspace.svg)。若要取消修改快捷键，按下 **Esc**， 或单击下方的”恢复默认”按钮。

##### 自定义快捷键
您可以为常用的应用自定义一个快捷键。

1. 在控制中心首页，单击 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 单击 **快捷键**。
3. 单击 **添加** 按钮![add](../common/add.svg)，进入添加快捷键界面。
4. 输入快捷键名称、命令和快捷键。
5. 单击 **添加**。
6. 添加成功后，单击”自定义快捷键“后的 **编辑**。
7. 单击某个快捷键后 ![delete](../common/delete.svg)，删除自定义的快捷键。

> ![tips](../common/tips.svg)窍门：若要修改快捷键，单击输入新的快捷键即可。若要修改自定义快捷键的名称和命令，单击“自定义快捷键”后的 **编辑** ，单击快捷键名称后的 ![edit](../common/edit.svg)，进入修改页面。



### 系统更新
当系统存在更新时会在控制中心首页提示，单击 **更新** 按钮 ![update](../common/update.svg) 进入"检查更新"页面，检查完毕后，即可开始下载和安装更新。除此之外，在更新设置模块中还可以设置自动下载更新。

> ![tips](../common/tips.svg)窍门：如果您不想收到系统或应用更新的提示，可在“更新设置”中关闭“更新提醒”。

![0|update](fig/d_update.png)


#### 更新和升级

1. 在控制中心首页，单击 ![update](../common/update.svg)。
2. 单击 **检查更新**，进入检查系统更新界面。
   - 如果系统没有更新将会提示“您的系统已经是最新的”。
   - 如果系统存在更新，将显示 **下载并安装更新** 按钮，下载数据大小和更新详情。
3. 单击 **下载并安装更新** 按钮，系统将自动开始下载并安装更新。
4. 更新完成后，会出现”更新成功”提示。

> ![notes](../common/notes.svg)说明：在下载过程中，您可以单击按钮暂停下载，再次单击按钮继续下载。更新完成后，会弹出对话框提醒用户 **重启** 或 **关机** 。

#### 自动下载更新

1. 在控制中心首页，单击 ![update](../common/update.svg)。
2. 单击 **更新设置**。
3. 打开 **自动下载更新**。
4. 当系统存在更新时，将自动下载数据。

> ![tips](../common/tips.svg)窍门：打开 **自动清除软件包缓存** 开关，系统会定期清理下载软件包导致的缓存。

### 系统信息

查看系统版本和电脑硬件等信息，以及该系统的一些协议。

![0|info](fig/d_info.png)

#### 关于本机

1. 在控制中心首页，单击 ![system_info_normal](../common/nav_info_42px.svg)。
2. 在 **关于本机** 下，您可以查看当前系统版本、版本授权及电脑硬件信息。

#### 版本协议

1. 在控制中心首页，单击 ![system_info_normal](../common/nav_info_42px.svg)。
2. 在 **版本协议** 下，查看系统版本协议。

#### 最终用户许可协议

1. 在控制中心首页，单击 ![system_info_normal](../common/nav_info_42px.svg)。
2. 在 **最终用户许可协议** 下，查看最终用户许可协议。

### 备份还原

为避免因软件缺陷、硬件损毁、人为操作不当、骇客攻击、电脑病毒、自然灾害等因素造成数据缺失或损坏，可以进行应用数据或系统数据的备份还原，以保障系统的正常运行。

![0|backup-recovery](fig/d_backupRestore.png)

#### 备份

deepin操作系统提供初始化备份、控制中心备份的备份方式。

##### 通过初始化进行备份

在系统安装时，如果选择全盘安装，会先自动创建恢复分区，并在后续安装过程中备份启动分区和根分区。

##### 通过控制中心进行备份

在控制中心，用户可以通过全盘备份或系统备份来备份数据。

1. 在控制中心首页，单击 ![system_info_normal](../common/nav_info_42px.svg)。
2. 选择 **备份/还原** > **备份**，设置备份模式和备份文件的保存路径。
   备份模式：全盘备份、系统备份
   - 全盘备份：备份全磁盘的系统文件和用户文件
   - 系统备份：备份根分区、启动分区

   > ![notes](../common/notes.svg)说明：全盘备份无法备份在自己本身的磁盘里，只能备份在其它存储介质中。

3. 单击 **开始备份**，弹出密码输入框，请输入密码授权备份文件，直至文件备份完成。

> ![attention](../common/attention.svg)注意： 在备份文件的过程中，请不要拔掉电源或强行关机，以防止数据的丢失或损坏。

#### 还原

deepin操作系统支持从Grub、控制中心进行数据还原。

##### 从Grub进入还原

在开机时，选择系统界面，单击 **Deepin Restore**，进入deepin系统还原。用户可以选择“恢复出厂设置”读取安装时的初始化备份，也可以选择“自定义恢复”恢复已创建的历史还原点。

##### 通过控制中心进行还原

用户既可以恢复出厂设置，也可以自定义恢复前期备份的数据。

1. 在控制中心首页，单击 ![system_info_normal](../common/nav_info_42px.svg)。
2. 选择 **备份/还原** > **还原**，您可以选择：

   - 恢复出厂设置
      1. 选择是否勾选 **保留个人数据**，单击 **开始还原**，在弹出的对话框中，单击 **确定**。 
      2. 在弹出的密码输入框中，输入密码授权进行数据的还原。
   - 自定义恢复
      1. 在选择还原目录参数后，单击![loadfile](../common/loadfile.svg)选择要还原的文件。
      2. 单击 **开始还原**，开始还原系统。

### 通用设置

![general](fig/d_general.png)

#### 设置启动菜单

启动菜单，指的是开机后选择操作系统的菜单。选择某一系统后，电脑就会引导进入该操作系统。

##### 设置启动延时

当系统存在多个系统时，“启动延时”默认开启，开机后在启动菜单停留5秒钟，您可以在启动菜单单击要进入的系统。

当系统仅存在一个系统时，“启动延时”默认关闭，开机后在启动菜单停留1秒钟，不需要进行选择。

##### 修改默认启动项

1. 在控制中心首页，单击 ![general](../common/general.svg)。
2. 单击 **启动菜单**，进入启动菜单界面。
3. 单击选中某一菜单项后，该项将成为默认启动项。

##### 更改启动菜单背景

1. 在控制中心首页，单击 ![general](../common/general.svg)。
2. 单击 **启动菜单**，进入启动菜单界面。
3. 开启 **主题**，使用该主题为启动菜单的背景。

> ![tips](../common/tips.svg)窍门：您也可以把图片拖拽到预览窗口，来更换启动菜单的背景。

#### 用户体验计划
用户体验计划会收集您的硬件信息、应用信息和系统信息，帮助我们更好地了解用户的使用习惯，进而改善和提升用户体验。为了更好地使用该系统，建议您开启用户体验计划。当然，您可以随时参与或退出该计划。

1. 在控制中心首页，单击 ![general](../common/general.svg)。
2. 打开 **加入用户体验计划** 开关，了解用户体验计划许可协议。
3. 若同意，勾选 **同意并加入用户体验计划**，单击 **确定**。

## 窗口管理器
窗口管理器可以在不同的工作区内展示不同的窗口内容。通过窗口管理器您可以同时使用多个桌面，以便对桌面窗口进行分组管理。

> ![notes](../common/notes.svg)说明： 只有在“控制中心 > 个性化 > 通用”界面开启了窗口特效功能后，才支持运行窗口管理器功能。

![1|workspace](fig/d_workspace.png)

> ![notes](../common/notes.svg)说明：在触控板上，四指/五指向上移动显示多任务视图，紧接着向下移动隐藏多任务视图， 对应 **Super** + **S** 快捷键。

### 打开工作区

工作区将您的桌面窗口进行分组管理，通过划分工作区可以增大您的工作区域。

按下 **Super** + **S** 组合键，或单击 ![multitasking](../common/deepin-multitasking-view.svg) 打开工作区界面。

> ![notes](../common/notes.svg)说明：当使用触屏电脑时，手指从屏幕底部划入超过任务栏高度，打开工作区。

### 添加工作区

在工作区界面，您可以通过以下方式添加工作区。

- 单击工作区上方的 **+**。
- 按下键盘上的  **+**。

> ![notes](../common/notes.svg)说明：当您添加的工作区达到最大值时，将不能再添加工作区。

### 切换工作区
在桌面和工作区界面，您可以通过以下方式切换工作区。

- 在桌面，按下键盘上的 **Super** + ![Left](../common/Left.svg) / ![Right](../common/Right.svg) 组合键，切换到上一个/下一个工作区。
- 在桌面，按下键盘上的 **Super** + 数字键 (1-4) ， 切换到指定顺序的工作区。
- 在工作区界面，滚动鼠标滚轮切换到上一个/下一个工作区。
- 在工作区界面，按下键盘上的 ![Left](../common/Left.svg) / ![Right](../common/Right.svg)键来切换到上一个/下一个工作区。
- 在工作区界面，单击对应的预览窗口或按下数字键（1-4）来切换到指定工作区。

> ![notes](../common/notes.svg)说明：在触控板上，四指/五指向左或向右移动，切换到前一个或后一个工作区，对应 **Super** + **Left** 或 **Super** + **Right** 快捷键。

### 删除工作区

当您执行删除工作区操作后，该工作区中的所有窗口将自动转移到相邻的工作区中显示，当桌面环境中只存在一个工作区时，将不能执行删除工作区的操作。
- 在工作区界面，单击 ![close](../common/close_icon.svg) 删除工作区。
- 在工作区界面，按下键盘上的 **AIt** + **-**。
- 鼠标将某个工作区向上拖拽出屏幕，删除当前工作区。

### 退出工作区
当您在工作区界面完成相关操作后，可以通过以下方式退出工作区。

- 按下键盘上的 **Esc** 键。
- 在当前工作区界面区域内的任意位置单击一下鼠标。
- 再次按下键盘上的 **Super** + **S** 组合键。

### 查看所有窗口
您可以通过以下方式查看工作区的所有窗口。

- 按下键盘上的 **Super** + **A** 组合键，查看所有工作区的窗口。
- 按下键盘上的 **Super** + **W** 组合键，查看当前工作区的窗口。

### 移动工作区窗口
您可以通过以下方式移动窗口到另一工作区。

- 在工作区界面，拖拽窗口到指定的工作区。
- 在桌面，按下键盘上的 **Super** + **Shift** + ![Left](../common/Left.svg) / ![Right](../common/Right.svg) 键，将当前窗口移动到上一个/下一个工作区。
- 在桌面，按下键盘上的 **Super** + **Shift** + 数字键，将当前窗口移动到对应顺序的工作区。
- 在桌面，按下键盘上的 **AIt**  + **Space** 或在窗口标题栏上单击右键，打开窗口快捷操作菜单，选择 **总在可见工作区**，或 **移至右边的工作区** 或 **移至左边的工作区**，将当前窗口移动到指定的工作区。

> ![tips](../common/tips.svg)窍门：在窗口快捷操作菜单，您还可以选择最小化，最大化，移动窗口，改变窗口大小，置顶窗口和关闭窗口。

### 切换桌面窗口
您可以通过以下方式切换当前工作区的桌面窗口。

#### 快速切换相邻窗口

同时按下 **AIt**  + **Tab**  并快速释放，快速切换当前窗口和相邻程序窗口；

同时按下 **AIt** + **Shift** + **Tab** 并快速释放，快速反向切换当前窗口和相邻程序窗口。

#### 快速切换同类型窗口

同时按下 **AIt** + ![~](../common/~.svg) 并快速释放，快速切换当前同类型窗口；

同时按下 **AIt** + **Shift** +![~](../common/~.svg) 并快速释放，快速反向切换当前同类型窗口。

#### 切换所有窗口
按住键盘上的 **AIt** 键不放，连续按下键盘上的 **Tab** 键，所有窗口依次向右切换显示；

按住键盘上的 **AIt** + **Shift** 键不放，连续按下键盘上的 **Tab** 键，所有窗口依次向左切换显示。

#### 切换同类型窗口
按住键盘上的 **AIt** 键不放，连续按下键盘上的 ![~](../common/~.svg) 键，当前同类型窗口依次向右切换显示；

按住键盘上的 **AIt** + **Shift** 键不放，连续按下键盘上的 ![~](../common/~.svg) 键，窗口依次向左切换显示。

### 窗口分屏

使用窗口分屏，让多个应用和任务窗口同时显示在大屏幕上，既充分利用了大屏幕的空间，又能减少在多个应用窗口之间频繁切换，提高您的工作学习效率。

1. 拖拽窗口到屏幕左侧或者右侧，当光标接触到屏幕左右侧边缘时，会出现一个透明的白色背景，释放窗口，窗口将吸附在屏幕左半边或右半边。

> ![tips](../common/tips.svg)窍门：要取消窗口分屏，只需将窗口从屏幕一侧拖离即可。