package modules

import (
	"github.com/godbus/dbus"
)

// ModuleIFCInfo module dbus interfaces
type ModuleBusInfo struct {
	ServiceName string
	Path        string
}

const (
	moduleDBusIFC   = "com.deepin.sync.Config"
	moduleMethodSet = moduleDBusIFC + ".Set"
	moduleMethodGet = moduleDBusIFC + ".Get"
)

// Get get the module current config data via dbus caller
func (info *ModuleBusInfo) Get() ([]byte, error) {
	conn, err := dbus.SessionBus()
	if err != nil {
		return nil, err
	}
	var data []byte
	err = conn.Object(info.ServiceName, dbus.ObjectPath(info.Path)).Call(moduleMethodGet,
		0).Store(&data)
	if err != nil {
		return nil, err
	}
	return data, nil
}

// Set set the module config via dbus caller
func (info *ModuleBusInfo) Set(data []byte) error {
	conn, err := dbus.SessionBus()
	if err != nil {
		return err
	}
	return conn.Object(info.ServiceName, dbus.ObjectPath(info.Path)).Call(moduleMethodSet,
		0, data).Store()
}
