/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk-mouse.h"

typedef struct {
	GtkCheckButtonClass parent_class;

	void (*motion) (GuiGtkMouse *mouse);
	void (*button) (GuiGtkMouse *mouse);
} GuiGtkMouseClass;

enum {
	MOUSE_MOTION,
	MOUSE_BUTTON,
	GUI_GTK_MOUSE_LAST_SIGNAL
};

static guint gui_gtk_mouse_signals[GUI_GTK_MOUSE_LAST_SIGNAL] = { 0, 0 };

static GuiGtkMouse *mouse_current = NULL;

static void
gui_gtk_mouse_class_init(GuiGtkMouseClass *class)
{
	gui_gtk_mouse_signals[MOUSE_MOTION] =
		g_signal_new("mouse-motion",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkMouseClass, motion),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT, G_TYPE_NONE,
			1, G_TYPE_INT);
	gui_gtk_mouse_signals[MOUSE_BUTTON] =
		g_signal_new("mouse-button",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkMouseClass, button),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT, G_TYPE_NONE,
			1, G_TYPE_INT);
}

static void
gui_gtk_mouse_motion_do(GuiGtkMouse *mouse, unsigned int dir, int delta)
{
	int val;

	val = (dir << 16) | (delta & 0xffff);

	g_signal_emit(G_OBJECT(mouse),
			gui_gtk_mouse_signals[MOUSE_MOTION], 0, val);
}

static void
gui_gtk_mouse_button_do(GuiGtkMouse *mouse, unsigned int nr, int pressed)
{
	int val;

	val = (nr << 16) | (pressed & 0xffff);

	g_signal_emit(G_OBJECT(mouse),
			gui_gtk_mouse_signals[MOUSE_BUTTON], 0, val);
}

static void
gui_gtk_mouse_deselect(GuiGtkMouse *mouse)
{
	if (! mouse->active) {
		mouse->active = 1;

		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(mouse), 0);

		mouse->active = 0;
	}
}

static void
gui_gtk_mouse_select_toggled(GtkWidget *w, gpointer _mouse)
{
	GuiGtkMouse *mouse = (GuiGtkMouse *) _mouse;

	if (! mouse->active) {
		mouse->active = 1;

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))) {
			if (mouse_current) {
				gui_gtk_mouse_deselect(mouse_current);
			}
			mouse_current = mouse;
		} else {
			mouse_current = NULL;
		}

		mouse->active = 0;
	}
}

static void
gui_gtk_mouse_init(GuiGtkMouse *mouse)
{
	g_signal_connect(G_OBJECT(mouse), "toggled",
			G_CALLBACK(gui_gtk_mouse_select_toggled), mouse);

	/* Last call will de-select all other mice. */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mouse), 1);
}

GType
gui_gtk_mouse_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkMouseClass),
			NULL,   /* base_init */
			NULL,   /* base_finalize */
			(GClassInitFunc) gui_gtk_mouse_class_init,
			NULL,   /* class_finalize */
			NULL,   /* class_data */
			sizeof(GuiGtkMouse),
			0,      /* n_preallocs */
			(GInstanceInitFunc) gui_gtk_mouse_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_CHECK_BUTTON,
				"Mouse", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKMOUSE_TYPE       gui_gtk_mouse_get_type()

GtkWidget *
gui_gtk_mouse_new(void)
{
	GuiGtkMouse *mouse;

	mouse = GUI_GTK_MOUSE(g_object_new(GUIGTKMOUSE_TYPE, NULL));
	gtk_button_set_label(GTK_BUTTON(mouse), "Selected");
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(mouse), GTK_CAN_FOCUS);

	if (! mouse_current) {
		mouse_current = mouse;
	}

	return GTK_WIDGET(mouse);
}

void
gui_gtk_mouse_motion(unsigned int dir, int delta)
{
	if (mouse_current) {
		gui_gtk_mouse_motion_do(mouse_current, dir, delta);
	}
}

void
gui_gtk_mouse_button(unsigned int nr, int pressed)
{
	if (mouse_current) {
		gui_gtk_mouse_button_do(mouse_current, nr, pressed);
	}
}
