/* Created by Richard Frith-Macdonald <rfm@gnu.org> on 2002 Jan 24 */
/*
  Copyright (C) 2005 Free Software Foundation

  Copying and distribution of this file, with or without modification,
  are permitted in any medium without royalty provided the copyright
  notice and this notice are preserved.
*/


// GSM0338 to Unicode maping

static const unsigned int GSM0338_conv_base = 0x00;
static unichar GSM0338_char_to_uni_table[] =
{
  0x0040,
  0x00A3,
  0x0024,
  0x00A5,
  0x00E8,
  0x00E9,
  0x00F9,
  0x00EC,
  0x00F2,
  0x00C7,
  0x000A,
  0x00D8,
  0x00F8,
  0x000D,
  0x00C5,
  0x00E5,
  0x0394,
  0x005F,
  0x03A6,
  0x0393,
  0x039B,
  0x03A9,
  0x03A0,
  0x03A8,
  0x03A3,
  0x0398,
  0x039E,
  0x00A0,
  0x00C6,
  0x00E6,
  0x00DF,
  0x00C9,
  0x0020,
  0x0021,
  0x0022,
  0x0023,
  0x00A4,
  0x0025,
  0x0026,
  0x0027,
  0x0028,
  0x0029,
  0x002A,
  0x002B,
  0x002C,
  0x002D,
  0x002E,
  0x002F,
  0x0030,
  0x0031,
  0x0032,
  0x0033,
  0x0034,
  0x0035,
  0x0036,
  0x0037,
  0x0038,
  0x0039,
  0x003A,
  0x003B,
  0x003C,
  0x003D,
  0x003E,
  0x003F,
  0x00A1,
  0x0041,
  0x0042,
  0x0043,
  0x0044,
  0x0045,
  0x0046,
  0x0047,
  0x0048,
  0x0049,
  0x004A,
  0x004B,
  0x004C,
  0x004D,
  0x004E,
  0x004F,
  0x0050,
  0x0051,
  0x0052,
  0x0053,
  0x0054,
  0x0055,
  0x0056,
  0x0057,
  0x0058,
  0x0059,
  0x005A,
  0x00C4,
  0x00D6,
  0x00D1,
  0x00DC,
  0x00A7,
  0x00BF,
  0x0061,
  0x0062,
  0x0063,
  0x0064,
  0x0065,
  0x0066,
  0x0067,
  0x0068,
  0x0069,
  0x006A,
  0x006B,
  0x006C,
  0x006D,
  0x006E,
  0x006F,
  0x0070,
  0x0071,
  0x0072,
  0x0073,
  0x0074,
  0x0075,
  0x0076,
  0x0077,
  0x0078,
  0x0079,
  0x007A,
  0x00E4,
  0x00F6,
  0x00F1,
  0x00FC,
  0x00E0
};

static _ucc_ GSM0338_uni_to_char_table[] =
{
  {0x000A,0x0A,},
  {0x000D,0x0D,},
  {0x0020,0x20,},
  {0x0021,0x21,},
  {0x0022,0x22,},
  {0x0023,0x23,},
  {0x0024,0x02,},
  {0x0025,0x25,},
  {0x0026,0x26,},
  {0x0027,0x27,},
  {0x0028,0x28,},
  {0x0029,0x29,},
  {0x002A,0x2A,},
  {0x002B,0x2B,},
  {0x002C,0x2C,},
  {0x002D,0x2D,},
  {0x002E,0x2E,},
  {0x002F,0x2F,},
  {0x0030,0x30,},
  {0x0031,0x31,},
  {0x0032,0x32,},
  {0x0033,0x33,},
  {0x0034,0x34,},
  {0x0035,0x35,},
  {0x0036,0x36,},
  {0x0037,0x37,},
  {0x0038,0x38,},
  {0x0039,0x39,},
  {0x003A,0x3A,},
  {0x003B,0x3B,},
  {0x003C,0x3C,},
  {0x003D,0x3D,},
  {0x003E,0x3E,},
  {0x003F,0x3F,},
  {0x0040,0x00,},
  {0x0041,0x41,},
  {0x0042,0x42,},
  {0x0043,0x43,},
  {0x0044,0x44,},
  {0x0045,0x45,},
  {0x0046,0x46,},
  {0x0047,0x47,},
  {0x0048,0x48,},
  {0x0049,0x49,},
  {0x004A,0x4A,},
  {0x004B,0x4B,},
  {0x004C,0x4C,},
  {0x004D,0x4D,},
  {0x004E,0x4E,},
  {0x004F,0x4F,},
  {0x0050,0x50,},
  {0x0051,0x51,},
  {0x0052,0x52,},
  {0x0053,0x53,},
  {0x0054,0x54,},
  {0x0055,0x55,},
  {0x0056,0x56,},
  {0x0057,0x57,},
  {0x0058,0x58,},
  {0x0059,0x59,},
  {0x005A,0x5A,},
  {0x005F,0x11,},
  {0x0061,0x61,},
  {0x0062,0x62,},
  {0x0063,0x63,},
  {0x0064,0x64,},
  {0x0065,0x65,},
  {0x0066,0x66,},
  {0x0067,0x67,},
  {0x0068,0x68,},
  {0x0069,0x69,},
  {0x006A,0x6A,},
  {0x006B,0x6B,},
  {0x006C,0x6C,},
  {0x006D,0x6D,},
  {0x006E,0x6E,},
  {0x006F,0x6F,},
  {0x0070,0x70,},
  {0x0071,0x71,},
  {0x0072,0x72,},
  {0x0073,0x73,},
  {0x0074,0x74,},
  {0x0075,0x75,},
  {0x0076,0x76,},
  {0x0077,0x77,},
  {0x0078,0x78,},
  {0x0079,0x79,},
  {0x007A,0x7A,},
  {0x00A0,0x20,},	/* Map unicode no-break-space to gsm space */
  {0x00A1,0x40,},
  {0x00A3,0x01,},
  {0x00A4,0x24,},
  {0x00A5,0x03,},
  {0x00A7,0x5F,},
  {0x00BF,0x60,},
  {0x00C4,0x5B,},
  {0x00C5,0x0E,},
  {0x00C6,0x1C,},
  {0x00C7,0x09,},
  {0x00C9,0x1F,},
  {0x00D1,0x5D,},
  {0x00D6,0x5C,},
  {0x00D8,0x0B,},
  {0x00DC,0x5E,},
  {0x00DF,0x1E,},
  {0x00E0,0x7F,},
  {0x00E4,0x7B,},
  {0x00E5,0x0F,},
  {0x00E6,0x1D,},
  {0x00E8,0x04,},
  {0x00E9,0x05,},
  {0x00EC,0x07,},
  {0x00F1,0x7D,},
  {0x00F2,0x08,},
  {0x00F6,0x7C,},
  {0x00F8,0x0C,},
  {0x00F9,0x06,},
  {0x00FC,0x7E,},
  {0x0393,0x13,},
  {0x0394,0x10,},
  {0x0398,0x19,},
  {0x039B,0x14,},
  {0x039E,0x1A,},
  {0x03A0,0x16,},
  {0x03A3,0x18,},
  {0x03A6,0x12,},
  {0x03A8,0x17,},
  {0x03A9,0x15,}
};
#define	GSM0338_tsize	(sizeof(GSM0338_uni_to_char_table)/sizeof(_ucc_))

static _ucc_ GSM0338_escapes[] =
{
  {0x000C,0x0A},	/* Form feed	*/
  {0x005B,0x3C},	/* '['		*/
  {0x005C,0x2F},	/* '\\'		*/
  {0x005D,0x3E},	/* ']'		*/
  {0x005E,0x14},	/* '^'		*/
  {0x007B,0x28},	/* '{'		*/
  {0x007C,0x40},	/* '|'		*/
  {0x007D,0x29},	/* '}'		*/
  {0x007E,0x3D},	/* '~'		*/
  {0x20AC,0x65}		/* Euro symbol	*/
};

#define	GSM0338_esize	(sizeof(GSM0338_escapes)/sizeof(_ucc_))

/*
 * Some of these conversions should not be needed because they are
 * already handled by escape sequences ... I put them here so we can
 * support two varieties of the GSM alphabet.  The official one, and
 * a cut down version suitable for use when delivering data to phones
 * which don't support escape sequences.
 */
static _ucc_ GSM0338_lossy[] =
{
  {0x005B,0x3C},	/* '[' => '<'	*/
  {0x005C,0x2F},	/* '\\' => '/'	*/
  {0x005D,0x3E},	/* ']' => '>'	*/
  {0x005E,0x14},	/* '^' => lambda */
  {0x0060,0x27},	/* '`' => '\''	*/
  {0x007B,0x28},	/* '{' => '('	*/
  {0x007C,0x40},	/* '|' => 'i'	*/
  {0x007D,0x29},	/* '}' => ')'	*/
  {0x007E,0x3D},	/* '~' => '='	*/
  {0x00AA,'a'},	/* FEMININE ORDINAL INDICATOR */
  {0x00BA,'o'},	/* MASCULINE ORDINAL INDICATOR */
  {0x00C0,'A'},	/* LATIN CAPITAL LETTER A WITH GRAVE */
  {0x00C1,'A'},	/* LATIN CAPITAL LETTER A WITH ACUTE */
  {0x00C2,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
  {0x00C3,'A'},	/* LATIN CAPITAL LETTER A WITH TILDE */
  {0x00C7,0x09},	/* C cedilla	*/
  {0x00C8,'E'},	/* LATIN CAPITAL LETTER E WITH GRAVE */
  {0x00CA,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
  {0x00CB,'E'},	/* LATIN CAPITAL LETTER E WITH DIAERESIS */
  {0x00CC,'I'},	/* LATIN CAPITAL LETTER I WITH GRAVE */
  {0x00CD,'I'},	/* LATIN CAPITAL LETTER I WITH ACUTE */
  {0x00CE,'I'},	/* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
  {0x00CF,'I'},	/* LATIN CAPITAL LETTER I WITH DIAERESIS */
  {0x00D0,'D'},	/* LATIN CAPITAL LETTER ETH */
  {0x00D2,'O'},	/* LATIN CAPITAL LETTER O WITH GRAVE */
  {0x00D3,'O'},	/* LATIN CAPITAL LETTER O WITH ACUTE */
  {0x00D4,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
  {0x00D5,'O'},	/* LATIN CAPITAL LETTER O WITH TILDE */
  {0x00D9,'U'},	/* LATIN CAPITAL LETTER U WITH GRAVE */
  {0x00DA,'U'},	/* LATIN CAPITAL LETTER U WITH ACUTE */
  {0x00DB,'U'},	/* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
  {0x00DD,'Y'},	/* LATIN CAPITAL LETTER Y WITH ACUTE */
  {0x00DF,'s'},	/* LATIN SMALL LETTER SHARP S */
  {0x00E0,'a'},	/* LATIN SMALL LETTER A WITH GRAVE */
  {0x00E1,'a'},	/* LATIN SMALL LETTER A WITH ACUTE */
  {0x00E2,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX */
  {0x00E3,'a'},	/* LATIN SMALL LETTER A WITH TILDE */
  {0x00E7,'c'},	/* LATIN SMALL LETTER C WITH CEDILLA */
  {0x00EA,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX */
  {0x00EB,'e'},	/* LATIN SMALL LETTER E WITH DIAERESIS */
  {0x00ED,'i'},	/* LATIN SMALL LETTER I WITH ACUTE */
  {0x00EE,'i'},	/* LATIN SMALL LETTER I WITH CIRCUMFLEX */
  {0x00EF,'i'},	/* LATIN SMALL LETTER I WITH DIAERESIS */
  {0x00F0,'d'},	/* LATIN SMALL LETTER ETH */
  {0x00F3,'o'},	/* LATIN SMALL LETTER O WITH ACUTE */
  {0x00F4,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX */
  {0x00F5,'o'},	/* LATIN SMALL LETTER O WITH TILDE */
  {0x00FA,'u'},	/* LATIN SMALL LETTER U WITH ACUTE */
  {0x00FB,'u'},	/* LATIN SMALL LETTER U WITH CIRCUMFLEX */
  {0x00FD,'y'},	/* LATIN SMALL LETTER Y WITH ACUTE */
  {0x00FF,'y'},	/* LATIN SMALL LETTER Y WITH DIAERESIS */
  {0x0100,'A'},	/* LATIN CAPITAL LETTER A WITH MACRON */
  {0x0101,'a'},	/* LATIN SMALL LETTER A WITH MACRON */
  {0x0102,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE */
  {0x0103,'a'},	/* LATIN SMALL LETTER A WITH BREVE */
  {0x0104,'A'},	/* LATIN CAPITAL LETTER A WITH OGONEK */
  {0x0105,'a'},	/* LATIN SMALL LETTER A WITH OGONEK */
  {0x0106,'C'},	/* LATIN CAPITAL LETTER C WITH ACUTE */
  {0x0107,'c'},	/* LATIN SMALL LETTER C WITH ACUTE */
  {0x0108,'C'},	/* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
  {0x0109,'c'},	/* LATIN SMALL LETTER C WITH CIRCUMFLEX */
  {0x010A,'C'},	/* LATIN CAPITAL LETTER C WITH DOT ABOVE */
  {0x010B,'c'},	/* LATIN SMALL LETTER C WITH DOT ABOVE */
  {0x010C,'C'},	/* LATIN CAPITAL LETTER C WITH CARON */
  {0x010D,'c'},	/* LATIN SMALL LETTER C WITH CARON */
  {0x010E,'D'},	/* LATIN CAPITAL LETTER D WITH CARON */
  {0x010F,'d'},	/* LATIN SMALL LETTER D WITH CARON */
  {0x0110,'D'},	/* LATIN CAPITAL LETTER D WITH STROKE */
  {0x0111,'d'},	/* LATIN SMALL LETTER D WITH STROKE */
  {0x0112,'E'},	/* LATIN CAPITAL LETTER E WITH MACRON */
  {0x0113,'e'},	/* LATIN SMALL LETTER E WITH MACRON */
  {0x0114,'E'},	/* LATIN CAPITAL LETTER E WITH BREVE */
  {0x0115,'e'},	/* LATIN SMALL LETTER E WITH BREVE */
  {0x0116,'E'},	/* LATIN CAPITAL LETTER E WITH DOT ABOVE */
  {0x0117,'e'},	/* LATIN SMALL LETTER E WITH DOT ABOVE */
  {0x0118,'E'},	/* LATIN CAPITAL LETTER E WITH OGONEK */
  {0x0119,'e'},	/* LATIN SMALL LETTER E WITH OGONEK */
  {0x011A,'E'},	/* LATIN CAPITAL LETTER E WITH CARON */
  {0x011B,'e'},	/* LATIN SMALL LETTER E WITH CARON */
  {0x011C,'G'},	/* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
  {0x011D,'g'},	/* LATIN SMALL LETTER G WITH CIRCUMFLEX */
  {0x011E,'G'},	/* LATIN CAPITAL LETTER G WITH BREVE */
  {0x011F,'g'},	/* LATIN SMALL LETTER G WITH BREVE */
  {0x0120,'G'},	/* LATIN CAPITAL LETTER G WITH DOT ABOVE */
  {0x0121,'g'},	/* LATIN SMALL LETTER G WITH DOT ABOVE */
  {0x0122,'G'},	/* LATIN CAPITAL LETTER G WITH CEDILLA */
  {0x0123,'g'},	/* LATIN SMALL LETTER G WITH CEDILLA */
  {0x0124,'H'},	/* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
  {0x0125,'h'},	/* LATIN SMALL LETTER H WITH CIRCUMFLEX */
  {0x0126,'H'},	/* LATIN CAPITAL LETTER H WITH STROKE */
  {0x0127,'h'},	/* LATIN SMALL LETTER H WITH STROKE */
  {0x0128,'I'},	/* LATIN CAPITAL LETTER I WITH TILDE */
  {0x0129,'i'},	/* LATIN SMALL LETTER I WITH TILDE */
  {0x012A,'I'},	/* LATIN CAPITAL LETTER I WITH MACRON */
  {0x012B,'i'},	/* LATIN SMALL LETTER I WITH MACRON */
  {0x012C,'I'},	/* LATIN CAPITAL LETTER I WITH BREVE */
  {0x012D,'i'},	/* LATIN SMALL LETTER I WITH BREVE */
  {0x012E,'I'},	/* LATIN CAPITAL LETTER I WITH OGONEK */
  {0x012F,'i'},	/* LATIN SMALL LETTER I WITH OGONEK */
  {0x0130,'I'},	/* LATIN CAPITAL LETTER I WITH DOT ABOVE */
  {0x0131,'i'},	/* LATIN SMALL LETTER DOTLESS I */
  {0x0132,'I'},	/* LATIN CAPITAL LIGATURE IJ     */
  {0x0133,'i'},	/* LATIN SMALL LIGATURE IJ       */
  {0x0134,'J'},	/* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
  {0x0135,'j'},	/* LATIN SMALL LETTER J WITH CIRCUMFLEX */
  {0x0136,'K'},	/* LATIN CAPITAL LETTER K WITH CEDILLA */
  {0x0137,'k'},	/* LATIN SMALL LETTER K WITH CEDILLA */
  {0x0138,'k'},	/* LATIN SMALL LETTER KRA */
  {0x0139,'L'},	/* LATIN CAPITAL LETTER L WITH ACUTE */
  {0x013A,'l'},	/* LATIN SMALL LETTER L WITH ACUTE */
  {0x013B,'L'},	/* LATIN CAPITAL LETTER L WITH CEDILLA */
  {0x013C,'l'},	/* LATIN SMALL LETTER L WITH CEDILLA */
  {0x013D,'L'},	/* LATIN CAPITAL LETTER L WITH CARON */
  {0x013E,'l'},	/* LATIN SMALL LETTER L WITH CARON */
  {0x013F,'L'},	/* LATIN CAPITAL LETTER L WITH MIDDLE DOT */
  {0x0140,'l'},	/* LATIN SMALL LETTER L WITH MIDDLE DOT */
  {0x0141,'L'},	/* LATIN CAPITAL LETTER L WITH STROKE */
  {0x0142,'l'},	/* LATIN SMALL LETTER L WITH STROKE */
  {0x0143,'N'},	/* LATIN CAPITAL LETTER N WITH ACUTE */
  {0x0144,'n'},	/* LATIN SMALL LETTER N WITH ACUTE */
  {0x0145,'N'},	/* LATIN CAPITAL LETTER N WITH CEDILLA */
  {0x0146,'n'},	/* LATIN SMALL LETTER N WITH CEDILLA */
  {0x0147,'N'},	/* LATIN CAPITAL LETTER N WITH CARON */
  {0x0148,'n'},	/* LATIN SMALL LETTER N WITH CARON */
  {0x014C,'O'},	/* LATIN CAPITAL LETTER O WITH MACRON */
  {0x014D,'o'},	/* LATIN SMALL LETTER O WITH MACRON */
  {0x014E,'O'},	/* LATIN CAPITAL LETTER O WITH BREVE */
  {0x014F,'o'},	/* LATIN SMALL LETTER O WITH BREVE */
  {0x0150,'O'},	/* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
  {0x0151,'o'},	/* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
  {0x0154,'R'},	/* LATIN CAPITAL LETTER R WITH ACUTE */
  {0x0155,'r'},	/* LATIN SMALL LETTER R WITH ACUTE */
  {0x0156,'R'},	/* LATIN CAPITAL LETTER R WITH CEDILLA */
  {0x0157,'r'},	/* LATIN SMALL LETTER R WITH CEDILLA */
  {0x0158,'R'},	/* LATIN CAPITAL LETTER R WITH CARON */
  {0x0159,'r'},	/* LATIN SMALL LETTER R WITH CARON */
  {0x015A,'S'},	/* LATIN CAPITAL LETTER S WITH ACUTE */
  {0x015B,'s'},	/* LATIN SMALL LETTER S WITH ACUTE */
  {0x015C,'S'},	/* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
  {0x015D,'s'},	/* LATIN SMALL LETTER S WITH CIRCUMFLEX */
  {0x015E,'S'},	/* LATIN CAPITAL LETTER S WITH CEDILLA */
  {0x015F,'s'},	/* LATIN SMALL LETTER S WITH CEDILLA */
  {0x0160,'S'},	/* LATIN CAPITAL LETTER S WITH CARON */
  {0x0161,'s'},	/* LATIN SMALL LETTER S WITH CARON */
  {0x0162,'T'},	/* LATIN CAPITAL LETTER T WITH CEDILLA */
  {0x0163,'t'},	/* LATIN SMALL LETTER T WITH CEDILLA */
  {0x0164,'T'},	/* LATIN CAPITAL LETTER T WITH CARON */
  {0x0165,'t'},	/* LATIN SMALL LETTER T WITH CARON */
  {0x0166,'T'},	/* LATIN CAPITAL LETTER T WITH STROKE */
  {0x0167,'t'},	/* LATIN SMALL LETTER T WITH STROKE */
  {0x0168,'U'},	/* LATIN CAPITAL LETTER U WITH TILDE */
  {0x0169,'u'},	/* LATIN SMALL LETTER U WITH TILDE */
  {0x016A,'U'},	/* LATIN CAPITAL LETTER U WITH MACRON */
  {0x016B,'u'},	/* LATIN SMALL LETTER U WITH MACRON */
  {0x016C,'U'},	/* LATIN CAPITAL LETTER U WITH BREVE */
  {0x016D,'u'},	/* LATIN SMALL LETTER U WITH BREVE */
  {0x016E,'U'},	/* LATIN CAPITAL LETTER U WITH RING ABOVE */
  {0x016F,'u'},	/* LATIN SMALL LETTER U WITH RING ABOVE */
  {0x0170,'U'},	/* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
  {0x0171,'u'},	/* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
  {0x0172,'U'},	/* LATIN CAPITAL LETTER U WITH OGONEK */
  {0x0173,'u'},	/* LATIN SMALL LETTER U WITH OGONEK */
  {0x0174,'W'},	/* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */
  {0x0175,'w'},	/* LATIN SMALL LETTER W WITH CIRCUMFLEX */
  {0x0176,'Y'},	/* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */
  {0x0177,'y'},	/* LATIN SMALL LETTER Y WITH CIRCUMFLEX */
  {0x0178,'Y'},	/* LATIN CAPITAL LETTER Y WITH DIAERESIS */
  {0x0179,'Z'},	/* LATIN CAPITAL LETTER Z WITH ACUTE */
  {0x017A,'z'},	/* LATIN SMALL LETTER Z WITH ACUTE */
  {0x017B,'Z'},	/* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
  {0x017C,'z'},	/* LATIN SMALL LETTER Z WITH DOT ABOVE */
  {0x017D,'Z'},	/* LATIN CAPITAL LETTER Z WITH CARON */
  {0x017E,'z'},	/* LATIN SMALL LETTER Z WITH CARON */
  {0x017F,'s'},	/* LATIN SMALL LETTER LONG S     */
  {0x0180,'b'},	/* LATIN SMALL LETTER B WITH STROKE */
  {0x0181,'B'},	/* LATIN CAPITAL LETTER B WITH HOOK */
  {0x0182,'B'},	/* LATIN CAPITAL LETTER B WITH TOPBAR */
  {0x0183,'b'},	/* LATIN SMALL LETTER B WITH TOPBAR */
  {0x0184,'6'},	/* LATIN CAPITAL LETTER TONE SIX */
  {0x0185,'6'},	/* LATIN SMALL LETTER TONE SIX */
  {0x0186,'O'},	/* LATIN CAPITAL LETTER OPEN O */
  {0x0187,'C'},	/* LATIN CAPITAL LETTER C WITH HOOK */
  {0x0188,'c'},	/* LATIN SMALL LETTER C WITH HOOK */
  {0x0189,'D'},	/* LATIN CAPITAL LETTER AFRICAN D */
  {0x018A,'D'},	/* LATIN CAPITAL LETTER D WITH HOOK */
  {0x018B,'D'},	/* LATIN CAPITAL LETTER D WITH TOPBAR */
  {0x018C,'d'},	/* LATIN SMALL LETTER D WITH TOPBAR */
  {0x018D,'d'},	/* LATIN SMALL LETTER TURNED DELTA */
  {0x018E,'E'},	/* LATIN CAPITAL LETTER REVERSED E */
  {0x018F,'E'},	/* LATIN CAPITAL LETTER SCHWA */
  {0x0190,'E'},	/* LATIN CAPITAL LETTER OPEN E */
  {0x0191,'F'},	/* LATIN CAPITAL LETTER F WITH HOOK */
  {0x0192,'f'},	/* LATIN SMALL LETTER F WITH HOOK */
  {0x0193,'G'},	/* LATIN CAPITAL LETTER G WITH HOOK */
  {0x0194,'G'},	/* LATIN CAPITAL LETTER GAMMA */
  {0x0196,'I'},	/* LATIN CAPITAL LETTER IOTA */
  {0x0197,'I'},	/* LATIN CAPITAL LETTER I WITH STROKE */
  {0x0198,'K'},	/* LATIN CAPITAL LETTER K WITH HOOK */
  {0x0199,'k'},	/* LATIN SMALL LETTER K WITH HOOK */
  {0x019A,'l'},	/* LATIN SMALL LETTER L WITH BAR */
  {0x019B,'l'},	/* LATIN SMALL LETTER LAMBDA WITH STROKE */
  {0x019C,'M'},	/* LATIN CAPITAL LETTER TURNED M */
  {0x019D,'N'},	/* LATIN CAPITAL LETTER N WITH LEFT HOOK */
  {0x019E,'n'},	/* LATIN SMALL LETTER N WITH LONG RIGHT LEG */
  {0x019F,'O'},	/* LATIN CAPITAL LETTER O WITH MIDDLE TILDE */
  {0x01A0,'O'},	/* LATIN CAPITAL LETTER O WITH HORN */
  {0x01A1,'o'},	/* LATIN SMALL LETTER O WITH HORN */
  {0x01A4,'P'},	/* LATIN CAPITAL LETTER P WITH HOOK */
  {0x01A5,'p'},	/* LATIN SMALL LETTER P WITH HOOK */
  {0x01A7,'2'},	/* LATIN CAPITAL LETTER TONE TWO */
  {0x01A8,'2'},	/* LATIN SMALL LETTER TONE TWO */
  {0x01A9,'S'},	/* LATIN CAPITAL LETTER ESH */
  {0x01AA,'s'},	/* LATIN LETTER REVERSED ESH LOOP */
  {0x01AB,'t'},	/* LATIN SMALL LETTER T WITH PALATAL HOOK */
  {0x01AC,'T'},	/* LATIN CAPITAL LETTER T WITH HOOK */
  {0x01AD,'t'},	/* LATIN SMALL LETTER T WITH HOOK */
  {0x01AE,'T'},	/* LATIN CAPITAL LETTER T WITH RETROFLEX HOOK */
  {0x01AF,'U'},	/* LATIN CAPITAL LETTER U WITH HORN */
  {0x01B0,'u'},	/* LATIN SMALL LETTER U WITH HORN */
  {0x01B1,'u'},	/* LATIN CAPITAL LETTER UPSILON */
  {0x01B2,'V'},	/* LATIN CAPITAL LETTER V WITH HOOK */
  {0x01B3,'Y'},	/* LATIN CAPITAL LETTER Y WITH HOOK */
  {0x01B4,'y'},	/* LATIN SMALL LETTER Y WITH HOOK */
  {0x01B5,'Z'},	/* LATIN CAPITAL LETTER Z WITH STROKE */
  {0x01B6,'z'},	/* LATIN SMALL LETTER Z WITH STROKE */
  {0x01B7,'Z'},	/* LATIN CAPITAL LETTER EZH */
  {0x01B8,'Z'},	/* LATIN CAPITAL LETTER EZH REVERSED */
  {0x01B9,'Z'},	/* LATIN SMALL LETTER EZH REVERSED */
  {0x01BA,'z'},	/* LATIN SMALL LETTER EZH WITH TAIL */
  {0x01BB,'2'},	/* LATIN LETTER TWO WITH STROKE */
  {0x01BC,'5'},	/* LATIN CAPITAL LETTER TONE FIVE */
  {0x01BD,'5'},	/* LATIN SMALL LETTER TONE FIVE */
  {0x01BF,'w'},	/* LATIN LETTER WYNN */
  {0x01C6,'d'},	/* LATIN SMALL LETTER DZ WITH CARON */
  {0x01CD,'A'},	/* LATIN CAPITAL LETTER A WITH CARON */
  {0x01CE,'a'},	/* LATIN SMALL LETTER A WITH CARON */
  {0x01CF,'I'},	/* LATIN CAPITAL LETTER I WITH CARON */
  {0x01D0,'i'},	/* LATIN SMALL LETTER I WITH CARON */
  {0x01D1,'O'},	/* LATIN CAPITAL LETTER O WITH CARON */
  {0x01D2,'o'},	/* LATIN SMALL LETTER O WITH CARON */
  {0x01D3,'U'},	/* LATIN CAPITAL LETTER U WITH CARON */
  {0x01D4,'u'},	/* LATIN SMALL LETTER U WITH CARON */
  {0x01D5,'U'},	/* LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON */
  {0x01D6,'u'},	/* LATIN SMALL LETTER U WITH DIAERESIS AND MACRON */
  {0x01D7,'U'},	/* LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE */
  {0x01D8,'u'},	/* LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE */
  {0x01D9,'U'},	/* LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON */
  {0x01DA,'u'},	/* LATIN SMALL LETTER U WITH DIAERESIS AND CARON */
  {0x01DB,'U'},	/* LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE */
  {0x01DC,'u'},	/* LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE */
  {0x01DD,'e'},	/* LATIN SMALL LETTER TURNED E */
  {0x01DE,'A'},	/* LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON */
  {0x01DF,'a'},	/* LATIN SMALL LETTER A WITH DIAERESIS AND MACRON */
  {0x01E0,'A'},	/* LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON */
  {0x01E1,'a'},	/* LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON */
  {0x01E4,'G'},	/* LATIN CAPITAL LETTER G WITH STROKE */
  {0x01E5,'g'},	/* LATIN SMALL LETTER G WITH STROKE */
  {0x01E6,'G'},	/* LATIN CAPITAL LETTER G WITH CARON */
  {0x01E7,'g'},	/* LATIN SMALL LETTER G WITH CARON */
  {0x01E8,'K'},	/* LATIN CAPITAL LETTER K WITH CARON */
  {0x01E9,'k'},	/* LATIN SMALL LETTER K WITH CARON */
  {0x01EA,'O'},	/* LATIN CAPITAL LETTER O WITH OGONEK */
  {0x01EB,'o'},	/* LATIN SMALL LETTER O WITH OGONEK */
  {0x01EC,'O'},	/* LATIN CAPITAL LETTER O WITH OGONEK AND MACRON */
  {0x01ED,'o'},	/* LATIN SMALL LETTER O WITH OGONEK AND MACRON */
  {0x01EE,'Z'},	/* LATIN CAPITAL LETTER EZH WITH CARON */
  {0x01EF,'Z'},	/* LATIN SMALL LETTER EZH WITH CARON */
  {0x01F0,'j'},	/* LATIN SMALL LETTER J WITH CARON */
  {0x01F4,'G'},	/* LATIN CAPITAL LETTER G WITH ACUTE */
  {0x01F5,'g'},	/* LATIN SMALL LETTER G WITH ACUTE */
  {0x01F7,'w'},	/* LATIN CAPITAL LETTER WYNN */
  {0x01F8,'N'},	/* LATIN CAPITAL LETTER N WITH GRAVE */
  {0x01F9,'n'},	/* LATIN SMALL LETTER N WITH GRAVE */
  {0x01FA,'A'},	/* LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */
  {0x01FB,'a'},	/* LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */
  {0x01FE,'O'},	/* LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */
  {0x01FF,'o'},	/* LATIN SMALL LETTER O WITH STROKE AND ACUTE */
  {0x0200,'A'},	/* LATIN CAPITAL LETTER A WITH DOUBLE GRAVE */
  {0x0201,'a'},	/* LATIN SMALL LETTER A WITH DOUBLE GRAVE */
  {0x0202,'A'},	/* LATIN CAPITAL LETTER A WITH INVERTED BREVE */
  {0x0203,'a'},	/* LATIN SMALL LETTER A WITH INVERTED BREVE */
  {0x0204,'E'},	/* LATIN CAPITAL LETTER E WITH DOUBLE GRAVE */
  {0x0205,'e'},	/* LATIN SMALL LETTER E WITH DOUBLE GRAVE */
  {0x0206,'E'},	/* LATIN CAPITAL LETTER E WITH INVERTED BREVE */
  {0x0207,'e'},	/* LATIN SMALL LETTER E WITH INVERTED BREVE */
  {0x0208,'I'},	/* LATIN CAPITAL LETTER I WITH DOUBLE GRAVE */
  {0x0209,'i'},	/* LATIN SMALL LETTER I WITH DOUBLE GRAVE */
  {0x020A,'I'},	/* LATIN CAPITAL LETTER I WITH INVERTED BREVE */
  {0x020B,'i'},	/* LATIN SMALL LETTER I WITH INVERTED BREVE */
  {0x020C,'O'},	/* LATIN CAPITAL LETTER O WITH DOUBLE GRAVE */
  {0x020D,'o'},	/* LATIN SMALL LETTER O WITH DOUBLE GRAVE */
  {0x020E,'O'},	/* LATIN CAPITAL LETTER O WITH INVERTED BREVE */
  {0x020F,'o'},	/* LATIN SMALL LETTER O WITH INVERTED BREVE */
  {0x0210,'R'},	/* LATIN CAPITAL LETTER R WITH DOUBLE GRAVE */
  {0x0211,'r'},	/* LATIN SMALL LETTER R WITH DOUBLE GRAVE */
  {0x0212,'R'},	/* LATIN CAPITAL LETTER R WITH INVERTED BREVE */
  {0x0213,'r'},	/* LATIN SMALL LETTER R WITH INVERTED BREVE */
  {0x0214,'U'},	/* LATIN CAPITAL LETTER U WITH DOUBLE GRAVE */
  {0x0215,'u'},	/* LATIN SMALL LETTER U WITH DOUBLE GRAVE */
  {0x0216,'U'},	/* LATIN CAPITAL LETTER U WITH INVERTED BREVE */
  {0x0217,'u'},	/* LATIN SMALL LETTER U WITH INVERTED BREVE */
  {0x0218,'S'},	/* LATIN CAPITAL LETTER S WITH COMMA BELOW */
  {0x0219,'s'},	/* LATIN SMALL LETTER S WITH COMMA BELOW */
  {0x021A,'T'},	/* LATIN CAPITAL LETTER T WITH COMMA BELOW */
  {0x021B,'t'},	/* LATIN SMALL LETTER T WITH COMMA BELOW */
  {0x021C,'Z'},	/* LATIN CAPITAL LETTER YOGH */
  {0x021D,'z'},	/* LATIN SMALL LETTER YOGH */
  {0x021E,'H'},	/* LATIN CAPITAL LETTER H WITH CARON */
  {0x021F,'h'},	/* LATIN SMALL LETTER H WITH CARON */
  {0x0220,'N'},	/* LATIN CAPITAL LETTER N WITH LONG RIGHT LEG */
  {0x0221,'d'},	/* LATIN SMALL LETTER D WITH CURL */
  {0x0224,'Z'},	/* LATIN CAPITAL LETTER Z WITH HOOK */
  {0x0225,'z'},	/* LATIN SMALL LETTER Z WITH HOOK */
  {0x0226,'A'},	/* LATIN CAPITAL LETTER A WITH DOT ABOVE */
  {0x0227,'a'},	/* LATIN SMALL LETTER A WITH DOT ABOVE */
  {0x0228,'E'},	/* LATIN CAPITAL LETTER E WITH CEDILLA */
  {0x0229,'e'},	/* LATIN SMALL LETTER E WITH CEDILLA */
  {0x022A,'O'},	/* LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON */
  {0x022B,'o'},	/* LATIN SMALL LETTER O WITH DIAERESIS AND MACRON */
  {0x022C,'O'},	/* LATIN CAPITAL LETTER O WITH TILDE AND MACRON */
  {0x022D,'o'},	/* LATIN SMALL LETTER O WITH TILDE AND MACRON */
  {0x022E,'O'},	/* LATIN CAPITAL LETTER O WITH DOT ABOVE */
  {0x022F,'o'},	/* LATIN SMALL LETTER O WITH DOT ABOVE */
  {0x0230,'O'},	/* LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON */
  {0x0231,'o'},	/* LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON */
  {0x0232,'Y'},	/* LATIN CAPITAL LETTER Y WITH MACRON */
  {0x0233,'y'},	/* LATIN SMALL LETTER Y WITH MACRON */
  {0x0234,'l'},	/* LATIN SMALL LETTER L WITH CURL */
  {0x0235,'n'},	/* LATIN SMALL LETTER N WITH CURL */
  {0x0236,'t'},	/* LATIN SMALL LETTER T WITH CURL */
  {0x0250,'a'},	/* LATIN SMALL LETTER TURNED A */
  {0x0251,'a'},	/* LATIN SMALL LETTER ALPHA */
  {0x0252,'a'},	/* LATIN SMALL LETTER TURNED ALPHA */
  {0x0253,'b'},	/* LATIN SMALL LETTER B WITH HOOK */
  {0x0254,'o'},	/* LATIN SMALL LETTER OPEN O */
  {0x0255,'c'},	/* LATIN SMALL LETTER C WITH CURL */
  {0x0256,'d'},	/* LATIN SMALL LETTER D WITH TAIL */
  {0x0257,'d'},	/* LATIN SMALL LETTER D WITH HOOK */
  {0x0258,'e'},	/* LATIN SMALL LETTER REVERSED E */
  {0x0259,'e'},	/* LATIN SMALL LETTER SCHWA */
  {0x025A,'e'},	/* LATIN SMALL LETTER SCHWA WITH HOOK */
  {0x025B,'e'},	/* LATIN SMALL LETTER OPEN E */
  {0x025C,'e'},	/* LATIN SMALL LETTER REVERSED OPEN E */
  {0x025D,'e'},	/* LATIN SMALL LETTER REVERSED OPEN E WITH HOOK */
  {0x025E,'e'},	/* LATIN SMALL LETTER CLOSED REVERSED OPEN E */
  {0x025F,'j'},	/* LATIN SMALL LETTER DOTLESS J WITH STROKE */
  {0x0260,'g'},	/* LATIN SMALL LETTER G WITH HOOK */
  {0x0261,'g'},	/* LATIN SMALL LETTER SCRIPT G */
  {0x0262,'G'},	/* LATIN LETTER SMALL CAPITAL G */
  {0x0263,'g'},	/* LATIN SMALL LETTER GAMMA */
  {0x0264,'y'},	/* LATIN SMALL LETTER RAMS HORN */
  {0x0265,'h'},	/* LATIN SMALL LETTER TURNED H */
  {0x0266,'h'},	/* LATIN SMALL LETTER H WITH HOOK */
  {0x0267,'h'},	/* LATIN SMALL LETTER HENG WITH HOOK */
  {0x0268,'i'},	/* LATIN SMALL LETTER I WITH STROKE */
  {0x0269,'i'},	/* LATIN SMALL LETTER IOTA */
  {0x026A,'I'},	/* LATIN LETTER SMALL CAPITAL I */
  {0x026B,'l'},	/* LATIN SMALL LETTER L WITH MIDDLE TILDE */
  {0x026C,'l'},	/* LATIN SMALL LETTER L WITH BELT */
  {0x026D,'l'},	/* LATIN SMALL LETTER L WITH RETROFLEX HOOK */
  {0x026F,'m'},	/* LATIN SMALL LETTER TURNED M */
  {0x0270,'m'},	/* LATIN SMALL LETTER TURNED M WITH LONG LEG */
  {0x0271,'m'},	/* LATIN SMALL LETTER M WITH HOOK */
  {0x0272,'n'},	/* LATIN SMALL LETTER N WITH LEFT HOOK */
  {0x0273,'n'},	/* LATIN SMALL LETTER N WITH RETROFLEX HOOK */
  {0x0274,'N'},	/* LATIN LETTER SMALL CAPITAL N */
  {0x0275,'o'},	/* LATIN SMALL LETTER BARRED O */
  {0x0277,'o'},	/* LATIN SMALL LETTER CLOSED OMEGA */
  {0x0279,'r'},	/* LATIN SMALL LETTER TURNED R */
  {0x027A,'r'},	/* LATIN SMALL LETTER TURNED R WITH LONG LEG */
  {0x027B,'r'},	/* LATIN SMALL LETTER TURNED R WITH HOOK */
  {0x027C,'r'},	/* LATIN SMALL LETTER R WITH LONG LEG */
  {0x027D,'r'},	/* LATIN SMALL LETTER R WITH TAIL */
  {0x027E,'r'},	/* LATIN SMALL LETTER R WITH FISHHOOK */
  {0x027F,'r'},	/* LATIN SMALL LETTER REVERSED R WITH FISHHOOK */
  {0x0280,'R'},	/* LATIN LETTER SMALL CAPITAL R */
  {0x0281,'r'},	/* LATIN LETTER SMALL CAPITAL INVERTED R */
  {0x0282,'s'},	/* LATIN SMALL LETTER S WITH HOOK */
  {0x0283,'s'},	/* LATIN SMALL LETTER ESH */
  {0x0284,'j'},	/* LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK */
  {0x0285,'s'},	/* LATIN SMALL LETTER SQUAT REVERSED ESH */
  {0x0286,'s'},	/* LATIN SMALL LETTER ESH WITH CURL */
  {0x0287,'y'},	/* LATIN SMALL LETTER TURNED T */
  {0x0288,'t'},	/* LATIN SMALL LETTER T WITH RETROFLEX HOOK */
  {0x0289,'u'},	/* LATIN SMALL LETTER U BAR */
  {0x028A,'u'},	/* LATIN SMALL LETTER UPSILON */
  {0x028B,'u'},	/* LATIN SMALL LETTER V WITH HOOK */
  {0x028C,'v'},	/* LATIN SMALL LETTER TURNED V */
  {0x028D,'w'},	/* LATIN SMALL LETTER TURNED W */
  {0x028E,'y'},	/* LATIN SMALL LETTER TURNED Y */
  {0x028F,'Y'},	/* LATIN LETTER SMALL CAPITAL Y */
  {0x0290,'z'},	/* LATIN SMALL LETTER Z WITH RETROFLEX HOOK */
  {0x0291,'z'},	/* LATIN SMALL LETTER Z WITH CURL */
  {0x0292,'z'},	/* LATIN SMALL LETTER EZH */
  {0x0293,'z'},	/* LATIN SMALL LETTER EZH WITH CURL */
  {0x0297,'C'},	/* LATIN LETTER STRETCHED C */
  {0x0299,'B'},	/* LATIN LETTER SMALL CAPITAL B */
  {0x029A,'e'},	/* LATIN SMALL LETTER CLOSED OPEN E */
  {0x029B,'G'},	/* LATIN LETTER SMALL CAPITAL G WITH HOOK */
  {0x029C,'H'},	/* LATIN LETTER SMALL CAPITAL H */
  {0x029D,'j'},	/* LATIN SMALL LETTER J WITH CROSSED-TAIL */
  {0x029E,'k'},	/* LATIN SMALL LETTER TURNED K */
  {0x029F,'L'},	/* LATIN LETTER SMALL CAPITAL L */
  {0x02A0,'q'},	/* LATIN SMALL LETTER Q WITH HOOK */
  {0x02AC,'w'},	/* LATIN LETTER BILABIAL PERCUSSIVE */
  {0x02AD,'t'},	/* LATIN LETTER BIDENTAL PERCUSSIVE */
  {0x02AE,'h'},	/* LATIN SMALL LETTER TURNED H WITH FISHHOOK */
  {0x02AF,'h'},	/* LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL */
  {0x02B0,'h'},	/* MODIFIER LETTER SMALL H */
  {0x02B1,'h'},	/* MODIFIER LETTER SMALL H WITH HOOK */
  {0x02B2,'j'},	/* MODIFIER LETTER SMALL J */
  {0x02B3,'r'},	/* MODIFIER LETTER SMALL R */
  {0x02B4,'r'},	/* MODIFIER LETTER SMALL TURNED R */
  {0x02B5,'r'},	/* MODIFIER LETTER SMALL TURNED R WITH HOOK */
  {0x02B6,'R'},	/* MODIFIER LETTER SMALL CAPITAL INVERTED R */
  {0x02B7,'w'},	/* MODIFIER LETTER SMALL W */
  {0x02B8,'y'},	/* MODIFIER LETTER SMALL Y */
  {0x02E1,'l'},	/* MODIFIER LETTER SMALL L */
  {0x02E2,'s'},	/* MODIFIER LETTER SMALL S */
  {0x02E3,'x'},	/* MODIFIER LETTER SMALL X */
  {0x0391,0x41},	/* Alpha	*/
  {0x0392,0x42},	/* Beta		*/
  {0x0395,0x45},	/* Epsilon	*/
  {0x0396,0x5A},	/* Zeta		*/
  {0x0397,0x48},	/* Eta		*/
  {0x0399,0x49},	/* Iota		*/
  {0x039A,0x4B},	/* Kappa	*/
  {0x039C,0x4D},	/* Mu		*/
  {0x039D,0x4E},	/* Nu		*/
  {0x039F,0x4F},	/* Omicron	*/
  {0x03A1,0x50},	/* Rho		*/
  {0x03A4,0x54},	/* Tau		*/
  {0x03A5,0x55},	/* Upsilon	*/
  {0x03A7,0x58},	/* Chi		*/
  {0x1D00,'A'},	/* LATIN LETTER SMALL CAPITAL A */
  {0x1D03,'B'},	/* LATIN LETTER SMALL CAPITAL BARRED B */
  {0x1D04,'C'},	/* LATIN LETTER SMALL CAPITAL C */
  {0x1D05,'D'},	/* LATIN LETTER SMALL CAPITAL D */
  {0x1D07,'E'},	/* LATIN LETTER SMALL CAPITAL E */
  {0x1D08,'e'},	/* LATIN SMALL LETTER TURNED OPEN E */
  {0x1D09,'i'},	/* LATIN SMALL LETTER TURNED I */
  {0x1D0A,'J'},	/* LATIN LETTER SMALL CAPITAL J */
  {0x1D0B,'K'},	/* LATIN LETTER SMALL CAPITAL K */
  {0x1D0C,'L'},	/* LATIN LETTER SMALL CAPITAL L WITH STROKE */
  {0x1D0D,'M'},	/* LATIN LETTER SMALL CAPITAL M */
  {0x1D0E,'N'},	/* LATIN LETTER SMALL CAPITAL REVERSED N */
  {0x1D0F,'O'},	/* LATIN LETTER SMALL CAPITAL O */
  {0x1D10,'O'},	/* LATIN LETTER SMALL CAPITAL OPEN O */
  {0x1D11,'o'},	/* LATIN SMALL LETTER SIDEWAYS O */
  {0x1D12,'o'},	/* LATIN SMALL LETTER SIDEWAYS OPEN O */
  {0x1D13,'o'},	/* LATIN SMALL LETTER SIDEWAYS O WITH STROKE */
  {0x1D16,'o'},	/* LATIN SMALL LETTER TOP HALF O */
  {0x1D17,'o'},	/* LATIN SMALL LETTER BOTTOM HALF O */
  {0x1D18,'P'},	/* LATIN LETTER SMALL CAPITAL P */
  {0x1D19,'R'},	/* LATIN LETTER SMALL CAPITAL REVERSED R */
  {0x1D1A,'R'},	/* LATIN LETTER SMALL CAPITAL TURNED R */
  {0x1D1B,'T'},	/* LATIN LETTER SMALL CAPITAL T */
  {0x1D1C,'U'},	/* LATIN LETTER SMALL CAPITAL U */
  {0x1D1D,'u'},	/* LATIN SMALL LETTER SIDEWAYS U */
  {0x1D1E,'u'},	/* LATIN SMALL LETTER SIDEWAYS DIAERESIZED U */
  {0x1D1F,'m'},	/* LATIN SMALL LETTER SIDEWAYS TURNED M */
  {0x1D20,'V'},	/* LATIN LETTER SMALL CAPITAL V */
  {0x1D21,'W'},	/* LATIN LETTER SMALL CAPITAL W */
  {0x1D22,'Z'},	/* LATIN LETTER SMALL CAPITAL Z */
  {0x1D25,'L'},	/* LATIN LETTER AIN */
  {0x1D2C,'A'},	/* MODIFIER LETTER CAPITAL A */
  {0x1D2E,'B'},	/* MODIFIER LETTER CAPITAL B */
  {0x1D2F,'B'},	/* MODIFIER LETTER CAPITAL BARRED B */
  {0x1D30,'D'},	/* MODIFIER LETTER CAPITAL D */
  {0x1D31,'E'},	/* MODIFIER LETTER CAPITAL E */
  {0x1D32,'E'},	/* MODIFIER LETTER CAPITAL REVERSED E */
  {0x1D33,'G'},	/* MODIFIER LETTER CAPITAL G */
  {0x1D34,'H'},	/* MODIFIER LETTER CAPITAL H */
  {0x1D35,'I'},	/* MODIFIER LETTER CAPITAL I */
  {0x1D36,'J'},	/* MODIFIER LETTER CAPITAL J */
  {0x1D37,'K'},	/* MODIFIER LETTER CAPITAL K */
  {0x1D38,'L'},	/* MODIFIER LETTER CAPITAL L */
  {0x1D39,'M'},	/* MODIFIER LETTER CAPITAL M */
  {0x1D3A,'N'},	/* MODIFIER LETTER CAPITAL N */
  {0x1D3B,'N'},	/* MODIFIER LETTER CAPITAL REVERSED N */
  {0x1D3C,'O'},	/* MODIFIER LETTER CAPITAL O */
  {0x1D3E,'P'},	/* MODIFIER LETTER CAPITAL P */
  {0x1D3F,'R'},	/* MODIFIER LETTER CAPITAL R */
  {0x1D40,'T'},	/* MODIFIER LETTER CAPITAL T */
  {0x1D41,'U'},	/* MODIFIER LETTER CAPITAL U */
  {0x1D42,'W'},	/* MODIFIER LETTER CAPITAL W */
  {0x1D43,'a'},	/* MODIFIER LETTER SMALL A */
  {0x1D44,'a'},	/* MODIFIER LETTER SMALL TURNED A */
  {0x1D47,'b'},	/* MODIFIER LETTER SMALL B */
  {0x1D48,'d'},	/* MODIFIER LETTER SMALL D */
  {0x1D49,'e'},	/* MODIFIER LETTER SMALL E */
  {0x1D4A,'e'},	/* MODIFIER LETTER SMALL SCHWA */
  {0x1D4B,'e'},	/* MODIFIER LETTER SMALL OPEN E */
  {0x1D4C,'e'},	/* MODIFIER LETTER SMALL TURNED OPEN E */
  {0x1D4D,'g'},	/* MODIFIER LETTER SMALL G */
  {0x1D4E,'i'},	/* MODIFIER LETTER SMALL TURNED I */
  {0x1D4F,'k'},	/* MODIFIER LETTER SMALL K */
  {0x1D50,'m'},	/* MODIFIER LETTER SMALL M */
  {0x1D51,'g'},	/* MODIFIER LETTER SMALL ENG */
  {0x1D52,'o'},	/* MODIFIER LETTER SMALL O */
  {0x1D53,'o'},	/* MODIFIER LETTER SMALL OPEN O */
  {0x1D54,'o'},	/* MODIFIER LETTER SMALL TOP HALF O */
  {0x1D55,'o'},	/* MODIFIER LETTER SMALL BOTTOM HALF O */
  {0x1D56,'p'},	/* MODIFIER LETTER SMALL P */
  {0x1D57,'t'},	/* MODIFIER LETTER SMALL T */
  {0x1D58,'u'},	/* MODIFIER LETTER SMALL U */
  {0x1D59,'u'},	/* MODIFIER LETTER SMALL SIDEWAYS U */
  {0x1D5A,'m'},	/* MODIFIER LETTER SMALL TURNED M */
  {0x1D5B,'v'},	/* MODIFIER LETTER SMALL V */
  {0x1D62,'i'},	/* LATIN SUBSCRIPT SMALL LETTER I */
  {0x1D63,'r'},	/* LATIN SUBSCRIPT SMALL LETTER R */
  {0x1D64,'u'},	/* LATIN SUBSCRIPT SMALL LETTER U */
  {0x1D65,'v'},	/* LATIN SUBSCRIPT SMALL LETTER V */
  {0x1E00,'A'},	/* LATIN CAPITAL LETTER A WITH RING BELOW */
  {0x1E01,'a'},	/* LATIN SMALL LETTER A WITH RING BELOW */
  {0x1E02,'B'},	/* LATIN CAPITAL LETTER B WITH DOT ABOVE */
  {0x1E03,'b'},	/* LATIN SMALL LETTER B WITH DOT ABOVE */
  {0x1E04,'B'},	/* LATIN CAPITAL LETTER B WITH DOT BELOW */
  {0x1E05,'b'},	/* LATIN SMALL LETTER B WITH DOT BELOW */
  {0x1E06,'B'},	/* LATIN CAPITAL LETTER B WITH LINE BELOW */
  {0x1E07,'b'},	/* LATIN SMALL LETTER B WITH LINE BELOW */
  {0x1E08,'C'},	/* LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE */
  {0x1E09,'c'},	/* LATIN SMALL LETTER C WITH CEDILLA AND ACUTE */
  {0x1E0A,'D'},	/* LATIN CAPITAL LETTER D WITH DOT ABOVE */
  {0x1E0B,'d'},	/* LATIN SMALL LETTER D WITH DOT ABOVE */
  {0x1E0C,'D'},	/* LATIN CAPITAL LETTER D WITH DOT BELOW */
  {0x1E0D,'d'},	/* LATIN SMALL LETTER D WITH DOT BELOW */
  {0x1E0E,'D'},	/* LATIN CAPITAL LETTER D WITH LINE BELOW */
  {0x1E0F,'d'},	/* LATIN SMALL LETTER D WITH LINE BELOW */
  {0x1E10,'D'},	/* LATIN CAPITAL LETTER D WITH CEDILLA */
  {0x1E11,'d'},	/* LATIN SMALL LETTER D WITH CEDILLA */
  {0x1E12,'D'},	/* LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */
  {0x1E13,'d'},	/* LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW */
  {0x1E14,'E'},	/* LATIN CAPITAL LETTER E WITH MACRON AND GRAVE */
  {0x1E15,'e'},	/* LATIN SMALL LETTER E WITH MACRON AND GRAVE */
  {0x1E16,'E'},	/* LATIN CAPITAL LETTER E WITH MACRON AND ACUTE */
  {0x1E17,'e'},	/* LATIN SMALL LETTER E WITH MACRON AND ACUTE */
  {0x1E18,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */
  {0x1E19,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW */
  {0x1E1A,'E'},	/* LATIN CAPITAL LETTER E WITH TILDE BELOW */
  {0x1E1B,'e'},	/* LATIN SMALL LETTER E WITH TILDE BELOW */
  {0x1E1C,'E'},	/* LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  {0x1E1D,'e'},	/* LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  {0x1E1E,'F'},	/* LATIN CAPITAL LETTER F WITH DOT ABOVE */
  {0x1E1F,'f'},	/* LATIN SMALL LETTER F WITH DOT ABOVE */
  {0x1E20,'G'},	/* LATIN CAPITAL LETTER G WITH MACRON */
  {0x1E21,'g'},	/* LATIN SMALL LETTER G WITH MACRON */
  {0x1E22,'H'},	/* LATIN CAPITAL LETTER H WITH DOT ABOVE */
  {0x1E23,'h'},	/* LATIN SMALL LETTER H WITH DOT ABOVE */
  {0x1E24,'H'},	/* LATIN CAPITAL LETTER H WITH DOT BELOW */
  {0x1E25,'h'},	/* LATIN SMALL LETTER H WITH DOT BELOW */
  {0x1E26,'H'},	/* LATIN CAPITAL LETTER H WITH DIAERESIS */
  {0x1E27,'h'},	/* LATIN SMALL LETTER H WITH DIAERESIS */
  {0x1E28,'H'},	/* LATIN CAPITAL LETTER H WITH CEDILLA */
  {0x1E29,'h'},	/* LATIN SMALL LETTER H WITH CEDILLA */
  {0x1E2A,'H'},	/* LATIN CAPITAL LETTER H WITH BREVE BELOW */
  {0x1E2B,'h'},	/* LATIN SMALL LETTER H WITH BREVE BELOW */
  {0x1E2C,'I'},	/* LATIN CAPITAL LETTER I WITH TILDE BELOW */
  {0x1E2D,'i'},	/* LATIN SMALL LETTER I WITH TILDE BELOW */
  {0x1E2E,'I'},	/* LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE */
  {0x1E2F,'i'},	/* LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE */
  {0x1E30,'K'},	/* LATIN CAPITAL LETTER K WITH ACUTE */
  {0x1E31,'k'},	/* LATIN SMALL LETTER K WITH ACUTE */
  {0x1E32,'K'},	/* LATIN CAPITAL LETTER K WITH DOT BELOW */
  {0x1E33,'k'},	/* LATIN SMALL LETTER K WITH DOT BELOW */
  {0x1E34,'K'},	/* LATIN CAPITAL LETTER K WITH LINE BELOW */
  {0x1E35,'k'},	/* LATIN SMALL LETTER K WITH LINE BELOW */
  {0x1E36,'L'},	/* LATIN CAPITAL LETTER L WITH DOT BELOW */
  {0x1E37,'l'},	/* LATIN SMALL LETTER L WITH DOT BELOW */
  {0x1E38,'L'},	/* LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON */
  {0x1E39,'l'},	/* LATIN SMALL LETTER L WITH DOT BELOW AND MACRON */
  {0x1E3A,'L'},	/* LATIN CAPITAL LETTER L WITH LINE BELOW */
  {0x1E3B,'l'},	/* LATIN SMALL LETTER L WITH LINE BELOW */
  {0x1E3C,'L'},	/* LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */
  {0x1E3D,'l'},	/* LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW */
  {0x1E3E,'M'},	/* LATIN CAPITAL LETTER M WITH ACUTE */
  {0x1E3F,'m'},	/* LATIN SMALL LETTER M WITH ACUTE */
  {0x1E40,'M'},	/* LATIN CAPITAL LETTER M WITH DOT ABOVE */
  {0x1E41,'m'},	/* LATIN SMALL LETTER M WITH DOT ABOVE */
  {0x1E42,'M'},	/* LATIN CAPITAL LETTER M WITH DOT BELOW */
  {0x1E43,'m'},	/* LATIN SMALL LETTER M WITH DOT BELOW */
  {0x1E44,'N'},	/* LATIN CAPITAL LETTER N WITH DOT ABOVE */
  {0x1E45,'n'},	/* LATIN SMALL LETTER N WITH DOT ABOVE */
  {0x1E46,'N'},	/* LATIN CAPITAL LETTER N WITH DOT BELOW */
  {0x1E47,'n'},	/* LATIN SMALL LETTER N WITH DOT BELOW */
  {0x1E48,'N'},	/* LATIN CAPITAL LETTER N WITH LINE BELOW */
  {0x1E49,'n'},	/* LATIN SMALL LETTER N WITH LINE BELOW */
  {0x1E4A,'N'},	/* LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */
  {0x1E4B,'n'},	/* LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW */
  {0x1E4C,'O'},	/* LATIN CAPITAL LETTER O WITH TILDE AND ACUTE */
  {0x1E4D,'o'},	/* LATIN SMALL LETTER O WITH TILDE AND ACUTE */
  {0x1E4E,'O'},	/* LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS */
  {0x1E4F,'o'},	/* LATIN SMALL LETTER O WITH TILDE AND DIAERESIS */
  {0x1E50,'O'},	/* LATIN CAPITAL LETTER O WITH MACRON AND GRAVE */
  {0x1E51,'o'},	/* LATIN SMALL LETTER O WITH MACRON AND GRAVE */
  {0x1E52,'O'},	/* LATIN CAPITAL LETTER O WITH MACRON AND ACUTE */
  {0x1E53,'o'},	/* LATIN SMALL LETTER O WITH MACRON AND ACUTE */
  {0x1E54,'P'},	/* LATIN CAPITAL LETTER P WITH ACUTE */
  {0x1E55,'p'},	/* LATIN SMALL LETTER P WITH ACUTE */
  {0x1E56,'P'},	/* LATIN CAPITAL LETTER P WITH DOT ABOVE */
  {0x1E57,'p'},	/* LATIN SMALL LETTER P WITH DOT ABOVE */
  {0x1E58,'R'},	/* LATIN CAPITAL LETTER R WITH DOT ABOVE */
  {0x1E59,'r'},	/* LATIN SMALL LETTER R WITH DOT ABOVE */
  {0x1E5A,'R'},	/* LATIN CAPITAL LETTER R WITH DOT BELOW */
  {0x1E5B,'r'},	/* LATIN SMALL LETTER R WITH DOT BELOW */
  {0x1E5C,'R'},	/* LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON */
  {0x1E5D,'r'},	/* LATIN SMALL LETTER R WITH DOT BELOW AND MACRON */
  {0x1E5E,'R'},	/* LATIN CAPITAL LETTER R WITH LINE BELOW */
  {0x1E5F,'r'},	/* LATIN SMALL LETTER R WITH LINE BELOW */
  {0x1E60,'S'},	/* LATIN CAPITAL LETTER S WITH DOT ABOVE */
  {0x1E61,'s'},	/* LATIN SMALL LETTER S WITH DOT ABOVE */
  {0x1E62,'S'},	/* LATIN CAPITAL LETTER S WITH DOT BELOW */
  {0x1E63,'s'},	/* LATIN SMALL LETTER S WITH DOT BELOW */
  {0x1E64,'S'},	/* LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE */
  {0x1E65,'s'},	/* LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE */
  {0x1E66,'S'},	/* LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE */
  {0x1E67,'s'},	/* LATIN SMALL LETTER S WITH CARON AND DOT ABOVE */
  {0x1E68,'S'},	/* LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE */
  {0x1E69,'s'},	/* LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */
  {0x1E6A,'T'},	/* LATIN CAPITAL LETTER T WITH DOT ABOVE */
  {0x1E6B,'t'},	/* LATIN SMALL LETTER T WITH DOT ABOVE */
  {0x1E6C,'T'},	/* LATIN CAPITAL LETTER T WITH DOT BELOW */
  {0x1E6D,'t'},	/* LATIN SMALL LETTER T WITH DOT BELOW */
  {0x1E6E,'T'},	/* LATIN CAPITAL LETTER T WITH LINE BELOW */
  {0x1E6F,'t'},	/* LATIN SMALL LETTER T WITH LINE BELOW */
  {0x1E70,'T'},	/* LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */
  {0x1E71,'t'},	/* LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW */
  {0x1E72,'U'},	/* LATIN CAPITAL LETTER U WITH DIAERESIS BELOW */
  {0x1E73,'u'},	/* LATIN SMALL LETTER U WITH DIAERESIS BELOW */
  {0x1E74,'U'},	/* LATIN CAPITAL LETTER U WITH TILDE BELOW */
  {0x1E75,'u'},	/* LATIN SMALL LETTER U WITH TILDE BELOW */
  {0x1E76,'U'},	/* LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */
  {0x1E77,'u'},	/* LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW */
  {0x1E78,'U'},	/* LATIN CAPITAL LETTER U WITH TILDE AND ACUTE */
  {0x1E79,'u'},	/* LATIN SMALL LETTER U WITH TILDE AND ACUTE */
  {0x1E7A,'U'},	/* LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS */
  {0x1E7B,'u'},	/* LATIN SMALL LETTER U WITH MACRON AND DIAERESIS */
  {0x1E7C,'V'},	/* LATIN CAPITAL LETTER V WITH TILDE */
  {0x1E7D,'v'},	/* LATIN SMALL LETTER V WITH TILDE */
  {0x1E7E,'V'},	/* LATIN CAPITAL LETTER V WITH DOT BELOW */
  {0x1E7F,'v'},	/* LATIN SMALL LETTER V WITH DOT BELOW */
  {0x1E80,'W'},	/* LATIN CAPITAL LETTER W WITH GRAVE */
  {0x1E81,'w'},	/* LATIN SMALL LETTER W WITH GRAVE */
  {0x1E82,'W'},	/* LATIN CAPITAL LETTER W WITH ACUTE */
  {0x1E83,'w'},	/* LATIN SMALL LETTER W WITH ACUTE */
  {0x1E84,'W'},	/* LATIN CAPITAL LETTER W WITH DIAERESIS */
  {0x1E85,'w'},	/* LATIN SMALL LETTER W WITH DIAERESIS */
  {0x1E86,'W'},	/* LATIN CAPITAL LETTER W WITH DOT ABOVE */
  {0x1E87,'w'},	/* LATIN SMALL LETTER W WITH DOT ABOVE */
  {0x1E88,'W'},	/* LATIN CAPITAL LETTER W WITH DOT BELOW */
  {0x1E89,'w'},	/* LATIN SMALL LETTER W WITH DOT BELOW */
  {0x1E8A,'X'},	/* LATIN CAPITAL LETTER X WITH DOT ABOVE */
  {0x1E8B,'x'},	/* LATIN SMALL LETTER X WITH DOT ABOVE */
  {0x1E8C,'X'},	/* LATIN CAPITAL LETTER X WITH DIAERESIS */
  {0x1E8D,'x'},	/* LATIN SMALL LETTER X WITH DIAERESIS */
  {0x1E8E,'Y'},	/* LATIN CAPITAL LETTER Y WITH DOT ABOVE */
  {0x1E8F,'y'},	/* LATIN SMALL LETTER Y WITH DOT ABOVE */
  {0x1E90,'Z'},	/* LATIN CAPITAL LETTER Z WITH CIRCUMFLEX */
  {0x1E91,'z'},	/* LATIN SMALL LETTER Z WITH CIRCUMFLEX */
  {0x1E92,'Z'},	/* LATIN CAPITAL LETTER Z WITH DOT BELOW */
  {0x1E93,'z'},	/* LATIN SMALL LETTER Z WITH DOT BELOW */
  {0x1E94,'Z'},	/* LATIN CAPITAL LETTER Z WITH LINE BELOW */
  {0x1E95,'z'},	/* LATIN SMALL LETTER Z WITH LINE BELOW */
  {0x1E96,'h'},	/* LATIN SMALL LETTER H WITH LINE BELOW */
  {0x1E97,'t'},	/* LATIN SMALL LETTER T WITH DIAERESIS */
  {0x1E98,'w'},	/* LATIN SMALL LETTER W WITH RING ABOVE */
  {0x1E99,'y'},	/* LATIN SMALL LETTER Y WITH RING ABOVE */
  {0x1E9A,'a'},	/* LATIN SMALL LETTER A WITH RIGHT HALF RING */
  {0x1E9B,'s'},	/* LATIN SMALL LETTER LONG S WITH DOT ABOVE */
  {0x1EA0,'A'},	/* LATIN CAPITAL LETTER A WITH DOT BELOW */
  {0x1EA1,'a'},	/* LATIN SMALL LETTER A WITH DOT BELOW */
  {0x1EA2,'A'},	/* LATIN CAPITAL LETTER A WITH HOOK ABOVE */
  {0x1EA3,'a'},	/* LATIN SMALL LETTER A WITH HOOK ABOVE */
  {0x1EA4,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE */
  {0x1EA5,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE */
  {0x1EA6,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE */
  {0x1EA7,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE */
  {0x1EA8,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1EA9,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1EAA,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE */
  {0x1EAB,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE */
  {0x1EAC,'A'},	/* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  {0x1EAD,'a'},	/* LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  {0x1EAE,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE AND ACUTE */
  {0x1EAF,'a'},	/* LATIN SMALL LETTER A WITH BREVE AND ACUTE */
  {0x1EB0,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE AND GRAVE */
  {0x1EB1,'a'},	/* LATIN SMALL LETTER A WITH BREVE AND GRAVE */
  {0x1EB2,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE */
  {0x1EB3,'a'},	/* LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE */
  {0x1EB4,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE AND TILDE */
  {0x1EB5,'a'},	/* LATIN SMALL LETTER A WITH BREVE AND TILDE */
  {0x1EB6,'A'},	/* LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW */
  {0x1EB7,'a'},	/* LATIN SMALL LETTER A WITH BREVE AND DOT BELOW */
  {0x1EB8,'E'},	/* LATIN CAPITAL LETTER E WITH DOT BELOW */
  {0x1EB9,'e'},	/* LATIN SMALL LETTER E WITH DOT BELOW */
  {0x1EBA,'E'},	/* LATIN CAPITAL LETTER E WITH HOOK ABOVE */
  {0x1EBB,'e'},	/* LATIN SMALL LETTER E WITH HOOK ABOVE */
  {0x1EBC,'E'},	/* LATIN CAPITAL LETTER E WITH TILDE */
  {0x1EBD,'e'},	/* LATIN SMALL LETTER E WITH TILDE */
  {0x1EBE,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */
  {0x1EBF,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE */
  {0x1EC0,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE */
  {0x1EC1,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE */
  {0x1EC2,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1EC3,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1EC4,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE */
  {0x1EC5,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE */
  {0x1EC6,'E'},	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  {0x1EC7,'e'},	/* LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  {0x1EC8,'I'},	/* LATIN CAPITAL LETTER I WITH HOOK ABOVE */
  {0x1EC9,'i'},	/* LATIN SMALL LETTER I WITH HOOK ABOVE */
  {0x1ECA,'I'},	/* LATIN CAPITAL LETTER I WITH DOT BELOW */
  {0x1ECB,'i'},	/* LATIN SMALL LETTER I WITH DOT BELOW */
  {0x1ECC,'O'},	/* LATIN CAPITAL LETTER O WITH DOT BELOW */
  {0x1ECD,'o'},	/* LATIN SMALL LETTER O WITH DOT BELOW */
  {0x1ECE,'O'},	/* LATIN CAPITAL LETTER O WITH HOOK ABOVE */
  {0x1ECF,'o'},	/* LATIN SMALL LETTER O WITH HOOK ABOVE */
  {0x1ED0,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE */
  {0x1ED1,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE */
  {0x1ED2,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE */
  {0x1ED3,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE */
  {0x1ED4,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1ED5,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  {0x1ED6,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE */
  {0x1ED7,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE */
  {0x1ED8,'O'},	/* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  {0x1ED9,'o'},	/* LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  {0x1EDA,'O'},	/* LATIN CAPITAL LETTER O WITH HORN AND ACUTE */
  {0x1EDB,'o'},	/* LATIN SMALL LETTER O WITH HORN AND ACUTE */
  {0x1EDC,'O'},	/* LATIN CAPITAL LETTER O WITH HORN AND GRAVE */
  {0x1EDD,'o'},	/* LATIN SMALL LETTER O WITH HORN AND GRAVE */
  {0x1EDE,'O'},	/* LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE */
  {0x1EDF,'o'},	/* LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */
  {0x1EE0,'O'},	/* LATIN CAPITAL LETTER O WITH HORN AND TILDE */
  {0x1EE1,'o'},	/* LATIN SMALL LETTER O WITH HORN AND TILDE */
  {0x1EE2,'O'},	/* LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW */
  {0x1EE3,'o'},	/* LATIN SMALL LETTER O WITH HORN AND DOT BELOW */
  {0x1EE4,'U'},	/* LATIN CAPITAL LETTER U WITH DOT BELOW */
  {0x1EE5,'u'},	/* LATIN SMALL LETTER U WITH DOT BELOW */
  {0x1EE6,'U'},	/* LATIN CAPITAL LETTER U WITH HOOK ABOVE */
  {0x1EE7,'u'},	/* LATIN SMALL LETTER U WITH HOOK ABOVE */
  {0x1EE8,'U'},	/* LATIN CAPITAL LETTER U WITH HORN AND ACUTE */
  {0x1EE9,'u'},	/* LATIN SMALL LETTER U WITH HORN AND ACUTE */
  {0x1EEA,'U'},	/* LATIN CAPITAL LETTER U WITH HORN AND GRAVE */
  {0x1EEB,'u'},	/* LATIN SMALL LETTER U WITH HORN AND GRAVE */
  {0x1EEC,'U'},	/* LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE */
  {0x1EED,'u'},	/* LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE */
  {0x1EEE,'U'},	/* LATIN CAPITAL LETTER U WITH HORN AND TILDE */
  {0x1EEF,'u'},	/* LATIN SMALL LETTER U WITH HORN AND TILDE */
  {0x1EF0,'U'},	/* LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW */
  {0x1EF1,'u'},	/* LATIN SMALL LETTER U WITH HORN AND DOT BELOW */
  {0x1EF2,'Y'},	/* LATIN CAPITAL LETTER Y WITH GRAVE */
  {0x1EF3,'y'},	/* LATIN SMALL LETTER Y WITH GRAVE */
  {0x1EF4,'Y'},	/* LATIN CAPITAL LETTER Y WITH DOT BELOW */
  {0x1EF5,'y'},	/* LATIN SMALL LETTER Y WITH DOT BELOW */
  {0x1EF6,'Y'},	/* LATIN CAPITAL LETTER Y WITH HOOK ABOVE */
  {0x1EF7,'y'},	/* LATIN SMALL LETTER Y WITH HOOK ABOVE */
  {0x1EF8,'Y'},	/* LATIN CAPITAL LETTER Y WITH TILDE */
  {0x1EF9,'y'},	/* LATIN SMALL LETTER Y WITH TILDE */
  {0x2014,0x2D},	/* Em-dash		*/
  {0x2018,0x27},	/* left single quote	*/
  {0x2019,0x27},	/* right single quote	*/
  {0x201C,0x22},	/* left double quote	*/
  {0x201D,0x22},	/* right double quote	*/
  {0x2071,'i'},	/* SUPERSCRIPT LATIN SMALL LETTER I */
  {0x207F,'n'},	/* SUPERSCRIPT LATIN SMALL LETTER N */
  {0x212A,'K'},	/* KELVIN SIGN */
  {0x212B,'A'},	/* ANGSTROM SIGN */
  {0x212C,'B'},	/* SCRIPT CAPITAL B */
  {0x212D,'C'},	/* BLACK-LETTER CAPITAL C */
  {0x212F,'e'},	/* SCRIPT SMALL E */
  {0x2130,'E'},	/* SCRIPT CAPITAL E */
  {0x2131,'F'},	/* SCRIPT CAPITAL F */
  {0x2132,'F'},	/* TURNED CAPITAL F */
  {0x2133,'M'},	/* SCRIPT CAPITAL M */
  {0x2134,'0'},	/* SCRIPT SMALL O */
  {0x213A,'0'},	/* ROTATED CAPITAL Q */
  {0x2141,'G'},	/* TURNED SANS-SERIF CAPITAL G */
  {0x2142,'L'},	/* TURNED SANS-SERIF CAPITAL L */
  {0x2143,'L'},	/* REVERSED SANS-SERIF CAPITAL L */
  {0x2144,'Y'},	/* TURNED SANS-SERIF CAPITAL Y */
  {0x2145,'D'},	/* DOUBLE-STRUCK ITALIC CAPITAL D */
  {0x2146,'d'},	/* DOUBLE-STRUCK ITALIC SMALL D */
  {0x2147,'e'},	/* DOUBLE-STRUCK ITALIC SMALL E */
  {0x2148,'i'},	/* DOUBLE-STRUCK ITALIC SMALL I */
  {0x2149,'j'},	/* DOUBLE-STRUCK ITALIC SMALL J */
  {0xFF21,'A'},	/* FULLWIDTH LATIN CAPITAL LETTER B */
  {0xFF22,'B'},	/* FULLWIDTH LATIN CAPITAL LETTER B */
  {0xFF23,'C'},	/* FULLWIDTH LATIN CAPITAL LETTER C */
  {0xFF24,'D'},	/* FULLWIDTH LATIN CAPITAL LETTER D */
  {0xFF25,'E'},	/* FULLWIDTH LATIN CAPITAL LETTER E */
  {0xFF26,'F'},	/* FULLWIDTH LATIN CAPITAL LETTER F */
  {0xFF27,'G'},	/* FULLWIDTH LATIN CAPITAL LETTER G */
  {0xFF28,'H'},	/* FULLWIDTH LATIN CAPITAL LETTER H */
  {0xFF29,'I'},	/* FULLWIDTH LATIN CAPITAL LETTER I */
  {0xFF2A,'J'},	/* FULLWIDTH LATIN CAPITAL LETTER J */
  {0xFF2B,'K'},	/* FULLWIDTH LATIN CAPITAL LETTER K */
  {0xFF2C,'L'},	/* FULLWIDTH LATIN CAPITAL LETTER L */
  {0xFF2D,'M'},	/* FULLWIDTH LATIN CAPITAL LETTER M */
  {0xFF2E,'N'},	/* FULLWIDTH LATIN CAPITAL LETTER N */
  {0xFF2F,'O'},	/* FULLWIDTH LATIN CAPITAL LETTER O */
  {0xFF30,'P'},	/* FULLWIDTH LATIN CAPITAL LETTER P */
  {0xFF31,'Q'},	/* FULLWIDTH LATIN CAPITAL LETTER Q */
  {0xFF32,'R'},	/* FULLWIDTH LATIN CAPITAL LETTER R */
  {0xFF33,'S'},	/* FULLWIDTH LATIN CAPITAL LETTER S */
  {0xFF34,'T'},	/* FULLWIDTH LATIN CAPITAL LETTER T */
  {0xFF35,'U'},	/* FULLWIDTH LATIN CAPITAL LETTER U */
  {0xFF36,'V'},	/* FULLWIDTH LATIN CAPITAL LETTER V */
  {0xFF37,'W'},	/* FULLWIDTH LATIN CAPITAL LETTER W */
  {0xFF38,'X'},	/* FULLWIDTH LATIN CAPITAL LETTER X */
  {0xFF39,'Y'},	/* FULLWIDTH LATIN CAPITAL LETTER Y */
  {0xFF3A,'Z'},	/* FULLWIDTH LATIN CAPITAL LETTER Z */
  {0xFF41,'a'},	/* FULLWIDTH LATIN SMALL LETTER A */
  {0xFF42,'b'},	/* FULLWIDTH LATIN SMALL LETTER B */
  {0xFF43,'c'},	/* FULLWIDTH LATIN SMALL LETTER C */
  {0xFF44,'d'},	/* FULLWIDTH LATIN SMALL LETTER D */
  {0xFF45,'e'},	/* FULLWIDTH LATIN SMALL LETTER E */
  {0xFF46,'f'},	/* FULLWIDTH LATIN SMALL LETTER F */
  {0xFF47,'g'},	/* FULLWIDTH LATIN SMALL LETTER G */
  {0xFF48,'h'},	/* FULLWIDTH LATIN SMALL LETTER H */
  {0xFF49,'i'},	/* FULLWIDTH LATIN SMALL LETTER I */
  {0xFF4A,'j'},	/* FULLWIDTH LATIN SMALL LETTER J */
  {0xFF4B,'k'},	/* FULLWIDTH LATIN SMALL LETTER K */
  {0xFF4C,'l'},	/* FULLWIDTH LATIN SMALL LETTER L */
  {0xFF4D,'m'},	/* FULLWIDTH LATIN SMALL LETTER M */
  {0xFF4E,'n'},	/* FULLWIDTH LATIN SMALL LETTER N */
  {0xFF4F,'o'},	/* FULLWIDTH LATIN SMALL LETTER O */
  {0xFF50,'p'},	/* FULLWIDTH LATIN SMALL LETTER P */
  {0xFF51,'q'},	/* FULLWIDTH LATIN SMALL LETTER Q */
  {0xFF52,'r'},	/* FULLWIDTH LATIN SMALL LETTER R */
  {0xFF53,'s'},	/* FULLWIDTH LATIN SMALL LETTER S */
  {0xFF54,'t'},	/* FULLWIDTH LATIN SMALL LETTER T */
  {0xFF55,'u'},	/* FULLWIDTH LATIN SMALL LETTER U */
  {0xFF56,'v'},	/* FULLWIDTH LATIN SMALL LETTER V */
  {0xFF57,'w'},	/* FULLWIDTH LATIN SMALL LETTER W */
  {0xFF58,'x'},	/* FULLWIDTH LATIN SMALL LETTER X */
  {0xFF59,'y'},	/* FULLWIDTH LATIN SMALL LETTER Y */
  {0xFF5A,'z'}	/* FULLWIDTH LATIN SMALL LETTER Z */
};

#define	GSM0338_lsize	(sizeof(GSM0338_lossy)/sizeof(_ucc_))

