{- This module was generated from data in the Kate syntax
   highlighting file c.xml, version 2, by  -}

module Text.Highlighting.Kate.Syntax.C
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "C"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.c;*.C;*.h"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("C","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("C","Normal") -> return ()
      ("C","String") -> (popContext) >> pEndLine
      ("C","Region Marker") -> (popContext) >> pEndLine
      ("C","Commentar 1") -> (popContext) >> pEndLine
      ("C","Commentar 2") -> return ()
      ("C","AfterHash") -> (popContext) >> pEndLine
      ("C","Include") -> (popContext) >> pEndLine
      ("C","Preprocessor") -> (popContext) >> pEndLine
      ("C","Define") -> (popContext) >> pEndLine
      ("C","Commentar/Preprocessor") -> return ()
      ("C","Outscoped") -> return ()
      ("C","Outscoped intern") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_controlflow = Set.fromList $ words $ "break case continue default do else for goto if return switch while"
list_keywords = Set.fromList $ words $ "enum extern inline sizeof struct typedef union"
list_types = Set.fromList $ words $ "auto char const double float int long register restrict short signed static unsigned void volatile int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t int_least8_t int_least16_t int_least32_t int_least64_t uint_least8_t uint_least16_t uint_least32_t uint_least64_t int_fast8_t int_fast16_t int_fast32_t int_fast64_t uint_fast8_t uint_fast16_t uint_fast32_t uint_fast64_t size_t ssize_t wchar_t intptr_t uintptr_t intmax_t uintmax_t ptrdiff_t sig_atomic_t wint_t _Imaginary _Complex _Bool"

regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 = compileRegex True "#\\s*if\\s+0\\s*$"
regex_0b'5b01'5d'2b'5bul'5d'7b0'2c3'7d = compileRegex True "0b[01]+[ul]{0,3}"
regex_'23'5cs'2a'28'3f'3ainclude'7cinclude'5fnext'29 = compileRegex True "#\\s*(?:include|include_next)"
regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 = compileRegex True "#\\s*if(?:def|ndef)?(?=\\s+\\S)"
regex_'23'5cs'2aendif = compileRegex True "#\\s*endif"
regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex True "#\\s*define.*((?=\\\\))"
regex_'23'5cs'2apragma'5cs'2bmark'5cs'2b'2d'5cs'2a'24 = compileRegex True "#\\s*pragma\\s+mark\\s+-\\s*$"
regex_'23'5cs'2apragma'5cs'2bmark = compileRegex True "#\\s*pragma\\s+mark"
regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex True "#\\s*(?:el(?:se|if)|define|undef|line|error|warning|pragma)"
regex_'23'5cs'2b'5b0'2d9'5d'2b = compileRegex True "#\\s+[0-9]+"
regex_'23'5cs'2aif = compileRegex True "#\\s*if"
regex_'23'5cs'2ael'28'3f'3ase'7cif'29 = compileRegex True "#\\s*el(?:se|if)"

parseRules ("C","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Outscoped"))
   <|>
   ((pFirstNonSpace >> lookAhead (pDetectChar False '#') >> pushContext ("C","AfterHash") >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("C","Region Marker"))
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("C","Region Marker"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_controlflow >>= withAttribute ControlFlowTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_0b'5b01'5d'2b'5bul'5d'7b0'2c3'7d >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("C","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen",""))))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 2"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("C","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute SpecialCharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("C","Region Marker") =
  (currentContext >>= \x -> guard (x == ("C","Region Marker")) >> pDefault >>= withAttribute RegionMarkerTok)

parseRules ("C","Commentar 1") =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Commentar 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("C","Commentar 2") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("C","AfterHash") =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ainclude'7cinclude'5fnext'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Include"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Define"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2apragma'5cs'2bmark'5cs'2b'2d'5cs'2a'24 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2apragma'5cs'2bmark >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2b'5b0'2d9'5d'2b >>= withAttribute PreprocessorTok) >>~ pushContext ("C","Preprocessor"))
   <|>
   (currentContext >>= \x -> guard (x == ("C","AfterHash")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("C","Include") =
  (((pLineContinue >>= withAttribute PreprocessorTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute ImportTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute ImportTok))
   <|>
   ((parseRules ("C","Preprocessor")))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Include")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("C","Preprocessor") =
  (((pLineContinue >>= withAttribute PreprocessorTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute PreprocessorTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar/Preprocessor"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 1"))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Preprocessor")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("C","Define") =
  (((pLineContinue >>= withAttribute PreprocessorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Define")) >> pDefault >>= withAttribute PreprocessorTok))

parseRules ("C","Commentar/Preprocessor") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Commentar/Preprocessor")) >> pDefault >>= withAttribute CommentTok))

parseRules ("C","Outscoped") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("C","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("C","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute PreprocessorTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute PreprocessorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Outscoped")) >> pDefault >>= withAttribute CommentTok))

parseRules ("C","Outscoped intern") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("C","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("C","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("C","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C","Outscoped intern")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression Nothing
parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("C","Normal") <|> fail ("Unknown context" ++ show x)
