/*
 * @file utf8.h
 * @author Vincent Wei
 * @date 2022/02/28
 * @brief The interfaces for UTF-8 encoding.
 *
 * Copyright (C) 2022 FMSoft <https://www.fmsoft.cn>
 *
 * This file is a part of PurC (short for Purring Cat), an HVML interpreter.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef PURC_PRIVATE_UTF8_H
#define PURC_PRIVATE_UTF8_H

#include <stdlib.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include "purc-utils.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

size_t
pcutils_string_utf8_chars (const char *p, ssize_t max);

extern const char * const _pcutils_utf8_skip;

#define pcutils_utf8_next_char(p)   \
    (char *)((p) + _pcutils_utf8_skip[*(const unsigned char *)(p)])

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* PURC_PRIVATE_UTF8_H */
