/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.util.Arrays;
import java.util.HashSet;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;

public class SimpleDiffCriteria
implements DiffCriteria {
    public boolean validClass(ClassInfo info) {
        return !info.isSynthetic() && (info.isPublic() || info.isProtected());
    }

    public boolean validMethod(MethodInfo info) {
        return !info.isSynthetic() && (info.isPublic() || info.isProtected());
    }

    public boolean validField(FieldInfo info) {
        return !info.isSynthetic() && (info.isPublic() || info.isProtected());
    }

    public boolean differs(ClassInfo oldInfo, ClassInfo newInfo) {
        HashSet<String> newInterfaces;
        if (oldInfo.getAccess() != newInfo.getAccess()) {
            return true;
        }
        if (oldInfo.getSupername() == null ? newInfo.getSupername() != null : !oldInfo.getSupername().equals(newInfo.getSupername())) {
            return true;
        }
        HashSet<String> oldInterfaces = new HashSet<String>(Arrays.asList(oldInfo.getInterfaces()));
        return !((Object)oldInterfaces).equals(newInterfaces = new HashSet<String>(Arrays.asList(newInfo.getInterfaces())));
    }

    public boolean differs(MethodInfo oldInfo, MethodInfo newInfo) {
        HashSet<String> newExceptions;
        HashSet<String> oldExceptions;
        if (oldInfo.getAccess() != newInfo.getAccess()) {
            return true;
        }
        return oldInfo.getExceptions() == null || newInfo.getExceptions() == null ? oldInfo.getExceptions() != newInfo.getExceptions() : !((Object)(oldExceptions = new HashSet<String>(Arrays.asList(oldInfo.getExceptions())))).equals(newExceptions = new HashSet<String>(Arrays.asList(newInfo.getExceptions())));
    }

    public boolean differs(FieldInfo oldInfo, FieldInfo newInfo) {
        if (oldInfo.getAccess() != newInfo.getAccess()) {
            return true;
        }
        return oldInfo.getValue() == null || newInfo.getValue() == null ? oldInfo.getValue() != newInfo.getValue() : !oldInfo.getValue().equals(newInfo.getValue());
    }
}

