<?xml version="1.0" encoding="UTF-8"?>
 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
 
<xsl:output method="xml"
              doctype-public="-//W3C//DTD XHTML 1.1//EN"
              doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
              encoding="UTF-8"
              indent="yes"
/>

<xsl:template match="jclassinfo">
	<html xml:lang="en">
		<head>
			<link rel="stylesheet" type="text/css" href="jclassinfo.css"/>
		</head>
		<body>
			<xsl:apply-templates select="class"/>
			<p>Report generated with jclassinfo <xsl:value-of select="@version"/></p>
		</body>
	</html>	
</xsl:template>

<xsl:template match="class">
	<div class="class-section">
		<h2><xsl:value-of select="@name"/></h2>
		<p class="general-information">
			<xsl:if test="@sourcefile">
				Build from: <xsl:value-of select="@sourcefile"/><br/>
			</xsl:if>
			<xsl:if test="@access">
				Access: <xsl:value-of select="@access"/><br/>
			</xsl:if>
			<xsl:if test="@extends">
				Extends: <xsl:value-of select="@extends"/><br/>
			</xsl:if>
			<xsl:if test="@package">
				Package: <xsl:value-of select="@package"/><br/>
			</xsl:if>
			<xsl:if test="@vm">
				Requires: Java VM <xsl:value-of select="@vm"/><br/>
			</xsl:if>
		</p>

		<xsl:if test="count(implements) &gt; 0">
			<h3>Implements</h3>
			<div class="implements">
				<ul>
				<xsl:for-each select="implements">
					<li><xsl:value-of select="@name"/></li>
				</xsl:for-each>
				</ul>
			</div>
		</xsl:if>

		<h3>Synopsis</h3>
		<div class="synopsis">
		<xsl:if test="count(field) &gt; 0">
			<p>
				<xsl:apply-templates select="field"/>
			</p>
		</xsl:if>
	
		<xsl:if test="count(method) &gt; 0">
			<p>
				<xsl:apply-templates select="method" mode="brief"/>
			</p>
		</xsl:if>
		</div>

		<xsl:apply-templates select="constant_pool"/>

		<xsl:if test="count(method) &gt; 0">
			<div class="methods">
				<h3>Methods</h3>
				<xsl:apply-templates select="method"/>
			</div>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="constant_pool">
	<h3>Constant Pool</h3>
	<div class="constant_pool">
	<table>
		<th>
			<td>Index</td>
			<td>Type</td>
			<td>Value...</td>
		</th>
		<xsl:apply-templates/>
	</table>
	</div>
</xsl:template>

<xsl:template match="Integer|Float|Long|Double">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="@value"/></td>
	</tr>
</xsl:template>

<xsl:template match="String">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="@string_index"/></td>
	</tr>
</xsl:template>

<xsl:template match="Utf8">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="."/></td>
	</tr>
</xsl:template>

<xsl:template match="Class">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="@name_index"/></td>
	</tr>
</xsl:template>

<xsl:template match="NameAndType">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="@name_index"/></td>
		<td><xsl:value-of select="@signature_index"/></td>
	</tr>
</xsl:template>

<xsl:template match="Fieldref|Methodref|InterfaceMethodref">
	<tr>
		<td><xsl:value-of select="@index"/></td>
		<td><xsl:value-of select="name()"/></td>
		<td><xsl:value-of select="@class_index"/></td>
		<td><xsl:value-of select="@name_and_type_index"/></td>
	</tr>
</xsl:template>

<xsl:template match="field">
	<xsl:value-of select="@access"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@type"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:if test="attribute[@name='ConstantValue']">
		= <xsl:value-of select="attribute/value"/>
	</xsl:if>
	<br/>
</xsl:template>

<xsl:template match="method" mode="brief">
	<xsl:value-of select="@access"/><xsl:value-of select="string(' ')"/>
	<xsl:value-of select="@type"/><xsl:value-of select="string(' ')"/>
	<xsl:value-of select="@name"/><xsl:value-of select="string(' ')"/>
	<xsl:text>(</xsl:text>
	<xsl:for-each select="param">
		<xsl:if test="position() &gt; 1">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:value-of select="@type"/>
	</xsl:for-each>
	<xsl:text>)</xsl:text><br/>
</xsl:template>

<xsl:template match="method">
	<h4>
	<xsl:value-of select="@access"/><xsl:value-of select="string(' ')"/>
	<xsl:value-of select="@type"/><xsl:value-of select="string(' ')"/>
	<xsl:value-of select="@name"/><xsl:value-of select="string(' ')"/>
	<xsl:text>(</xsl:text>
	<xsl:for-each select="param">
		<xsl:if test="position() &gt; 1">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:value-of select="@type"/>
	</xsl:for-each>
	<xsl:text>)</xsl:text>
	</h4>
	<p>
		<xsl:apply-templates select="attribute"/>
	</p>
	<hr/>
</xsl:template>

<xsl:template match="attribute">
	<xsl:apply-templates select="code"/>
</xsl:template>

<xsl:template match="code">
	<table class="code">
		<xsl:apply-templates select="instruction"/>
	</table>
</xsl:template>

<xsl:template match="instruction">
	<tr>
		<td>
			<xsl:value-of select="@pc"/>
		</td>
		<td>
			<xsl:value-of select="@name"/>
			<xsl:for-each select="operand">
				<xsl:value-of select="string(' ')"/><xsl:value-of select="@value"/>
			</xsl:for-each>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
