/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.LisaacKeywordDetector;
import org.lisaac.ldt.editors.LisaacNumberDetector;
import org.lisaac.ldt.editors.LisaacPrototypeDetector;
import org.lisaac.ldt.editors.LisaacWhitespaceDetector;
import org.lisaac.ldt.editors.LisaacWordDetector;
import org.lisaac.ldt.editors.LisaacWordRule;
import org.lisaac.ldt.model.ILisaacModel;

public class LisaacScanner
extends RuleBasedScanner {
    private IToken stringToken;
    private IToken characterToken;
    private IToken numberToken;
    private IToken prototypeToken;
    private IToken prototypeStyleToken;
    private IToken keywordToken;
    private IToken localVariableToken;
    private IToken operatorToken;
    private IToken externalToken;
    private IToken undefinedToken;

    public LisaacScanner(ColorManager manager) {
        this.stringToken = manager.getToken("string_color", "string_style");
        this.characterToken = manager.getToken("character_color", "character_style");
        this.numberToken = manager.getToken("number_color", "number_style");
        this.prototypeToken = manager.getToken("prototype_color", "prototype_style");
        this.prototypeStyleToken = manager.getToken("prototype_style_color", "prototype_style_style");
        this.keywordToken = manager.getToken("keyword_color", "keyword_style");
        this.localVariableToken = manager.getToken("local_slot_color", "local_slot_style");
        this.operatorToken = manager.getToken("operator_color", "operator_style");
        this.externalToken = manager.getToken2("external_color", "local_slot_color");
        this.undefinedToken = manager.getToken("slot_color", "slot_style");
        IRule[] rules = new IRule[5];
        rules[0] = new WhitespaceRule((IWhitespaceDetector)new LisaacWhitespaceDetector());
        WordRule wr = new WordRule((IWordDetector)new LisaacKeywordDetector(), Token.UNDEFINED);
        String[] keywords = ILisaacModel.keywords;
        int i = 0;
        while (i < keywords.length) {
            wr.addWord(keywords[i], this.keywordToken);
            ++i;
        }
        rules[1] = wr;
        rules[2] = new WordRule((IWordDetector)new LisaacPrototypeDetector(), this.prototypeToken);
        rules[3] = new LisaacWordRule(new LisaacWordDetector(), this.undefinedToken, this.localVariableToken);
        rules[4] = new WordRule((IWordDetector)new LisaacNumberDetector(), this.numberToken);
        this.setRules(rules);
    }

    public IToken nextToken() {
        char c;
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            int i = 0;
            while (i < this.fRules.length) {
                IToken token = this.fRules[i].evaluate((ICharacterScanner)this);
                if (!token.isUndefined()) {
                    return token;
                }
                ++i;
            }
        }
        if ((c = (char)this.read()) != '\uffffffff') {
            if (c == '+' || c == '-') {
                if (this.getColumn() == 3) {
                    return this.prototypeStyleToken;
                }
                if (this.detectLocalSlot()) {
                    return this.prototypeStyleToken;
                }
                return this.operatorToken;
            }
            if (c == '<') {
                c = (char)this.read();
                if (c == '-') {
                    return this.fDefaultReturnToken;
                }
                this.unread();
                return this.operatorToken;
            }
            if (c == ':') {
                c = (char)this.read();
                if (c != '=') {
                    this.unread();
                    if (this.detectBlockType()) {
                        return this.prototypeToken;
                    }
                }
                return this.fDefaultReturnToken;
            }
            if (c == '?') {
                c = (char)this.read();
                if (c == '=') {
                    return this.fDefaultReturnToken;
                }
                this.unread();
                return this.operatorToken;
            }
            if (c == '*' || c == '/' || c == '&' || c == '$' || c == '|' || c == '>' || c == '=' || c == '!' || c == '~' || c == '@' || c == '#' || c == '^') {
                return this.operatorToken;
            }
            if (c == '{' || c == '}') {
                return this.operatorToken;
            }
        }
        this.unread();
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    private boolean readIndentifier() {
        char c;
        int i = 0;
        do {
            c = (char)this.read();
            ++i;
        } while (c != '\uffffffff' && (Character.isLetterOrDigit(c) || c == '_'));
        this.unread();
        return i > 1;
    }

    private void readSpace() {
        char c;
        while ((c = (char)this.read()) != '\uffffffff' && Character.isWhitespace(c)) {
        }
        this.unread();
    }

    private boolean detectLocalSlot() {
        int oldOffset = this.fOffset;
        boolean result = false;
        this.readSpace();
        while (this.readIndentifier()) {
            this.readSpace();
            char c = (char)this.read();
            if (c == '\uffffffff') break;
            if (c == ':') {
                result = true;
                break;
            }
            if (c != ',') break;
            this.readSpace();
        }
        this.fOffset = oldOffset;
        this.fColumn = -1;
        return result;
    }

    private boolean detectBlockType() {
        int oldOffset = this.fOffset;
        boolean result = false;
        this.readSpace();
        char c = (char)this.read();
        if (c != '\uffffffff' && c == '{') {
            int level = 1;
            do {
                if ((c = (char)this.read()) == '\uffffffff') continue;
                if (c == '{') {
                    ++level;
                    continue;
                }
                if (c == '}') {
                    --level;
                    continue;
                }
                if (c == '\n' || c == '\r' || c == '\uffff') break;
            } while (c != '\uffffffff' && level != 0);
            if (level == 0) {
                result = true;
            }
        }
        if (!result) {
            this.fOffset = oldOffset;
            this.fColumn = -1;
        }
        return result;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public static boolean isPrototypeIdentifier(String word) {
        return LisaacScanner.detectKeyword(word, new LisaacPrototypeDetector());
    }

    public static boolean isIdentifier(String word) {
        return LisaacScanner.detectKeyword(word, new LisaacWordDetector());
    }

    public static boolean isKeywordIdentifier(String word) {
        return LisaacScanner.detectKeyword(word, new LisaacKeywordDetector());
    }

    private static boolean detectKeyword(String word, IWordDetector detector) {
        int i = 0;
        boolean b = true;
        if (word.length() > 0 && detector.isWordStart(word.charAt(0))) {
            if (word.length() == 1) {
                return true;
            }
            i = 1;
            do {
                char c = word.charAt(i);
                b = detector.isWordPart(c);
            } while (++i < word.length() && b);
            if (!b) {
                return false;
            }
        }
        return i == word.length();
    }
}

