
## Tutorials

Tutorials for mlpack can be found [here : mlpack tutorials](https://www.mlpack.org/docs/mlpack-git/doxygen/tutorials.html).


### General mlpack tutorials

These tutorials introduce the basic concepts of working with mlpack, aimed at developers who want to use and contribute to mlpack but are not sure where to start.

* [Building mlpack from source](http://www.mlpack.org/docs/mlpack-git/doxygen/build.html)
* [File Formats in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen/formatdoc.html)
* [Matrices in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen/matrices.html)
* [mlpack input and output](http://www.mlpack.org/docs/mlpack-git/doxygen/iodoc.html)
* [mlpack timers](http://www.mlpack.org/docs/mlpack-git/doxygen/timer.html)
* [Simple sample mlpack programs](http://www.mlpack.org/docs/mlpack-git/doxygen/sample.html)


### Method-specific tutorials

These tutorials introduce the various methods mlpack offers, aimed at users who want to get started quickly. These tutorials start with simple examples and progress to complex, extensible uses.

* [NeighborSearch tutorial (mlpack_knn / mlpack_kfn)](http://www.mlpack.org/docs/mlpack-git/doxygen/nstutorial.html)
* [LinearRegression tutorial (mlpack_linear_regression)](http://www.mlpack.org/docs/mlpack-git/doxygen/lrtutorial.html)
* [RangeSearch tutorial (mlpack_range_search)](http://www.mlpack.org/docs/mlpack-git/doxygen/rstutorial.html)
* [Density Estimation Trees tutorial (mlpack_det)](http://www.mlpack.org/docs/mlpack-git/doxygen/dettutorial.html)
* [K-Means tutorial (mlpack_kmeans)](http://www.mlpack.org/docs/mlpack-git/doxygen/kmtutorial.html)
* [FastMKS tutorial (mlpack_fastmks)](http://www.mlpack.org/docs/mlpack-git/doxygen/fmkstutorial.html)
* [Euclidean Minimum Spanning Trees tutorial (mlpack_emst)](http://www.mlpack.org/docs/mlpack-git/doxygen/emst_tutorial.html)
* [Alternating Matrix Factorization Tutorial](http://www.mlpack.org/docs/mlpack-git/doxygen/amftutorial.html)
* [Collaborative Filtering Tutorial](http://www.mlpack.org/docs/mlpack-git/doxygen/cftutorial.html)
* [Conventional Neural Evolution Tutorial](http://www.mlpack.org/docs/mlpack-git/doxygen/cnetutorial.html)


### Policy Class Documentation

mlpack uses templates to achieve its genericity and flexibility. Some of the template types used by mlpack are common across multiple machine learning algorithms. The links below provide documentation for some of these common types.

* [The MetricType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen/metrics.html)
* [The KernelType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen/kernels.html)
* [The TreeType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen/trees.html)
