// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_MakeSolid_HeaderFile
#define _BRepLib_MakeSolid_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_ListOfShape.hxx>
#include <BRepLib_MakeShape.hxx>
#include <BRepLib_ShapeModification.hxx>
class StdFail_NotDone;
class TopoDS_CompSolid;
class TopoDS_Shell;
class TopoDS_Solid;
class TopoDS_Face;


//! Makes a solid from compsolid  or  shells.
class BRepLib_MakeSolid  : public BRepLib_MakeShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Solid covers whole space.
  Standard_EXPORT BRepLib_MakeSolid();
  
  //! Make a solid from a CompSolid.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_CompSolid& S);
  
  //! Make a solid from a shell.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S);
  
  //! Make a solid from two shells.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S1, const TopoDS_Shell& S2);
  
  //! Make a solid from three shells.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S1, const TopoDS_Shell& S2, const TopoDS_Shell& S3);
  
  //! Make a solid from a solid. Usefull for adding later.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Solid& So);
  
  //! Add a shell to a solid.
  Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Solid& So, const TopoDS_Shell& S);
  
  //! Add the shell to the current solid.
  Standard_EXPORT   void Add (const TopoDS_Shell& S) ;
  
  //! Returns the new Solid.
  Standard_EXPORT  const  TopoDS_Solid& Solid()  const;
Standard_EXPORT operator TopoDS_Solid() const;
  
  //! returns the status of the Face after
  //! the shape creation.
  Standard_EXPORT virtual   BRepLib_ShapeModification FaceStatus (const TopoDS_Face& F)  const;




protected:



  TopTools_ListOfShape myDeletedFaces;


private:





};







#endif // _BRepLib_MakeSolid_HeaderFile
