% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-mutate.R
\name{summarise_all}
\alias{summarise_all}
\alias{summarise_if}
\alias{summarise_at}
\alias{summarize_all}
\alias{summarize_if}
\alias{summarize_at}
\alias{mutate_all}
\alias{mutate_if}
\alias{mutate_at}
\alias{transmute_all}
\alias{transmute_if}
\alias{transmute_at}
\title{Summarise and mutate multiple columns.}
\usage{
summarise_all(.tbl, .funs, ...)

summarise_if(.tbl, .predicate, .funs, ...)

summarise_at(.tbl, .vars, .funs, ..., .cols = NULL)

summarize_all(.tbl, .funs, ...)

summarize_if(.tbl, .predicate, .funs, ...)

summarize_at(.tbl, .vars, .funs, ..., .cols = NULL)

mutate_all(.tbl, .funs, ...)

mutate_if(.tbl, .predicate, .funs, ...)

mutate_at(.tbl, .vars, .funs, ..., .cols = NULL)

transmute_all(.tbl, .funs, ...)

transmute_if(.tbl, .predicate, .funs, ...)

transmute_at(.tbl, .vars, .funs, ..., .cols = NULL)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{List of function calls generated by \code{\link[=funs]{funs()}}, or a
character vector of function names, or simply a function.

Bare formulas are passed to \code{\link[rlang:as_function]{rlang::as_function()}} to create
purrr-style lambda functions. Note that these lambda prevent
hybrid evaluation from happening and it is thus more efficient to
supply functions like \code{mean()} directly rather than in a
lambda-formula.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy dots} support.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.cols}{This argument has been renamed to \code{.vars} to fit
dplyr's terminology and is deprecated.}
}
\value{
A data frame. By default, the newly created columns have the shortest
names needed to uniquely identify the output. To force inclusion of a name,
even when not needed, name the input (see examples for details).
}
\description{
These verbs are \link{scoped} variants of \code{\link[=summarise]{summarise()}}, \code{\link[=mutate]{mutate()}} and
\code{\link[=transmute]{transmute()}}. They apply operations on a selection of variables.
\itemize{
\item \code{summarise_all()}, \code{mutate_all()} and \code{transmute_all()} apply the
functions to all (non-grouping) columns.
\item \code{summarise_at()}, \code{mutate_at()} and \code{transmute_at()} allow you to
select columns using the same name-based \link{select_helpers} just
like with \code{\link[=select]{select()}}.
\item \code{summarise_if}(), \code{mutate_if}() and \code{transmute_if()} operate on
columns for which a predicate returns \code{TRUE}.
}
}
\examples{
# The scoped variants of summarise() and mutate() make it easy to
# apply the same transformation to multiple variables:

iris \%>\%
  group_by(Species) \%>\%
  summarise_all(mean)

# There are three variants.
# * _all affects every variable
# * _at affects variables selected with a character vector or vars()
# * _if affects variables selected with a predicate function:

# The _at() variants directly support strings:
starwars \%>\% summarise_at(c("height", "mass"), mean, na.rm = TRUE)

# You can also supply selection helpers to _at() functions but you have
# to quote them with vars():
iris \%>\% mutate_at(vars(matches("Sepal")), log)
starwars \%>\% summarise_at(vars(height:mass), mean, na.rm = TRUE)

# The _if() variants apply a predicate function (a function that
# returns TRUE or FALSE) to determine the relevant subset of
# columns. Here we apply mean() to the numeric columns:
starwars \%>\% summarise_if(is.numeric, mean, na.rm = TRUE)

# mutate_if() is particularly useful for transforming variables from
# one type to another
iris \%>\% as_tibble() \%>\% mutate_if(is.factor, as.character)
iris \%>\% as_tibble() \%>\% mutate_if(is.double, as.integer)

# ---------------------------------------------------------------------------
# If you want apply multiple transformations, use funs()
by_species <- iris \%>\% group_by(Species)

by_species \%>\% summarise_all(funs(min, max))
# Note that output variable name now includes the function name, in order to
# keep things distinct.

# You can express more complex inline transformations using .
by_species \%>\% mutate_all(funs(. / 2.54))

# Function names will be included if .funs has names or multiple inputs
by_species \%>\% mutate_all(funs(inches = . / 2.54))
by_species \%>\% summarise_all(funs(med = median))
by_species \%>\% summarise_all(funs(Q3 = quantile), probs = 0.75)
by_species \%>\% summarise_all(c("min", "max"))
}
\seealso{
\code{\link[=vars]{vars()}}, \code{\link[=funs]{funs()}}
}
