% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_common_names.R
\name{rl_common_names}
\alias{rl_common_names}
\alias{rl_common_names_}
\title{Get common names for a given taxonomic name}
\usage{
rl_common_names(name = NULL, key = NULL, parse = TRUE, ...)

rl_common_names_(name = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) Binomial taxonomic name}

\item{key}{A IUCN API token. See \code{\link{rl_use_iucn}}.}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get common names for a given taxonomic name
}
\examples{
\dontrun{
rl_common_names('Loxodonta africana')
rl_common_names_('Loxodonta africana')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}
