% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-comparison.R
\name{comparison-expectations}
\alias{comparison-expectations}
\alias{expect_lt}
\alias{expect_lte}
\alias{expect_gt}
\alias{expect_gte}
\alias{expect_less_than}
\alias{expect_more_than}
\title{Expectation: is returned value less or greater than specified value?}
\usage{
expect_lt(object, expected, label = NULL, expected.label = NULL)

expect_lte(object, expected, label = NULL, expected.label = NULL)

expect_gt(object, expected, label = NULL, expected.label = NULL)

expect_gte(object, expected, label = NULL, expected.label = NULL)
}
\arguments{
\item{object}{object to test}

\item{expected}{Single numeric value to compare.}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}

\item{...}{other values passed to \code{\link[=all.equal]{all.equal()}}}
}
\description{
Expectation: is returned value less or greater than specified value?
}
\examples{
a <- 9
expect_lt(a, 10)

\dontrun{
expect_lt(11, 10)
}

a <- 11
expect_gt(a, 10)
\dontrun{
expect_gt(9, 10)
}
}
\seealso{
Other expectations: \code{\link{equality-expectations}},
  \code{\link{expect_length}}, \code{\link{expect_match}},
  \code{\link{expect_named}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}},
  \code{\link{output-expectations}}
}
