% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill}
\alias{fill}
\title{Fill in missing values.}
\usage{
fill(data, ..., .direction = c("down", "up"))
}
\arguments{
\item{data}{A data frame.}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default) or "up".}
}
\description{
Fills missing values in using the previous entry. This is useful in the
common output format where values are not repeated, they're recorded
each time they change.
}
\details{
Missing values are replaced in atomic vectors; \code{NULL}s are replaced
in list.
}
\examples{
df <- data.frame(Month = 1:12, Year = c(2000, rep(NA, 11)))
df \%>\% fill(Year)
}
