/* rygel-tracker-search-container.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_0_PROPERTY,
	RYGEL_TRACKER_SEARCH_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_tracker_search_container_properties[RYGEL_TRACKER_SEARCH_CONTAINER_NUM_PROPERTIES];
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP (rygel_tracker_upn_pproperty_map_get_type ())
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMap))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))

typedef struct _RygelTrackerUPnPPropertyMap RygelTrackerUPnPPropertyMap;
typedef struct _RygelTrackerUPnPPropertyMapClass RygelTrackerUPnPPropertyMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerExecuteQueryData RygelTrackerSearchContainerExecuteQueryData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerSearchContainerPrivate {
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaFileItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
	void (*add_resources) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	RygelMediaObjects* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerExecuteQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	gchar* sort_criteria;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp0_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* _tmp2_;
	RygelTrackerSelectionQuery* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	gboolean _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	gchar* id;
	RygelTrackerSelectionQuery* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* uri;
	RygelTrackerSelectionQuery* _tmp14_;
	TrackerSparqlCursor* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	RygelMediaFileItem* item;
	RygelTrackerItemFactory* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	RygelTrackerSelectionQuery* _tmp21_;
	TrackerSparqlCursor* _tmp22_;
	RygelMediaFileItem* _tmp23_;
	RygelMediaObjects* _tmp24_;
	RygelMediaFileItem* _tmp25_;
	RygelMediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSearchContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* _tmp1_;
	RygelRelationalExpression* _tmp2_;
	gchar* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gchar* _tmp5_;
	guint total_matches;
	RygelMediaObjects* results;
	RygelRelationalExpression* _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	RygelMediaObjects* _tmp12_;
	gpointer _tmp13_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp0_;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	TrackerSparqlConnection* _tmp7_;
	gboolean _tmp8_;
	RygelTrackerSelectionQuery* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	RygelTrackerSelectionQuery* _tmp11_;
	TrackerSparqlCursor* _tmp12_;
	const gchar* _tmp13_;
	GError* _error_;
	RygelTrackerItemFactory* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;
static GeeHashMap* rygel_tracker_search_container_update_id_hash;
static GeeHashMap* rygel_tracker_search_container_update_id_hash = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value,
                                    gpointer v_object);
void rygel_tracker_value_take_query (GValue* value,
                                     gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value,
                                           gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value,
                                            gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "nfo:fileLastModified"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id,
                                                                 RygelMediaContainer* parent,
                                                                 const gchar* title,
                                                                 RygelTrackerItemFactory* item_factory,
                                                                 RygelTrackerQueryTriplets* triplets,
                                                                 GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type,
                                                                       const gchar* id,
                                                                       RygelMediaContainer* parent,
                                                                       const gchar* title,
                                                                       RygelTrackerItemFactory* item_factory,
                                                                       RygelTrackerQueryTriplets* triplets,
                                                                       GeeArrayList* filters);
static void __lambda4_ (RygelTrackerSearchContainer* self,
                 RygelMediaContainer* container,
                 RygelMediaObject* origin);
static void ___lambda4__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                          RygelMediaContainer* container,
                                                          RygelMediaObject* object,
                                                          RygelObjectEventType event_type,
                                                          gboolean sub_tree_update,
                                                          gpointer self);
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject,
                                                           const gchar* predicate,
                                                           const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type,
                                                                 const gchar* subject,
                                                                 const gchar* predicate,
                                                                 const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value,
                                            gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value,
                                             gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_upn_pproperty_map_get_type (void) G_GNUC_CONST;
RygelTrackerUPnPPropertyMap* rygel_tracker_upn_pproperty_map_get_property_map (void);
gchar* rygel_tracker_upn_pproperty_map_get (RygelTrackerUPnPPropertyMap* self,
                                            const gchar* property);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables,
                                                               RygelTrackerQueryTriplets* triplets,
                                                               GeeArrayList* filters,
                                                               const gchar* order_by,
                                                               gint offset,
                                                               gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type,
                                                                     GeeArrayList* variables,
                                                                     RygelTrackerQueryTriplets* triplets,
                                                                     GeeArrayList* filters,
                                                                     const gchar* order_by,
                                                                     gint offset,
                                                                     gint max_count);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self,
                                                               GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children_async_ready_wrapper (GObject *source_object,
                                                                           GAsyncResult *res,
                                                                           void *user_data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base,
                                                       guint offset,
                                                       guint max_count,
                                                       const gchar* sort_criteria,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_);
void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self,
                                                   RygelSearchExpression* expression,
                                                   const gchar* sort_criteria,
                                                   guint offset,
                                                   guint max_count,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self,
                                                                        GAsyncResult* _res_,
                                                                        guint* total_matches,
                                                                        GError** error);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void rygel_tracker_search_container_execute_query_data_free (gpointer _data);
static void rygel_tracker_search_container_execute_query_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data);
static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self,
                                                                         RygelRelationalExpression* expression,
                                                                         gint offset,
                                                                         gint max_count,
                                                                         const gchar* sort_criteria);
void rygel_tracker_query_execute (RygelTrackerQuery* self,
                                  TrackerSparqlConnection* resources,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static void rygel_tracker_search_container_execute_query_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self,
                                                               const gchar* urn);
RygelMediaFileItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self,
                                                       const gchar* id,
                                                       const gchar* uri,
                                                       RygelTrackerSearchContainer* parent,
                                                       TrackerSparqlCursor* metadata,
                                                       GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object_async_ready_wrapper (GObject *source_object,
                                                                          GAsyncResult *res,
                                                                          void *user_data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base,
                                                      const gchar* id,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self,
                                                      const gchar* id);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self,
                                                     const gchar* item_id,
                                                     gchar* * parent_id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static void rygel_tracker_search_container_get_children_count_async_ready_wrapper (GObject *source_object,
                                                                            GAsyncResult *res,
                                                                            void *user_data);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type,
                                                                           RygelTrackerSelectionQuery* query);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self,
                                                                                const gchar* sort_criteria);
static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self,
                                                               RygelRelationalExpression* expression);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type,
                                                                         RygelTrackerQueryTriplets* triplets);
static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self,
                                                   const gchar* urn);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
gchar* rygel_tracker_query_escape_regex (const gchar* literal);
static void rygel_tracker_search_container_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void
__lambda4_ (RygelTrackerSearchContainer* self,
            RygelMediaContainer* container,
            RygelMediaObject* origin)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (origin != NULL);
	if (origin == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
		GeeHashMap* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		guint32 _tmp3_;
		_tmp0_ = rygel_tracker_search_container_update_id_hash;
		_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = ((RygelMediaContainer*) self)->update_id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, (gpointer) ((guintptr) ((guint) _tmp3_)));
	}
}


static void
___lambda4__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                     RygelMediaContainer* container,
                                                     RygelMediaObject* object,
                                                     RygelObjectEventType event_type,
                                                     gboolean sub_tree_update,
                                                     gpointer self)
{
	__lambda4_ ((RygelTrackerSearchContainer*) self, container, object);
}


static gpointer
_rygel_tracker_item_factory_ref0 (gpointer self)
{
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelTrackerSearchContainer*
rygel_tracker_search_container_construct (GType object_type,
                                          const gchar* id,
                                          RygelMediaContainer* parent,
                                          const gchar* title,
                                          RygelTrackerItemFactory* item_factory,
                                          RygelTrackerQueryTriplets* triplets,
                                          GeeArrayList* filters)
{
	RygelTrackerSearchContainer * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelTrackerItemFactory* _tmp9_;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	RygelTrackerQueryTriplets* our_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp14_;
	const gchar* _tmp15_;
	RygelTrackerQueryTriplet* _tmp16_;
	RygelTrackerQueryTriplet* _tmp17_;
	RygelTrackerUPnPPropertyMap* property_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp18_;
	gchar* order_by = NULL;
	gchar* _tmp36_;
	GeeArrayList* _tmp37_;
	RygelTrackerQueryTriplets* _tmp38_;
	RygelTrackerSelectionQuery* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	self = (RygelTrackerSearchContainer*) rygel_simple_container_construct (object_type, id, parent, title);
	_tmp0_ = rygel_tracker_search_container_update_id_hash;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_tracker_search_container_update_id_hash);
		rygel_tracker_search_container_update_id_hash = _tmp1_;
	}
	_tmp2_ = rygel_tracker_search_container_update_id_hash;
	_tmp3_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp4_ = _tmp3_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp4_)) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		_tmp5_ = rygel_tracker_search_container_update_id_hash;
		_tmp6_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp7_);
		((RygelMediaContainer*) self)->update_id = (guint32) ((guint) ((guintptr) _tmp8_));
	}
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) ___lambda4__rygel_media_container_container_updated, self, 0);
	_tmp9_ = _rygel_tracker_item_factory_ref0 (item_factory);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	self->item_factory = _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	variables = _tmp10_;
	_tmp11_ = variables;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
	if (triplets != NULL) {
		RygelTrackerQueryTriplets* _tmp12_;
		_tmp12_ = _g_object_ref0 (triplets);
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp12_;
	} else {
		RygelTrackerQueryTriplets* _tmp13_;
		_tmp13_ = rygel_tracker_query_triplets_new ();
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp13_;
	}
	_tmp14_ = our_triplets;
	_tmp15_ = item_factory->category;
	_tmp16_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp15_);
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
	_rygel_tracker_query_triplet_unref0 (_tmp17_);
	_tmp18_ = rygel_tracker_upn_pproperty_map_get_property_map ();
	property_map = _tmp18_;
	{
		GeeArrayList* _property_list = NULL;
		RygelTrackerItemFactory* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		gint _property_size = 0;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _property_index = 0;
		_tmp19_ = self->item_factory;
		_tmp20_ = _tmp19_->properties;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_property_list = _tmp21_;
		_tmp22_ = _property_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_property_size = _tmp24_;
		_property_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gchar* property = NULL;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			GeeArrayList* _tmp31_;
			RygelTrackerUPnPPropertyMap* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp25_ = _property_index;
			_property_index = _tmp25_ + 1;
			_tmp26_ = _property_index;
			_tmp27_ = _property_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _property_list;
			_tmp29_ = _property_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			property = (gchar*) _tmp30_;
			_tmp31_ = variables;
			_tmp32_ = property_map;
			_tmp33_ = property;
			_tmp34_ = rygel_tracker_upn_pproperty_map_get (_tmp32_, _tmp33_);
			_tmp35_ = _tmp34_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (property);
		}
		_g_object_unref0 (_property_list);
	}
	_tmp36_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")");
	order_by = _tmp36_;
	_tmp37_ = variables;
	_tmp38_ = our_triplets;
	_tmp39_ = rygel_tracker_selection_query_new (_tmp37_, _tmp38_, filters, order_by, 0, -1);
	_rygel_tracker_query_unref0 (self->query);
	self->query = _tmp39_;
	{
		TrackerSparqlConnection* _tmp40_ = NULL;
		TrackerSparqlConnection* _tmp41_;
		TrackerSparqlConnection* _tmp42_;
		_tmp41_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp40_ = _tmp41_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp42_ = _tmp40_;
		_tmp40_ = NULL;
		_g_object_unref0 (self->priv->resources);
		self->priv->resources = _tmp42_;
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
		_g_object_unref0 (_tmp40_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp43_ = _error_;
		_tmp44_ = _tmp43_->message;
		g_critical (_ ("Failed to get Tracker connection: %s"), _tmp44_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (order_by);
		_g_object_unref0 (property_map);
		_g_object_unref0 (our_triplets);
		_g_object_unref0 (variables);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (order_by);
	_g_object_unref0 (property_map);
	_g_object_unref0 (our_triplets);
	_g_object_unref0 (variables);
	return self;
}


RygelTrackerSearchContainer*
rygel_tracker_search_container_new (const gchar* id,
                                    RygelMediaContainer* parent,
                                    const gchar* title,
                                    RygelTrackerItemFactory* item_factory,
                                    RygelTrackerQueryTriplets* triplets,
                                    GeeArrayList* filters)
{
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
}


static void
rygel_tracker_search_container_real_get_children_data_free (gpointer _data)
{
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, _data_);
}


static void
rygel_tracker_search_container_real_get_children_async_ready_wrapper (GObject *source_object,
                                                                      GAsyncResult *res,
                                                                      void *user_data)
{
	RygelTrackerSearchContainerGetChildrenData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_tracker_search_container_real_get_children (RygelMediaContainer* base,
                                                  guint offset,
                                                  guint max_count,
                                                  const gchar* sort_criteria,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_search_container_real_get_children_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp1_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static RygelMediaObjects*
rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_tracker_search_container_get_children_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static gboolean
rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp1_ = g_strdup ("@parentID");
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->expression, _data_->sort_criteria, _data_->offset, _data_->max_count, _data_->cancellable, rygel_tracker_search_container_get_children_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp6_;
	_data_->_tmp5_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_data_->result = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp5_);
	_rygel_search_expression_unref0 (_data_->expression);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_tracker_search_container_execute_query_data_free (gpointer _data)
{
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerExecuteQueryData, _data_);
}


static void
rygel_tracker_search_container_execute_query_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data)
{
	RygelTrackerSearchContainerExecuteQueryData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}


void
rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self,
                                              RygelSearchExpression* expression,
                                              const gchar* sort_criteria,
                                              guint offset,
                                              guint max_count,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerExecuteQueryData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_search_container_execute_query_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_search_container_execute_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_tracker_search_container_execute_query_co (_data_);
}


RygelMediaObjects*
rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self,
                                                     GAsyncResult* _res_,
                                                     guint* total_matches,
                                                     GError** error)
{
	RygelMediaObjects* result;
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_tracker_search_container_execute_query_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_search_container_execute_query_co (_data_);
}


static gboolean
rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->results = _data_->_tmp0_;
	_data_->_tmp1_ = rygel_tracker_search_container_create_query (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->expression) : NULL, (gint) _data_->offset, (gint) _data_->max_count, _data_->sort_criteria);
	_data_->query = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->query;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->query;
		_data_->_tmp4_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp3_, _data_->_tmp4_, rygel_tracker_search_container_execute_query_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_rygel_tracker_query_unref0 (_data_->query);
			_g_object_unref0 (_data_->results);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		while (TRUE) {
			_data_->_tmp6_ = _data_->query;
			_data_->_tmp7_ = _data_->_tmp6_->result;
			_data_->_state_ = 2;
			tracker_sparql_cursor_next_async (_data_->_tmp7_, NULL, rygel_tracker_search_container_execute_query_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp5_ = tracker_sparql_cursor_next_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_rygel_tracker_query_unref0 (_data_->query);
				_g_object_unref0 (_data_->results);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (!_data_->_tmp5_) {
				break;
			}
			_data_->_tmp8_ = _data_->query;
			_data_->_tmp9_ = _data_->_tmp8_->result;
			_data_->_tmp10_ = tracker_sparql_cursor_get_string (_data_->_tmp9_, 0, NULL);
			_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
			_data_->id = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->id;
			_data_->_tmp13_ = rygel_tracker_search_container_create_child_id_for_urn (_data_->self, _data_->_tmp12_);
			_g_free0 (_data_->id);
			_data_->id = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->query;
			_data_->_tmp15_ = _data_->_tmp14_->result;
			_data_->_tmp16_ = tracker_sparql_cursor_get_string (_data_->_tmp15_, 1, NULL);
			_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
			_data_->uri = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->self->item_factory;
			_data_->_tmp19_ = _data_->id;
			_data_->_tmp20_ = _data_->uri;
			_data_->_tmp21_ = _data_->query;
			_data_->_tmp22_ = _data_->_tmp21_->result;
			_data_->_tmp23_ = rygel_tracker_item_factory_create (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_, _data_->self, _data_->_tmp22_, &_data_->_inner_error_);
			_data_->item = _data_->_tmp23_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_free0 (_data_->uri);
				_g_free0 (_data_->id);
				_rygel_tracker_query_unref0 (_data_->query);
				_g_object_unref0 (_data_->results);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp24_ = _data_->results;
			_data_->_tmp25_ = _data_->item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, (RygelMediaObject*) _data_->_tmp25_);
			_g_object_unref0 (_data_->item);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->id);
		}
	}
	_data_->_tmp26_ = _data_->results;
	_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp26_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->total_matches = (guint) _data_->_tmp28_;
	_data_->result = _data_->results;
	_rygel_tracker_query_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_tracker_search_container_real_find_object_data_free (gpointer _data)
{
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerFindObjectData, _data_);
}


static void
rygel_tracker_search_container_real_find_object_async_ready_wrapper (GObject *source_object,
                                                                     GAsyncResult *res,
                                                                     void *user_data)
{
	RygelTrackerSearchContainerFindObjectData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_tracker_search_container_real_find_object (RygelMediaContainer* base,
                                                 const gchar* id,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_tracker_search_container_real_find_object_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static RygelMediaObject*
rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_tracker_search_container_find_object_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static gboolean
rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!rygel_tracker_search_container_is_our_child (_data_->self, _data_->id)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp1_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp2_ = _data_->expression;
	_data_->_tmp3_ = g_strdup ("@id");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp2_)->operand1);
	((RygelSearchExpression*) _data_->_tmp2_)->operand1 = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->expression;
	_data_->_tmp5_ = g_strdup (_data_->id);
	_g_free0 (((RygelSearchExpression*) _data_->_tmp4_)->operand2);
	((RygelSearchExpression*) _data_->_tmp4_)->operand2 = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->expression;
	_data_->_tmp7_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->_tmp6_, "", (guint) 0, (guint) 1, _data_->cancellable, rygel_tracker_search_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp7_;
	_data_->results = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->results;
	_data_->_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	if (_data_->_tmp11_ > 0) {
		_data_->_tmp12_ = _data_->results;
		_data_->_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp12_, 0);
		_data_->result = (RygelMediaObject*) _data_->_tmp13_;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_rygel_search_expression_unref0 (_data_->expression);
}


gchar*
rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self,
                                                        const gchar* urn)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, urn, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


gchar*
rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self,
                                              const gchar* item_id,
                                              gchar* * parent_id)
{
	gchar* _vala_parent_id = NULL;
	gchar* result = NULL;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (item_id, ",", 2);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	if (_tmp4_ != NULL) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		_tmp5_ = tokens;
		_tmp5__length1 = tokens_length1;
		_tmp6_ = _tmp5_[1];
		_tmp2_ = _tmp6_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp8_ = _tmp7_[0];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_vala_parent_id);
		_vala_parent_id = _tmp9_;
		_tmp10_ = tokens;
		_tmp10__length1 = tokens_length1;
		_tmp11_ = _tmp10_[1];
		_tmp12_ = g_strdup (_tmp11_);
		result = _tmp12_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	} else {
		_g_free0 (_vala_parent_id);
		_vala_parent_id = NULL;
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (parent_id) {
		*parent_id = _vala_parent_id;
	} else {
		_g_free0 (_vala_parent_id);
	}
}


static void
rygel_tracker_search_container_get_children_count_data_free (gpointer _data)
{
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, _data_);
}


static void
rygel_tracker_search_container_get_children_count_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data)
{
	RygelTrackerSearchContainerGetChildrenCountData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_tracker_search_container_get_children_count_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


void
rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self,
                                                          GAsyncResult* _res_)
{
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
rygel_tracker_search_container_get_children_count_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static gboolean
rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->query;
		_data_->_tmp1_ = rygel_tracker_selection_query_new_clone (_data_->_tmp0_);
		_data_->query = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (_data_->_tmp2_->variables);
		_data_->_tmp2_->variables = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = _data_->_tmp4_->variables;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, "COUNT(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") AS ?x");
		_data_->_tmp6_ = _data_->query;
		_data_->_tmp7_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_count_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_rygel_tracker_query_unref0 (_data_->query);
			goto __catch5_g_error;
		}
		_data_->_tmp9_ = _data_->query;
		_data_->_tmp10_ = _data_->_tmp9_->result;
		_data_->_tmp8_ = tracker_sparql_cursor_next (_data_->_tmp10_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_rygel_tracker_query_unref0 (_data_->query);
			goto __catch5_g_error;
		}
		if (_data_->_tmp8_) {
			_data_->_tmp11_ = _data_->query;
			_data_->_tmp12_ = _data_->_tmp11_->result;
			_data_->_tmp13_ = tracker_sparql_cursor_get_string (_data_->_tmp12_, 0, NULL);
			rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, atoi (_data_->_tmp13_));
			rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		}
		_rygel_tracker_query_unref0 (_data_->query);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp14_ = _data_->self->item_factory;
		_data_->_tmp15_ = _data_->_tmp14_->category;
		_data_->_tmp16_ = _data_->_error_;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_critical (_ ("Error getting item count under category “%s”: %s"), _data_->_tmp15_, _data_->_tmp17_);
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean
rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self,
                                             const gchar* id)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (id, _tmp3_);
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static RygelTrackerSelectionQuery*
rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self,
                                             RygelRelationalExpression* expression,
                                             gint offset,
                                             gint max_count,
                                             const gchar* sort_criteria)
{
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_;
	RygelTrackerSelectionQuery* query = NULL;
	gboolean _tmp5_ = FALSE;
	gconstpointer _tmp9_;
	RygelTrackerSelectionQuery* _tmp18_;
	RygelTrackerSelectionQuery* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp1_ = ((RygelSearchExpression*) expression)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp1_, "upnp:class") == 0) {
		RygelTrackerItemFactory* _tmp2_;
		const gchar* _tmp3_;
		gconstpointer _tmp4_;
		_tmp2_ = self->item_factory;
		_tmp3_ = _tmp2_->upnp_class;
		_tmp4_ = ((RygelSearchExpression*) expression)->operand2;
		_tmp0_ = !g_str_has_prefix (_tmp3_, (const gchar*) _tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	if (sort_criteria == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_strcmp0 (sort_criteria, "") == 0;
	}
	if (_tmp5_) {
		RygelTrackerSelectionQuery* _tmp6_;
		RygelTrackerSelectionQuery* _tmp7_;
		_tmp6_ = self->query;
		_tmp7_ = rygel_tracker_selection_query_new_clone (_tmp6_);
		_rygel_tracker_query_unref0 (query);
		query = _tmp7_;
	} else {
		RygelTrackerSelectionQuery* _tmp8_;
		_tmp8_ = rygel_tracker_search_container_create_sorted_query (self, sort_criteria);
		_rygel_tracker_query_unref0 (query);
		query = _tmp8_;
	}
	_tmp9_ = ((RygelSearchExpression*) expression)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp9_, "@parentID") == 0) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp11_ = _tmp10_;
		if (!rygel_relational_expression_compare_string (expression, _tmp11_)) {
			result = NULL;
			_rygel_tracker_query_unref0 (query);
			return result;
		}
	} else {
		gconstpointer _tmp12_;
		_tmp12_ = ((RygelSearchExpression*) expression)->operand1;
		if (g_strcmp0 ((const gchar*) _tmp12_, "upnp:class") != 0) {
			gchar* filter = NULL;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = rygel_tracker_search_container_create_filter_for_child (self, expression);
			filter = _tmp13_;
			_tmp14_ = filter;
			if (_tmp14_ != NULL) {
				RygelTrackerSelectionQuery* _tmp15_;
				GeeArrayList* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = query;
				_tmp16_ = _tmp15_->filters;
				_tmp17_ = filter;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp16_, 0, _tmp17_);
			} else {
				result = NULL;
				_g_free0 (filter);
				_rygel_tracker_query_unref0 (query);
				return result;
			}
			_g_free0 (filter);
		}
	}
	_tmp18_ = query;
	_tmp18_->offset = offset;
	_tmp19_ = query;
	_tmp19_->max_count = max_count;
	result = query;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static RygelTrackerSelectionQuery*
rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self,
                                                    const gchar* sort_criteria)
{
	RygelTrackerSelectionQuery* result = NULL;
	RygelTrackerUPnPPropertyMap* key_chain_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp0_;
	gchar** sort_props = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint sort_props_length1;
	gint _sort_props_size_;
	gchar* order = NULL;
	gchar* _tmp3_;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	RygelTrackerSelectionQuery* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	RygelTrackerSelectionQuery* _tmp10_;
	GeeArrayList* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp34_;
	GeeArrayList* _tmp38_;
	RygelTrackerSelectionQuery* _tmp39_;
	RygelTrackerQueryTriplets* _tmp40_;
	RygelTrackerQueryTriplets* _tmp41_;
	RygelTrackerQueryTriplets* _tmp42_;
	GeeArrayList* _tmp43_;
	const gchar* _tmp44_;
	RygelTrackerSelectionQuery* _tmp45_;
	RygelTrackerSelectionQuery* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_tracker_upn_pproperty_map_get_property_map ();
	key_chain_map = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (sort_criteria, ",", 0);
	sort_props = _tmp2_;
	sort_props_length1 = _vala_array_length (_tmp1_);
	_sort_props_size_ = sort_props_length1;
	_tmp3_ = g_strdup ("");
	order = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	variables = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filters = _tmp5_;
	_tmp6_ = variables;
	_tmp7_ = self->query;
	_tmp8_ = _tmp7_->variables;
	gee_array_list_add_all (_tmp6_, (GeeCollection*) _tmp8_);
	_tmp9_ = filters;
	_tmp10_ = self->query;
	_tmp11_ = _tmp10_->filters;
	gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp11_);
	_tmp12_ = sort_props;
	_tmp12__length1 = sort_props_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp12_;
		s_collection_length1 = _tmp12__length1;
		for (s_it = 0; s_it < _tmp12__length1; s_it = s_it + 1) {
			gchar* _tmp13_;
			gchar* s = NULL;
			_tmp13_ = g_strdup (s_collection[s_it]);
			s = _tmp13_;
			{
				gchar* key = NULL;
				RygelTrackerUPnPPropertyMap* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp14_ = key_chain_map;
				_tmp15_ = s;
				_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = rygel_tracker_upn_pproperty_map_get (_tmp14_, _tmp17_);
				_tmp19_ = _tmp18_;
				_g_free0 (_tmp17_);
				key = _tmp19_;
				_tmp20_ = key;
				if (string_index_of (_tmp20_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, 0) == 0) {
					_g_free0 (key);
					_g_free0 (s);
					continue;
				}
				_tmp21_ = s;
				if (g_str_has_prefix (_tmp21_, "-")) {
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp22_ = order;
					_tmp23_ = key;
					_tmp24_ = g_strconcat ("DESC (", _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strconcat (_tmp25_, ") ", NULL);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strconcat (_tmp22_, _tmp27_, NULL);
					_g_free0 (order);
					order = _tmp28_;
					_g_free0 (_tmp27_);
					_g_free0 (_tmp25_);
				} else {
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp29_ = order;
					_tmp30_ = key;
					_tmp31_ = g_strconcat (_tmp30_, " ", NULL);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
					_g_free0 (order);
					order = _tmp33_;
					_g_free0 (_tmp32_);
				}
				_g_free0 (key);
				_g_free0 (s);
			}
		}
	}
	_tmp34_ = order;
	if (g_strcmp0 (_tmp34_, "") == 0) {
		RygelTrackerSelectionQuery* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp35_ = self->query;
		_tmp36_ = _tmp35_->order_by;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (order);
		order = _tmp37_;
	}
	_tmp38_ = variables;
	_tmp39_ = self->query;
	_tmp40_ = ((RygelTrackerQuery*) _tmp39_)->triplets;
	_tmp41_ = rygel_tracker_query_triplets_new_clone (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = filters;
	_tmp44_ = order;
	_tmp45_ = rygel_tracker_selection_query_new (_tmp38_, _tmp42_, _tmp43_, _tmp44_, 0, -1);
	_tmp46_ = _tmp45_;
	_g_object_unref0 (_tmp42_);
	result = _tmp46_;
	_g_object_unref0 (filters);
	_g_object_unref0 (variables);
	_g_free0 (order);
	sort_props = (_vala_array_free (sort_props, sort_props_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (key_chain_map);
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static gchar*
rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self,
                                            const gchar* urn)
{
	gchar* result = NULL;
	GString* urn_builder = NULL;
	GString* _tmp0_;
	const gchar* s = NULL;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = g_string_new ("");
	urn_builder = _tmp0_;
	s = urn;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			gunichar character = 0U;
			const gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gunichar _tmp7_;
			if (!_tmp1_) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = s;
				_tmp3_ = g_utf8_next_char (_tmp2_);
				s = _tmp3_;
			}
			_tmp1_ = FALSE;
			_tmp4_ = s;
			if (!(string_get_char (_tmp4_, (glong) 0) != ((gunichar) 0))) {
				break;
			}
			_tmp5_ = s;
			character = string_get_char (_tmp5_, (glong) 0);
			_tmp7_ = character;
			if (g_unichar_iscntrl (_tmp7_)) {
				_tmp6_ = TRUE;
			} else {
				gunichar _tmp8_;
				_tmp8_ = character;
				_tmp6_ = !g_unichar_validate (_tmp8_);
			}
			if (!_tmp6_) {
				GString* _tmp9_;
				gunichar _tmp10_;
				_tmp9_ = urn_builder;
				_tmp10_ = character;
				g_string_append_unichar (_tmp9_, _tmp10_);
			}
		}
	}
	_tmp11_ = urn_builder;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (urn_builder);
	return result;
}


static gchar*
rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self,
                                                        RygelRelationalExpression* expression)
{
	gchar* result = NULL;
	gchar* filter = NULL;
	gchar* variable = NULL;
	gchar* value = NULL;
	gconstpointer _tmp0_;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gconstpointer _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	filter = NULL;
	variable = NULL;
	value = NULL;
	_tmp0_ = ((RygelSearchExpression*) expression)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp0_, "@id") == 0) {
		gchar* _tmp1_;
		gchar* parent_id = NULL;
		gchar* urn = NULL;
		gconstpointer _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gconstpointer _tmp18_;
		_tmp1_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
		_g_free0 (variable);
		variable = _tmp1_;
		_tmp2_ = ((RygelSearchExpression*) expression)->operand2;
		_tmp4_ = rygel_tracker_search_container_get_item_info (self, (const gchar*) _tmp2_, &_tmp3_);
		_g_free0 (parent_id);
		parent_id = _tmp3_;
		urn = _tmp4_;
		_tmp5_ = urn;
		_tmp6_ = g_utf8_validate (_tmp5_, (gssize) -1, NULL);
		if (!_tmp6_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = urn;
			_tmp8_ = rygel_tracker_search_container_urn_to_utf8 (self, _tmp7_);
			_g_free0 (urn);
			urn = _tmp8_;
		}
		_tmp11_ = urn;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = parent_id;
			_tmp10_ = _tmp12_ == NULL;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = parent_id;
			_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) self);
			_tmp15_ = _tmp14_;
			_tmp9_ = g_strcmp0 (_tmp13_, _tmp15_) != 0;
		}
		if (_tmp9_) {
			result = NULL;
			_g_free0 (urn);
			_g_free0 (parent_id);
			_g_free0 (value);
			_g_free0 (variable);
			_g_free0 (filter);
			return result;
		}
		_tmp16_ = urn;
		_tmp17_ = rygel_tracker_query_escape_string (_tmp16_);
		_g_free0 (urn);
		urn = _tmp17_;
		_tmp18_ = ((RygelSearchExpression*) expression)->op;
		switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_)) {
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
			{
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = urn;
				_tmp20_ = g_strconcat ("<", _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp21_, ">", NULL);
				_g_free0 (value);
				value = _tmp22_;
				_g_free0 (_tmp21_);
				break;
			}
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
			{
				gconstpointer _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = ((RygelSearchExpression*) expression)->operand2;
				_tmp24_ = g_strdup ((const gchar*) _tmp23_);
				_g_free0 (value);
				value = _tmp24_;
				break;
			}
			default:
			break;
		}
		_g_free0 (urn);
		_g_free0 (parent_id);
	}
	_tmp26_ = variable;
	if (_tmp26_ == NULL) {
		_tmp25_ = TRUE;
	} else {
		const gchar* _tmp27_;
		_tmp27_ = value;
		_tmp25_ = _tmp27_ == NULL;
	}
	if (_tmp25_) {
		result = NULL;
		_g_free0 (value);
		_g_free0 (variable);
		_g_free0 (filter);
		return result;
	}
	_tmp28_ = ((RygelSearchExpression*) expression)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp28_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp29_ = variable;
			_tmp30_ = g_strconcat (_tmp29_, " = ", NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = value;
			_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
			_g_free0 (filter);
			filter = _tmp33_;
			_g_free0 (_tmp31_);
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			gchar* regex = NULL;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp34_ = value;
			_tmp35_ = rygel_tracker_query_escape_regex (_tmp34_);
			regex = _tmp35_;
			_tmp36_ = variable;
			_tmp37_ = g_strconcat ("regex(", _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat (_tmp38_, ", \"", NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = regex;
			_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\", \"i\")", NULL);
			_g_free0 (filter);
			filter = _tmp44_;
			_g_free0 (_tmp43_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (regex);
			break;
		}
		default:
		break;
	}
	result = filter;
	_g_free0 (value);
	_g_free0 (variable);
	return result;
}


static void
rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass)
{
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
	((RygelMediaContainerClass *) klass)->get_children = (void (*) (RygelMediaContainer *, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_search_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = (RygelMediaObjects* (*) (RygelMediaContainer *, GAsyncResult*, GError**)) rygel_tracker_search_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_search_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer *, GAsyncResult*, GError**)) rygel_tracker_search_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void
rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self)
{
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
}


static void
rygel_tracker_search_container_finalize (GObject * obj)
{
	RygelTrackerSearchContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer);
	_rygel_tracker_query_unref0 (self->query);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


/**
 * A container listing a Tracker search result.
 */
GType
rygel_tracker_search_container_get_type (void)
{
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



