/* ====================================================================
 * Copyright (c) 2008                    Martin Hauner
 *                                       http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _RPVIEWITEM_H
#define _RPVIEWITEM_H

// sc
namespace sc {
  class String;
}

// qt
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtGui/QColor>

// boost
#include <boost/shared_ptr.hpp>

// sys
#include <vector>


/** RpViewTreeModel item interface. */
class RpViewItem
{
public:
  virtual bool isDir() const = 0;
  virtual const sc::String& path() const = 0;
};

typedef boost::shared_ptr<RpViewItem> RpViewItemPtr;
typedef std::vector< RpViewItemPtr >  RpViewItems;

/** make available to QVariant. */
Q_DECLARE_METATYPE(const RpViewItem*);

/** make available to QVariant. */
Q_DECLARE_METATYPE(sc::String);


/** RpViewItemData interface, used to get data from a RpViewItem. */
class RpViewItemData
{
public:
  /** return the data for @a column. */
  virtual QString data( int column, const RpViewItem* ) const = 0;

  /** return the header string for @a column. */
  virtual QString header( int column ) const = 0;

  /** return alignment for @a column. */
  virtual Qt::Alignment alignment( int column ) const = 0;

  /** return the number of columns. */
  virtual int columns() const = 0;
};


#endif //  _RPVIEWITEM_H
