#ifndef TB_TASK_H
#define TB_TASK_H
#include <QString>
#include <QDateTime>

class Tb_Task
{
public:
    Tb_Task();
    Tb_Task(QString task_id,QString gid,int gid_index,QString url,QString download_path,
            QString download_filename,QDateTime create_time);

    bool addTbTask(Tb_Task * task);
    bool updateTbTaskByTaskId(Tb_Task *task);
    Tb_Task * getTbTaskByTaskId(QString task_id);
    QList<Tb_Task *> getAllTbTask();
    bool deleteTbTask(QString task_id);
    bool deleteAllTbTask();
    bool isExistUrl(QString url);


public:
    QString task_id; //任务id，主键唯一标识
    QString gid; //下载gid
    int gid_index; //位置index
    QString url; //下载url地址
    QString download_path; //下载全路径包括文件名
    QString download_filename; //下载文件名
    QDateTime create_time; //任务创建时间

};

#endif // TB_TASK_H
