#ifndef DELETEITEMTHREAD_H
#define DELETEITEMTHREAD_H

#include "global.h"
#include <QThread>
#include <tableview.h>
#include <aria2cinterface.h>

using namespace Global;

class DeleteItemThread:public QThread
{
    Q_OBJECT
public:
    DeleteItemThread();
    DeleteItemThread(QList<DelDataItem>,TableView* recycle_tableview,Aria2cInterface *aria2c,bool ifDeleteLocal,QString deleteType);
    DeleteItemThread( QList<DataItem> delete_list,TableView *downloading_tableview,Aria2cInterface *aria2c ,bool ifDeleteLocal,QString deleteType);
    void run();
    bool DelDir(const QString &path);

    QList<DelDataItem> recycle_delete_list;
    TableView *recycle_tableview;
    Aria2cInterface *aria2c;
    bool ifDeleteLocal;
    QString deleteType;
    QList<DataItem> delete_list;
    TableView *downloading_tableview;
private:
     void delete_recycle_data();
     void delete_download_data();

signals:
     void signal_aria2_remove(QString gId, QString id);
};

#endif // DELETEITEMTHREAD_H
