/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "toolbar.h"
#include "settings.h"
#include "messagebox.h"
#include "tableview.h"
#include "aria2cinterface.h"
#include "btinfodialog.h"

#include <DMainWindow>
#include <DTitlebar>
#include <DIconButton>
#include <DApplication>
#include <DListView>
#include <DDialog>
#include <DCheckBox>
#include <DLabel>
#include <dguiapplicationhelper.h>
#include <QIcon>
#include <QStackedWidget>
#include <QTimer>
#include <QClipboard>
#include <QIODevice>
#include <QSystemTrayIcon>
#include <QUuid>


DWIDGET_USE_NAMESPACE

class MainWindow:public DMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow();
    ~MainWindow();
private:
    void initUI();
    void initConnections();
    void initaria2();
    void initDataBase();
    void init_tableData(); //初始化列表数据
    void initConfig();//初始化设置配置文件
    QString getFileName(const QString &url);
    QString formatFileSize(long size);
    QString formatDownloadSpeed( long size);
    /**
     * @brief addDeleteItem_toRecycle 添加删除条目到回收站列表
     * @param data 添加的条目数据
     */
    void addDeleteItem_toRecycle(DelDataItem *data);
    /**
     * @brief setTask_Num 设置界面是显示的任务数
     * @param num 任务数
     */
    void setTask_Num(int num);
    /**
     * @brief show_Warning_MsgBox 显示警告窗口
     */
    void show_Warning_MsgBox(QString title,int sameurl_count=0,QList<QString> same_url_list={});
    /**
     * @brief show_reload_MsgBox 显示重新下载警告窗口
     */
    void show_reload_MsgBox();
	 /**
     * @brief show_rename_MsgBox 显示重命名窗口
     */
    void show_rename_MsgBox();
    /**
     * @brief show_delete_MsgBox 显示删除或彻底删除警告窗口
     * @param permanently 是否是彻底删除 tru    e是显示彻底删除窗口，false是显示删除窗口
     */
    void show_delete_MsgBox(bool permanently);
    /**
     * @brief show_clear_MsgBox 显示清空回收站警告窗口
     */
    void show_clear_MsgBox();
    void show_repeat_download_task();	
    void Deal_Notificaiton_Settings(QString statusStr,QString fileName); //处理设置界面通知设置函数
    void modify_config_file(QString config_item, QString value); //修改设置文件
    void get_limit_speed_time(QTime * period_start_time , QTime * period_end_time);//获取下载器用户设置限速时间段
    int checkTime(QTime * start_time,QTime * end_time);//获取下载器用户设置限速时间段开始时间和结束时间判断
    void deal_download_upload_limit_period(); //当有下载任务时，判断是否在限速时间内，并且根据时间进行限速设置
    bool check_if_in_period(QTime * current_time,QTime *period_start_time, QTime *period_end_time);//判断当前时间是否在限速时间内
    void change_download_upload_speed(QString downloadSpeed, QString uploadSpeed); //修改上传速度和下载速度
    void get_download_upload_limit_speed(QString * downloadSpeed, QString *uploadSpeed ); //获取上传速度，下载速度
    QString get_download_savePath_from_config();
    void clear_table_item_check_status();
    void save_data_before_close();//在关闭程序时保存数据到数据库中
    bool  Is_duplicate_seed_file(QString infoHash,QString select_num);

    DToolBar *tool;

    ToolBar *m_toolBar;
    TableView *downloading_tableview,*downloaded_tableview,*recycle_tableview;
    Aria2cInterface *aria2c;

    DIconButton *downloadingBtn;
    DIconButton *downloadedBtn;
    DListView *left_list;

    QStandardItemModel *LeftList_mode;
    QStandardItem * downloading_item;
    QStandardItem * downloadFinish_item;
    QStandardItem * recycle_item;
    QStackedWidget *RightStackwidget;
    QTimer *updatetimer;
    QLabel  *Task_Num;
    int current_listview_row;
    enum tableView_flag{
        downloading,recycle
    };
    TableViewModel *download_model;
    QList<DataItem*> reload_list;  /*已完成界面点击重新下载的数据列表*/
    QList<DelDataItem*> recycle_reload_list;  /*回收站界面点击重新下载的数据列表*/
    QList<DataItem*> rename_list;
    QList<DataItem*> delete_list;
    QList<DelDataItem*> recycle_delete_list;
    bool shutdownOk = false;

    DMenu * settings_menu ;
    Settings *m_settings;
    QSystemTrayIcon * systemTray;
    QAction * quitAct;
    QAction * restoreAct;
    QAction * minimumAct;
    QMenu * trayMenu;
    QString Global_Url;
    QAction *settingAction;
    QWidget *noTask_Widget;
    QWidget *LeftWidget;
    QWidget *Right_Widget;
    DLabel *noTask_label;
    QLabel *noTask_tip_Label;
    QWidget *Task_Num_Widget;
    int downloading_header_check_status=0;
    int finish_header_check_status=0;
    bool ctrlKey_press=false;
    QString g_search_content;
private slots:
    void get_doubleClicked(const QModelIndex &index);
    void itemClicked(const QModelIndex &index);
    void onNewDownloadBtnClicked();
    void onPauseDownloadBtnClicked();
    void onStartDownloadBtnClicked();
    void onDeleteDownloadBtnClicked();

    void onSearchEditFocusChanged(bool focus);
    //search begin
    void slot_searchEditTextChange(QString text);
    //search end
    void Update_MainUi();
    void get_NewDowload_slot(QString url,QString savepath);
    void get_Redowload_confirm_slot();
    void get_clear_Recycle_slot(bool);
    void on_tray_restore_click();
    void on_tray_quit_click();
    void onActivated(QSystemTrayIcon::ActivationReason);
    /**
     * @brief get_delete_confirm_slot 获取删除窗口确定信号
     * @param ischecked 是否删除本地文件，true 删除本地文件；false 不删除
     * @param permanent 是否彻底删除，true彻底删除；false不彻底删除
     */
    void get_delete_confirm_slot(bool ischecked,bool permanent);
    /**
     * @brief get_ReName_confirm_slot 获取重命名窗口确定信号
     * @param newname 新名字
     */
    void get_ReName_confirm_slot(QString newname);
    /**
     * @brief get_TorrentDowload_slot 获取下载种子文件中内容的信号
     * @param filename 种子文件名
     * @param opt 下载参数
     */
    void get_TorrentDowload_slot(QString filename,QMap<QString, QVariant> opt,QString infoName, QString infoHash); //获取种子下载信号
    void get_Repeatdowload_confirm_slot();
    void slot_rpc_success(QString method, QJsonObject json);
    void slot_rpc_error(QString method, QString id, int);
    void refreshTableView(const int &index, bool isClearSelection=false);
    void slotContextMenu(QPoint pos);
    void del_downloading_Action();
    void open_Folder_Action();
    void delete_permanently_Action();
    void copy_download_url_Action();
    void redownload_Action();
    void rename_Action();
    void moveTo_directory_Action();
    void open_file_Action();
    void returnTo_origin_Action();
    void clear_recycle_Action();
    void onSettingsMenuClicked();
    void on_download_limitspeed_slot(QString downloadlimitSpeed); //最大下载速度改变处理函数
    void on_UploadSpeed_limitspeed_slot(QString UploadlimitSpeed); //最大上传速度改变处理函数
    void on_disckCacheNum_slot(QString disckCacheNum); //下载磁盘缓存
    void deal_max_download_slot(QString maxDownload); //最大下载数目
    void on_deal_poweron_slot(int poweronStatus); //开机启动状态变化
    void get_header_stateChanged(bool checked);

    void slot_auto_download_bt(QString btFilePath);
    void slot_selected(const QModelIndex &selected);

    void slot_aria2_remove(QString gId, QString id);
    void slot_check_change(bool checked, int flag);
    void slot_redownload(QString taskId, int rd);
    void get_paletteTypeChanged(DGuiApplicationHelper::ColorType type);
protected:
     void dragEnterEvent(QDragEnterEvent *event);
     void dropEvent(QDropEvent *event);
     void closeEvent(QCloseEvent *evt);
     void resizeEvent(QResizeEvent *event);
     void keyPressEvent(QKeyEvent *event);
     void keyReleaseEvent(QKeyEvent *event);


signals:
     void switch_table_signal();
     void table_changed(int index);

     void signal_auto_download_bt(QString btFilePath);
     void signal_redownload(QString taskId, int rd);
};

#endif // MAINWINDOW_H
