/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "messagebox.h"
#include <QDebug>
#include<QMimeData>
#include<QDragEnterEvent>
#include<QUrl>

MessageBox::MessageBox(int Msg_flag)
    :DDialog ()
{
    Msg_type_flag=Msg_flag;
    initUI();

}
void MessageBox::initUI()
{
    setCloseButtonVisible(true);
    setAcceptDrops(true);
}


void MessageBox::addLabel(QString lableText)
{
    DLabel * title= new DLabel(this);
    title->setText(lableText);
    this->addContent(title,Qt::AlignHCenter);
}
void MessageBox::addCheckbox(QString checkboxText)
{
    checkbox= new DCheckBox(this);
    checkbox->setText(checkboxText);
    this->addContent(checkbox,Qt::AlignHCenter);
}


void MessageBox::addTextBrowser(QString placehold, QString url)
{
    textBrowser = new DTextEdit(this);
    textBrowser->setReadOnly(false);
    textBrowser->setAcceptDrops(false);
    textBrowser->setPlaceholderText(placehold);
    textBrowser->setFixedSize(QSize(454,154));


    QPalette pal;
    pal.setColor(QPalette::Base, QColor(0,0,0,20));
    textBrowser->setPalette(pal);
    if(url!="")
    {
        textBrowser->append(url);
    }
    this->addContent(textBrowser);

}

void MessageBox::dragEnterEvent(QDragEnterEvent *event)
{
     if(event->mimeData()->hasUrls()) //数据中是否包含URL
     {
         event->acceptProposedAction(); //如果是则接受动作
     }
     else
         event->ignore();

}
void MessageBox::dropEvent(QDropEvent *event)
{
   const QMimeData *mineData=event->mimeData();//获取MIME数据
   if(mineData->hasUrls())                     //如数据中包含URL
   {
       QList<QUrl>urlList=mineData->urls();    //获取URL列表
       if(urlList.isEmpty())return ;
       QString fileName;
       for(int i=0;i<urlList.size();++i)
       {
           fileName=urlList.at(i).toString();
       

       if(fileName.isEmpty())return;

       if(!fileName.isEmpty())                 //若文件路径不为空
       {
           if(fileName.startsWith("file:")&&fileName.endsWith(".torrent"))
           {
               fileName=fileName.right(fileName.length()-6);

               BtInfoDialog *dialog = new BtInfoDialog(fileName,last_save_path);//torrent文件路径
               int ret = dialog->exec();
               if(ret == QDialog::Accepted) {
                   QMap<QString,QVariant> opt;
                   opt.insert("dir",dialog->getSaveto());
                   opt.insert("select-file",dialog->getSelected());
                   QString infoName=dialog->getName();
                   QString infoHash=dialog->getBtInfo().infoHash;
                   emit DownloadTorrent_sig(fileName,opt,infoName,infoHash);
                   this->close();
               }
               delete dialog;
            }
           else
                textBrowser->append(fileName);
       }
      }
   }
}
void MessageBox::addLineEdit(QString oldname, int x, int y, int w,int h)
{
    newName_lineedit = new DLineEdit(this);
    newName_lineedit->setText(oldname);
    newName_lineedit->setGeometry(x,y,w,h);
}
void MessageBox::openfileDialog()
{
    QString file = DFileDialog::getOpenFileName(this, tr("Choose Torrent File"), QDir::homePath(), "File(*.torrent)");
    if(file != "") {
        BtInfoDialog *dialog = new BtInfoDialog(file,last_save_path);//torrent文件路径
        int ret = dialog->exec();
        if(ret == QDialog::Accepted) {
            QMap<QString,QVariant> opt;
            opt.insert("dir",dialog->getSaveto());
            opt.insert("select-file",dialog->getSelected());
            QString infoName=dialog->getName();
            QString infoHash=dialog->getBtInfo().infoHash;
            emit DownloadTorrent_sig(file,opt,infoName,infoHash);
            this->close();
        }
        delete dialog;
    }
}
void MessageBox::onCancelBtnClicked()
{
    this->close();
}
void MessageBox::onSureBtnClicked()
{
    if(Msg_type_flag==Global::Msgbox_type::NewDownloding)
    {
        QString url=textBrowser->toPlainText();
        QString save_path=filechooserEdit->text();
        if(url.isEmpty())
        {

        }
        else
        {
            QString config_path=QString("%1/%2/%3/last_save_path")
                    .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
                    .arg(qApp->organizationName())
                    .arg(qApp->applicationName());
            QFile file;
            file.setFileName(config_path);
            bool isOK = file.open(QIODevice::WriteOnly);
            if (isOK == true)
            {
                file.write(save_path.toStdString().data());
            }
            file.close();
            emit NewDownload_sig(url,save_path);
            this->close();
        }

    }
    else if(Msg_type_flag==Global::Msgbox_type::ReName)
    {

            QString newname=newName_lineedit->text();
            if(newname.contains("\\")||newname.contains("/"))
            {
                MessageBox *msg=new MessageBox(Warnings);
                msg->set_warning_MsgBox(tr("file name can not containts '\\' or '/' "),tr("sure"));

                msg->exec();

                return;
            }

            emit ReName_sig(newname);

           this->close();
    }

}
void MessageBox::set_delete_Task_MsgBox(bool permanentl )
{
    this->setIcon(QIcon::fromTheme("ndm_messagebox_logo"));
    delete_flag=permanentl;
    QString show_title=tr("Are you soure to delete this download task?");
    this->setTitle(show_title);
    QString show_msg=tr("After deleting,the local file will be deleted");
    //this->addLabel(show_title);
    this->addSpacing(10);
    if(permanentl)
        this->addLabel(show_msg);
    else
    {
        this->addCheckbox(tr("delete local file at the same time"));
    }
    this->addSpacing(10);
    this->addButton(tr("Cancel"));
    if(permanentl)
    {
        this->addButton(tr("Delete permanently"),true,ButtonType::ButtonWarning);
    }
    else {
        this->addButton(tr("Delete"),true,ButtonType::ButtonWarning);

    }
    connect(this,&MessageBox::buttonClicked,this,&MessageBox::get_buttonClicked);

}
void MessageBox::set_clear_Task_MsgBox()
{
    this->setIcon(QIcon::fromTheme("ndm_messagebox_logo"));
    QString show_title=tr("Are you soure to clear all tasks in recycle bin?");
    this->addLabel(show_title);
    this->addSpacing(10);
    this->addCheckbox(tr("delete local file at the same time"));
    this->addButton(tr("Cancel"));
    this->addButton(tr("Delete"));
    connect(this,&MessageBox::buttonClicked,this,&MessageBox::get_buttonClicked);

}

void MessageBox::set_new_download_MsgBox(QString save_path,QString url)
{
    //QIcon tryIcon=QIcon(":/icons/deepin/builtin/dark/icons/ndm_preferencesystem_24px.svg");
    QIcon tryIcon=QIcon::fromTheme("ndm_preferencesystem");

    this->setIcon(tryIcon);
    last_save_path=save_path;
    this->setWindowFlags(this->windowFlags()&~Qt::WindowMinMaxButtonsHint);

    QString show_title=tr("New download task");
    //this->setWindowTitle(tr("New download task"));
    this->setTitle(tr("New download task"));
    QString show_msg = tr("When you add multiple download links,\n please make sure each row has one link.");
    this->addSpacing(10);
    this->addLabel(show_msg);
    this->addSpacing(10);
    this->addTextBrowser(tr("please input download address or drag file to here"),url);
    this->addSpacing(10);
    filechooserEdit= new DFileChooserEdit;

    filechooserEdit->lineEdit()->setEnabled(false);
    filechooserEdit->setFileMode(QFileDialog::DirectoryOnly);
    filechooserEdit->setClearButtonEnabled(false);
    filechooserEdit->setText(save_path);
    default_download_path=save_path;
    connect(filechooserEdit,&DFileChooserEdit::fileChoosed,this,&MessageBox::get_filechoosed_signal);
   // this->addContent(filechooserEdit);
   // this->addSpacing(10);

    QWidget *button_box= new QWidget(this);
    QHBoxLayout *layout=new QHBoxLayout(button_box);
    layout->setMargin(0);
    layout->setContentsMargins(0,0,10,0);
    DIconButton *iconBtn= new DIconButton(button_box);
    iconBtn->setIcon(QIcon::fromTheme("ndm_bt"));
    iconBtn->setIconSize(QSize(18,15));
    iconBtn->setFixedSize(QSize(40,35));
    connect(iconBtn,&DIconButton::clicked,this,&MessageBox::openfileDialog);
    layout->addWidget(iconBtn);
    QWidget *button_box_right= new QWidget(button_box);
    QHBoxLayout *layout_right=new QHBoxLayout(button_box_right);
    layout->setSpacing(10);
    layout_right->setSpacing(10);
    layout_right->setContentsMargins(0,0,0,0);

    DPushButton *cancel_button = new DPushButton(button_box);
    cancel_button->setFixedSize(QSize(197,36));
    cancel_button->setText(tr("Cancel"));
    connect(cancel_button,&DPushButton::clicked,this,&MessageBox::onCancelBtnClicked);
    layout_right->addWidget(cancel_button);
    DSuggestButton *sure_button = new DSuggestButton(button_box);
    sure_button->setText(tr("Confirm"));
    sure_button->setFixedSize(QSize(197,36));
    connect(sure_button,&DPushButton::clicked,this,&MessageBox::onSureBtnClicked);
    layout_right->addWidget(sure_button);
    layout->addWidget(button_box_right);
    this->addContent(button_box);

}
void MessageBox::set_warning_MsgBox(QString warningMsg,QString surebtntext,QString cancelbtntext,int sameurl_count,QList<QString> same_url_list)
{
    this->setIcon(QIcon::fromTheme("ndm_messagebox_logo"));

    this->setTitle(tr("Warning"));

    this->addLabel(warningMsg);
    this->addSpacing(10);
    if(sameurl_count!=0)
    {
        DTextEdit *url_text = new DTextEdit(this);
        url_text->setReadOnly(true);
        url_text->setFixedSize(QSize(454,154));

        QPalette pal;
        pal.setColor(QPalette::Base, QColor(0,0,0,20));
        url_text->setPalette(pal);
        for(int i=0;i<same_url_list.size();i++)
        {
            url_text->append(same_url_list.at(i));
        }
        this->addContent(url_text);
    }
    if(cancelbtntext!="")
    {
        this->addButton(cancelbtntext);

    }
    this->addButton(surebtntext);
    connect(this,&MessageBox::buttonClicked,this,&MessageBox::get_buttonClicked);

}
void MessageBox::set_rename_MsgBox(QString title, QString surebtntext, QString cancelbtntext, QString oldname)
{
    this->setIcon(QIcon::fromTheme("ndm_messagebox_logo"));

    this->setCloseButtonVisible(false);
   // this->setWindowTitle(tr("rename"));
    this->setTitle(tr("rename"));
    newName_lineedit = new DLineEdit();
    newName_lineedit->setText(oldname);
    newName_lineedit->setFixedWidth(400);
    this->addContent(newName_lineedit,Qt::AlignHCenter);
    this->addSpacing(20);
    QWidget *button_box= new QWidget(this);
    QHBoxLayout *layout=new QHBoxLayout(button_box);
    QPushButton *cancel_button = new QPushButton(button_box);
    cancel_button->setText(cancelbtntext);
    connect(cancel_button,&DPushButton::clicked,this,&MessageBox::onCancelBtnClicked);
    layout->addWidget(cancel_button);
    rename_sure_button = new QPushButton(button_box);
    rename_sure_button->setText(surebtntext);
    connect(rename_sure_button,&DPushButton::clicked,this,&MessageBox::onSureBtnClicked);
    layout->addWidget(rename_sure_button);
    this->addContent(button_box);
    connect(newName_lineedit,&DLineEdit::textChanged,this,&MessageBox::get_renameLineEdit_changed);
}
void MessageBox::get_renameLineEdit_changed(const QString &text)
{

    QString real_name= QString(text).left(text.lastIndexOf('.'));

    if(!text.isEmpty()&&!real_name.isEmpty())
    {
        rename_sure_button->setEnabled(true);
    }
    else {
        rename_sure_button->setEnabled(false);
    }
}
void MessageBox::get_buttonClicked(int index,const QString & text)
{
    if(Msg_type_flag==Global::Msgbox_type::Warnings)
    {
        this->close();
    }
    else if(Msg_type_flag==Global::Msgbox_type::ReDownload)
    {
        if(index==1)
            emit ReDownload_sig();
        this->close();
    }
    else if(Msg_type_flag==Global::Msgbox_type::Clear)
    {
        if(index==1)
        {
            bool ischecked;
            ischecked= checkbox->isChecked();
            emit ClearRecycle_sig(ischecked);
        }
        this->close();
    }
    else if(Msg_type_flag==Global::Msgbox_type::Delete)
    {

        if(index==1)
        {

	    QAbstractButton *button= this->getButton(index);
            button->setEnabled(false);
            if(delete_flag)
                 emit DeleteDownload_sig(true,delete_flag);
            else
            {
                bool ischecked;
                ischecked= checkbox->isChecked();
                emit DeleteDownload_sig(ischecked,delete_flag);

            }
        }
        this->close();
    }

}
void MessageBox::get_filechoosed_signal(const QString &filename)
{
    QFileInfo fileinfo;
    fileinfo.setFile(filename);
    if(!fileinfo.isWritable())
    {
        MessageBox *msg=new MessageBox(Warnings);
        msg->set_warning_MsgBox(tr("select directory not writeable"),tr("sure"));
        msg->exec();
        filechooserEdit->lineEdit()->setText(default_download_path);
    }
}
