/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __UOSFILTER_H__
#define __UOSFILTER_H__

#include "libsylph/filter.h"

#include "uosprocmsg.h"
typedef FilterCond UosFilterCond;
typedef FilterAction UosFilterAction;
typedef FilterRule UosFilterRule;
typedef FilterUser UosFilterUser; //add by shui
typedef FilterInfo UosFilterInfo;


typedef FilterTiming UosFilterTiming;
#define UosFLT_TIMING_ANY FLT_TIMING_ANY
#define UosFLT_TIMING_ON_RECEIVE FLT_TIMING_ON_RECEIVE
#define UosFLT_TIMING_MANUAL FLT_TIMING_MANUAL

typedef FilterCondType UosFilterCondType;
#define UosFLT_COND_HEADER FLT_COND_HEADER
#define UosFLT_COND_ANY_HEADER FLT_COND_ANY_HEADER
#define UosFLT_COND_TO_OR_CC FLT_COND_TO_OR_CC
#define UosFLT_COND_BODY FLT_COND_BODY
#define UosFLT_COND_CMD_TEST FLT_COND_CMD_TEST
#define UosFLT_COND_SIZE_GREATER FLT_COND_SIZE_GREATER
#define UosFLT_COND_AGE_GREATER FLT_COND_AGE_GREATER
#define UosFLT_COND_TIME_GREATER FLT_COND_TIME_GREATER
#define UosFLT_COND_UNREAD FLT_COND_UNREAD
#define UosFLT_COND_MARK FLT_COND_MARK
#define UosFLT_COND_COLOR_LABEL FLT_COND_COLOR_LABEL
#define UosFLT_COND_MIME FLT_COND_MIME
#define UosFLT_COND_ACCOUNT FLT_COND_ACCOUNT

typedef FilterMatchType UosFilterMatchType;
#define UosFLT_CONTAIN FLT_CONTAIN
#define UosFLT_EQUAL FLT_EQUAL
#define UosFLT_REGEX FLT_REGEX
#define UosFLT_IN_ADDRESSBOOK FLT_IN_ADDRESSBOOK

typedef FilterMatchFlag UosFilterMatchFlag;
#define UosFLT_NOT_MATCH FLT_NOT_MATCH
#define UosFLT_CASE_SENS FLT_CASE_SENS

typedef FilterBoolOp UosFilterBoolOp;
#define UosFLT_OR FLT_OR
#define UosFLT_AND FLT_AND

typedef FilterActionType UosFilterActionType;
#define UosFLT_ACTION_MOVE FLT_ACTION_MOVE
#define UosFLT_ACTION_COPY FLT_ACTION_COPY
#define UosFLT_ACTION_NOT_RECEIVE FLT_ACTION_NOT_RECEIVE
#define UosFLT_ACTION_DELETE FLT_ACTION_DELETE
#define UosFLT_ACTION_EXEC FLT_ACTION_EXEC
#define UosFLT_ACTION_EXEC_ASYNC FLT_ACTION_EXEC_ASYNC
#define UosFLT_ACTION_MARK FLT_ACTION_MARK
#define UosFLT_ACTION_COLOR_LABEL FLT_ACTION_COLOR_LABEL
#define UosFLT_ACTION_MARK_READ FLT_ACTION_MARK_READ
#define UosFLT_ACTION_FORWARD FLT_ACTION_FORWARD
#define UosFLT_ACTION_FORWARD_AS_ATTACHMENT FLT_ACTION_FORWARD_AS_ATTACHMENT
#define UosFLT_ACTION_REDIRECT FLT_ACTION_REDIRECT
#define UosFLT_ACTION_STOP_EVAL FLT_ACTION_STOP_EVAL
#define UosFLT_ACTION_FORWARDMAIL FLT_ACTION_FORWARDMAIL
#define UosFLT_ACTION_REPLY FLT_ACTION_REPLY
#define UosFLT_ACTION_NONE FLT_ACTION_NONE

typedef FilterCreateType UosFilterCreateType;
#define UosFLT_BY_NONE FLT_BY_NONE
#define UosFLT_BY_AUTO FLT_BY_AUTO
#define UosFLT_BY_FROM FLT_BY_FROM
#define UosFLT_BY_TO FLT_BY_TO
#define UosFLT_BY_SUBJECT FLT_BY_SUBJECT

typedef FilterErrorValue UosFilterErrorValue;
#define UosFLT_ERROR_OK FLT_ERROR_OK
#define UosFLT_ERROR_ERROR FLT_ERROR_ERROR
#define UosFLT_ERROR_EXEC_FAILED FLT_ERROR_EXEC_FAILED

#define UOSFLT_IS_NOT_MATCH(flag) FLT_IS_NOT_MATCH(flag)
#define UOSFLT_IS_CASE_SENS(flag) FLT_IS_CASE_SENS(flag)

typedef FilterInAddressBookFunc UosFilterInAddressBookFunc;

gint uos_filter_apply(GSList *fltlist,
                  const gchar *file,
                  UosFilterInfo *fltinfo);
gint uos_filter_apply_msginfo(GSList *fltlist,
                          UosMsgInfo *msginfo,
                          UosFilterInfo *fltinfo);

gint uos_filter_action_exec(UosFilterRule *rule,
                        UosMsgInfo *msginfo,
                        const gchar *file,
                        UosFilterInfo *fltinfo);

gboolean uos_filter_match_rule(UosFilterRule *rule,
                           UosMsgInfo *msginfo,
                           GSList *hlist,
                           UosFilterInfo *fltinfo);

gboolean uos_filter_rule_requires_full_headers(UosFilterRule *rule);

/* read / write config */
GSList *uos_filter_user_xml_node_to_filter_list(GNode *node);
GSList *uos_filter_xml_node_to_filter_list(GNode *node);
GSList *uos_filter_read_file(const gchar *file);
void uos_filter_read_config(void);
void uos_filter_write_file(GSList *list,
                       const gchar *file);
void uos_filter_write_config(void);

/* for old filterrc */
gchar *uos_filter_get_str(UosFilterRule *rule);
UosFilterRule *uos_filter_read_str(const gchar *str);

void uos_filter_set_addressbook_func(UosFilterInAddressBookFunc func);
UosFilterInAddressBookFunc uos_filter_get_addressbook_func(void);

UosFilterUser *uos_filter_user_new(const gchar *name, //add by shui
                            const gchar *type,
                            GSList *rules);

UosFilterRule *uos_filter_rule_new(const gchar *name,
                            UosFilterBoolOp bool_op,
                            GSList *cond_list,
                            GSList *action_list);
UosFilterCond *uos_filter_cond_new(UosFilterCondType type,
                            UosFilterMatchType match_type,
                            UosFilterMatchFlag match_flag,
                            const gchar *header,
                            const gchar *value,
                            const gchar *reserve);
UosFilterAction *uos_filter_action_new(UosFilterActionType type,
                                const gchar *str);
UosFilterAction *uos_filter_action_new_self(UosFilterActionType type, //add by shui
                                     const gchar *str,
                                     gint ivalue,
                                     const gchar *reserve);
UosFilterInfo *uos_filter_info_new(void);

UosFilterRule *uos_filter_junk_rule_create(UosPrefsAccount *account,
                                    UosFolderItem *default_junk,
                                    gboolean is_manual);

void uos_filter_rule_rename_dest_path(UosFilterRule *rule,
                                  const gchar *old_path,
                                  const gchar *new_path);
void uos_filter_rule_delete_action_by_dest_path(UosFilterRule *rule,
                                            const gchar *path);

void uos_filter_list_rename_path(const gchar *old_path,
                             const gchar *new_path);
void uos_filter_list_delete_path(const gchar *path);

void uos_filter_rule_match_type_str_to_enum(const gchar *type_str,
                                        UosFilterMatchType *type,
                                        UosFilterMatchFlag *flag);

void uos_filter_get_keyword_from_msg(UosMsgInfo *msginfo,
                                 gchar **header,
                                 gchar **key,
                                 UosFilterCreateType type);

void uos_filter_rule_list_free(GSList *fltlist);
void uos_filter_rule_free(UosFilterRule *rule);
void uos_filter_user_free(UosFilterUser *user); //add by shui
void uos_filter_cond_list_free(GSList *cond_list);
void uos_filter_action_list_free(GSList *action_list);
void uos_filter_info_free(UosFilterInfo *info);

#endif /* __UOSFILTER_H__ */
