/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosnntp.h"

#if USE_SSL
UosSession *uos_nntp_session_new	(const gchar	*server,
                 gushort	 port,
                 gchar		*buf,
                 const gchar	*userid,
                 const gchar	*passwd,
                                     SSLType	 ssl_type){
     return nntp_session_new	(server,port,buf,userid,passwd,ssl_type);
}

UosSession *uos_nntp_session_new_full	(const gchar	*server,
                 gushort	 port,
                 UosSocksInfo	*socks_info,
                 gchar		*buf,
                 const gchar	*userid,
                 const gchar	*passwd,
                 SSLType	 ssl_type){
    return nntp_session_new_full	(server,port,socks_info,buf,userid,passwd,ssl_type);
}

#else
UosSession *uos_nntp_session_new	(const gchar	*server,
                 gushort	 port,
                 gchar		*buf,
                 const gchar	*userid,
                 const gchar	*passwd){
    return nntp_session_new	(server,port,buf,userid,passwd);
}
UosSession *uos_nntp_session_new_full	(const gchar	*server,
                 gushort	 port,
                 SocksInfo	*socks_info,
                 gchar		*buf,
                 const gchar	*userid,
                 const gchar	*passwd){
    return nntp_session_new_full	(server,port,socks_info,buf,userid,passwd);
}
#endif

gint uos_nntp_group			(UosNNTPSession	*session,
                 const gchar	*group,
                 gint		*num,
                 gint		*first,
                 gint		*last){
    return nntp_group			(session,group,num,first,last);
}

gint uos_nntp_get_article		(UosNNTPSession	*session,
                 const gchar	*cmd,
                 gint		 num,
                 gchar	       **msgid){
    return nntp_get_article		(session,cmd,num,msgid);
}

gint uos_nntp_article		(UosNNTPSession	*session,
                 gint		 num,
                 gchar	       **msgid){
    return nntp_article		(session,num,msgid);
}

gint uos_nntp_body			(UosNNTPSession	*session,
                 gint		 num,
                 gchar	       **msgid){
    return nntp_body			(session,num,msgid);
}

gint uos_nntp_head			(UosNNTPSession	*session,
                 gint		 num,
                 gchar	       **msgid){
    return nntp_head			(session,num,msgid);
}

gint uos_nntp_stat			(UosNNTPSession	*session,
                 gint		 num,
                 gchar	       **msgid){
    return nntp_stat			(session,num,msgid);
}

gint uos_nntp_next			(UosNNTPSession	*session,
                 gint		*num,
                 gchar	       **msgid){
    return nntp_next			(session,num,msgid);
}

gint uos_nntp_xover			(UosNNTPSession	*session,
                 gint		 first,
                 gint		 last){
    return nntp_xover			(session,first,last);
}

gint uos_nntp_xhdr			(UosNNTPSession	*session,
                 const gchar	*header,
                 gint		 first,
                 gint		 last){
    return nntp_xhdr			(session,header,first,last);
}

gint uos_nntp_list			(UosNNTPSession	*session){
    return nntp_list			(session);
}

gint uos_nntp_post			(UosNNTPSession	*session,
                 FILE		*fp){
    return nntp_post			(session,fp);
}

gint uos_nntp_newgroups		(UosNNTPSession	*session){
    return nntp_newgroups			(session);
}

gint uos_nntp_newnews		(UosNNTPSession	*session){
    return nntp_newnews			(session);
}

gint uos_nntp_mode			(UosNNTPSession	*session,
                 gboolean	 stream){
    return nntp_mode			(session,stream);
}

