/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSPREFS_H__
#define __UOSPREFS_H__

#include "libsylph/prefs.h"
typedef	PrefParam UosPrefParam;
typedef PrefFile UosPrefFile;

typedef PrefType UosPrefType;

typedef DataSetFunc UosDataSetFunc;
typedef WidgetSetFunc UosWidgetSetFunc;

GHashTable *uos_prefs_param_table_get	(UosPrefParam	*param);
void uos_prefs_param_table_destroy		(GHashTable	*param_table);

void uos_prefs_read_config		(UosPrefParam	*param,
				 const gchar	*label,
				 const gchar	*rcfile,
				 const gchar	*encoding);
void uos_prefs_write_config		(UosPrefParam	*param,
				 const gchar	*label,
				 const gchar	*rcfile);

UosPrefFile *uos_prefs_file_open		(const gchar	*path);
gint uos_prefs_file_write_param		(UosPrefFile	*pfile,
                     UosPrefParam	*param);
void uos_prefs_file_set_backup_generation	(UosPrefFile	*pfile,
					 gint		 generation);
gint uos_prefs_file_get_backup_generation	(UosPrefFile	*pfile);
gint uos_prefs_file_close			(UosPrefFile	*pfile);
gint uos_prefs_file_close_revert		(UosPrefFile	*pfile);

void uos_prefs_set_default		(UosPrefParam	*param);
void uos_prefs_free			(UosPrefParam	*param);

#endif /* __UOSPREFS_H__ */
