#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# 解决u代u wifi问题

main() {
    # 控制平台处理
	if lspci -n | grep -i 8086 | egrep -i '0082|0083|0084|0085|0087|0089|008A|008B|0090|0091|02F0|06F0|0885|0886|0887|0888|088E|088F|0890|0891|0892|0893|0894|0895|0896|0897|08AE|08AF|08B1|08B2|08B3|08B4|095A|095B|24F3|24F4|24F5|24F6|24FB|24FD|2526|271B|271C|2720|2723|2725|30DC|3165|3166|31DC|34F0|3DF0|422B|422C|4232|4235|4236|4237|4238|4239|423A|423B|423C|423D|43F0|7A70|7AF0|9DF0|A0F0|A370' ; then
        msg "fix iwlwifi driver"

        local PACKAGE_NAME="backport-iwlwifi-dkms"
        is_installed $PACKAGE_NAME
        rc=$?
        if [ $rc == 0 ]; then
            msg "$PACKAGE_NAME has been installed"
        fi

        safe_install $PACKAGE_NAME  # 10代U-iwlwifi解决方案
	fi
}

head "-- wifi device detect and driver adaptation"

main || true
