/* getbits.c, bit level routines                                            */

/*
 * All modifications (mpeg2decode -> mpeg2play) are
 * Copyright (C) 1996, Stefan Eckart. All Rights Reserved.
 */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "mpeg-config.h"
#include "global.h"

/* initialize buffer, call once before first getbits or showbits */

void _mpeg2Initialize_Buffer (struct mpeg2obj *m)
{
  m->ld->Incnt = 0;
  m->ld->Rdptr = m->ld->Rdbfr + 2048;
  m->ld->Rdmax = m->ld->Rdptr;

#ifdef VERIFY
  /*  only the verifier uses this particular bit counter 
   *  Bitcnt keeps track of the current parser position with respect
   *  to the video elementary stream being decoded, regardless 
   *  of whether or not it is wrapped within a systems layer stream 
   */
  m->ld->Bitcnt = 0;
#endif

  m->ld->Bfr = 0;
  _mpeg2Flush_Buffer(m, 0); /* fills valid data into bfr */
}

void _mpeg2Fill_Buffer(struct mpeg2obj *m)
{
  int Buffer_Level;

  Buffer_Level = read(m->ld->Infile,m->ld->Rdbfr,2048);
  m->ld->Rdptr = m->ld->Rdbfr;

  if (m->System_Stream_Flag)
    m->ld->Rdmax -= 2048;

  
  /* end of the bitstream file */
  if (Buffer_Level < 2048)
  {
    /* just to be safe */
    if (Buffer_Level < 0)
      Buffer_Level = 0;

    /* pad until the next to the next 32-bit word boundary */
    while (Buffer_Level & 3)
      m->ld->Rdbfr[Buffer_Level++] = 0;

	/* pad the buffer with sequence end codes */
    while (Buffer_Level < 2048)
    {
      m->ld->Rdbfr[Buffer_Level++] = SEQUENCE_END_CODE>>24;
      m->ld->Rdbfr[Buffer_Level++] = SEQUENCE_END_CODE>>16;
      m->ld->Rdbfr[Buffer_Level++] = SEQUENCE_END_CODE>>8;
      m->ld->Rdbfr[Buffer_Level++] = SEQUENCE_END_CODE&0xff;
    }
  }
}


/* MPEG-1 system layer demultiplexer */

int _mpeg2Get_Byte(struct mpeg2obj *m)
{
  while(m->ld->Rdptr >= m->ld->Rdbfr+2048)
  {
    read(m->ld->Infile,m->ld->Rdbfr,2048);
    m->ld->Rdptr -= 2048;
    m->ld->Rdmax -= 2048;
  }
  return *m->ld->Rdptr++;
}

/* extract a 16-bit word from the bitstream buffer */
int _mpeg2Get_Word(struct mpeg2obj *m)
{
  int Val;

  Val = _mpeg2Get_Byte(m);
  return (Val<<8) | _mpeg2Get_Byte(m);
}


/* return next n bits (right adjusted) without advancing */

unsigned int _mpeg2Show_Bits(struct mpeg2obj *m, int N)
{
  return m->ld->Bfr >> (32-N);
}


/* return next bit (could be made faster than Get_Bits(1)) */

unsigned int _mpeg2Get_Bits1(struct mpeg2obj *m)
{
  return _mpeg2Get_Bits(m,1);
}


/* advance by n bits */

void _mpeg2Flush_Buffer(struct mpeg2obj *m, int N)
{
  int Incnt;

  m->ld->Bfr <<= N;

  Incnt = m->ld->Incnt -= N;

  if (Incnt <= 24)
  {
    if (m->System_Stream_Flag && (m->ld->Rdptr >= m->ld->Rdmax-4))
    {
      do
      {
        if (m->ld->Rdptr >= m->ld->Rdmax)
          _mpeg2Next_Packet(m);
        m->ld->Bfr |= _mpeg2Get_Byte(m) << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    else if (m->ld->Rdptr < m->ld->Rdbfr+2044)
    {
      do
      {
        m->ld->Bfr |= *m->ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    else
    {
      do
      {
        if (m->ld->Rdptr >= m->ld->Rdbfr+2048)
          _mpeg2Fill_Buffer(m);
        m->ld->Bfr |= *m->ld->Rdptr++ << (24 - Incnt);
        Incnt += 8;
      }
      while (Incnt <= 24);
    }
    m->ld->Incnt = Incnt;
  }

#ifdef VERIFY 
  m->ld->Bitcnt += N;
#endif /* VERIFY */

}


/* return next n bits (right adjusted) */

unsigned int _mpeg2Get_Bits(struct mpeg2obj *m, int N)
{
  unsigned int Val;

  Val = _mpeg2Show_Bits(m, N);
  _mpeg2Flush_Buffer(m, N);

  return Val;
}

