/* where-clause-test.c generated by valac 0.39.91, the Vala compiler
 * generated from where-clause-test.vala, do not modify */

/* where-clause-test.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-internal.h"


#define TYPE_PUBLIC_WHERE_CLAUSE (public_where_clause_get_type ())
#define PUBLIC_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUBLIC_WHERE_CLAUSE, PublicWhereClause))
#define PUBLIC_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUBLIC_WHERE_CLAUSE, PublicWhereClauseClass))
#define IS_PUBLIC_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUBLIC_WHERE_CLAUSE))
#define IS_PUBLIC_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUBLIC_WHERE_CLAUSE))
#define PUBLIC_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUBLIC_WHERE_CLAUSE, PublicWhereClauseClass))

typedef struct _PublicWhereClause PublicWhereClause;
typedef struct _PublicWhereClauseClass PublicWhereClauseClass;
typedef struct _PublicWhereClausePrivate PublicWhereClausePrivate;
enum  {
	PUBLIC_WHERE_CLAUSE_0_PROPERTY,
	PUBLIC_WHERE_CLAUSE_NUM_PROPERTIES
};
static GParamSpec* public_where_clause_properties[PUBLIC_WHERE_CLAUSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _PublicWhereClause {
	ZeitgeistWhereClause parent_instance;
	PublicWhereClausePrivate * priv;
};

struct _PublicWhereClauseClass {
	ZeitgeistWhereClauseClass parent_class;
};


static gpointer public_where_clause_parent_class = NULL;

gint _vala_main (gchar** args,
                 int args_length1);
void basic_test (void);
static void _basic_test_gtest_func (void);
void nested_test (void);
static void _nested_test_gtest_func (void);
void nested_negation_test (void);
static void _nested_negation_test_gtest_func (void);
void match_condition_test (void);
static void _match_condition_test_gtest_func (void);
void right_boundary_test (void);
static void _right_boundary_test_gtest_func (void);
GType public_where_clause_get_type (void) G_GNUC_CONST;
PublicWhereClause* public_where_clause_new (ZeitgeistWhereClauseType type,
                                            gboolean negate);
PublicWhereClause* public_where_clause_construct (GType object_type,
                                                  ZeitgeistWhereClauseType type,
                                                  gboolean negate);
gchar* public_where_clause_get_right_boundary (const gchar* text);
static void _g_free0_ (gpointer var);


static void
_basic_test_gtest_func (void)
{
#line 31 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	basic_test ();
#line 90 "where-clause-test.c"
}


static void
_nested_test_gtest_func (void)
{
#line 32 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	nested_test ();
#line 99 "where-clause-test.c"
}


static void
_nested_negation_test_gtest_func (void)
{
#line 33 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	nested_negation_test ();
#line 108 "where-clause-test.c"
}


static void
_match_condition_test_gtest_func (void)
{
#line 34 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	match_condition_test ();
#line 117 "where-clause-test.c"
}


static void
_right_boundary_test_gtest_func (void)
{
#line 35 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	right_boundary_test ();
#line 126 "where-clause-test.c"
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
#line 26 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_init (&args_length1, &args, NULL);
#line 29 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 31 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_add_func ("/WhereClause/basic", _basic_test_gtest_func);
#line 32 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_add_func ("/WhereClause/nested", _nested_test_gtest_func);
#line 33 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_add_func ("/WhereClause/nested_negation", _nested_negation_test_gtest_func);
#line 34 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_add_func ("/WhereClause/match_condition", _match_condition_test_gtest_func);
#line 35 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_test_add_func ("/WhereClause/glob/right_boundary", _right_boundary_test_gtest_func);
#line 37 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	result = g_test_run ();
#line 37 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return result;
#line 153 "where-clause-test.c"
}


int
main (int argc,
      char ** argv)
{
#line 24 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return _vala_main (argv, argc);
#line 163 "where-clause-test.c"
}


PublicWhereClause*
public_where_clause_construct (GType object_type,
                               ZeitgeistWhereClauseType type,
                               gboolean negate)
{
	PublicWhereClause * self = NULL;
#line 45 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	self = (PublicWhereClause*) zeitgeist_where_clause_construct (object_type, type, negate);
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return self;
#line 177 "where-clause-test.c"
}


PublicWhereClause*
public_where_clause_new (ZeitgeistWhereClauseType type,
                         gboolean negate)
{
#line 43 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return public_where_clause_construct (TYPE_PUBLIC_WHERE_CLAUSE, type, negate);
#line 187 "where-clause-test.c"
}


gchar*
public_where_clause_get_right_boundary (const gchar* text)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 48 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 50 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = zeitgeist_where_clause_get_right_boundary (text);
#line 50 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	result = _tmp0_;
#line 50 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return result;
#line 204 "where-clause-test.c"
}


static void
public_where_clause_class_init (PublicWhereClauseClass * klass)
{
#line 40 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	public_where_clause_parent_class = g_type_class_peek_parent (klass);
#line 213 "where-clause-test.c"
}


static void
public_where_clause_instance_init (PublicWhereClause * self)
{
}


GType
public_where_clause_get_type (void)
{
	static volatile gsize public_where_clause_type_id__volatile = 0;
	if (g_once_init_enter (&public_where_clause_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublicWhereClauseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) public_where_clause_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublicWhereClause), 0, (GInstanceInitFunc) public_where_clause_instance_init, NULL };
		GType public_where_clause_type_id;
		public_where_clause_type_id = g_type_register_static (ZEITGEIST_TYPE_WHERE_CLAUSE, "PublicWhereClause", &g_define_type_info, 0);
		g_once_init_leave (&public_where_clause_type_id__volatile, public_where_clause_type_id);
	}
	return public_where_clause_type_id__volatile;
}


void
basic_test (void)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* _tmp1_;
	ZeitgeistWhereClause* _tmp2_;
	ZeitgeistWhereClause* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ZeitgeistWhereClause* _tmp6_;
	ZeitgeistWhereClause* _tmp7_;
	ZeitgeistWhereClause* _tmp8_;
	ZeitgeistWhereClause* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ZeitgeistWhereClause* _tmp12_;
	ZeitgeistWhereClause* _tmp13_;
	ZeitgeistWhereClause* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 59 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp0_;
#line 60 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp1_ = where;
#line 60 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (_tmp1_, "1st condition", NULL);
#line 61 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp2_ = where;
#line 61 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (_tmp2_, "2nd condition", NULL);
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp3_ = where;
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp4_ = zeitgeist_where_clause_get_sql_conditions (_tmp3_);
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp5_ = _tmp4_;
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp5_, ==, "(1st condition AND 2nd condition)");
#line 62 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp5_);
#line 64 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp6_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
#line 64 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 64 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp6_;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp7_ = where;
#line 65 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (_tmp7_, "1st condition", NULL);
#line 66 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp8_ = where;
#line 66 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (_tmp8_, "2nd condition", NULL);
#line 67 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp9_ = where;
#line 67 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp10_ = zeitgeist_where_clause_get_sql_conditions (_tmp9_);
#line 67 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp11_ = _tmp10_;
#line 67 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp11_, ==, "(1st condition OR 2nd condition)");
#line 67 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp11_);
#line 69 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp12_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, TRUE);
#line 69 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 69 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp12_;
#line 70 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp13_ = where;
#line 70 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (_tmp13_, "some condition", NULL);
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp14_ = where;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp15_ = zeitgeist_where_clause_get_sql_conditions (_tmp14_);
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp16_ = _tmp15_;
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp16_, ==, "NOT some condition");
#line 71 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp16_);
#line 55 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 328 "where-clause-test.c"
}


static void
_g_free0_ (gpointer var)
{
#line 81 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	var = (g_free (var), NULL);
#line 337 "where-clause-test.c"
}


static gpointer
_g_ptr_array_ref0 (gpointer self)
{
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	return self ? g_ptr_array_ref (self) : NULL;
#line 346 "where-clause-test.c"
}


static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	guint _tmp0_;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 5001 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 363 "where-clause-test.c"
}


static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5002 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5002 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 375 "where-clause-test.c"
}


void
nested_test (void)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* subwhere = NULL;
	ZeitgeistWhereClause* _tmp1_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
#line 76 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp0_;
#line 77 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (where, "1st condition", "arg1");
#line 79 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp1_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
#line 79 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	subwhere = _tmp1_;
#line 398 "where-clause-test.c"
	{
		GPtrArray* args = NULL;
		GPtrArray* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 81 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
#line 81 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		args = _tmp2_;
#line 82 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp3_ = g_strdup ("arg2");
#line 82 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_ptr_array_add (args, _tmp3_);
#line 83 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp4_ = g_strdup ("arg3");
#line 83 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_ptr_array_add (args, _tmp4_);
#line 84 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		zeitgeist_where_clause_add_with_array (subwhere, "2nd condition", args);
#line 85 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		zeitgeist_where_clause_add (subwhere, "3rd condition", NULL);
#line 80 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_g_ptr_array_unref0 (args);
#line 422 "where-clause-test.c"
	}
#line 88 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_extend (where, subwhere);
#line 89 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (where, "last condition", NULL);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp5_ = zeitgeist_where_clause_get_sql_conditions (where);
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp6_ = _tmp5_;
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp6_, ==, "(1st condition AND (2nd condition OR 3rd condition) AND " "last condition)");
#line 91 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp6_);
#line 436 "where-clause-test.c"
	{
		GPtrArray* args = NULL;
		GPtrArray* _tmp7_;
		GPtrArray* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gconstpointer _tmp11_;
		gconstpointer _tmp12_;
		gconstpointer _tmp13_;
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp7_ = zeitgeist_where_clause_get_bind_arguments (where);
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp8_ = _g_ptr_array_ref0 (_tmp7_);
#line 96 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		args = _tmp8_;
#line 97 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp9_ = g_ptr_array_get_length (args);
#line 97 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp10_ = _tmp9_;
#line 97 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_assert_cmpint (_tmp10_, ==, 3);
#line 98 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp11_ = g_ptr_array_index (args, (guint) 0);
#line 98 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_assert_cmpstr ((const gchar*) _tmp11_, ==, "arg1");
#line 99 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp12_ = g_ptr_array_index (args, (guint) 1);
#line 99 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_assert_cmpstr ((const gchar*) _tmp12_, ==, "arg2");
#line 100 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_tmp13_ = g_ptr_array_index (args, (guint) 2);
#line 100 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		g_assert_cmpstr ((const gchar*) _tmp13_, ==, "arg3");
#line 95 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
		_g_ptr_array_unref0 (args);
#line 472 "where-clause-test.c"
	}
#line 74 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (subwhere);
#line 74 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 478 "where-clause-test.c"
}


void
nested_negation_test (void)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* subwhere = NULL;
	ZeitgeistWhereClause* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 106 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
#line 106 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp0_;
#line 107 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (where, "cond1", "arg1");
#line 109 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp1_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, TRUE);
#line 109 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	subwhere = _tmp1_;
#line 110 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (subwhere, "cond2", NULL);
#line 112 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_extend (where, subwhere);
#line 113 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add (where, "cond3", NULL);
#line 115 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp2_ = zeitgeist_where_clause_get_sql_conditions (where);
#line 115 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp3_ = _tmp2_;
#line 115 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp3_, ==, "(cond1 OR NOT cond2 OR cond3)");
#line 115 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp3_);
#line 104 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (subwhere);
#line 104 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 519 "where-clause-test.c"
}


void
match_condition_test (void)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* _tmp1_;
	ZeitgeistWhereClause* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ZeitgeistWhereClause* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ZeitgeistWhereClause* _tmp9_;
	ZeitgeistWhereClause* _tmp10_;
	ZeitgeistWhereClause* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
#line 124 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
#line 124 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 124 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp0_;
#line 125 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp1_ = where;
#line 125 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add_match_condition (_tmp1_, "field1", 5, FALSE);
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp2_ = where;
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp3_ = zeitgeist_where_clause_get_sql_conditions (_tmp2_);
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp4_ = _tmp3_;
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp4_, ==, "field1 = 5");
#line 126 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp4_);
#line 128 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp5_ = where;
#line 128 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp6_ = zeitgeist_where_clause_get_bind_arguments (_tmp5_);
#line 128 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 128 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp8_ = _tmp7_;
#line 128 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpint (_tmp8_, ==, 0);
#line 131 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp9_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
#line 131 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 131 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	where = _tmp9_;
#line 132 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp10_ = where;
#line 132 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	zeitgeist_where_clause_add_match_condition (_tmp10_, "f2", 3, TRUE);
#line 133 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp11_ = where;
#line 133 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp12_ = zeitgeist_where_clause_get_sql_conditions (_tmp11_);
#line 133 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp13_ = _tmp12_;
#line 133 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp13_, ==, "f2 != 3");
#line 133 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp13_);
#line 119 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (where);
#line 593 "where-clause-test.c"
}


void
right_boundary_test (void)
{
	PublicWhereClause* clause = NULL;
	PublicWhereClause* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 140 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp0_ = public_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
#line 140 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	clause = _tmp0_;
#line 141 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp1_ = public_where_clause_get_right_boundary ("a");
#line 141 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp2_ = _tmp1_;
#line 141 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp2_, ==, "b");
#line 141 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp2_);
#line 142 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp3_ = public_where_clause_get_right_boundary ("hello");
#line 142 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp4_ = _tmp3_;
#line 142 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp4_, ==, "hellp");
#line 142 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp4_);
#line 143 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp5_ = public_where_clause_get_right_boundary ("a b");
#line 143 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_tmp6_ = _tmp5_;
#line 143 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	g_assert_cmpstr (_tmp6_, ==, "a c");
#line 143 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_free0 (_tmp6_);
#line 138 "/home/rico/sources/repos-git/zeitgeist/zeitgeist/test/direct/where-clause-test.vala"
	_g_object_unref0 (clause);
#line 638 "where-clause-test.c"
}



