/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.swt.graphics.Rectangle;

public abstract class RowVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<Range> rowPositionRanges;
    private int[] rowIndexes;

    public RowVisualChangeEvent(ILayer layer, int rowPosition) {
        this(layer, new Range(rowPosition, rowPosition + 1));
    }

    public RowVisualChangeEvent(ILayer layer, Range ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowVisualChangeEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        this.layer = layer;
        this.rowPositionRanges = rowPositionRanges;
    }

    public RowVisualChangeEvent(ILayer layer, Collection<Range> rowPositionRanges, Collection<Integer> rowIndexes) {
        this.layer = layer;
        this.rowPositionRanges = rowPositionRanges;
        this.rowIndexes = rowIndexes.stream().mapToInt(Integer::intValue).toArray();
    }

    public RowVisualChangeEvent(ILayer layer, Collection<Range> rowPositionRanges, int ... rowIndexes) {
        this.layer = layer;
        this.rowPositionRanges = rowPositionRanges;
        this.rowIndexes = rowIndexes;
    }

    protected RowVisualChangeEvent(RowVisualChangeEvent event) {
        this.layer = event.layer;
        this.rowPositionRanges = event.rowPositionRanges;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<Range> getRowPositionRanges() {
        return this.rowPositionRanges != null ? this.rowPositionRanges : new ArrayList(0);
    }

    protected void setRowPositionRanges(Collection<Range> rowPositionRanges) {
        this.rowPositionRanges = rowPositionRanges;
    }

    public int[] getRowIndexes() {
        if (this.rowIndexes == null) {
            int[] positions = PositionUtil.getPositions(this.rowPositionRanges);
            this.rowIndexes = new int[positions.length];
            int i = 0;
            while (i < positions.length) {
                int pos = positions[i];
                this.rowIndexes[i] = this.layer.getRowIndexByPosition(pos);
                ++i;
            }
        }
        return this.rowIndexes;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.rowPositionRanges != null) {
            this.rowPositionRanges = localLayer.underlyingToLocalRowPositions(this.layer, this.rowPositionRanges);
        }
        this.layer = localLayer;
        return this.rowPositionRanges != null && !this.rowPositionRanges.isEmpty();
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        if (this.rowPositionRanges == null) {
            return new ArrayList<Rectangle>(0);
        }
        int columnCount = this.layer.getColumnCount();
        return this.rowPositionRanges.stream().map(range -> new Rectangle(0, range.start, columnCount, range.end - range.start)).collect(Collectors.toList());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

