/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.diffmergetool.CommandExecutor;
import org.eclipse.jgit.internal.diffmergetool.CommandLineDiffTool;
import org.eclipse.jgit.internal.diffmergetool.DiffToolConfig;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.ExternalToolUtils;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.InformNoToolHandler;
import org.eclipse.jgit.internal.diffmergetool.PreDefinedDiffTool;
import org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class DiffTools {
    private final FS fs;
    private final File gitDir;
    private final File workTree;
    private final DiffToolConfig config;
    private final Repository repo;
    private final Map<String, ExternalDiffTool> predefinedTools;
    private final Map<String, ExternalDiffTool> userDefinedTools;

    public DiffTools(Repository repo) {
        this(repo, repo.getConfig());
    }

    public DiffTools(StoredConfig config) {
        this(null, config);
    }

    private DiffTools(Repository repo, StoredConfig config) {
        this.repo = repo;
        this.config = config.get(DiffToolConfig.KEY);
        this.gitDir = repo == null ? null : repo.getDirectory();
        this.fs = repo == null ? FS.DETECTED : repo.getFS();
        this.workTree = repo == null ? null : repo.getWorkTree();
        this.predefinedTools = DiffTools.setupPredefinedTools();
        this.userDefinedTools = this.setupUserDefinedTools(this.predefinedTools);
    }

    public Optional<FS.ExecutionResult> compare(FileElement localFile, FileElement remoteFile, Optional<String> toolName, BooleanTriState prompt, boolean gui, BooleanTriState trustExitCode, PromptContinueHandler promptHandler, InformNoToolHandler noToolHandler) throws ToolException {
        if (toolName == null) {
            throw new ToolException(JGitText.get().diffToolNullError);
        }
        String toolNameToUse = toolName.isPresent() ? toolName.get() : this.getDefaultToolName(gui);
        if (StringUtils.isEmptyOrNull(toolNameToUse)) {
            throw new ToolException(JGitText.get().diffToolNotGivenError);
        }
        boolean doPrompt = prompt != BooleanTriState.UNSET ? prompt == BooleanTriState.TRUE : this.isInteractive();
        if (doPrompt && !promptHandler.prompt(toolNameToUse)) {
            return Optional.empty();
        }
        boolean trust = trustExitCode != BooleanTriState.UNSET ? trustExitCode == BooleanTriState.TRUE : this.config.isTrustExitCode();
        ExternalDiffTool tool = this.getTool(toolNameToUse);
        if (tool == null) {
            throw new ToolException("External diff tool is not defined: " + toolNameToUse);
        }
        return Optional.of(this.compare(localFile, remoteFile, tool, trust));
    }

    public FS.ExecutionResult compare(FileElement localFile, FileElement remoteFile, ExternalDiffTool tool, boolean trustExitCode) throws ToolException {
        try {
            if (tool == null) {
                throw new ToolException(JGitText.get().diffToolNotSpecifiedInGitAttributesError);
            }
            String command = ExternalToolUtils.prepareCommand(tool.getCommand(), localFile, remoteFile, null, null);
            Map<String, String> env = ExternalToolUtils.prepareEnvironment(this.gitDir, localFile, remoteFile, null, null);
            CommandExecutor cmdExec = new CommandExecutor(this.fs, trustExitCode);
            FS.ExecutionResult executionResult = cmdExec.run(command, this.workTree, env);
            return executionResult;
        }
        catch (IOException | InterruptedException e) {
            throw new ToolException(e);
        }
        finally {
            localFile.cleanTemporaries();
            remoteFile.cleanTemporaries();
        }
    }

    public Set<String> getUserDefinedToolNames() {
        return this.userDefinedTools.keySet();
    }

    public Set<String> getPredefinedToolNames() {
        return this.predefinedTools.keySet();
    }

    public Set<String> getAllToolNames() {
        String defaultName = this.getDefaultToolName(false);
        if (defaultName == null) {
            defaultName = this.getFirstAvailableTool();
        }
        return ExternalToolUtils.createSortedToolSet(defaultName, this.getUserDefinedToolNames(), this.getPredefinedToolNames());
    }

    public Optional<String> getExternalToolFromAttributes(String path) throws ToolException {
        return ExternalToolUtils.getExternalToolFromAttributes(this.repo, path, "difftool");
    }

    public Set<String> getPredefinedAvailableTools() {
        Map<String, ExternalDiffTool> defTools = this.getPredefinedTools(true);
        LinkedHashSet<String> availableTools = new LinkedHashSet<String>();
        for (Map.Entry<String, ExternalDiffTool> elem : defTools.entrySet()) {
            if (!elem.getValue().isAvailable()) continue;
            availableTools.add(elem.getKey());
        }
        return availableTools;
    }

    public Map<String, ExternalDiffTool> getUserDefinedTools() {
        return Collections.unmodifiableMap(this.userDefinedTools);
    }

    public Map<String, ExternalDiffTool> getPredefinedTools(boolean checkAvailability) {
        if (checkAvailability) {
            for (ExternalDiffTool tool : this.predefinedTools.values()) {
                PreDefinedDiffTool predefTool = (PreDefinedDiffTool)tool;
                predefTool.setAvailable(ExternalToolUtils.isToolAvailable(this.fs, this.gitDir, this.workTree, predefTool.getPath()));
            }
        }
        return Collections.unmodifiableMap(this.predefinedTools);
    }

    public String getFirstAvailableTool() {
        for (ExternalDiffTool tool : this.predefinedTools.values()) {
            if (!ExternalToolUtils.isToolAvailable(this.fs, this.gitDir, this.workTree, tool.getPath())) continue;
            return tool.getName();
        }
        return null;
    }

    public String getDefaultToolName(boolean gui) {
        String guiToolName;
        if (gui && (guiToolName = this.config.getDefaultGuiToolName()) != null) {
            return guiToolName;
        }
        return this.config.getDefaultToolName();
    }

    public boolean isInteractive() {
        return this.config.isPrompt();
    }

    private ExternalDiffTool getTool(String name) {
        ExternalDiffTool tool = this.userDefinedTools.get(name);
        if (tool == null) {
            tool = this.predefinedTools.get(name);
        }
        return tool;
    }

    private static Map<String, ExternalDiffTool> setupPredefinedTools() {
        TreeMap<String, ExternalDiffTool> tools = new TreeMap<String, ExternalDiffTool>();
        CommandLineDiffTool[] commandLineDiffToolArray = CommandLineDiffTool.values();
        int n = commandLineDiffToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineDiffTool tool = commandLineDiffToolArray[n2];
            tools.put(tool.name(), new PreDefinedDiffTool(tool));
            ++n2;
        }
        return tools;
    }

    private Map<String, ExternalDiffTool> setupUserDefinedTools(Map<String, ExternalDiffTool> predefTools) {
        TreeMap<String, ExternalDiffTool> tools = new TreeMap<String, ExternalDiffTool>();
        Map<String, ExternalDiffTool> userTools = this.config.getTools();
        for (String name : userTools.keySet()) {
            PreDefinedDiffTool predefTool;
            ExternalDiffTool userTool = userTools.get(name);
            if (userTool.getCommand() != null) {
                tools.put(name, userTool);
                continue;
            }
            if (userTool.getPath() == null || (predefTool = (PreDefinedDiffTool)predefTools.get(name)) == null) continue;
            predefTool.setPath(userTool.getPath());
        }
        return tools;
    }
}

